<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.4.1
*/namespace
Adminer;const
VERSION="5.4.1";error_reporting(24575);set_error_handler(function($rc,$tc){return!!preg_match('~^Undefined (array key|offset|index)~',$tc);},E_WARNING|E_NOTICE);$Nc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Nc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$vi=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($vi)$$X=$vi;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($g=null){return($g?:Db::$instance);}function
adminer(){return
Adminer::$instance;}function
driver(){return
Driver::$instance;}function
connect(){$wb=adminer()->credentials();$L=Driver::connect($wb[0],$wb[1],$wb[2]);return(is_object($L)?$L:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$le=substr($v,-1);return
str_replace($le.$le,$le,substr($v,1,-1));}function
q($zh){return
connection()->quote($zh);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($ta,$z,$k=null){return($ta&&array_key_exists($z,$ta)?$ta[$z]:$k);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$sg,$Nc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($z,$X)=each($sg)){foreach($X
as$de=>$W){unset($sg[$z][$de]);if(is_array($W)){$sg[$z][stripslashes($de)]=$W;$sg[]=&$sg[$z][stripslashes($de)];}else$sg[$z][stripslashes($de)]=($Nc?$W:stripslashes($W));}}}}function
bracket_escape($v,$Aa=false){static$ii=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Aa?array_flip($ii):$ii));}function
min_version($Li,$ze="",$g=null){$g=connection($g);$eh=$g->server_info;if($ze&&preg_match('~([\d.]+)-MariaDB~',$eh,$C)){$eh=$C[1];$Li=$ze;}return$Li&&version_compare($eh,$Li)>=0;}function
charset(Db$f){return(min_version("5.5.3",0,$f)?"utf8mb4":"utf8");}function
ini_bool($Nd){$X=ini_get($Nd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
ini_bytes($Nd){$X=ini_get($Nd);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
sid(){static$L;if($L===null)$L=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$L;}function
set_password($Ki,$P,$V,$H){$_SESSION["pwds"][$Ki][$P][$V]=($_COOKIE["adminer_key"]&&is_string($H)?array(encrypt_string($H,$_COOKIE["adminer_key"])):$H);}function
get_password(){$L=get_session("pwds");if(is_array($L))$L=($_COOKIE["adminer_key"]?decrypt_string($L[0],$_COOKIE["adminer_key"]):false);return$L;}function
get_val($J,$m=0,$mb=null){$mb=connection($mb);$K=$mb->query($J);if(!is_object($K))return
false;$M=$K->fetch_row();return($M?$M[$m]:false);}function
get_vals($J,$c=0){$L=array();$K=connection()->query($J);if(is_object($K)){while($M=$K->fetch_row())$L[]=$M[$c];}return$L;}function
get_key_vals($J,$g=null,$hh=true){$g=connection($g);$L=array();$K=$g->query($J);if(is_object($K)){while($M=$K->fetch_row()){if($hh)$L[$M[0]]=$M[1];else$L[]=$M[0];}}return$L;}function
get_rows($J,$g=null,$l="<p class='error'>"){$mb=connection($g);$L=array();$K=$mb->query($J);if(is_object($K)){while($M=$K->fetch_assoc())$L[]=$M;}elseif(!$K&&!$g&&$l&&(defined('Adminer\PAGE_HEADER')||$l=="-- "))echo$l.error()."\n";return$L;}function
unique_array($M,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$L=array();foreach($w["columns"]as$z){if(!isset($M[$z]))continue
2;$L[$z]=$M[$z];}return$L;}}}function
escape_key($z){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$z,$C))return$C[1].idf_escape(idf_unescape($C[2])).$C[3];return
idf_escape($z);}function
where(array$Z,array$n=array()){$L=array();foreach((array)$Z["where"]as$z=>$X){$z=bracket_escape($z,true);$c=escape_key($z);$m=idx($n,$z,array());$Kc=$m["type"];$L[]=$c.(JUSH=="sql"&&$Kc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="pgsql"&&preg_match('~^json~',$Kc)?"::jsonb = ".q($X)."::jsonb":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Kc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($m,q($X))))));if(JUSH=="sql"&&preg_match('~char|text~',$Kc)&&preg_match("~[^ -@]~",$X))$L[]="$c = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$z)$L[]=escape_key($z)." IS NULL";return
implode(" AND ",$L);}function
where_check($X,array$n=array()){parse_str($X,$Sa);remove_slashes(array(&$Sa));return
where($Sa,$n);}function
where_link($t,$c,$Y,$tf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($c)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$tf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$d,array$n,array$O=array()){$L="";foreach($d
as$z=>$X){if($O&&!in_array(idf_escape($z),$O))continue;$ua=convert_field($n[$z]);if($ua)$L
.=", $ua AS ".idf_escape($z);}return$L;}function
cookie($E,$Y,$te=2592000){header("Set-Cookie: $E=".urlencode($Y).($te?"; expires=".gmdate("D, d M Y H:i:s",time()+$te)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($sb){parse_str($_COOKIE[$sb],$ih);return$ih;}function
get_setting($z,$sb="adminer_settings",$k=null){return
idx(get_settings($sb),$z,$k);}function
save_settings(array$ih,$sb="adminer_settings"){$Y=http_build_query($ih+get_settings($sb));cookie($sb,$Y);$_COOKIE[$sb]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($Sc=false){$Ei=ini_bool("session.use_cookies");if(!$Ei||$Sc){session_write_close();if($Ei&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($z){return$_SESSION[$z][DRIVER][SERVER][$_GET["username"]];}function
set_session($z,$X){$_SESSION[$z][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Ki,$P,$V,$j=null){$Ai=remove_from_uri(implode("|",array_keys(SqlDriver::$drivers))."|username|ext|".($j!==null?"db|":"").($Ki=='mssql'||$Ki=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Ai,$C);return"$C[1]?".(sid()?SID."&":"").($Ki!="server"||$P!=""?urlencode($Ki)."=".urlencode($P)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($j!=""?"&db=".urlencode($j):"").($C[2]?"&$C[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($B,$D=null){if($D!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($B!==null?$B:$_SERVER["REQUEST_URI"]))][]=$D;}if($B!==null){if($B=="")$B=".";header("Location: $B");exit;}}function
query_redirect($J,$B,$D,$_g=true,$yc=true,$Gc=false,$Vh=""){if($yc){$vh=microtime(true);$Gc=!connection()->query($J);$Vh=format_time($vh);}$qh=($J?adminer()->messageQuery($J,$Vh,$Gc):"");if($Gc){adminer()->error
.=error().$qh.script("messagesPrint();")."<br>";return
false;}if($_g)redirect($B,$D.$qh);return
true;}class
Queries{static$queries=array();static$start=0;}function
queries($J){if(!Queries::$start)Queries::$start=microtime(true);Queries::$queries[]=(preg_match('~;$~',$J)?"DELIMITER ;;\n$J;\nDELIMITER ":$J).";";return
connection()->query($J);}function
apply_queries($J,array$T,$uc='Adminer\table'){foreach($T
as$R){if(!queries("$J ".$uc($R)))return
false;}return
true;}function
queries_redirect($B,$D,$_g){$vg=implode("\n",Queries::$queries);$Vh=format_time(Queries::$start);return
query_redirect($vg,$B,$D,$_g,false,!$_g,$Vh);}function
format_time($vh){return
lang(0,max(0,microtime(true)-$vh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Mf=""){return
substr(preg_replace("~(?<=[?&])($Mf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($z,$Hb=false,$Nb=""){$Mc=$_FILES[$z];if(!$Mc)return
null;foreach($Mc
as$z=>$X)$Mc[$z]=(array)$X;$L='';foreach($Mc["error"]as$z=>$l){if($l)return$l;$E=$Mc["name"][$z];$di=$Mc["tmp_name"][$z];$ob=file_get_contents($Hb&&preg_match('~\.gz$~',$E)?"compress.zlib://$di":$di);if($Hb){$vh=substr($ob,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$vh))$ob=iconv("utf-16","utf-8",$ob);elseif($vh=="\xEF\xBB\xBF")$ob=substr($ob,3);}$L
.=$ob;if($Nb)$L
.=(preg_match("($Nb\\s*\$)",$ob)?"":$Nb)."\n\n";}return$L;}function
upload_error($l){$He=($l==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($l?lang(1).($He?" ".lang(2,$He):""):lang(3));}function
repeat_pattern($Zf,$re){return
str_repeat("$Zf{0,65535}",$re/65535)."$Zf{0,".($re%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Hc=false){$L=table_status($R,$Hc);return($L?reset($L):array("Name"=>$R));}function
column_foreign_keys($R){$L=array();foreach(adminer()->foreignKeys($R)as$p){foreach($p["source"]as$X)$L[$X][]=$p;}return$L;}function
fields_from_edit(){$L=array();foreach((array)$_POST["field_keys"]as$z=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$z];$_POST["fields"][$X]=$_POST["field_vals"][$z];}}foreach((array)$_POST["fields"]as$z=>$X){$E=bracket_escape($z,true);$L[$E]=array("field"=>$E,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($z==driver()->primary),);}return$L;}function
dump_headers($zd,$Ve=false){$L=adminer()->dumpHeaders($zd,$Ve);$Jf=$_POST["output"];if($Jf!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($zd).".$L".($Jf!="file"&&preg_match('~^[0-9a-z]+$~',$Jf)?".$Jf":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$L;}function
dump_csv(array$M){foreach($M
as$z=>$X){if(preg_match('~["\n,;\t]|^0.|\.\d*0$~',$X)||$X==="")$M[$z]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$M)."\r\n";}function
apply_sql_function($r,$c){return($r?($r=="unixepoch"?"DATETIME($c, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$c)"):$c);}function
get_temp_dir(){$L=ini_get("upload_tmp_dir");if(!$L){if(function_exists('sys_get_temp_dir'))$L=sys_get_temp_dir();else{$o=@tempnam("","");if(!$o)return'';$L=dirname($o);unlink($o);}}return$L;}function
file_open_lock($o){if(is_link($o))return;$q=@fopen($o,"c+");if(!$q)return;@chmod($o,0660);if(!flock($q,LOCK_EX)){fclose($q);return;}return$q;}function
file_write_unlock($q,$Bb){rewind($q);fwrite($q,$Bb);ftruncate($q,strlen($Bb));file_unlock($q);}function
file_unlock($q){flock($q,LOCK_UN);fclose($q);}function
first(array$ta){return
reset($ta);}function
password_file($h){$o=get_temp_dir()."/adminer.key";if(!$h&&!file_exists($o))return'';$q=file_open_lock($o);if(!$q)return'';$L=stream_get_contents($q);if(!$L){$L=rand_string();file_write_unlock($q,$L);}else
file_unlock($q);return$L;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$A,array$m,$Uh){if(is_array($X)){$L="";foreach($X
as$de=>$W)$L
.="<tr>".($X!=array_values($X)?"<th>".h($de):"")."<td>".select_value($W,$A,$m,$Uh);return"<table>$L</table>";}if(!$A)$A=adminer()->selectLink($X,$m);if($A===null){if(is_mail($X))$A="mailto:$X";if(is_url($X))$A=$X;}$L=adminer()->editVal($X,$m);if($L!==null){if(!is_utf8($L))$L="\0";elseif($Uh!=""&&is_shortable($m))$L=shorten_utf8($L,max(0,+$Uh));else$L=h($L);}return
adminer()->selectVal($L,$A,$m,$X);}function
is_blob(array$m){return
preg_match('~blob|bytea|raw|file~',$m["type"])&&!in_array($m["type"],idx(driver()->structuredTypes(),lang(6),array()));}function
is_mail($hc){$va='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Wb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Zf="$va+(\\.$va+)*@($Wb?\\.)+$Wb";return
is_string($hc)&&preg_match("(^$Zf(,\\s*$Zf)*\$)i",$hc);}function
is_url($zh){$Wb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Wb?\\.)+$Wb(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$zh);}function
is_shortable(array$m){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea|hstore~',$m["type"]);}function
host_port($P){return(preg_match('~^(\[(.+)]|([^:]+)):([^:]+)$~',$P,$C)?array($C[2].$C[3],$C[4]):array($P,''));}function
count_rows($R,array$Z,$Xd,array$s){$J=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($Xd&&(JUSH=="sql"||count($s)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$s).")$J":"SELECT COUNT(*)".($Xd?" FROM (SELECT 1$J GROUP BY ".implode(", ",$s).") x":$J));}function
slow_query($J){$j=adminer()->database();$Wh=adminer()->queryTimeout();$mh=driver()->slowQuery($J,$Wh);$g=null;if(!$mh&&support("kill")){$g=connect();if($g&&($j==""||$g->select_db($j))){$fe=get_val(connection_id(),0,$g);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$fe&token=".get_token()."'); }, 1000 * $Wh);");}}ob_flush();flush();$L=@get_key_vals(($mh?:$J),$g,false);if($g){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$L;}function
get_token(){$yg=rand(1,1e6);return($yg^$_SESSION["token"]).":$yg";}function
verify_token(){list($ei,$yg)=explode(":",$_POST["token"]);return($yg^$_SESSION["token"])==$ei;}function
lzw_decompress($Ga){$Sb=256;$Ha=8;$ab=array();$Jg=0;$Kg=0;for($t=0;$t<strlen($Ga);$t++){$Jg=($Jg<<8)+ord($Ga[$t]);$Kg+=8;if($Kg>=$Ha){$Kg-=$Ha;$ab[]=$Jg>>$Kg;$Jg&=(1<<$Kg)-1;$Sb++;if($Sb>>$Ha)$Ha++;}}$Rb=range("\0","\xFF");$L="";$Ui="";foreach($ab
as$t=>$Za){$gc=$Rb[$Za];if(!isset($gc))$gc=$Ui.$Ui[0];$L
.=$gc;if($t)$Rb[]=$Ui.$gc[0];$Ui=$gc;}return$L;}function
script($oh,$hi="\n"){return"<script".nonce().">$oh</script>$hi";}function
script_src($Bi,$Kb=false){return"<script src='".h($Bi)."'".nonce().($Kb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($E,$Y=""){return"<input type='hidden' name='".h($E)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($zh){return
str_replace("\0","&#0;",htmlspecialchars($zh,ENT_QUOTES,'utf-8'));}function
nl_br($zh){return
str_replace("\n","<br>",$zh);}function
checkbox($E,$Y,$Ua,$he="",$sf="",$Ya="",$je=""){$L="<input type='checkbox' name='$E' value='".h($Y)."'".($Ua?" checked":"").($je?" aria-labelledby='$je'":"").">".($sf?script("qsl('input').onclick = function () { $sf };",""):"");return($he!=""||$Ya?"<label".($Ya?" class='$Ya'":"").">$L".h($he)."</label>":$L);}function
optionlist($wf,$Zg=null,$Fi=false){$L="";foreach($wf
as$de=>$W){$xf=array($de=>$W);if(is_array($W)){$L
.='<optgroup label="'.h($de).'">';$xf=$W;}foreach($xf
as$z=>$X)$L
.='<option'.($Fi||is_string($z)?' value="'.h($z).'"':'').($Zg!==null&&($Fi||is_string($z)?(string)$z:$X)===$Zg?' selected':'').'>'.h($X);if(is_array($W))$L
.='</optgroup>';}return$L;}function
html_select($E,array$wf,$Y="",$rf="",$je=""){static$he=0;$ie="";if(!$je&&substr($wf[""],0,1)=="("){$he++;$je="label-$he";$ie="<option value='' id='$je'>".h($wf[""]);unset($wf[""]);}return"<select name='".h($E)."'".($je?" aria-labelledby='$je'":"").">".$ie.optionlist($wf,$Y)."</select>".($rf?script("qsl('select').onchange = function () { $rf };",""):"");}function
html_radios($E,array$wf,$Y="",$dh=""){$L="";foreach($wf
as$z=>$X)$L
.="<label><input type='radio' name='".h($E)."' value='".h($z)."'".($z==$Y?" checked":"").">".h($X)."</label>$dh";return$L;}function
confirm($D="",$ah="qsl('input')"){return
script("$ah.onclick = () => confirm('".($D?js_escape($D):lang(7))."');","");}function
print_fieldset($u,$qe,$Oi=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$qe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($Oi?"":" class='hidden'").">\n";}function
bold($Ja,$Ya=""){return($Ja?" class='active $Ya'":($Ya?" class='$Ya'":""));}function
js_escape($zh){return
addcslashes($zh,"\r\n'\\/");}function
pagination($G,$zb){return" ".($G==$zb?$G+1:'<a href="'.h(remove_from_uri("page").($G?"&page=$G".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($G+1)."</a>");}function
hidden_fields(array$sg,array$Bd=array(),$lg=''){$L=false;foreach($sg
as$z=>$X){if(!in_array($z,$Bd)){if(is_array($X))hidden_fields($X,array(),$z);else{$L=true;echo
input_hidden(($lg?$lg."[$z]":$z),$X);}}}return$L;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
file_input($Pd){$Ce="max_file_uploads";$De=ini_get($Ce);$zi="upload_max_filesize";$_i=ini_get($zi);return(ini_bool("file_uploads")?$Pd.script("qsl('input[type=\"file\"]').onchange = partialArg(fileChange, "."$De, '".lang(8,"$Ce = $De")."', ".ini_bytes("upload_max_filesize").", '".lang(8,"$zi = $_i")."')"):lang(9));}function
enum_input($U,$wa,array$m,$Y,$kc=""){preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$Ae);$lg=($m["type"]=="enum"?"val-":"");$Ua=(is_array($Y)?in_array("null",$Y):$Y===null);$L=($m["null"]&&$lg?"<label><input type='$U'$wa value='null'".($Ua?" checked":"")."><i>$kc</i></label>":"");foreach($Ae[1]as$X){$X=stripcslashes(str_replace("''","'",$X));$Ua=(is_array($Y)?in_array($lg.$X,$Y):$Y===$X);$L
.=" <label><input type='$U'$wa value='".h($lg.$X)."'".($Ua?' checked':'').'>'.h(adminer()->editVal($X,$m)).'</label>';}return$L;}function
input(array$m,$Y,$r,$_a=false){$E=h(bracket_escape($m["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$Y=json_encode($Y,128|64|256);$r="json";}$Ig=(JUSH=="mssql"&&$m["auto_increment"]);if($Ig&&!$_POST["save"])$r=null;$bd=(isset($_GET["select"])||$Ig?array("orig"=>lang(10)):array())+adminer()->editFunctions($m);$qc=driver()->enumLength($m);if($qc){$m["type"]="enum";$m["length"]=$qc;}$Tb=stripos($m["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$wa=" name='fields[$E]".($m["type"]=="enum"||$m["type"]=="set"?"[]":"")."'$Tb".($_a?" autofocus":"");echo
driver()->unconvertFunction($m)." ";$R=$_GET["edit"]?:$_GET["select"];if($m["type"]=="enum")echo
h($bd[""])."<td>".adminer()->editInput($R,$m,$wa,$Y);else{$nd=(in_array($r,$bd)||isset($bd[$r]));echo(count($bd)>1?"<select name='function[$E]'$Tb>".optionlist($bd,$r===null||$nd?$r:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($bd))).'<td>';$Pd=adminer()->editInput($R,$m,$wa,$Y);if($Pd!="")echo$Pd;elseif(preg_match('~bool~',$m["type"]))echo"<input type='hidden'$wa value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$wa value='1'>";elseif($m["type"]=="set")echo
enum_input("checkbox",$wa,$m,(is_string($Y)?explode(",",$Y):$Y));elseif(is_blob($m)&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$E'>";elseif($r=="json"||preg_match('~^jsonb?$~',$m["type"]))echo"<textarea$wa cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Th=preg_match('~text|lob|memo~i',$m["type"]))||preg_match("~\n~",$Y)){if($Th&&JUSH!="sqlite")$wa
.=" cols='50' rows='12'";else{$N=min(12,substr_count($Y,"\n")+1);$wa
.=" cols='30' rows='$N'";}echo"<textarea$wa>".h($Y).'</textarea>';}else{$qi=driver()->types();$Je=(!preg_match('~int~',$m["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$m["length"],$C)?((preg_match("~binary~",$m["type"])?2:1)*$C[1]+($C[3]?1:0)+($C[2]&&!$m["unsigned"]?1:0)):($qi[$m["type"]]?$qi[$m["type"]]+($m["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$m["type"]))$Je+=7;echo"<input".((!$nd||$r==="")&&preg_match('~(?<!o)int(?!er)~',$m["type"])&&!preg_match('~\[\]~',$m["full_type"])?" type='number'":"")." value='".h($Y)."'".($Je?" data-maxlength='$Je'":"").(preg_match('~char|binary~',$m["type"])&&$Je>20?" size='".($Je>99?60:40)."'":"")."$wa>";}echo
adminer()->editHint($R,$m,$Y);$Oc=0;foreach($bd
as$z=>$X){if($z===""||!$X)break;$Oc++;}if($Oc&&count($bd)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $Oc);");}}function
process_input(array$m){if(stripos($m["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($m["field"]);$r=idx($_POST["function"],$v);$Y=idx($_POST["fields"],$v);if($m["type"]=="enum"||driver()->enumLength($m)){$Y=$Y[0];if($Y=="orig")return
false;if($Y=="null")return"NULL";$Y=substr($Y,4);}if($m["auto_increment"]&&$Y=="")return
null;if($r=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?idf_escape($m["field"]):false);if($r=="NULL")return"NULL";if($m["type"]=="set")$Y=implode(",",(array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(is_blob($m)&&ini_bool("file_uploads")){$Mc=get_file("fields-$v");if(!is_string($Mc))return
false;return
driver()->quoteBinary($Mc);}return
adminer()->processInput($m,$Y,$r);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$ch="<ul>\n";foreach(table_status('',true)as$R=>$S){$E=adminer()->tableName($S);if(isset($S["Engine"])&&$E!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$K=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$K||$K->fetch_row()){$og="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$E</a>";echo"$ch<li>".($K?$og:"<p class='error'>$og: ".error())."\n";$ch="";}}}echo($ch?"<p class='message'>".lang(11):"</ul>")."\n";}function
on_help($fb,$kh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $fb, $kh) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$n,$M,$yi,$l=''){$Hh=adminer()->tableName(table_status1($R,true));page_header(($yi?lang(12):lang(13)),$l,array("select"=>array($R,$Hh)),$Hh);adminer()->editRowPrint($R,$n,$M,$yi);if($M===false){echo"<p class='error'>".lang(14)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$n)echo"<p class='error'>".lang(15)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$_a=!$_POST;foreach($n
as$E=>$m){echo"<tr><th>".adminer()->fieldName($m);$k=idx($_GET["set"],bracket_escape($E));if($k===null){$k=$m["default"];if($m["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$k,$Gg))$k=$Gg[1];if(JUSH=="sql"&&preg_match('~binary~',$m["type"]))$k=bin2hex($k);}$Y=($M!==null?($M[$E]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$m["type"])&&is_array($M[$E])?implode(",",$M[$E]):(is_bool($M[$E])?+$M[$E]:$M[$E])):(!$yi&&$m["auto_increment"]?"":(isset($_GET["select"])?false:$k)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$m);$r=($_POST["save"]?idx($_POST["function"],$E,""):($yi&&preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$yi&&$Y==$m["default"]&&preg_match('~^[\w.]+\(~',$Y))$r="SQL";if(preg_match("~time~",$m["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$r="now";}if($m["type"]=="uuid"&&$Y=="uuid()"){$Y="";$r="uuid";}if($_a!==false)$_a=($m["auto_increment"]||$r=="now"||$r=="uuid"?null:true);input($m,$Y,$r,$_a);if($_a)$_a=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($n){echo"<input type='submit' value='".lang(16)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($yi?lang(17):lang(18))."' title='Ctrl+Shift+Enter'>\n",($yi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(19)."…', this); };"):"");}echo($yi?"<input type='submit' name='delete' value='".lang(20)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($zh,$re=80,$Ch=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$re).")($)?)u",$zh,$C))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$re).")($)?)",$zh,$C);return
h($C[1]).$Ch.(isset($C[2])?"":"<i>…</i>");}function
icon($yd,$E,$xd,$Yh){return"<button type='submit' name='$E' title='".h($Yh)."' class='icon icon-$yd'><span>$xd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",'1');if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcQCa	2ód<fa:;NBqR;1Lf9u7&)l;3J/CQXr2Mai0)e:LuÝh-923li7mZw4њ<-̴!U,Févt2S,a҇FVXaNq)-ǜh:n59Y;j-_9krٓ;.tTqo0{y\rHnGSZh;i^uxWΒC@k=b/A0+(l\\x:\rb8\00!\0F\nB͎(3\r\\Ȅa'I|(i\n\r4Og@4C@@!QB	°c¯q,\r1Eh&2PZiGH9G\"v4rDR\npJ-A|/.cDu:,=R]U5mVkLLQ@-\\@9%SrMPDIa\r(YY\\@Xp:plLC O,\r2]7?m06pTaҥC;_˗yȴd>bnnܣ3X8\r[ˀ-)i>V[Yy&L3#X|	X\\ù`C#H22.#Z`<sÒ\0uh־M_\niZeO/CӒ_`31>=k3R/;/d\0ڵm7/AXq.sL :\$Fw8߾~Hj\"Գ7gSFLίQ_O'W]c=51X~7;i\r*\nJS1ZctAV86fdy;Y]zIpc3Y]}@\$.+1'>ZcpdGL#k8PzYAuv]s9_Aq:\nKhB;XbAHq,CI`jS[ˌ1Vr;pB)#鐉;4H/*<3L;lf\ns\$K`}Ք7jx`d%j]4YHbYJ`GG.KfI)2MfָXRC̱V,~g\0g6:[j1H:AlIqu3\"q|8<9s'Q]J|\0`pjfObq\$1J>RH(ǔq\n#r@e(yVJ0Q҈6P[C:G伞4^PZ\\(\n)~9R%Sj{70_s	z|8H	\"@#9DVL\$H5WJ@zaJ ^	)2\nQv]j (ABB056b˰][kAwvkgƴ+k[jmzc}MyDZi\$5eʷ	ACY%.Wb*뮼.q/%}BXZV337ʻawW[LQ޲_2`1Ii,曣Mf&(s-Aİ*DwTNɻjX\$x+;F93JkS;qR{>l;B1AIb)(6r\r\rڇZR^SOy/M#9{kv\"KCJrEo\0\\,|fa͚hI/o4k^p1H^phǡVvox@`g&(;~Ǎz68*5EpӘ3ņgrDL)4g{峩L&>脻Z7\0̊@ffRVh֝Iۈrw)=x^,k2ݓjbl0u\"fp1RIz[]wpN6dIzn.7X{;3-I	7pjÝR#,_-[>3\\WqqJ֘uhFbLKyVľѕVf{K}SޝM̀.M\\ixb1+α?<3~H\$\\2\$ e6tÖ\$sxxCnSkV=z6'æNaָhR噣8gw:_ҒIRKÝ.nkVU+dwj%`#,{醳Y(oվ.c0gDXOk7Klhx;؏ ݃L\$09*9 hNrM.>\0rP9\$g	\0\$\\F*d'L:b429@Hnb-E #ĜrPY t \n5.\$oplX\n@`\r	\r  	 	@@\n  	\0j@Q@1\r@ 	\$p	 V\0``\n\0\n \n@'\n\0`\r	\r\0r	\0`	{	,\"^P0\n4\n0.0p\rp\rppqQ0%1Q8\n \0kȼ\0^\0`@>\no1w,Y	h*=P:іVи.q\r\rp1Q	1 `/17\r^\"y`\n #\0	 p\n\n` r Qb13\n##1\$q\$ѱ%0%q%&&q &'1\rR}16	 @b\r``\r	d	j\n``\n`dcсP,1R\$rIO 	Q	Y32b1&01  f\0\0f\0j\nf`	 \n`@\$n=`\0v nI\$P(d'g6--C7R 	4-1&2t\r\"\n 	H*@	`\n  	l2,z\r~ \rFthmz~\0]GF\\I\\}ItC\nT}IEJ\rx>MpIH~fht.bxYEiKoj\nLtr.~dH2U4G\\A4uPt谐L/P	\"G!RMtO-<#APuIR\$cDƊ-GO`Pv^W@tH;QRę\$gKF<\rR*\$4'[IUmh:+5@/lI2^\0OD\rR'\rTЭ[ĪMCMZ4E B\"`euN,䙬]t\r`@h*\r.V%!MBlPF\"&/@v\\C:mMgni8I2\rpvj+Z mTuefv>fИ`DU[ZTVCT\rUvk^Lb/KSev2ubvOVDIm\$%X?ud!W|,\r+cnUeZʖ-~XBGd\$iMv!t#L3oUIOu?ZweRcw.`ȡi\rb%bH\"\"\"h_\$b@z\0f\"rW*B|\$\$Bנ\"@r(\r` C(0&.`Nk9B\n&#(@䂯d^ @`I-{0\nB{4sG{;zb{ {bׯ){BxKŇ5=cڪy&JPrI/ \0V\r׉=N\\ئ=K}XVxإˋxdՊی*H'δ{X==\08\0[ɫJtOeɋ\rDXŇ}z)y''яI([l(5`f\\`e.lY(=zה!Y%hO+`ٙ\"e ėKߚ#SEIY.HJtG`HJ55~ 6ChXDz\nxyshFKczjZY8(%|yIߑ؃eYXu i]cM;ȧ>ǡQT [~W~c݂zz\r:  \0rYx)!ɡK+z!ӀC+ٮï:ݎZg~z4f	:sӪ+x%=GIf3?+Yq@GyoѴp\r~{W[y:\0\\;eۡYI\"zdkZ|[uu+׹9qnR ˮBׁz|\rᤄk^[1%.pA2<=ء\$;5)m!XXYx5vT\\Q%:>ɛ;e|/yWxנ|gC\\<9z\\#.FV;8NX7\"8&d5P4Gj?\0?\"=HER");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!\"-6NbdGg:;Nr)c7\r(Hb81s9k\rc)m8OVAc1c34Of*-P1r416d2ցo#3Bf#	g9Φ،fc\rIb6EC&,bum7aVs#m!hrv\\3\rL:SAdk5naF3e6fSyr!L-K,3L@J˲*J쵣	bc99@H8\\6>`Ŏ;A<T'p&qqE4\rlh<5#pR #I%fBIܲ>ʫ29<Cj27j8jc(n?(a\0@5*3:δ60-AlLP4@ɰ\$H4n311t0͙9WO!rH9Q96F<7\r-xC\n @:\$iضm4Kid{\n6\rxhˋ#^'4V@a<#h0S-c9+pa2cyhBO\$9wiXɔVY9*rHtm	@b|@/l\$z+%p2l.7;&{mXC<l96x9m7R0\\4P)AoxqO#f[;6~P\raTGT0uޟ\n3\\ \\ʎJudCGPZ>d8ҨC?VdLL.(ti>,֜R+9iޞC\$#\"AChVb\n6T2ew\nf6m	!1'c;*eLRn\rG\$2S\$0a'l6&~Ad\$J\$s ȃB4j.RC̔Qj\"7\nXs!6=BȀ}");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zc|^RE8kMsdka)h%\"P0nn/#;g\rd8F<3\$,P);<4`<2\n@w-͗A0LrYhXCa>tL2yto;2Qtfrm:AAN\\\"k5oVɃ=t7r1pAv\\+9{^(if=rut]yޅCgivf+Ø|;]~|\re쿓݂'	\0+Wcow6wd Suj3@0!\n .wm[8x<cM\n9'a1>[dux<\"YcB!iw}5Uk]{IךR=f W~](bea'ubm>)\$P-6R*IGu#ƕUKAXt(`_\"p &UI]YG6P]Ar!b *ЙJoӯv*!~_4B_~RBiK`&J\0N\0\$CK SjZ0pvMJbN`Le/`RO.0P82`	d GxbP-(@ɸ@4H%<&Zp%\0pЄ		/\"J\ns_\rg`!kpX	:v6p\$'RUeZd\$\nLB.dntm>vj)	M\r\0.ʊH\"5*!eZJf(dc(xjg\0\\ Z@|`^r)<()@Ykml3Qyс@ѐfPnTNmRqVmvN֍|ШZȆ(Yp\"4Ǩ&%lP`ĀXx bbdr0Fr5<Cz6he!\rdzK;t\n͠HƋQ\$QEnnn\r#T\$ˈ(ȟѩ|c,-#\rJ{dE\n\$BriT+2PEDBe}&%Rf\n^CZZ RVA,;<\0O1c^\r%\r `n\0y1.\rĂK1M3H\r\"0\0NkXPr{3 }	\nSdڗx.ZRTwS;53 .s4sO3F2S~YFpZs'@ّOqR4\n6q6@Dh67vEl\"^;-(&b**.! \r!#x'G\"͆w\" 2!\"R(vX|\"Dv)@,zmAwT@  \nЫhдIDP\$m>\r&`>4A#*#<w\$T{\$4@dӴRem6-#Dd%EDT\\\$)@WC(t\"M#@TF\r,g\rP8~֣JcĹƂ ʎ\"LZ\r+P4=STA)0\"CDhM\n%Fp|fLNlFtDmH5=H\nļ4\$K6\rbZ\r\"pEQ%wJV0M%l\"hPFAA㌮/G6h6]5\$fSCLiRT?RCHUZYbF/.Z\"\"^y6RG n܌\$\\&O(v^ KUѮam(\r\$_%+KTt.ٖ36\nc:@6 jPAQF/Sk\"<4AgAaU\$'fQO\"k~S;.:k9e]`n-7;+V8W2HUYlBv⯎Ԇ	plm\04B)X\0QqFSq4nFx+pESovGW7owKRW\r4`|cqe7,19uucq\"LCth)\rJ\\W@	|D#S\r%5l!%++^k^ʙ`/7(z*񘋀E{S(W-Xė0V0=a	~fB˕2Qru mCtr(\0Q!K;xNW?b<@`X,`0eƂN'&~tu\"| i B 7R lSu8AdF%(?3@A-oQź@|~K^@xb~D@سTNZC	Wix<\0P|\n\0\n`\"&?st|ïw%mduN^8[t9B\$'\">U~98ÔFf u/)9\0Az\"FWAx\$'jG(\" s%THe,	M7b ǅa ˓ƃ&wYφ3 /\rϖ{\"ݜp{%4b`팤~nE3	93XdՏZ9'@lfQbP*Go`8AB|z	@	bZn_h'ѢF\$f`HdDdH%4\rsAjLR'f9g I,R\\>\nH[\"\rӁL,%FLl8gzL<0ko\$k`KPv@d'V:VM%@6<\rTLENԀS#.[x4a̭LL\n@\0۫tٲ\n^F5` R7lLu(d \rBf/uCf4cҞ B_nL\0 \$aYƦ~Ukve˥˲\0ZaZXأ|Cq/<}سú Z*w\nOz`518cIQ2YsK\n\\\" ðc*B.R1<3+*S[4m쭛:RhITdevIH-Zw\\%n56\nWi\$ōow+r&Jq+}Djd?U%BBe/MNm=τUb\$HRfwb|x d2NiSg@q@>Sv|krx\0{R=F#r8	Zv8*ʳ{2S+;SӨ+yL\$\"_B8\"E%\npp''pwUҪ\"8бI\\ @ʾ LnR#MDqLN\n\\̎\$`~@`\0u~^@l-{5,@bruo[}/y. {6qRp\$+13+O!D)\nu<,=Jd+}d#0ɞc3U3EY\rtj5ҥ7ewׄǡ^q߂9<\$}kRI-+'_Ne?SRhd*X4c}\"@vi>;5>Dn \r)bNuP@YG<6i#PB2A-0d0+gK?nddOci<0\0\\gꡖNTi';imj܈uJ+V~'ol`\",F	{CT aNEۃQp p+?\n>'l* tKάp(YC\n-q̔0\"*ɕ,#7\"%+qB=i.@x7:%GcYI0*Ðkۈ\\Q_{#\r{H[p >7chn.S|&JMǾ8mOh	qJ&aݢ'.bOp\$D@CHB	&ݡ|\$Ԭ-6++ pଡAC\rɓ/0MiZnE͢j*>!Ңu%g0@5}r+3%-mG<T;0DVdg9'lMH F@PuntFB%Mt'G2@2<e;`=LX2X}oc.L+xӎ&DaɫF2\ngLE.\\xSLx;lwD=0_QV,a 5+L+|\$ijZ\nDE,Bt\\'H0R~(\\\":n*(o1wQrEteF\$Sђ]\rLyF\\Bihhd&ᚇh;foB-y`0JlPxao\$Xq,(C*	:/HG\"cCQ\nFԄ#8F:У\0OkD])ϚtT8L𒨔n`|HJ  \"6{?=I<HGc ŤF@,C @j\$L(nEʑPjbnΑW \rLqsPHꉝz\\V\$kҏtr5,l<'\0^S020f -5\"ac\"3Up\"ܘ%\0'Zt\"969_ @Z{0IDZE@Nh`\"`\0ɹ(GHCh If`@ZD\$)K;Z\0/CT>r_R@O`1rTҨIb\0*8h\$_pRĕ\$Ni^ʪP/O).ŹT6\\ٔ@Trą`)T=n\02e+9ʢ\\@>PH1	y#r<aeK/cM@_.\09ˈB0ia\ndea%|S2#nD\$/+Ed_2P\$s,ok#<	Ađr{BA-Q4Ҥ\n\ry!b䱎O@ɬk \"r*݇Y/ȑ a0%.gE~& 89#@M_ 7K䃸J`X)B\$(	:gn*|M6PZHtJtqCx[ڼl=\nU3f\\̔JP	,:}TASYH(\nIٲ!t(2U\"\\X^s	a!\nPr`X3fnbJ&zzQSf t!T?9%(QB}6BkP\0>g&~fhUr, p5HipqɚgVVOgWEJ80Gak@N NMUUxȪSx		K@c1yVlϠC2Q^rP6|I^M,j%d`ܫF\\#%|C7싢GTNiHQOCyB\$%T*>z\rMM Kp J7O۷4%\$p4͂EҪ\"T\0O\0@>	rO]x}^I@ źqn0BbȵI(M/;}RN\nC<bPԵu?=PeCL^'S?}4)S-1\r5SOESFAOR+ޙ+v5&C)ِKSDB߳N|E\rcUYʾV?H)実+sFkLPW-,U:&t{VoJl'We74Xn GF'`Cc%Ilju6vUZ\0*Nԟ#(n-;|4]Xy';Z) s9%R+\$	Q(\"_kX\nM#\"!p~:*\$3O6+\nB{1|HK<[`3#F@ǐ! |؊\0>[nrMM+mO_2Ȇ\0e^	7Z&BJ褓h7QO%rfp΁֞mبÇ4El+ViN SZWt2W[;v\"%\$^-(I\$S@R-&Tzk(	%R8uY\0[9-()E8=^G5#)1Vb\r]Ne;&Y`rIPݱֲ\0@P70H؍Rx\0000C|n=`TT\rEhON'&tcK ܕU5P3\\2\"\0y5V]6>U!@hu(\"E%07B6dHNij';@eMzlSfjKY֍-uhHsmL@\"rjj'l7	(uuEea@+K:ӕ%nzV;[_Vz_E8<Sb6g:c7\n%Q K7ܮBwu50֚yncnKT8ʙsW=+=K\n_[pGC5'D\"M<\":|Mq4fsx	qlͰQPaOYE=6nT떒BthC\0p@nD(aP\"'ZN۬\rLNXg<!w[B))~cxvi¦qa@K7sEQdýk?\"3-\"U||21D>߳]­&\\hTƳ5\0`Tzs -N\"fNLU]n(D(&%\"e\\ONInۿ\0ƕ@V|RMYCTbUHp)Ss qi`Z5vt坉*OO\n(F58!ax@{^P?eh}\\j^2L,6.N	K%uip!?l -5wK\"V\\Is2!\$45v\ngrN};W%D(pWa\0v'6Vƿ0WE4EUl8LDE<kOHDU	`vSL!DTMbnWVCd)Ze蟀:2d8Kބ4-Gb;wQW30\rf\0,`Qhl֍0P0h@\\r8T⛜1`&wX>F?|P*MqZѯ}0k`#իc'[ֱˍ|sIJ\r<OaƼ@WuT:E^!ka\$>5u_KcCQr-ъ'\riC@8SPS_Xgl%	n1r.<w_aɺĳGh4\nWZaBn,\\\0DU\nbbZ'72r¢}Y>/w\\Y`^7JjSS.o%Jg\0GD,>7R036%i\0S^LA\riO<a phv[{\0E^xܼgYzWyGa:(>Ce\0])3yts_a7+BCeTfoP2ECv>wlz*pYqQp\nv[|qҨE[Xi=z(	Mn]7F\rCs4|-} Ŀ(NU?,څq	pq~ F%88靦\$ް[ro!3(gץpJ!qZv?cL76\$mq8l!5C;Q,dsF-OfÈ\$6%UCf\"e(j\rMtFRx;nB\$SSx'G陊M	4ͬ'k~#9eY~뭈;f+jK9pM'X/rt\0\\J%QR\rвO3|寚ϱ4xFs5EԐ;ԒWRJXʶJ\$wzO&ǵzkS\n\nNUP.0bdkP	G6+Bz1ΎhQ>sHvQ٠EpM)\n\\ўPz.s g)a~ȥ!(!Ghr[*բ`~\"!O5G3Ş*qkgB,\$**1c.n	8\$dVSneMiZ7žgA5\n`,2aүmMkʻɯ/-6@?#`)Ԁha)Vc]_=Rz\\VR=ط(-ot\$ܥ\ndSmyfөN\rm(t;Dp2ݶZRl)9M̛,/Yixkя).2@S^ud6!>VB x<Kt06@\nGAP(NbDK\n\"cN\ră.p'2Ldꟲ\\LyA=	Dm3%@8qbSP\"ޢƮ/DzC&O\0007fD^1X/,\nvWx%f)' DdQ@I(ҋ7Y|AQDڠe 8ׇ7k)_ @\"\"%}	(11؍\re?-ɵH&\rL'eۮ0T]C!emNz	UzɈSܜaf7M^CD(_#\"dr5981hfȭa_×tZX\0U{2nn];FR!}>sHiy#?\"Ť>{/?7FY?Aj.U!5`H\$r\0'\n\":.dԂٙƪqRխoh>{1+>tk%-D=9}C@8cmHrWn\0Ď<(RR8YV`pp.Ue_`^쵛n^_R|r΅p7/!M5|\n&FVVzOA~ш|ƛ4NȒՔgyh-\nN\"r\"GcsD'Xo٧O{{Y{E=TeZ{\";HXztw*-Uw-\"<A^OT ]D?:<pq[,)&`{xKII``c0Dy8qCYCFJnk[8:\n^ցT!X*M<5`\06A2oP.aAH#x[▞ 'o@O0^h|P=+)d[X-W!Æ/:\"0k#XǞ<hCGݠ@F(kl&HF0OSzwQ3z|+\r9bT}'ܬwA\rnF!g0lpl1+|hkzi&uD{K\\\$t(;ìHr|BwD3[M!:({Z(|-Hy0^'׽}*NK5KUjM\"w]%{1qz)]Ů[k\0O4UF\0cmZEGtsDQZ)n;7<qhlXxI^V&ͷC`,ɑ%1\"@1|)RkV}S,#!G]ExYT<%Qѿ@mJcBB iGf2cDnէ=JI_'iA&,{c4oV%d2xe#s_UHՉW!  =۷O<(y\0.G'\r57pV(þ:}RRHHy[	 1O\")Ll1+<~	\0s?B@d?n~&LЄ?@:@;yQ>f:\0t+jszK,b^pHX?P\\D?v\"\"& ?t`V?\0JwC1O#Ɛ*	@̿\0Ƈ/#8\"O\"\06Ncä[p@Ch\0{\0	pDOFtH/!h@L;@wI~Cˀ¸)E4+)Eb?]d\$<`o?}8b/Jo#IV,Ac3Xa oxi\"椌CUDkYȊ}\n\r\0,G\0|q .ŊNqpNДjBO\$|Cp}4`\\*4bA+D_X\$@6\n\0\$~ˣ\0Jb݅ UpXiD\"ێlgt' +x<N51e0`B8q\"O- 	C!Қmɵ*f@#6ZЛ9ZRǁ	HZL e99 T n?xX\$0%\0002\ny!e:\$QssAnxKl1'Nz!p.Ṇcp1@)m:@P\01\n(CR5D(P1#	d7+\nBuhaM	a\0>1W\0a4 s-ׂ'jp\nJmQ)");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:A,Iv4ǢꆌP-\nҸ%>(c(P74c8X`X:\r3 KIAHHs\"N8R0HY5GDW(3Ut  P9MVd?4\rCPbؼ2*b3T`nVMsb0]pG%n\\E]8ߋh7E`@PIjVTz\rC+R8\r\0aRؾ70l_2dYAxPZA@yART o^CK~c⊰{}cZ.~!`@C.ޒ.y\nl9wt\\C\$pըp8/媤eyn_H!fwZ%hc5~[H{\$\n\r!4nn6͊cHJ.6|`ӛ;.ް[pWݪ>\\hWZO7PxApUW)!/pi[~X\nR\$8?BEy!cPC5.\nH]=y*\$st`57a\r\05j-g\0ͤ#oA\"p;\nH<m!dÙK>+d=p)pP	#|<)70-(ek9HE9.N䔒J hL>e<ۿC`KxVA aPA9WIy4WjpWdER2ip#)CD?ruxs|ϸAX+?l<H&T#|РQb -\$}Ah:t0PD9!9SmHi\ro}ƪP_Eaxfu{Ӳv<)/#QC*ܪ\0rNirtGNow>MӼ DJCv``Na@](U S5{=9N8z3^<		Xc\n=@s3&ꚠdAj%\ry\\{<#	UgR`^K4l!t{\0W&|-U/7yUCXR6uHVu|IV\nq<鼇*p)&Nq/Rل\nV	83<;}_ph\r ӊpt9#%<2id3Rs\nkOf9pA\n9  IYCc,U2^\00\$NqsJ+d*@1:ukΆ!4;@zZ&d\n3\$ݠC]QBVwp.K\\άԌ\$9i<2Zp:a`US3|T!&P,c=0=Nd뛭6nZyiTTJweSu'nm틸In\r;ݔ*)Ai1yQ\r_8?՞76l1ǽ{cvr{\\.,ۼevkۛe~L^7\n@.s8t}ɘ8C-ѻ-4IdO{sջ8[˵f;}Qs^ݹQ2[(@\nL\n)(Aa\" 	&P@O\n師0(M&}'! 0{6}kʘ@;px6zg|+D+ϤyJL#}~*/}4|Aw<wOX\0~\rڏޏZ*\nϧ\0v0 */hD?O\rnBPFo0\\`0fkrOHphxpq֐PTbOPį8揢POo.0·\0\r	PEK͙\rP)\roTv \rDܯoMA(XhCL&\"h\r,N^qKkb\"	}qy\"R`\0n+\rnqHHL\0V%F: ؎\$\rf鬶јjBmQmG\\蕱nk%\"Vdk@ !2+6% ~Ğ% r.R[ 2?\"̹#\0Ԁw\$U%#!%)\$	\$LmA-W{@ܷ#_&x]\$S'\0\rg@m0`df`G&L\0':xjx*оDL(q,&lNt*\n	 %f(оkZ	%in\".Ļ氮~\0U@d4'r\rn#`2H g6&v'\rrS^\$@Xf>΃k6r7`\\	5V'W5\rdTb@E2`P( B'0/w␑s&r.SVsє9JJx&8v!`z4\$k\0x7pI өA9;\r~4>~'\nPs0PQA+/7`WOG1Fp暴\n|\0PGGtI\"TiGO@FV~G荔2\$%96,7LLSoLhP5ʼУ\0P\r\$=%nUjXUkϋN\0\r)F*h@kB5\$56Lbs|Mo8+8\":G4ONS5#j\"NncJtT%(DUS]Mj\$TK`5o@rYSNR1ER\rEXrNJ7bgTUxM5*0r:3		2i1QkF0YZstec\n:oHFExu#4S#	 	\$t?E(p(R\"|eBX8	4>\r/<\0E,^D.E{5a܆*\rZg|~\r:moc9Jv*B7rT&nlHPV6mDw)m\rCVw\$uSwS`ADLS6qk)Jkl'LhB9h Jimn<\0  <\0[:\0K(~s\0K̒Y'ʈgaO(]v:&!`PxV^wnĹ7\0&g|B\0(*,ľ²d7⛬tzwz\nE\",\0\"fb\$B(h(4ժ5b?΍wq|@Ƙ+؁޶&Ɋ~NⴎחN6<uFxWQ^^;P.#/|Wȃ8k./7K/wQl8~Qψ\\1\\&\"ئWR/)|A5reE@k\0OwK&f\"'Lml@ۄPZ7\r#ox`]b̄NzZ@0NR,x[Pc8zX\r?Ǎ?92x}LF'LPyzð\\ƙǌT ŤiNǀTx%xaucw#l,\"Pb*g#Zud,5\$D3]؛?h~0\nyN7bz\0a5qkpvQ,D[A\\EyKyP#UZk&)E9q\"7![QMd۔uQJ#\$o]jۥgO\nXD6꣢eXZ:E:OUbz]7sDc0`?\\S{ySihzEiij&׫e'kXy f6V-ZWewŊ;G\${SK7	1n>@izzw9{x;\0\nIyk[7{޻8-~w,[lȌ@ϷVԘ+Ӌؿjcؤ\\qǊY'zYݻ˜?aA:Q٭(} \ny#Sy\0[?/]My{ˣ9=PϫOLs\\sWDػ˱|7jN-E˕+`uƼ\rM}~I~iڴ|lv}YL1l>\r9,oY9}Sgg銼:u)ÈCR%~|~w0]|\\yϙy\\ج7йe,mu7(T],wθfU=TRW6<Kֽg;||1\0Qy\"9vb\$5mwΆo\r\0xbkH|ɚ Z\rhWʜ\\Ա.3U\r˽ؘ\r>?2)᩟/=50@ƅH~<нx_/˾3~I+~l~HY{Y^]^ae^h^r+>CbB,2/LR#mRKIK'픕EW1]Fz_]T%4̔\0V=4;\$T 枍{?לּԞ3n\rz X?cp\n?#adX\n:z-^X!`:\0y,DlJ`A)hU+5+~_+<b]<m5~']')ެܺ/Pr4o{_ngHFpBsH1)bb?톼\"[C<U~<0y:G@}脬z޺w)}[ꖞ<8&X\"`BWw{kU.E;=pQɢR)t\0;Լ*JC^ d,+d-~*xpn@A?Qh{䄳'A5P{dX`H+sSkX/E(3=!004\rjłZa>m4?og3xƕJW\$EQ^&\nQEhjqCNƠ,yHβ\$'@\n;\0\\]ϛв(\n6arǩuP/;P#q1\nPB.6`\nFٰ͒W3dbZU֜=xa@=fZ;Bk謀mJNg^prٲ(Ilcp*AOU7\\D<Tf+THϠ`RZq[`of\\\"πx|EfŰP/S\"_8-CF]\"jhF29!Eb[E*Mx\0`9DU_tюq^(j!tX'E_ػMQd^b|,{4\\MXFf-kN`7,BJG5&*1L4	#-`'\nL?\0)|r	X|e\nJ9@ʬȥ6qX\"qE	Pm¢NҖ7}	<I\nA͌juL+F'CZd&RncIl\$\")|74hCvcs}sG0~#feB.rO!<]/d[A\$)JP\0Y%F`&BvMIIP*7֐2&lXo.\0KZBq&<Jp	ei;\r0PBHMLİ=TXc1&y-I6fN|&yRn0r	%VRKRdH AY\n<JĺL'~V \"l!d'`q>Iit3:Lɲ\\s%ͪE@HC\nf\"@ 11 ln͆/X\\DK ^-n|\"\n8@{)P(P(s f y0M@\0&bQX]3	8<#11<.bf*p'<4)1\0)n~cȁTStI11(\0P,d\"=@6\0w\\fzYLn(O}5	W=2Y͖e@Ol܀7INmX\0N:nB\0k|,p>Nxnxh5Θ	Gd'3MS\$H1iN0݀8Mvĝ\0P\\NH\0|9@\0!dHNɥL\nS؞؀*MQu@&7i8򓖜)1\0#Ljr3\\9HKd?hg:	OzvsO|\0F4>ϾpS|<*LBw)<?9@	3+7ϲes\0@Ђy\$\n(#B'Rӫ5CiР4:C о}4D(i<jPQ\0ADf%>L4T@IOXX (&l')}\$eIfN_% 4i\\UhC=Du'@v8dB-%(T%7㖨f\nX\0m@C0I\rɽw<QhS09@I,t')˦\0J7\r\0!ƷW1\0~_\r2\nf܊@QK9\r\rXi{/~2Z_2'*o	Uس\0{e(\$iM4T44}6)mV}A3Q\0l/=@QZ:kN|Q&4JR*iSP5\nt@_)QIMXoޠk19B7=\0ɷ̆l|[aa.Ԩ\n\049Βv@GPO'ZHX'VZ@Tng7>l3cDXZfjY_mX)ʀzG\"P2|\0NjX{\00dTl \nq;߁:bShfy)Q+jSCQyS0Hq`	`FlpT+yrjZKcWmA:y5\0P&zWZ)D	TvDV3VFȭRj֭pv5)'X&@.C@`pTlSw_	#:!/5rrr;F&M@\\C\0\"\$(TX+\$t+r84XfId#&cIPZḻ(lZ6^3|s\\=Er3w+(, c^|:`h[UahtZԶO;qyv\\A^x!j2VդմEd0رְ4HYHz 0+Rjf_kAJj[,U\\jXX=ZDw5uˤ՟n	%'}&p& )qX\0+_9C)Iۊ)R짇`ĵ@/!+UAf\0R=A%r3{\0`%z0\$>Ѹ=h]/64\0i_2Ue;:JNuV|@	GhU=Qh'(T>,n?#tsf=cVvu`U'X)MQpp7פ!aJl0@ZFE=ClJduAJtȪp0WUwƁFa\niݻXJ*o*6k8N[*/uMCUMaJ޲V!U!+Ŭpxh<@B] ;  u_2RL:߈	4.f1@b%\0!{=Mۿ|`x	\nтo!p)_tȾ#pai\\3D.񶕁Y2xFg넞8'(0BJ@bZn	p\"Ee9J0X3b\r; S1[y=(73	Ñ2*l0!VlrZ@<TKmXiF\nU?fT\$i8GS)L\$8BiD!\\B#<4aT+@-7\\x6p?\rN/黰%L+`ht<W>{~(@R06ǞP+{Esö\$*b	&#[X̯&bnSUl,0G~}cUf'dCs<m\r;<*4~ǉoam4]/02cFxwH;Rqﵾ&	kX?AIƠ\">x?,Pbiū)c<\\++^n3ő|N'!+PGN5TBK!1\":2bP,Fy*NÓ<a[&3t閇7\$\\qߔ 2ecInTy2c_	@\nup x+XUq<A.Kʕʎ!2?8fr˗8\r8(p^!!Y=q>\rv-πٗ	1gf,[,e'ZX:2\\Hy<1)[α;D|#H@LS3>;]2Xvj.GEBi+d%,Qr%Ц¶*I5`t-sb8E۾e\0=2/Yq9-eZ1\\^U`&gWJYhK]8W@;p##Bynqĕ\$uY!\$)(rX@/+L8O^ʔp6,Ѱw<%MSS=Z%W\r\nHy/2+e1Eɣ\\Uw	(p\n-ISEZiI@1	`\$448>\0iMӈ4QjYyp#x`m'Zڂ6zaSi&ʒR>z\n{TiP:jZjTtR@:ޭ5hj{\rfr\"x|cx?rkp.r>tqC	k5ha\nU:yxW8k)3!ҋk^t}-x5^B(q@Qd]ƴCr\"kw[&usW:ꕝN@d=+Z9N@m{-%>HR0*7K/<~,jsnP\09.͵Sj\n74ݱ,\$;E-m\0*Ȼv7c;u&vֲ37ءy(tn;JAG4hfR@5)V{[Ymb61pJ6;[.Ŋ[rb9V0\rw݀CwVT&=,hzH)8EsIt<@e+0ynjTƮw~dJσ@)c+h,ث8pL K:QAog1o?IZ.?=~nkF!n%/Et0'̔P<ƵGqP䴓FxAq⃫vn`,cW{9K߇{|+s<4Z+צ6PPL(L=ծjfh>)A혠qpK̆Ҡ~6d0Y#y}tORCS_燜|bHwsO%UwpN򈍜Y]U\"rMt\0jxoWD[[M yT8@9h!̋r`\\/4u{d8Sǡsb\" i;jiǿkj}vi74߽J9=՗540'?(7qg t	_[zӌ\\w_>s_g\0V|\$p-BsX܇.;3gPCDGy1j\0y=M˞;Fm(oD7ykbo=!:.%C%t߿Xm\$6&PbjTu*Tx\nd5Νt^d(S|-q\0(tXYQ!HFk0t4H|oNoN%\\w\"0Bq\$[玙f|q7~EyXqר>| Ob*\nImcEЮe6ev˟LnɩKxx~aǜf)9˟]F!sIiNh~ӔR.GF8/zdCf6-#g|t;4TV)kV/yC907h@).HqEN}K+Yr\nb3@K1 )lA˧=#HiLʄ5oAB>Y@\n1H!+ȣs0GH~^7ـQrI8\0Ì`\nw=0Ay[Q8HOg m#ʮukHB#oufoݐk^!p{}4Iv?x{CY-ICמȒ>0l\r\0|Q15L/j3;Lﴷ^{Un(}bW١+>'{WsC~qM;PRv̢Ɗ:pQG 7a;_z)|:g\0Y*/kė\n>U0xH@-=\"0H^UE+x+#;1kyTh:G&-!qs3^|xW-l!׸FXt]BXY;QL0cIojAQLGG%\$(wҹEhXKaob5sAt/\rݒ`w7<MP*yYh>Pr=zjW01gdliD/}^V\"b>XRnr.0̙9@ ۮȷ;&^2hYXh(b\0؀/\0l:0܂?t%> CG4@@E< h	O0K\0@r[\")AoX4z NR̃`jkP ]Ol2\n*b5Dn2(\$<)Hac:ϋ/8i:n6:0;<1LP\$ أY\$:0jIP\nrL!wN\0>~/`4+\0<^RXU6:\0bN莌*.Npxp_ 8\0XoKb蘖|l\0Ɩ)\0P:<pl\n@ASPPƚ\\ A03\0006 (.pv}9z@N\$ņ?5ㅟi+Av8`y \n;  Vp߀\"jE=x0d\$PV	xXg\\?\0ePaAJ/`pSLЙ	(PYBqОA!.bVs\$	|Pf%gzTAk0l%.l5I+8I+BH*pQ\nG^B	rLPUBqhBnB,b4Y`	|#`.B.B\$6!*s\$#<B%Q*e	NrL\0N1!i+\0Ѥ\"60bCgaN\rPUCq/P\$BNIB,%#-\r+eh&pº/d+PC-BD;DC}<BB:0Ï\rPCPBi1r	'c[\r?P*?³+pA,1Q\0L@qDh.YP`0@6Qb\n\rޕ0\r\$1@=ĺB֔ -tXBC1,+BI%	ֳ(KT\0F@/7X\nD``[ΕpDLDQ\0\0N`3^\n@%	9\0[ 	LMA믤Q2Q8)HWGDb%\np	S(#tDHQq[f]\\'(B@^(CCvV[Ř`(^EZc!7ÑE*Y1mEuY_E\\`Ec,[1e]`E\"䆬86 zq]hŀx@OE\$O6}Qq=!\nŐ<b:QcO'b\nT(|QqFR`&E*1R!L^f``ņc\0^H!yg|F\rbFl<ƐcqeFipFhϖ\0]Qhqbƨ4O #\$=\$gFkFp.<\0k`nƦO(J [qFj1F4\\(3\\TgD-TCA+ \r7Mx	\0Z	R\0005p\r1E\nVI(;R~[>`36rp	%-Ж\0	dCñ(9Ax@2!*`\0002ǲ~8S	PAڏ/ #揩-81nt*\0#O0=0	'\0d	( xG  \$\0H(2\n3fn 7\ñ`7GF@>H.5 >?B><z\$`>0RtY+ FQ΃ l@>\0̅10\$VƴK&\0@0 H>4o\0006q81P=9\n17\0D*<#H\"1|#!K3=~=nmH,#,{I#t~) ֓\r b6I!1gE/r\$)\06̎'0v3g@\\@\0! 3!4HdLf_9r,[xebf HHhpf1~D%,a)0֥%<Nc>& K!K0-;H0&܏ଛ.|#.@3!K\0002\0!07ʿeJ9h\\=dT\\\0QDId\r(II 8DrZ~(;bJ8CU!RH\r 3Iė_AN#321@{@J+#=R}2-~H.!`:T^!K)Jл(\\-\"#L0	tʃ)d/!r]8ы.SKҐ\0H\\wG:)Gʘ5+N	N\rJt0&(\na!Is!!d10D	2:53)WJ%:0˂#Z*H-k״\rR<-|Z2L\0dxKAty2vLA8\0K3+\\{e뼠!ֲ\$gI.O#򝂵)>\$g!P؀6KF#q\nWP2NzS{)|/'(kfQ*JdJ>!02\00Rbr4yJ\r <^H@SdWlT\\TTF;q!MCx!\$9_Ay?z2|I|.2)*cBR+2ԭ`K2\\R˛+B0˙L43d)(G,\"̈Ғ3xS?L3<SAM.t2. !+%8!JH@K%4A3N*d,M4/ſZcO1\r\0\0(M</Q5̭38J75S_=5ܩA-0:)~HRQt͑\0\rsdGsdL.[6@562M̒-/	\0cLΦMe7xq\0003b44`1.j@H46\$W6\0\ri\ny\08h;>Q_<40?RH10G(LfQ5/xXsbL`<8{rSɭ9@B8x6'N\nRQf`8|\n'ԟ6T(2^A*/'0Et*xɇ#dgHRH(BU#`\n\$c\0(#92\r>\n`CrKHP eP7\$8҆6Y6|ThRЄ,4sǊ* K)DsJVԟ5\nMH?/|\0006@.Lh˨>KvL\"!K(\nIOv)I v6Ü3>d!Of/KLv0	T\nؑ,,ܹ6M|Od!'U=C/Jd*ǭF<Ӹ!H;ڂ;љA~^<aSe2֘=O1 9L{9,:9,7-\0`\0` u:1| e1VL#A	Ap\r`7)@,dġ{+5\0b`LhU\nЦe\nSΖ}\0JA!2\0A,u\0006PKQ|3O	PS68\0%@0ɦ\nL5.ə \0',<)@?(P5JgI\rd9\0T̒)BLA\$cb)\rXCO(\$NJqHV `\"M8t\r;03|QC7XLu1}3X:bO4]UMaE?T=%0␂C!TLH`*P8K/\\K6{SY+͐KQ6@6V͑<eIP6CSzO\0Pf>80a\"gI,gmFᙔrId|FR\$ ȋH!2FܦP HR		8a5Ih.QL(@;\rZ3%\0=)@B*H?T\0#I\rJpLJU%eR_I&@:R%&ԪRq+*RY?R\"J*R3JiԬ\",F5&j6.'KE+ԣ&u)TRML)TLD~ԹRESK	ԤK1!L7DcK-34DA/x%T@SVIS^= `\r\n5#0	R2Q8TI#%Swނ|R7Ӝ/E\0~0A/\$ӿ@82L!dtYO|7<a(ʮ64d@\rO;tA?QiIᏐ|&,<w-C\$0ۀ+B1P\"*#\0HEJO5\0\r]O첈^\rxz:^	_(6M'%[-i]F#ғN\0ĕLN4f#i:SX@4%[ʙ =&#eHc\08f  p4\0ag/eD,Aڀ@bE	\$PJj2\0*: .24ࣨ-P@u=)\n=x )\0򔂀=\n`+H()\0#x&=:ki&)H+>UՇChi\0OZ~@+x	\".F?B	BmAC[DmQuFjR/4TuK%TMDcW!B\0EГ`ɏ=&L=cϏB(\n̨[0U\n Oό1EUTu]\rU\\D[\rG`1'XdUT?CHsV3WEcuu!Xu\$,B}e5~UP1.'A:>p èi\nSSE\n1\"T@@#lN1[(ñ:PQUl4D[%lЄ%[XuD5b	kHbDpqW]p@9\0[R8Ŋ(-RN..UpTW%\\*U̦)\\Ⴡ@CtU͟j\"\0<WRc}uuu]v3Qs!]}WX]w.mu<I\\ 5׹rdh^usM+ 9Eu\njWy^UW[_E{҄H>WA~U_:k]xٵ\0b(\\B\$89\\dX4UمaH8W#es^A?+=u\0`ĵ|\0z)upQu)`]xOu@6ew`q9? W@hv#	@m\$X+ <~(f\"jDe1X_=rA=W9\\ 5c=E@l1X̐: ^\0\$=bMsخFVb\$Y	b8WCTs6%Y @(-)Tb/DؑdH؜L`@d	VG=eUvX\neZWF{MMY9eMѲu2GN(-(+b	K_fX#f9dcvnRb%4'-\"\n9\$(JW%fՙ6j@7gvr4d/1g׀[e}Ӈc%cNJ\$aa٬N	Y2dSbQ`\0ŠW\rr,H\rhrQ\"i\nFKK;iP+Viupc3]֚Z`8j\0-Ei+d]\"ىh	VLϼŕf}1j67dM\"XYjW@١A\re%\0jbtY:Zev(ծ6dAZk\riEK6l*<J]hu 6[#lb;bճvdtt7JtAو8A\nlxҖZ&!~Ҙ[OmHմ~<\0mZm,[Gdui-DqZL66[nE ۇej1[l6ޗJ}s/[me#mJvF7n?Jt[R\\6YoLc`5ovmX-6acZsl%C@[Wa [W[Mog\\/\0o \"sbM9dģ58<v#4m,}نV|MlS\\im;ᆞ+YQrEȷ%rj7ۯa}ZMrW\"ܝs3؊(B4q76qCo*+qhsv<oՔW-r7?ܧt\r صt->tH)rJ7\"@w]Ŭ7IYpmҷ7XYt\nG]\rp\rQ\n8\n2ѰTezP\0=vNE#ܽu̗Eiu-Ns^.}Cܕd˂2]1f.gr04x>WvE7.]jU\\k4q!twIF]pwq5w)\0qp\0\"\0_az]^7v][-ܗ<vޖL7c]a7?\$-7;^w5v]=vagv	k\$w;Z!Vql@;V0l\\[v-`X xW_\"n <^uw^ew=ӷ]rup*urZ[]G>é5C̻(0*ɒV0W	(\nՂ[z`)^Zkɱ'#\n\n^()BiW \n\nݦ 7<'@	^:3\0*@\nЏJ&h\n| z\0)_\n=젠_D=h\n5_Z`*\03.(\n'!h'(`«>< -\0{zi /L8`/:IUv@Z]<_{0~=`m{,7E{=+c~l}5W_X&\$Jk1m7O{%8hx`\"'{}7^袍Ѐt@\$z\nVi߱{i&JW|\n	UZw_NW(:_RR3}`&\niAh0\0	|ES_%_2֠7߶8|{8%_Y}pc\0}k_k_s}_~Ώ?`	׻{Lpf8;\0^8\0_E`\"b<wߍ~@	_-Jߣ̀_-:fW_~Mia1~~w=&_?ZouU7|XJaUrbdpZ	ը<wЙ0f#U{~@&_	*Ԁ{zw_3`#\$(0gUPX?Rk`>+\$.8gÆxlIa8[{X8aI\n\rc~aͅWx?\r8&L>!^|ڏt=a`=؍߫ %d	M}x\nW+|- Ux	iaCWa-s߯'f(Z'}צ\"^'b\nxkb=5hdCݏz=6\$C؀&+~%8\0W`'`v&Y\n&0<cͨ<	 !M\0,8bɊ\$ď?EXc\nU&Aha108VF2عeNIbq3>\0V..؀Wɗb#a=BϨ[P*=	*踂`7q+H 	`\$U5k^=Z	b=}Xc.(d_3)_3Cb\nF1O,Qyc.#c	.A`>5LF9:<+uߋ\"V[(=>X%Ҍ=H\nS9axIvE a[ &2dh=PZVU]U#d^\n7FG\"&T&F?\0&Hy)bK9)w;P\n\$d#bˉ&JgvK#=nLX㍓H*ا^ۀ *'Kቍn,`::\0V	)&!|PزVO-ԧ}{b	PEe#OcgP+Zrt(O{rByLN22(&U	\0X぀kMf5]VXUU\\<paH#\0=ZXvW	,R`)f6Ucᄝ0,bըf'`%ᛔe݀^8\0^.\nX__P\0).B@dva9)'NO+~++XA-	j3	MaX]\"f)ـ>y:L\nŅ4VX_p0=-@§zUYb\0ȸx\n&jX&*ɋ_r{R7Ki+q3kw8f9{6]aVlb>jyfy<)(\nkfjԫ@X \0Q~@F8CL0@*\0`^~rxgD6tT|x# >u	e)YϪǝuJky2&eU{M;iUL=u#gX*t+0׾ȁ	 'UY^)5VՓ*X-Ua\"ǆ8`}aוU{gdn-8\0t9<Ldh ,=I0h8\":8	ԣc3h1\0iz86cd81hiֆ'X9|̏_aK)߯Xn9Z05\0ƈx\0<\nX.UWic::	Q&\nZ\r<Yփ9VgR踶bZb*IGkc.rmP\03Y\0\"'2UjIiI9]W`+L>-c<|\0Z煥\0e{󀉎NH=h+&@1dS^hy=fWUa3~XN;B+FOva\"Mwg턆cȀG'Gib)@XCf<\0``ڴ:c<p6<ƊcaX^Yc=-axCRKZ<ƛcf%?n,نg種>h/xH筑VyeYWVZ}l\0-jO8_[0\nY\\Q~#nZ>wy৪Y_[X\r궚ޫ|egUj:Սsˢa\nZ&ȭ\r`.I`{.n冭\nqƖWd.)a`>gX}8򸋀(\n.͛v{T7,3dg~0ؔ	<{<}3\$ϔ)8@R34:䵥]~6U!<@jZ ֺS^ӈB~ 5ɳ,S,(M9p 3X/Zu':Fp\\)|ƣX\r<Y8Xt脕!`6 4.6+ZP۰n<0&bw0>Sr<@6d\nzlOFRlO;H5ڝ*L^x0>g6s/qYe\0@<z=\$Cئ\n`+'S9X8_/ij	h75Y\0&cwa֡EɟXyfub{5ͳvGjgnXd\n{lǫ͙~V	?3W}R	Ch0>R= 79x>S\"ӂ4zҴ0f\"`1:愸x:x;Zd֔eK;@gTML7N3RkN(iF;)Orn:Ӷ\">^#e;n!Q\0/ԆfU\0\"@Rp6Bm0	!Yr/Tt1VeOQzBr9,@9m!t11;\"cmMu,S<ŮW\"yvK)VmV,bk\"1hxF&9t?܄Iq\0g5MK!,?!PSQGe@a:bHd@(: DdFJ1Ḣ 8w&@⍅'iVmL E/[RR˻ZnfՏٴ_GhlbŇl.3%I[c6 3k,IDX%JSoxvKBq[iDanO@۱m/|iK2RjfVrZEJng\0_H;PHDn-iQa))PgL6%lk:sk1SmNFo(SJIe:ԺJ=lF)ﲋ\$xͣ>Æ9Xo<'mHf!D;\0fSAr/;Vl<eػ2JA\$kUY 	d\0׻|pP!fZ\r@O'_x6;\\4%Z6[6tKŰ#u1|2XOo&6~DqO<<:Ӷ|p%%ֳR&\r*oʡx\0C[ʸ#:lpw\$KL;sh`aRnz;ϔ;|8L=OEǥH* )-T/⛲_H._%H7THSD5>S_cr~yE\0*^,͎FS=\0#>@cEMA7o\rRq{Sմ1''m{p0f2/<m:-HƸ%N'[Pwdf\n5<t	<n5F3+b*qedƫ0@S;鞒d:;=>؁=#NR2`Fd\"wQݵUNRutvӡ\r'K#O\0ɰ씑r'rH.|;OK.8L܄HT|sr̃IMr/4<䏦<rƖ05nln,l?Nࢃafܠ!fo~|@2/<%|1~iL	_1 5'}r!16Eo2s. \rr7<2<sn;r5*OlLDF@l[͜;]ͦHaGw75Y̚5H\$A\\<t|ARQD!D\\Iqv@}_lh(SKi)|iwTμO>,a>T4|sd`#y\nu,\rη@As8=tdYw&		NBhR2t %q,TwM[!O=xNHJ@C6F~a\n.Gq\"'(q\r8CvhJ`9\0/|t&w@&+\0]<bt?DqO:</aX!8YEUEl7G=aLt@1^><ЇQX܀	\0}?CwԜ]=EW\rNR+N#]?1oG}.wG}%6Q#@.h;N <P䐠18t⡼uπIM!]tU֨D7q&0ܛTz\0qH؇tI|`6lIeRM^.5ue^M_\"7_'o+0sQ?FH݋uXR+J̢O\\\r7`N|EtHwY_ݻOa#b@GkN0 SUh7=\$_0cx7e2qtDp0umbر*]^蝍%7N?l/PZwO=gnVŝ veթwn1a^]]<p\\ޜ&AzX4#ݯ7د_=k`Ћ}!E^Kطt2_Cط\\IX3طѝ:%՝w/PQ.ęGݬA?[ݓ'wd\n9p)Ƀr7vj[@!w^R1ڤ7[e;qm[wkش/5٢r, ?b']r[\r/5ݰׯr.%UZv-l6~BCGhS ougMp,O?Ddmw?]u! R4V_!xIw^H9_=>}0ނ)=HO_=dء펝 d 3]_6:xDx7BӼ\0]/=vIJ<AX΁,Me;G\0002x|&\ntSc4u}pv]\"9x_Ob'SK(KaDXSmǍ煇3_<;TMM\rHo*_-ޘR'NU:׬Hڪ%\05g-t\rik5\n`Hsͯis~qOo\r^m>\rO/f&?w	r3*}t󵉏<wO\\eV&d%}!.{Jfם&Fx8+R:,x\r^2uV]qOs]x=#CI}e1bҚotJIwP\$v<Fp<yN\\\0=+5Pl\nSȳӾ\\6탿vi9q4g#|ԤvzK޽t//5j_Io%!7ItQk\nMwLMpu!0K\n/W]ڐ[﮴jz)}\\X)O>}S8@\01G{?yUaG//K~K-O_7}*Oa{z%/,Ե\0#S=`7aZL{H^>p7EO\"/{=TN뽏]G.ԠW?]O߿vLVFʝ{JTmio@xO?z/0OY|.Pb|+ۏ\nJaW/+!?\\V_W|=Oʆ\\FhaboC@Oq|\nzO2j=EQIv074͈ͮ7=z2M=)M7[!jJ	}^wmhzx9{ݶMA|>o)0\"Bx}40K(\rmݹykߧ1|OnPt謔{Cqۏ\\d1ҟa.u]t7cnYDEVd5(}	g׽u\r<T\\\$cԫ*T֜;[q{]U}ն	_t5udkmq_޾7K>+y{&a?>N,5Q^}ѡ.}aEr>+̧@n?ce|X}'oce_vo{}-x~S_=wn\0;=|'8']{CÏn?[uIֱ4)~=uM=1]>F\$sRO\rMw{/I]?5N6uRyJ tZ\"ptV_ȩfsۇozfɹ7̫fVAY\$|z[nP;[\0[/eCҝO)wUBVW\\pT]_	G#_v}5^M/\nDdK\0B\$Qzj MD)5đ4;");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$o=get_temp_dir()."/adminer.version";@unlink($o);$q=file_open_lock($o);if($q)file_write_unlock($q,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Nc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$F=null){if(is_string($v)){$gg=array_search($v,get_translations("en"));if($gg!==false)$v=$gg;}$sa=func_get_args();$sa[0]=Lang::$translations[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$sa);}function
lang_format($ji,$F=null){if(is_array($ji)){$gg=($F==1?0:(LANG=='cs'||LANG=='sk'?($F&&$F<5?1:2):(LANG=='fr'?(!$F?0:1):(LANG=='pl'?($F%10>1&&$F%10<5&&$F/10%10!=1?1:2):(LANG=='sl'?($F%100==1?0:($F%100==2?1:($F%100==3||$F%100==4?2:3))):(LANG=='lt'?($F%10==1&&$F%100!=11?0:($F%10>1&&$F/10%10!=1?1:2)):(LANG=='lv'?($F%10==1&&$F%100!=11?0:($F?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($F%10==1&&$F%100!=11?0:($F%10>1&&$F%10<5&&$F/10%10!=1?1:2)):1))))))));$ji=$ji[$gg];}$ji=str_replace("'",'’',$ji);$sa=func_get_args();array_shift($sa);$Wc=str_replace("%d","%s",$ji);if($Wc!=$ji)$sa[0]=format_number($F);return
vsprintf($Wc,$sa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(21).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(22)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ga=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Ae,PREG_SET_ORDER);foreach($Ae
as$C)$ga[$C[1]]=(isset($C[3])?$C[3]:1);arsort($ga);foreach($ga
as$z=>$I){if(idx(langs(),$z)){$ba=$z;break;}$z=preg_replace('~-.*~','',$z);if(!isset($ga[$z])&&idx(langs(),$z)){$ba=$z;break;}}}define('Adminer\LANG',$ba);class
Lang{static$translations;}Lang::$translations=(array)$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
3675122236){Lang::$translations=array();$_SESSION["translations_version"]=LANG.
3675122236;}if(!Lang::$translations){Lang::$translations=get_translations(LANG);$_SESSION["translations"]=Lang::$translations;}function
get_translations($ke){switch($ke){case"en":$e="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\r1rNQ<ΰC|~\n\$u\rZhsN(fa(L,7&sL \n'CΗt{:Z\rcG 9\0Qf 4N\0;Nl>\"d0!CDFPVG7Efq\nuJ90ar#uDC,/d\n&sSsu9nO4c){Wќ(Ax(-b7p(*k2' ªz+ 80*1i1A!\0L@02\0x\r\nC@:t㼜\"۪#8_\nsj\r\nb7\$8^0˺2j`ŷ866JO:ԌD-+s<@M*R\n!bI\nyP\r󊮎p@o(Ȼ0:\00M7 P:SC&:3#K94*JR/DBB;h6tan{z(T(ޭÛv*%z[!05v)\rR)F_.BԮ#lHʁB(8ضlc!J`FG+x<Sb;Ϻ|/jj砰*{.B[	 ī&p\"34ģ \n P2<`3d8c<mr|\$7('=#3WGZ/f0hJUh\";ZE]@AZ9t/(4kOsdlE\rp5s*:cp089G&4۪~HR\$\$IRd;4JXt@nt˸0W!haH>a-:dtE p4WREH%%Ԟ_;IY,6q_eIYVR5o.x0bPrs6%hO76c[]vDdFV/x`[z<Gb͡\rl/ Jn>Dq62(3BTH\n4Cs&A5-4+6ny:LHY\"Йb9I]c,y\rq쭓]\"ZE.AQ@ڭ&`26qmzo+) kb0nK\\#Ā@@rdHr4wK\rE\$H&[*F-|2X\n7jL%'3JRg12m\rZ5oa݆#\"xS\nPJ'h6Y[([h/0b{+ёa\"dU.F`\"eH呚A'	،|Q\$P*PY\0D0\"2i?k]+'A_-:x7#c\r<=*G4%u\$a=1rL	nhPG*?NH#J3.bx*	C2C8h*F6MOD]%)\n\nsZjec/T&_R\rYDAgŶS\"GDYD(TMPIl hq['apY\\\ne9\")]ep\rl7kcXr%0\rƬ\nr:AE	W,z	3,Yw@@ F9Έd*%a۔*)2(S\"<%fҮJ&q :glfzN2˯?<Uvn؎4ΎKf\0LrЁ,`2BkT\"갪? (+PŬ,!@),JB lt9PLsaL8IQƀ̫HNGn;F{M{8;6C-:E^vŐ~\$Uw<v<{҇(VViyg@Tu5AnU,8:8&a*R\r*2\nB	gl;kw'׸Qۼ&}o\\HgRlŐ,!:+NJ13gYC/^s=EŐ[~JW _<\"+u).ꉋ\ns-\r* p)hqT Q6rg>}*MTRdYrQ6[̸]ć?C͸	>Go2ş:m벯\$+YQB~6,g\$1b\0EfoHf#(N'78np.o08N.`2XA\0E ObGPXb4^?\\TJ\ro6a,В#Z`ţƐd;0pHM\nPo^?O6p?@\$CxV\n)\n60\rp?o`	[pnUjNވʔkfEO6\rhυ7Kh5RQ\$:b'6v\"1c	hܐ>M1R\rZN\rVr#*6g<\rB9b%fGd\nZ8b|M*/lc+\"\"DlZU|t^M	\r1ج\n9C#2,0UgBWz*L\"`c@+n\nj%W\"O0T\"KH?_\0\$G#2%oK7&4a,ʣFf*OKD7\0e-,)@¿NH\\ba	\n`0+NKHŲ6;7\\(,\nN\nW5-\"0T!";break;case"ar":$e="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`jR[-sa_Nvf|I7FS	;918+[x]š'\$g)EAxDt\n\"3?C,̅Jٷdj=v=I ,΢A7i6LS:h4NF~.5/LZuJ-xk莿bĔ*xB4:I(FSR2P7\rnH7(9\r&Br٬cY3,2lj\$ɓfGPsfU\$(RĒ())r\"K-37@2\rDD{9#,0c98@0͎ȾScJ2\0y@\rC@:tD3DD8^2xFQÐI|6ī3Dk4px!~&mIhDZe@HSD%(MZ34r	n>d	rݖBI!x+#>(ȈIBhhćyF\\܌cnJ#R1S P26NC6,(t,2IIU\nJJ&ۖNK%J-fY@[RZŬKw-j#ccc:( 0Фqui0(V/Cr^bM&hHNoJ[\\ݶM\\s)#fv5j%!仭+ƌ*J摚18\"vy;\ru1b7x\r9Ru:^<v*Aa`H䌾|C\0,B7|ߌú7ODa!MBqFƘ-Bi1>L36B\$BĄÐt\r(5_xf5*V,\0R\rWS{l@sR!9C@|K wA@s&ĩ\nR+3ݚf+I\0T8p\rS		4DC\r!53SyP* 4nUU*^_`tX\nK's)`FQ)enOɕLwc:j5GI{I)HTڝSQXڈrUj7#I\rX!}wCZNAC)TudQuv@\\\$xK(`Ճ3MeC4NpYö P|Of /A:ߺ+,iИcXK`mD`Xh\0R]fIJC\$\r	pcQoÜt9iӼ\rގ ziܻR#3+OOtOQrXxhM\nEK[xAdS\nA#Z	t`Nէ=b.6hY-6RKB\$d+4^)L4U \$l0&DЛ*z\"Ԝc`d|e܁#WNE7MuKqd/dHc\\Mu8|_VUN֑a\n<)B,\\܂qƌK<\$hR\"HmrE\0[MKOpMe=|MD	@\$s ;0Rc	v0T\n-}\nrq20<HIKsBgk:xNT(@.XA\"5Jf\0mf.i;<ɚiؠG6(-{I[ЄXWLF5,s\0J0#n2JۣFMl nr.dl;7tI5}\$S0Ӕj̘#JMY[O\"1?RS))h8+yRK1d;Vh2.\$\nC\"zN' NJ0zSP:\nڬa\0],KHPޛؼO#-i8R;LMKm<kLM&sFX﹏^|%GHyY(!π(C/gr#G=ԓ]iw\rܙC Iy[N'n\nHsDЄ!%{NI\"*1Y|*DA7Âu5t\$xD\\ qXu+3hDLD,X7p!`l\"Hkn{}]Zm㫨T2	qXjWG>j2vT]11ɠٷR*YnĊ*|;R%rIQCR~:v(B6wT^GL\"\r\"V\"X>wo0AF=apc\"rpjÂdox\"H\0pmDG*be!r\"@'h֢!YƗOTfPl\\n40z>LPvk\n2L	Rt|\$el0O@@(\"bHbx&DhHʆF2G\0*GF0>d3[̳nZ2FN\\`JP\r\r@\r΍p+P	mDԆ\$n-diJBT)@ĒJxPpK-b\r3	\r/MfƼejPu\$:\"KptNGO|lF1\r\"p10Qz1GŚ'1ђ`)dub4P-udz4#f+\"(\"	>>&&Ffr	\"RH'Qk8ڱm#%3C#Rgn3Pd.qبOʴ#*Yd]+Am'h,	',Uwgэ+Nr.)S-S/[CIji-x?ڨ*@I)qO]*3Y3P/M346D\\sE6s[\r#jq,[n8U\rȗnӈ:9>)8388c9cְ3(,2F7=\".%)V\"3sfs3/M<6\r=pF3,,o\"2 `<6lF2#2onS\\،B;Ͷ5ÓB\\heoPϮ@4+]DGF'EȈ\rV8iP<d hP@jx+\nZ֎4A0v'XF\"0j+Z_!~լ?G]\nZ	JbNa.0f3`@PxDѕ,aHʧ@ZWP#L2(G4GXBg@v0Do)K\nhlorWQ\n	mXp\n:89\0	M-9hpPhg6YBB[BGTe[MoDx\$,+!dţ]dXMTHO\00lB\$flf>OhUw04mRT\"MWHX^\rNdBT,jf\"--	\0@	t\n`";break;case"bg":$e="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9\$+JlYhmrF @#e&a9kG:~drUIzay2ƁѢ^ЦGeS2uJ\\nEW&oI\\qՎ=rBz~̲7Fp0bv%6ڰÈk;\rlJK=/\0X+ĺL=\$\n\r\r63L[ʏ;qlq*oYσhA9sr] ˈƹ\0*X7p@2C9+̤:ǻ,ԍRO11hL\n6'H*Qhii\rv۾ h7J\07A' 8*0c\"9c8@00MCT;#7@85+`@TCL3:xe\rEʁt3(փm\\\rUEҸS\r#x|֩C0O(3./;/j^>-kN눦'ê«\nrA(+#P(Ȍ1B^Қߨb;?4pJF奄\n\$I5}Cr8#o28*\$h/rJH 9O-nE^&Đ+?:Z,<oJzo\\ꋒ;Mr{'38<%ж`)\"b0oʃk{kCbaPDX*t8=3_9zM߫	#\\ͧ61(v+{_:,i=]\"FH.]@wԪ:I\0\n	/ \r9Ux0tQ&By]p3°\n,Փ0C\rtTLRQ:P]F\ntjH3B<A.\"\"YLa.G<\${;Pl6%tÜ\\FR+ŵQiArrL\"đBNɅ>tSe/3`c:ƓZd@t\$Krb0N䬾6dI3'EH\"R'O'L@2J-%*2Sd^L7a6D3\n0\$C (ql4Ea,ERYh5|Pk }DW@n,Tv\$iK}8\$RPY%9<HJJ`E:fFp:6vUXkcjϟH9-EbYuocHQ1!o3[*= &4L<3%TƟpSCQmD~m+R-\rxV\"QPh5Jr@`l<hed3EêS:٠<DU*Um 4kQ0\">zS9oD \nYeexkE\0@P	B⻻b=llzBtG\"Y LKY%oSve(Z#SuC53#i{3dRRJ9E=ҕX5jÓ'40óf0	.(\$XDHfе2b4Dq\"O)Āp\\OkJ,B<LoY4&xYE;7E84Y%=6<^kJz.&SZ|/;EB:D]Ԭ1bz\$)yIE?LBoe41	Hs0\nl\$Ug\\&ogWKl8ƽCFЯgq_5Q;aG?;\"oJ\"`#KG,IKYXe{Po1#1IdmO9]6\n;GN7qK+OR1[32NΔxL/\ny6h%;-3B\$)w/yYpWWluQIڼOi_o><՗>g_\\mEǸ]ݶbO~|=9πBp`E:좍.kw~䓒Vۮ!'6σP򞃕c;1EBSr#68ٍ#Ҝ[O	g_\r9۸â5\"t%8P{wYӑW:N`)0C2<)hM96ǈf2A&yD\0@\rb\ncLTT9☬._D	*\"\$DU@㜮o֎>1p -l\"GB,D\$\"({*FÒ\n \n`\0ZR%F4RPS4hӂ&6\"0IbfZ@NDYvDKpo!`WFZDB\06zą,Η\n\$Lrb!B)?My1\0Òq\"&fZy0#16!,&\\Hqbr7Q6c-	<;Cx\$ˠ--L+\$K|cVԱ-q`7DF	,ɇt^h'd#\r* JdfiN)p<\rq\rliI`cz(H,H'#s\$\"b|ilH:gqjz`\0#F+*0X|8uA r(%rDʼѠҖ22ФzjG&͊/bV42\$|ّ%G N~ds+-|,|sG1T\$ona=0FnQ<@\rJZ\r/\r ˦):pKZN\\G(.l3pMtރc1h(r+mI9:sR:38-~\n!<zG=\r<bskS\$丧\$q\r(5p.s\$Sh|;t LsBr*:	%D;\"M:ӘgSt qCpi=z\$2psK\nMQb\"Ng.\nfe)>Fމmq.C'E.ۇFyA|)rD;;_&44SDCIHTITX6K2T5(!\nG>+%('	S8-OEP5HJ75R\$6xt!SV@{TzF6~f#\$r6D1&l9=OO쳙[~T??w2}@S	VNFlR&]H!X1\$EV	n`u`\n|z(Lgp:\rj5fZ.k<<\$DM9?e`dKwVM3Q9n͹,UUA\\E?h0UP2z9R}\\SEvRvb#jJa%Zk~%7=|t\r^w({Q%\nC :D5\"mb6h:g.)^(8\r:o`)t\$GpB!~\rR3%MwD'zTk6dBFv\0op	f259&O@()	qw|zE'5G\0b=B>QncBM1G㴭Y2+Ⰸ-\0\npƳvOjԑ6Id9>tuRp\"w2*wɈ&grlV\$/k.UZL̑1@r(m2r'xeIVHELN7WgC'Lypw#if1x{\"3TԃgP`1r9T3(g.28G\n;L*2oyBoЂGxQg*tӄ!7X{uǎ큋ɣЖqm?͍KQmf캆R	јɏ~dՑ{`Noyִ3T2dMgRA#N4'9oNX\nuEfo6ԕmTZl;{Gҁ<΄.\"4aN(\rJb`Fl\$s1nY2l^N";break;case"bn":$e="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHWβt|,G8rgu\$)k2~\n\$g#)eӫf\nVUN(]>uL]	q:jtZut*#w=vp=L˨\r?JtH;:B6cz*\n(:O-*X#ps{BPB/j{BZ-INJGED!QY\$IMV.<SPw@H<ٗxm^&Hۼ4Ě6ش|/\"AjU<#'˒*Io>)2,p,6IQI4ϻAQU8\$XGKpME>]FDGV9JWO<۫u&-[X1aB*YPju4t!E*lSpx2\rH2SݠQj6FSV˿Xmpœ{֠Wj\$sBR}N@X@480z\r8a^\\0\rp^88ØxDȌ=G5͆xäޝT:JmdiPK*:K(w{-έPzN71f%fɨrw@IfF'\rO+Jl2!s+J-jK9'ŏ(JOT}dļE4ustٴJT4e\"7Xsгf*W2uA8Axh>1XRdE{(eghvm}l9ֈ8UAvy1̼Rއ\\9Bh:BLY;*IS'%^RFL ɖ6wېoi&7ePI@\$I>}+C__W]NF!BPjǂp^aTmNVƜٺ,jT	ҺreJMxp\$SƃLyRr|!c>!7LK0Xzi9qyE\r9@]7L5\rcaq\nR7XCnAZS0rx9\"lɧ]\$bI\$fX.)^TpKicJOɳz)Fɖ!C\n\"=I!7Za%WvqNh.*&ɒRXǴr5=0\\McMepPXž4䬸UirsJFzG(#ZcmB|/-L\$\"0yD\"PMѷ<x5IR[Uk./S5Qʬ#dZوwfl֫3td\r0@^4@Hy~x_;ou0I82huѐ#rnʛcR#?JWa[Z6~R(F̹]͡og+Hzjيyek dL2fPʙc.fɚUVnY=g:3_GgEeyj͑[m/1ZL{{y79긏%LVڛ}6j,5)M1W@b: \"a)O5&7-fj]H\n1OqE6/3a\$\$\n0)oEmi.×F=]`*~\"F2=VP`\"teʖ*٫*rO.%~ocVL/wP<Z\\¥=8m7{*gT4FجhI!0.Ĝ}鯧]0fȌ*AͲ38;{%ZY/I4dJB4#ipr\\3͒5ڠ@|}M2g{jF57kUWjwUv9QB5+3ir+V{;5OѲfM8:%Im\0T#lZ[\$|,x@_U.<|b\nw;nd{g!݁*d9AkG&x 3W9%FN#UwNnLKTaf_@#ԏ]֬n\$\"Y#'B1\rr0U\0KK6R!#'F\"\$U9Q/\nFhq,1n]e/A:t䗝k79JSrՆdLH7Q~~CxکKu+9\nQA[̉]e2EO+E﬜?/1f\",FKt7Q/LqOlrfϤX',t9*fI4O.Δ-q%.@4L؄2#ԿgHSnhmI\nP^7#zƺ/TS*%L˯ĴI(,r&_*Tl4TFvmt#j6/ZDRd(\\\r<l+nNvNFO3x7uVd\",1(9f+\nnnĬ\nCVOkvt4	lnA\r\r+r0\r\$pH*Jj*lQ8n:TUPC/b \n`6Ȇ,|Ό4W\r?5Gc<Nr^(rԠ'5!ErN0~|lȄʪ:B!VoqJ.̂\"*Ā##*媉oL3#pM%Jg\$4K'%2&Ąw\$Zlm#\0[hh7dsxǃï&O8oH3*W1m1#+-,B,o(i&m:lV\$K]&*!0D\n2X|/tʧ>Br\$!9Vz1s(-tdt1L(q\0Fsr-jB*,.l'BdS !\0bx>@ŲLkY/\$ǰV4bМ<`%I;;fI¯32s/q<̬+p+qRs<Rˉ,SS\n*>4mmC*ft@4t!4%.rP4CI2M8HȅCNyG vTR//7#r #Nt쎝+nF%PWqS|LCGz5CJuP\"R\$tGE'wC=W`KЉ:@[BAOOϷDo?j,PEPQ,gO:1ODRX@t))L?#hcRuU>rC3bKv~CU%YV&VrXrƠ5}K1X\$XWYS5\nVC3J.BULUPD՝<q\\#\\QSU5>DWhlN>S ڨ<06	Cu.ZtodQ.dv/6-R%V|lYLAM\nHm\"[]VW0vK~Gn\nn.H[3\$?Hȳ\\tFA]\"ȶ TU=3R(SA|\"]olF_qSIT	lvSvިgEJTcPct[p욾R1(Ի:[om?BPp%atֳNSoHf'+t6|'j[#7')FNN\rQOZNQ^q1:ԚzUom5o7uq/pwUAyiniy5elk-11ْz5Sޠ7i{sr}_yjjI7VtQ~aQbޏ+rWH1\\#}hz6Ը6xw4yEq8\"5?1u<7`{3)WK1L1s}XfM~8qnEqlDgs/sKWϭ1v	AW/D3jˋi|uw.J٘ЄSqa(2`ay\\rb'mvBo{\$cwZF5\$fA-2ZUJ9 \$E6Nm¤V#uu-&&ÑO>d9'շ1dz\$Ex:&` l\0x5My?Z@\npf|i7	\\VYS#ϗ{WMd6`yS{9;;z'V2xAK R	Gz.GVֽO(R#2jcb6ONfPs4cZ42;'sSٸ&<`_\rY\nd\rC@So\"ܙ0%8HFEx:!\$&\$e5G;Dv,(<i/=廫֏:.<#bW??6\\\\P⩓~dp˵b(]X-~'ed#v#iLƬiH\" x*TET[b+KN58(>u`84/;fASP{Gx`2w?0\"GM\0006;s1)\$J~5=\0+z,O9j\\V\\k:yI3/JTH͂P7_~	7,	|";break;case"bs":$e="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4(o9Nqi :igcH* A\"PCIrDqe0	>m7ݤSqA9!PtBaX.	B2w1{=biTe:Eo;i&a1l2̧;F8pȐ3c{1cMYd2wT/cg̒d9\r;P1,&)BM5Қ֍[;\09K\"Cj\ri5K^	Zpl\n P9\$iˊǀP25JH9n\"9X:1cp3ʩ0(`4m0#`@%#B3:x?Br3`^8M3X217\0ڇ#x|	1J{*Q0:C:.㬍XL5:t ׋\rT@Ȑ	K;F¼Kh(J2F:6m6m\rHrE`61t# r\r/ 3#*77SR#ռ[/|rH<z1\r(@3\$`PF!PŁB<q:,Љ0ׇh0ֿz1\rغXK\n\"`A!(vL:%+m_W==7Ǻ޺@(]};UtbRSUVZ[W#pшHmjZ=5zB0Mu-:mjl0kpJ 5DNO˫>wC4Gz,bngό\$7KT|7ucu?¦p:E!3ߖ{_ZHV7m\r0̚),.C\"{py#/@:tp1\$9i\0wo\$A@s\$*ʁʪGfC~NbIdi-PnoH4\rsN<úPi)C%1-*yH蒧\$YX\nr!!5ܐd!	TZHi\"I-F4ԛx\n2@\\i='0Q#cѐH9NBᾰЪkFm*\0`tCb:d,9 f\$.ZLa6-Q[3Ftx3tD ׂei3L#nN?D%-XHHi\r\0(J)\0#VJi!\$نJ)㜘R:53 	ܫe.ųbXRF-ཎ\"9j:wԒk0D03OUQhB\$bLHm(T)֖l\"e꒢XKU,R;\\%\$mBM\r9* ܶ/:m\rD*d'1F_ɚ,@'0gėH\0S˛bK+` {Gƺ\$P@axGEnN	OƚV&]cp)@^l%!*NyZ)`Jd	VV#hm\ni\0;pOO	*\0BE\0!F%RP &[|}Uq_HոKv!b@}i\03EdBxpg	Q'-APNC;#URmXUx2o+wFHѽZ3Ny)@	h٨s)בaȭG0\"K}VV}?M/sG`ᔳI|xs*D-ɧߝ\n\00}Yky\n+5S,HuK1mE\n`3^W&K4TPLuG)lXC)%[z'z;c2\\Jy\nk/,u`c|YP`O,88~<;_%Q'\$6XSm?4(DY_\0BH\$]pJDJ;2+I9]-^\0R6ˈUʣAV9B0FJw0[b6pO4Bp+ڪ}leC/3'pjM\\rnnsEڦ4Mڅ\0*L%=G#&H#3jH<׫<f34Jzg9#ϵ*d;Rz<FjdQH)s~PP=Ōz6Kp\nU,bU!v~A]A~#'cvڋf3O?9AFU3O)q߯?&؊DdD# ;Xlj-2z/P5kL|6!f\nǶ(-لɇ\n&\"J-E/\rb\0CfR<3Ei)rF)bF/k0oo )BECY	oП	,Lg-̿6&.6),X%j \r\\Ɏme1#9\rpe>\r˸ۋ010&kr\")#a_]qLRF78-#)-iBse%1\\[)UC1J%0\n4@KD\"1R,˼ͣ1ׇ6CX-qXWLX.q7YQ&11\0LqG;gX((c GBWfڥ6dEU\"p\rl6n+~ r,1VERO\$GQO%m \0002Y\rN~4+av\"E8KVȁ(R}(ҐW,f{Bb\r|0)|18+43֢2-H7ĚJ㠂`k\n\r	*Hj<15&01%9!*#TX0VEqqfJ+Ar^dF,N1/14E1*	&Eo&\0)p-*\rICl'(ӂ^ff VÞ8ef8;Ypn!\0s\"Vh4M(P&:!BJJ`\npxf\$nJvX̘;\0004*.B42'b'LsrtT&-^48,7cF\"`7q3)҃i1@ТgHdxCѮ)cfzg`n;<frc,Kf/V-w\0.]BtҐ] Lǈ5P!,nM>bVt\$Ѣ.{æjHPfP'-g\"#UC	D`\nT8G`]ssO\nC Ʀ&-e:Yr6J5d#2`4˕z!o5fLD \nCJMt\n2G2!";break;case"ca":$e="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(i8hTC`uADZs2Χ!c9L7)I&ZMQ)B>MΒc:N!i3M`(Q4D9pEΦ\r\$0߯Q5M]YbscL<7N	]WcEY!,\nNxmoF[7n絆^4C8)llމ-ޙB26#r*Z;93 4, )N7jk>cz,90p܈Q*I4cJN ap<4ɌJj0#\"S*1[#S.1pΈ|;C31,; X8D49Ax^;сr%-As<3^8N2\r d^062r,l((@C/mnۣuvMa6,rӹzl\n(Cʪ!F`6k2еF|M+\"#g0wP'!YB2+Y?2!Mp+ؼz86\r}'prs@ܝ>aV24#oH<J&a|0h#\\7Y@&CxYe7ؒ%pG\"WYz囯Wa:oȆ49퐂麱>lU(:nBHQ@eB4B+ <ȋc/n+d`VP!N,I\\J2PL3>C;*\"0<UbIaj7#܇+¼&4=WF4[B qH2\n&B*\n!4W2Ǔ\r9 74(O)7h*ryQ&A<A]B~Sڹ3D*[_A0S\0YlzX T5d*R2Z( K*@9'~IQNO@(%BQG%HԚ\r5Q>}CI\0Ҏ3ƍ6\$-J8ڬUHʘ!jioXC .O\"5\nJQ>' *)>z`蜖%54MJĐ!@@/FTPPijGb82ED%D6&|0h𘕊JlA''`fM#ڕI=v,oY5\"@\$` 4HBV㕐CD	֐\$B\nxoL̐7y+&Hb\\d\$JF0<Tau2f!a	1`EJBS\nAU C\$\0B06es@6PK.(`@KD@@˟}0\$^w聁mP]|CI?D0aT 1\"IؚTJ@S;*&{Vmy3hRm~ɥHlF2x*p R{%EL\\L!\$s46%D\0D}&P*Vw E	kY]0tkAVC 3N\0>phbb{R=oBG N;DcB	ZJ0:K\$atoxФ'd(\0\\^[ZI\\+\$,(:xDأ/HaG)e9s nA&p\\HiLFUW (\n߶VZ`^rJ5\$3:;lY	\0Pf̳Bfz\ndlI	:\n\0c\rdhӅCZXm,NnS\$Yvz\\72@0:R7YPTnuvη\"޽/ T!\$J<g)z.\\@-nW(/\0)rcW\"Σb=S	c_F2{N׃..>8+㶧nEĹ')v.13)ܿ{x/*\\(Ǡ4]#?S9ө9nBf)L(;2&E_r1nUv`F'93۝]{ÒXv51Sۑ\"D[rOW\nc{ŐP3g0Oa|Hpq:\nMLʴH4UoZE4F0eEY牅\$|rk[tL_Klt\nT+vKaD@l\n1}b<koc/[	\nK*\\L\"6AZՈb]V'L( <N ^%]\nd#vE>OPTfCI\08ƌ\\VLwpRNvloPdoRmIpW24nn&jǾPx0oP}	\n%j.פQxGc\r	%رOcCTlC\$ͤiv)T3\"dp*ZB24PT;	qj9;Wp0l]cFs[Z\"/0I\r*01y0OW&00mQѺ֐FCZ7&i1kѧp0BO1\nIghmD65Ѡ͊är-DF9@f\r&%`\rrT4&o%-	rklmلC m2ˣ ј-٢I\"%*͗*R0n'g+,LPPyV?`F@ҫ.*@0ig\r	cr|J8d)KǾX\$\\o#\nJvo1-\"P4\$4X2\nS\$?~ \0{⊏o;er\rVM`NkdHG\rX>\nZcnMPj\nF8Q1\r::Nq:{G,!Bi\"/ީ2'\n#f*I\0007\"Bohͺ6E޻B2*`I)\0[Bj\0\"D\noh]VƁ\r=\0D{Qe_;&\"nC{SLhDE4BUC^6t@(CX9pC`3\"R\"n<BF]2VkACLJg8g!f6gTm0ze1(/f84]lHhYİ4d(-=k7\"8q>>M6'Eu0P{GPF4Zj:`3#BBVd	\0@	t\n`";break;case"cs":$e="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8Ua:Nf@t< ya;Qhybƨ9:-P2l= bqa27GɌ1Wa1M̈vNBɲ:[t7Ie!;ɲZ-SDκfUFcga;da1l^ߐB͘e64\$\nch=-\0P#[h<KfIcD 0Cz 9&۬H	(B\"##\nh4@q0!2o2\rHHȄJ*\\\rof1FH@1@4E`ȋ0z\r8a^\\0F\$8^1ax0cxDQZ1r̐@X|\nˈ!n70<:(CX:Q=\rX:KV:U|!1㜃2ch0ViB\$0ClvoC:20\" :(\n%jf:Id 7c{{idօ35uS>A\"07\rt3C;6UZ\rc ʝ#DЍă/9D&\$o\"<]}9#4Y\n\"dL\rH.6mP۶bw^[#X}R:&4m0&T|7Ӌ<a\0͉֛2%)	#lو/횺.͈\"@R6j8@69SN#vxRT`92v7H\\*kOpSأBhO9*VlRF!Ee[+H4\$:9c,)(ڹR2\0G ҍbADS\$A<2\$|nL2	;AȜVL1=B7uA2\r<Cq;`&8MCl!XB*%8a4<C[?W[<I/~&:^DbRέ)H'aLc2XxDOa	7&f+Md1<\$:#9&zO@(%	\"I\nQj42* 40rT fLQJEObnN)IruµƒDpt3\$5K\"l}2ػ\$s<wPj)ɐ䢔`/*7K@ܥÕ{o*^;~d(tj\$-<BL\r2:5Jsi;S,LRh\$A&pȦ	9A.104Aȑ-!ԣSq:*b&jNBPi\$FQ\0@4IXi%E4ɩ+%MP \n (TuwRD0ttBCR2bC=W`Դ3ڔ3hQq4Sf:I\"Yd8YDb!t5&w84\ne0b	 aL)i)&OIO'Y\nD131D [#ZԠbLpS\n%b[E\0H0kkGim[׼C,24Oq9 D(baV)a-5\rEnjP	L*7d8IIX_҄}7~^44%lY#\n@I1|ș\"f\00TsH(E C\n?\03Io㖎2s@%kМb/#ec+Z:6hM1EZءu92:F Xeg~I\n	bIL?&6!W0kP~I6?	W59	AvMÒ6z`VHOvBM/\ryxbp`bhb^`՗<FNI=@\$îl~\ni~>4:t\\ՁF8rEr\$EtǶFZAh2sO_<gFRφ-P>/:#|rI-b/9<	.u&^CbHo3<Ɏ爌g@4\n/R\nʃ#g\\␥nP*\nu#U+RD22\\Dp\0/*˂= ֹ}5.{ =!QG<o^\rOFh.ix#LG9	![^]EchxF=,h0Y̍C7FĘKWH.񪥊;Cu^{_澿@e~8Z(T&`H}ddTPV ZHBmz>ohHDǜ'bvC\$ %dP(dX8#p5jhWE<J<@C\\j|Z/\$<V\0JƵU\"l;H\$@ېu6V:Wm	nlWХ	P~>fВ h.jN<,\"`&.(\nEvr&Pr6.lF!Q\0\$Xa.n&*Nm?	B4* خ(\$]Lb &kLdƴJXb\nО.=l\ruĐԞҦ/hرio9/&\$oWM2j/*jO5PAZQ#Hcū\"qG+!E|W#Cp\rW KC!rɁ х\0yŚ-ȧ ]lȳZaBP|kU\"^]urN%\$#fDx+v1q,\r(p@&F*@=R\$RA&ͱJ.0:Rr]kF= Q\".\r0--R\"<&eQq\"!er%q%\"P\n?/cfmmLG!0My0D^]!|r\rt~fAE/prїc,*3a61qyH#gbn0bX).q9jXvB%^S<6rsq\"v<.8SwHzŒ-^>P?d.3س1>:MO@|~rDN'/#4&,*7C\\E;\".\rAS5ZF2pyl\$ˀRRE5F	G	<q:\\l\"49Tt3(H`\$@\"vA%h`8CHa7l8,ѷHd=~t~\"2o-ςh\rV?te\"vNlDcLC'h\"o(6Bxr~i:(\nZ{,zNt>CRԑN,rARGF!B!NUgA	8chCC@]R7\0QOv-چ&a#n2#\n-KH[&֫E4\0'L1N\n	C>0h-|bh_b'`%1mA^ͻ__`\08&@sT)F@'aJcdcXFnt,\0\$2AP#P'u0f>f.\nbR'~#gpIKz7b~=B>qi\"McDoP\"AC>Ҁ\"*ƾdl\r\n3#iaV'PG6Ĺ 8s\0";break;case"da":$e="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9GS<y8MDYCQ\$cf2 )RN17&sIl36Me#)bl51#lg6rY&331@a\rI-	rɺ6G2A]	!τĝ4z]Nw?t\"3ob)t3˭YESq7\nn5P<ΐ&p7 z,ČP2ː	+	b\r&B6@7@c\"8;-1Ʃ\$߸:\rx!\0c04&C0z\r\r9Ax^;r+!Mk3\0_)r0I|6([31-L7^0ج\rB:a&t:!c2P<n\n71:\n\0VMq]W(7n@*,(eM2x-˃fC(0c;1?Eh#!B>\r7[chi{4H7h+68@v:3%	\r6V=\\`Z9m(h~D6BQS]CeH!'h0ԍyz(1U32,BPXɭ4\$8Hh\rSB*?4l!R*(	[,3mL-~#\rD#r!ЈL|<ˣ\\ĨLpm2	Vu(؜6:Zo*Mt54!1%4_[г'nX3آ.}+Ƣ:n[90d2S<\nʔ:#b#p:N]6&ơ	'	h%ŴtLi3roN!3\"X+WFZus\0&K̹Dd0ɑ:a_)\"fM5\"!sDB'Zə=褛g\"L:~!@9/8Xl H.p#zL|.vD,to_Ga\$utBte=5S7XIds]-krLc˩S5bk(\":^m \n (He1HS{Xq],82CtI[6Rhߜ\0gHU\"H!y\n9FD94Rb~\r'\$40LZabN-k6f!0k!hE@H!235PAɠ(!Z6tFI.+Mg\nLRd8&aW m2D˝BFLxS\nPJi~\0dNiʤ8PaHR&PCIt+ũ:r,᭻)*!-rM0o2QP(CH[魆v `B12Ym\0Rkd݊P*Vok E	ڡU)B\n\nM\$ej`Xǟ)F笕.pث'ֻ)`ԄO	39v|*6'L2r|SR*2^>ؙ/C_-չ)Ɵ*6p8#,2t]S}#a*0O\nk/HLpTΥ WZ\09LGZi1ePr~+9fDa4,,)Zy,A,``^Tb^ёvt.\$O˞9Lۛ.RrR%fSQGKx.u]=1mAa T[X]7\r;ZOC(j72PW༦T)RW;c^>n&'YJFS\"\0HKi5Av%#_]1\$iэS_F	#V	`e\r&Dl%ƦEW9 yMp+`atѭrd6\rd r0	!*w橙,a*|yG],9rŇ6|zɇ*K唌\$)<v.8\nOS3ŋt[.[IqEdIb>!>'ʧSYo1+;9To:IIcAXkC:Ug}A:E)@Uda#w^_i8oI^&ihﭧMN{4ZTYZV9?_v9o;/?oL`ʅcʭ!J\rF␏|~d =8KfFaomЇ0\rİ< K&DlP(BuɈF>c&d&L\rP^REPe	Tϑ\0'<U&*ж8p@Bp)s\n6C\rng#jTL	\nVR,zNfSOF0/쐔3o\"1.3	fzc-G,|30ko<l\ro|F.bH1減r`~qdHZÁ@\0K>r~1&PѨ1m	\rP\rz91-C0Doq\nB	.#q17CM>əM5bJ#\$u~>:`/Ğ!KjJ!Ѽ	emf0c4(N/\nUےJ@R`b`ݨL(ƌ88\\~(0c&Ê \n\n\"?,V6\rBP5K*VMįE+B2&jMÿ-7&\\(,\"lFRBc>#	f!p\\[0N,,dkVB//2tx%XŢ2lgFF%3S%4s\"3&)<0n\$bb@hSbū,Ф *!6B8cORd>&*M2ǎ%GCgpfX\01˯<c8Je#04F%CLXsT,J&\n	%0Jt\$";break;case"de":$e="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9S]\r3jPpv >9M(n1\$\$NқbqX8@a1Gc\\Z\n'X(7[sSa\$NF(X\n\"ڌ5MR\r6e]ͤ<#(@dDM^|z:gCܮvܧDSuﵗ6-l\"䇾*,7m+\râ50 P:c.\"\rc\n\"26J;)CZ<Cjr±(0:NB`3R;#	66OJxHj-3 cꁺTj\rCRHƄ\nD49Ax^;r.513h^8Jl`J |6c@bT\"Hpx!d2DRDp9SEK2n8\nhdT	(C*=Bd7>JC,aʋ {:2Kp\rmI\nP7^@Ko(-s|D\"@P<cM[,3Roc)nC&>3U\r=2d+mlhN64حc\\\n\"`Z%ީS7噚/LctmdVm];ͼ3c*T:N726ۈnOWűG<rr]b;r[0۬!Xrl@9\rD\r8m~cZ:Ia7-#=~2!K\$x.o:m/{'K%-\r-5\rM0D\"bKS8e^/\0خ˓//7ؗI AJ6&gx^Ú%ʤ6pNJfK.]Gɞ'xKQd'ZZPl%4ЀB\"	a9O]2%2&`:\r:J2~X2\$X\$E=#kJ\r\nC(rI-,I%@!4Hp!x\$3@Xd&4&k\$U22u ZSBf^V	_\n\nCTzRr8)u2A{86K*zsrO-=Ǧ_h|Th\\Z!:T8^\nDɁ1LFM\n (ЦGt)j(H 6YJ}n%G\$c4ji%3XsiZ&GPl3.~52ŨS5z}DLS\n\n )'#9&>̺4ꆨtcf=Z*~Ql\"H9Ơʿ^|WP	e02ȉ7,թlt0]T=ì\rdbHRl7kNPu!lRY&!*6bQkbn&D 7K.aƒf\$p*B\\	\$\\=mVdlR\\ ,>\0 -a,Rp*:Q==O99'd{\$0@s]\"w_׹HOضEh.{]l1Y@rLϸTVmX^ĹW\$I3\0mf'\0 A\n*@.[=KH35\rIY	V2Z\r7:#%DqU\r&̇6[LsBQ\n#5ٲ':ԋPA'a\r&cM EQnlyョI*P-D=NT\r1y\$/:2\\p:)l[,6|biS:@SWj@Sqz`K;g,f_Бuzu/;6oe\\/#!{Y0dy7R6x*&2i7#4r\\x.|1*fLq\$(bqJ\$	fTܯV堨BHu}ɒ}!T)%YUt8uOu07wTf)6cǂ/O7W~0B*uV˖ռ^q&71f_1\rtQ߽Q\nc׿.=yh̋6&#Q>5H#rFr\$X@|F]2g>	鼥~͙D; B|#v6[oe0)8et#H@3X&!ZЃ\r08#2sP6fHυHiMBؗfY6&fgF6tgPҍ/1z\0GP?<6Pcź-ig\0Z^D<?GEneg\\^\0\"C٭/0:\$\0lD'Ж9TBѤиZC>CM\nG\0001/&/*66M^1\$p1+\0|@'<q@,oL\$:0Y=,qlqf\rj!Qn5H\n%5ZǇ\"̇Kc\"^5l P:htc`9\rK/p}P2eh\r{1{9XX^.0&njfnBAnYQm#?#PEYњs#Hq&qrE%(5]L5?&Ru&Jqs%TWPB@e|z>o~̆}\$\r*\$G7Ҿyc>bfήYmDԊVbF)-HmF,rzեiP\nGhv\n-NmXMFdK?1k>k\$1S-.^TҹI3g21]4rsX^3N?24C.QRZ(3y7\$4o7Υ2T30,\nm%x]2Ԫ#\rΏh.(3;LV]*x3LI]'\\1Þ%^ev\rV	h2}b'hhطq\nZ\0@縢P\$pR1,0!:*`B2E4\$r0./?HÂFvT0tV@\$АtB!\rbcC\\L%\rvI7\0\0K\nOPc\0002S4-2&!,4;ML4K*\0PF߭AOLw;Kmbot@A#څ|@jPp5'!pB{S&^f1rSDmR`	c@΂R-Di⸢VG\r:E8L-Lrtm#Ӵt\"u9\rސb/Zf6b:vLs(C";break;case"el":$e="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqnFWBWPckx2V'\\Is4ADqe0̶3/tfOj,Q#rDIjI\rQe^DAJuC\"\nΕӗMs7>|w2U:RJ.(E,Z7O\" (b<K42LNpR8:8<,rZ\$39q!j|RbʒZ\rCMrGnS1˔>̂j ĚdڨQo(!r{Lqvg%|<B5x7(9\rQo	N-\"J22q0Z%	ړ(Q4tH1\$\"\"Trx^\rJ|q8!Ӛ%+ؖ28# 4p@2\r(Q#:#q#ov6:#RՎH4\r\rH;# XӌD49Ax^;pk[p]Hx7xDm\"5\"6cH7x<]q}ixP3qehv^,<07(Sj3:Aڲ\rk)D{֦q;\nr|3+#w (C2;[A=PE+TT0'%Vig6Hb*(sY(3ܴj(D3y̅[Ю1	vY%4F19)\\tu*\niEȩ)KKgyY?BS\n!0?JnCJ%%U)XJ-in3g\r]A60F*1!2r&X/TʲN\0GC(aQk'ƀ&<\$Nx)qG^Гw,]E'\01v.1٧hukNz^\n1 Y;&90i2|k5\"CaEF1&<80ܻYs%98+0)5gZEqO؃	bE&n˩C		V/FDӟ0JA2 (6@䭌y\$P\"\"ΩS,tdkId8`\r]XSQG:437{\\'k`ŞGZ]1(3dj\$b0\0^g7dJziI-x]hDr6 [G^4J&\n\rXZ!ԧ&O\n_v4Bl@aP} Ap Z]l&HiiXkb,Mv2#d-<\$@3PqgiIIduH\",zG !)tEz12e^fZ\$0ØbYv4++L)JEe]46bӚD29%rUZI9*l.,L;Wǥ,Y~q=J盨P]Q.gbu*]J\$*V'à]6c5aGU[a0꺗`fD6\$|.\r6dv\0000T3\"Rޏby8s\$_@>VX-d|D+\n (\0PYKE6y3öwR\$[ic\0Hv\r2d3\0\\tawA>UPS)T5UBf}x6䊌Ś8/\0 ro4#bK`ce,Y1xKT0!0R'<)*{D3)u}M; fO%+|㝕\\ֺь%eW!Q|nBH04[gDŽ\$l;WGYI%DD\"0Xޖfb \0T/|?vwzINdeɦ+ԑXߨ+\"Bpo\$KW<Y:l&+4*]|UFR'\$VN`L89\02X7}fG YFpT'/wH,V\0ф7	,N%\"!;b!Wˌpxi Ucav۰.(:S4UĒU&#4A{!MrΓW?^5\"~z?뺺]ky2.##}eڊD7,},K.|Rrof'S+|*Lyo.vl\$ۏl#on.0(~K>/Ҝ˃XqKXF*J%bȈ}#N	\rD̥6'JOr9AxHr\$C	cl\0Nlb7\$ip}ƾSd4`,R\0S\"f\$hzXF7heh&ltH\"J#k|Dm@ \rb\ncN^cV#\$H8qTzFQ\\,+B8QE{u@\"Ţ|)*D1ƚo&DwWNWQT%PUGɠ \n`\0\r%^Ne\\qG|f\"6vNGA#F?\0'#B?TBKDO0HِRt\"J,&*z,rHKP(r-%dn'&ɲfk&'\"'cw\0|2C\$@\"+.+&'Ľ^&*3\r\"](Bg&1\$q'%&'-b+.r)c))p*lFN>B\"?\riЎG쟂D0z-*s@'*0FSN>333\r Sd6jEh8k+L-b(2\"q2m]2o!(xyl2opD\\KѱiA3-KPHJOxx0p'Om,np^nM\0dtSNuIg%d\01?O?90?Ô2\"`* >\nGLp?2@)BTﶂ(:C@Chw\"F4%E/bEq @&\n)f'Mf6uF X眖\013Is0(b\$Ks0x\"\$;Dg\04q[TU\rR%\r	 \r\"}j)_K>H,045APCjMfwd\"R@#Q(A^cEA%DsMt<o-%h\"\n̒0J(ҥA҂`jdA2&UpwS\$.G\r\$L5(0Lqjb'>Q5Z+ZbGA^BI;TUW%\$i5Σ#u]T\\T5UStds-'RD~C%br+6kڲa,QRct-BF1\$4@6\$hg꟔Ľ~V'aMKdҾH.?%F\rU[u\"pBE\n7b!ce*V1f}؃MU!?!k[U>Vۑ_hSF^\0TXVnm\nc:!)47\\ip4:s)TJSl-gnV7oW#mlT{r:o36UEpI\nH<C=dlvcvO&!k\no살4?XVw\rQF0l1-7yyX=_zFlTЕ@JlP4]>^,}Et!|Rd'{4Ǖ}#g#9=w֭RFF[ty[&Ƭ9!!<QcX/Nl83rd\rDxڗ?{ۆ7ahLOrerXsn;71~cۈ79~&WؾB[(}\n_S@1(JTALȝtfBRPE-C%5y\relwUxی̛?u`_4ȾSB={#	x%OY.\0o2I3\0UoW=w!y+YI*KXwΗLqPt5Hry);zlΩW.FA3n҄HZNr3 `\r]8+\"H7v/}WPn`7KcBHU?pV}f\nZl+.RKBOB\n[(N6\$Krs	Ĳ!KϊCGs%~^(DʨˑϐrbDXuE4B{T.bͤ\$gG\"%.~ǭ8!rXr&NHP҄G)a1h5\\xO,Z4ZedVuYFD#8/ř#UGݯ(ɮ	:כM)!k[Dm0Y<ZqHa9q	IB,V,N27:%~X63iCbSGOwW	>/\nM2q!8\"--.qz\rLǹYlRѳr)e4>IiODޝV-w16ϨQآ;kJ\")3.w񧇱n\rQ`jfI=\r36ޗ+qh\$Oq|J'WF";break;case"es":$e="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AECL653MƓ\$:o9FS,i7K_2Χ#xI7FS\rA<MӔia	r8MNfDl4̆gMjE*p2iiN@	:.O~ir2,dQCO&p9H3,0gKvIyfG{[ <\rℶ8ܲJӪP0Β4kR݉-ޔNj,KoǬ:-&10*(2Pݹo9FXQd1&\r@RI\n:(@7P1hR2:hḞc;`@<#C3:xG±Gr3(^cxD´Țb\$9x\$b/:-\"ڹ/C:kܖڶ2ؽU\r-A\nrX:Ȥ9+2OkǰPJCʘaʦ (:2(0C-!%B 3`C`gVH817\$Hnǲ2j'N,G8C?mC2`7c XT9J++\nb3vK-ݗc-2lN.fÍl˳j<,l¨Qn[_v1ڌp\0SLF\"swM%B (*x?5#S827յzG@T(ܰR@؇:9nƐyZϩ-z9h1]^V24-XIeқ7!,>2[%:OK4/=Yb5'ڙdM.q#GpO2<)l1RLQ#\np7lBm\$x&@*Q*-FTcJX:Q.<C;D)\$!~1y\n#`-Q=C		#\nO*\0@JOI|8a4Z!*!E(6j^')~q^TT4/w~؄Z<u1ƄeO8D,\$HQ#	4#ğ08DpZ}:IZ'-c%\$-~WjɬApn\$NlNP.XP	@&h( (L!7lRb\n#1jvzp唅\$dÄ4%٢[@y!=!HQ,HNH@a?.2BLe#jr:\$(!=CEąA5\0F;A²\rT*F]y_l(ȍ\0C_D<&nhGigPѝ\nLIJO\".ѪA\0PF,0%BA23+W9ivYL5RcZ\$00cxS\n@YDAiz\"VB\nۘ7W[w	AsJaЙUtdڈLɔInӊ` Rz Ô3V<|Z(4mw=ԮR{njW7h 0oIA)˴xR\nX`o]i!r%#3u('2)7ڭ[X.35J͝RLIRq~:=ju%[\"M*mMwV@m;\r3P[c.|*`<RdZ*feqr>wԟ<<JiUj1L^z++TF\np5jW)JR㞆2A\n+M,F(\nkH>\0_9%%0ShB+z0Џ\r//1klk9lg8\$%vmac[ӇC9D֡q#7'ܑk]nvn\$7_)Zs3BZXbѪaHL\$@g}i}@/H7Q*1Sb[XrK] 9WAir\$Oܙla8s'19a0oh#	Y맔?l!=cDt\n\n>;1f@_]ZxL'Q|d4wqr݄.QRG;ʧ|I;2z\"e1He;l\$>s\"vXF_\\\"'*5ddZDbOoV˟A(-flbPFG}.;DfSTZ(Qبj_/e22c<Sal]|xh2^n2dd\" Lׅ^	G^v dJ6?l\n=̞Ȋ0bLx/	%'&?n\\4nffEy|΃V,Њ\nmd250c\nLϜ+#\")v%2LC&?#4?hGAJț &n\r&V8gΏ2p*pH؟+	#p-P\nGe)q`ܾ0nD('F?L&^Edpj._d1|pZN\$Fq'pl`0nb3,f2hHD76E#\"N<^G,/pQQo51vόoqB0!6	!!!h\0&xIQ@ۑ/\$Li`D\\|l\")&\rf>%ƙ-F1'='re/l(҂;݃v+!p*<HB'nO.b3op`cR\nov],W0.ˤe/F]'FRّ.cҩ,`0w0I*p\"\np\n\rVOEF!#@	d1#n'#:@tpE1d\n\np\$nih&N*\$N\n(>z\"\"\$/ͭhkmZ\"(dF\n(#cĞo>mHBVP\nJ\$J\$=n,%Lסtad.%<'.!hX tbȶ*GB@/Rтi4Vx:4C'mACi?1\\ -*pi	jbotPfr&x\"qMI(\nn4.dTĀDM\rc/hAJ4(vK\"\$ȗ*]PZ4t(7`[`r#bg1jȗtk\\̞:S";break;case"et":$e="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(a&	\r1Lj:e2\rq!?M3ϦV(6byeWhsygD̀nZhB\n%( i4sYm4'SRNY7D	4n7hI8'S:4ܜ>NSozZW<,5!Z 6N~ޓ0~3?r3̾!Ϋ'\n3R%b52C-x2HX6{94}@㪴\rȰ\n\$P*&\rտbS0kL.-fB\07\09'#ƈ%@̲(ʈڰ9h4.0z\r8a^\\?C\\ƌx74C ^'a8ƍx\$&5ћ2	\"i֣&Xо*. ]X1'\"Ln>+X5?b](J*(kC+\rl.7+Qtc]5N6ImC\"z# mF#XCJ&\r*+	\\Vڍ6kEmkxYM2v64cZp8g\rc1#Ø40S1e)@o{*\0uCeZW5k^\rZ:cFb5ha~lk%\"@4Pۿ\"(*\nvP6H\"|W	s[-؄fM0+90t#;Ou\"!6at:N\"Y𜱡0CÞ7aN'n4\n<(e #w-WCKF7HQ\$H\nCBVKrFlWPX0raJ0h2@RO\$\$|j'*22VL8h r2`c0tnӊsN<FB\n(eں0<F4)K\nlgjqIGM(60<d;`o3NIII**?(4i.!xOI?(\$^PiC\\p!:<WΈo-'*\n7*ÂS\$evFq.Դu2g3񌥰2ag+tKÒ-!3M ~6ALj(\\BС\$d\"2gP\0Ι#5:br-!@\$	g5!eVqN9c Cxw-]U{kj FQI]JcLq\n-5&A1fN4q\rL`@R́b8\nyb= 	R2DC\"ñ!a[L2.NHy7)(\n<i|:eP̄lDO^`7M='*(pTT3Q#i\nUHc5<3jIP^\0iXA׶~adpGİp@08}\0(2RaJab\"\"`(+C=	-h ayYExR1HdxNT(@+A\"~.7H\\Rȩf)GYmDC؃v<9C:&>\$a*\r0fbZ4CHQ5z硭`w	!͵7EZ6o(xzρdk:iFZ\n:l5\"xPJ%RG57Ld*|X-UVPiCxb\"1B\0Ǧ,#cLL	A]d@C@+>2Ls뤸Y񢦥pY64֓']ceZC+MN]a<љPC9K)ᴅ&paP)(RrT[V. aQYNY8-EcAC	\0+J)>pGDA\$eh/YrZ\$4FBHw>@\\g^\rdlن\"N6KM\$֪&>1klشc9\$*E i;\0\$)?WpDTFg=vʷU<\rTɅgvzIggJMMiJ:ƧQ!fkZ\$y\rg*)h::Yʫx[Gǈ\nCK7֔ubIMK}\rf?<!p8px2NYﺷ!!xpnn%?\${P	O\\nLFx\r\$,  \"d,,v@,Deg,I|D360:oRj+lV*.2n.E|9%T-\\M2(h,Nl'C>jk!p*g	pj\r\\ψI\nPy	T9Z}bXN|B#zpM^4>1~<Ef+x!M?|gPB̔c	!H>f-^d8pP3BW\$ha\np؍`&\$ ?DXGXŐ/_{*XY1bJT##Q<X14Fn\nekxq#q1\r>k-dq=1ksGr'&YMn@-\$)b5 o!J=£ У̘omp~fiP0N/8zIJ-#rHl&)prY'l[\$oIO#>m7b2j_*)͘(^12%r_m\$-ڈ2</~Ϋ'.r.C[&F--T2-m\rDb}A\$/./DOY04/~	43HFc\0P	c YRElmfTXWPJn38	o\rnEk8Za-o޲0=nW@`\$b-\r|qI.\npzBFQ!enlPf`@@ GRR4m5rlEDCުȧRb4KX\"Fc.!	f?l,ڣ_Rv\r/Q)-D145jL&A	I2?3ϐyr7}*\r[.ӣWFW!B<E(bG3.'0i+E`Ǐ_lC.h&\n\nP\0R)M-%]\$\$%TTŌAD̐m>b44`M<\rFR?o%Pmi+`½2`	\0t	@\n`";break;case"fa":$e="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6ѶmkvᶹBhHA9!d+anپ<W-l'Dqe0̳\nXvC-*UeKY\$v⬅5NWf+PdFZ\\aT綷Jė\\VLã#u\r#He)nZ4Į>N(N죂ͺ猪j(l4{\\)#7lX\$d˨)SCB5x7(9\r,;P\n!b()\nM*Rr?HF1|Iܶ1l7n0Q2\r|Tx9(1c30Ȳc:\rx6\"9h410z\r8a^\\0˒]x70DQAxDlZ4Z6H7x5NqTDCè8zT;0?ؑ	\$\$ͤ	5.%PU0P0Ct悄\$f@MyqlR%kҙُ/J\r|(m(6b`\rQ3\ņMN+6:˜[\$#\\&2|:>ܗgNUCILEL6>\nbhϣXO߼̖I*dg\"֊7\r%rZ	^o{I̟d>K(h+4	D=etk6\rҬ[Ј!c-&A\0:s=X1vαE9#{_u4̠Ax4slR7{v(:TvM3]\n\"!hOs%9Äs3;83l:K,\"@I\ni0x˜\\]1JÔO\$1B,,7#؈\"F r3D9B,D28K\0;6PABխkxrGa\\D̻Cdq6VEa݅@QdV;]\rȩF7C\"_QHU\$SJqO*rTʡ0@讕@\"U\\R5})\n0]FبN5/ƒ	m	knJ5G&TSjt;CrTS>&rmN1(G^<+(~-QKl8	κ\nZK5ҁ\nWD|#M!?\$웝dtW`?9ʼf}9TޜC0u7w\0 PM@c6?	{9#\"DP'GHYs%4\0%!;(`YDA21jD,GLcB\nJ{តTؙe\r鶋\"j>j,8ȓQ\r%F\$sP뢊ggCPD%@ia=+FaR^R5rd?:ƠK,\"F%B4I:'a\$<QJQQKȻKZ%~V׭<PmC@ʂL&s\$&<8Tƙ2,\rkf,2TԦE\r_6*u5(N͚8Ȍ\\2WqF\\\n-@n2112JbQ`B#[hiF07@Bd1:r,RX4IZ^BH8JAo?;CQbȎ@('@BD!P\"L(L8ٴ(GnTE9iFr:wz\\@\$&2A)m.;B(V>Җ!挄ЮcJ?.U3g.![Z@łsi-ZbD@VFz`7	(a\\Zh`H!|T++Wܳ稧Gq2HHRɓ\\9\$sg-&	\";=;&9Bި+p\r֗\nP!efb}guZ!Xn\r?,6/;{B*\\*Q1fk ǧ'j/adInb-4Tb-YC7.6u@u]~T!\$uə4&a=D܇\$2)˴^@CCCWT\rPѮO['@T}zcmay:+zgwiɳű̎ЪnC\\4g2<fr)N\$źf܎QG),xCG2B̬w\0mzsHIKFj_nb\$H\\lF\rIJG˧\07if	r<źC-r;nph4ŘuP\\\rF/pmY.X(;B8P\\D<4.Bt胫\\jڔ.\0ZO\ryF\rL.\"J0W`O1\rڍ.7-\nGMplj7meM©o-qGm?c{07a!.tB\rS	sMbO~4F\"˧ rv\$'N\r̠hf!QlM9-%ЌppQqƠPwc\"r@fmCs\nj9\"F,FmHARGV낤Ӱl)B`ʠ\r6P(-YU#]:R9SHÁ)q2A̼]\rRbm;PR4r9&*Rw(H_	M魞D/&:pF#N%rXM%m'w&'//&8pNZ`lDG\$-B.oF~4%.\ri2+`\nj6o1sL2xo@13\0ʷp)JFm-5'c/W-rSnr3~d3\0& \0^%7)0Gu0GŢq)!CI\00Ct\$2^hӵ*\rMT!r\n\$E=ۨiEqπbA>A1dG:H\0bţ@lS\0u+*c.@\npDq:/fTkP8s,PM.6?N\"ԍ6f(s6lwBM-0b,<\\EB\"6ihMj]+O!H()Zq!DX*o0x<BZmRO+QLHoD] t51Q5cPEXP&sC%(3IXdlF*&cQu3\rp-*ӯfFJi.f\r\\mKY+\$`dTi%o*BıC}QS;li1Yo8\rR\\\$2\rE@BŖӧѨ]Iߤ";break;case"fi":$e="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 [\rHyWUy8N|=NFI7FS	 ѧ4y0&~AHk!22p2p(MSQRM:\rf(i9׫hCcRJJrTf!7Y4֣I7uz^\r2ÛO 6ybkOd{%zMs24*6Z݊::cДBR906b>m*%#7\$JTă!kgLH0 	1<\\ֹö@ÓIp̧\r1<90f:i899lxнD4&xGԸЅx38^cKxDҼ6;A^0HK@t\$S`_%@7+X? *Q U^9\"ֿ-a(ț#ڊk8ഫ|çXMh\$͢\"a<W4,5}3}\r8t0׭)#0NE^8<c-&JkhȪJ7-#%z%U_5Pl)\"`ZhpR8<-cLը{cc;@O{4j'vtNxҗIV\\#@\r ͎k!=HZ%PfJ@!\0R/iI<UbS@Ԃ3\r#:Z2!\09	^O[erHch[w,Ch<֏_p\"L'o,(:W.fоHԠ3\rt҈-̥ͭP9-r3h:wrCHl`m(+21HPQB=c-#Y&1'\"u'56XΐbL\\qb#<jɢK\$ۆ\\	nn)R\rqڄDNaIB[_!|!H懁B@x(LR@@.+Ԋ,ePDúKf49)U.Cp/!GȐDC(hZ1j:R`'7!/aSHDay}CY9F6l_S.=袔bR\nJBHe0(xC\rHq#ׂJCC!/ŕ!p˖MId)?(Hj9cα+A\r@\0sL<i.XbRU.őSb;(X7IEjE	u\n>4D \n (2)Jۦ rKkCʈ巑jENi|a4d4\"5XJi̚\\&.#`á, Rq(i8nxa|Ġ-5gC\\/FTL+}\\>Rsi:2DL+&,p\$@X;4Br_lo)bM(]]uf\\{)dT\nCDpi<'Z,!\"zC[2vr٤Ҁ:`Rg'Hl`V.C\"f(UPw@' 3&Z=lT@BD!P\"@(LLH\0ԱѮC <f`<:RTÕܐSqh,v\rxff##	̕MW0ud[Cly@z?tbS֏ˑv9- ]3Q5H\n34B\rC3+CL|<L4	/W3ݱ!oVye+łi40=]Ry%eG3-]s:E:)6m/\$ZQLЗJM(CCm^P {5pG'K5~>.hao py6!%'#\r(\"7x*[<`pN\$AjR%TeAx r+|I<FU\"\\f2__T=Z1o]nv'ndCOMRũJW*蝎g{2Z+[΅/1)Xdڢ{aLC㄄ihGX=QV\\7[Iۯͬvhvсr%rs<aK^l\rln#[ρI{홙0%I<8Ճ5i'Ca(a%4&B(-gj3..\$.--p\"@,/\r/p2bje^\0\rL5`o fBX 'L+(/\"2O,o̴#(ko60Г	G&X	conFNкe鮾&\$iDNr-vvP0Aб\rj_'\0քt,TJ!bnl-Ҏp>\"ZGd&N2@%B\"Cҽ{Md;B,:d\\\rXEX?,]lIO:\noF\rY&.Q&pPܢ9fj'\\.  M\"T4kPC>\rn֞lP\"#0\r-ܠafЅ1\0!+\$ՑVHZFT#\$!VF\rMVe]%2( (rcC)-v1͈@%0Znf1ԻN{. XrD5#\$6\$n-_ ';A@CLh0ddS3:1.d>'#l	<RA{%f_\r-4b#NΈ|j.{'A\rt4gk\$\r|\\J|퀆\rV<EУhI2}q:ਲ@pb'Ip:da\r\$\n(o)&&f.oL=ϣ0O:>h^{;CP;#EgBdJ8eq\$H^\"\r>X1,T\"x3Of9*r=12Z'G¸PE1C#gV \rnHbb	Ъ`-\nO7l\"\" #gt`ArφGT-RzH[\"81TO/,{Gp\nN|L*G\$";break;case"fr":$e="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AECj :%f0u9hZvMqM0Pecqe0:N+MޏR5Mj;g*L'S\$yy=W3Rt\"pv2LndNhM@m2)@jF~-N\$\"s93N78-L?O\n77eKzT7@<o0½)03 P\rcr\"L;?t\0ъca\0).Eb2z:lKLJ!\$ X4kn04,KJ4,Ò\\ש+T2\rc0נ胨\rp1	:\0'&҄* <%`@\$C3tD3d8_,; ^(6*&7Ȳ]^0 BJjY	X:.Sh7ؓ(xml\\(:`@\r4:5N.1W\n\0ϼ M`!d5,67Tð5,2#J+&R\"4#LS-12d܈̞Zʣ;T)ei..j):#\\cd0|QW;SPę\":(5Y()tS+(=VyeV)\"cHKܶOALJ:\"Ay8>os2T.2_	'm(iCWx?xcdKBT5ǣ7\"&\\b&SR))ZlZ06zc}W5}L`\"8p@yA\r7#^~Fc.}ˬ6#AB\"C?`,-Ƽ3\r0s8N\$@(W{r,᠋'Lk#(ד\nxp2ѯ@%`uJHtWy\r˰5ȢM\0|:I(8H\nC3\$-Ds\"b\"1A/ئ_qA@K\r+׈C *ׇ%\$Ha4#JR)u2âSQXHJ\ræ5f#ˌ˿fI#VCΑxi0cAQeUq\$x8JR~baM)<wTL%TY!MYRغiOpabHyᄏDG8n;	،v0rR\$,	`\$g'?Ô|'&!33M8<1,\nD\".>\r~mJScm5FBwK 4@\$ȰtQ\0fa	\r4ROJh:P-:WNI9'wZM*\r4i}%ʰ!`K8_h2֢lI̔ni:g\nhklх@ aL)dTI4?AZ|ȑ<KG[_V&h\$h(Cl; R\"gqvvXUμߣ\nv\nYcsE^K6aۄ*':5\$3aA>Xs{.\0¡( (l~(6g\$Jt5oHmvaN,Q#ȒքO9gt\$+>>bI#A*S6EO-iu.1AL?)(39Kc[,20p \n@\"r>I&\\#% aVQO*hЂ1ۅOB2dN5!<bNpג˓ f)gsNm*siJE(jJxO[렪\"Sm L㲛9w%F\0bNf92A4YH\$hR&	rSK?k=u&F62R9v7-_nM:yF2ͨXW4ŭ(T[Si&8>;=%ŴRqJ#ɨ!hKXfC,\ra?eI)\"LEnPPa1LŹG%hH%Q6P 0ss{M4D|nvx ys^\$/uAVC*Σ8NŚ(Ά+G'^cbwg1Β#?50>eOޟʧ%şzR=O}G{So,ig[̱9.!2B1\nzgA\0W_v/7ȷД(lt#\$\\.#h01CȦ0dB\n	4b.+-%qmޜ&2Rӣ^<(Bo`)\$8p@Adf\\R#2C>ʜx8\$S0V*%PfbSpx|nd\";NcMm0`{B#0d͌0PeЮ!F/b3HaWnB JJ2ap\raDF CLԇ\nOf9*ձ0Qj6/mԧBu,t\r+G\0N`!BXMZOX#oPX*-1EQ	k0B,zYBmqǎg0wJ0f<,(2.\nAD'Pƞ:\rX#%R\"]Ģ9dbˆ^Ҋl?Ɓip2c8xvE\"r'zlqne'L g(jN]0(	1+)%eDnw08\"u9+ڱ[+rG-['5,̍*5-q,B\\0,Ng0cܣ H0[)ӫQќNҡ3S+*r4rZb:fEnmj _b+N0S6.Z\$2b2=(eցN\nr,ȠNm8h &ӌ\"dw9s:u:800GdS,;-d=:<kSD34dN??ȥ:.Gm-ќE.>g-`OA첛-CB;	Z	>\r8gq~5:%g7\rkR{CnKt`!hPfmn2cr`hcbRݠGϮ`pLst5G_E #)#B\rV@v#8d;)\"F,:2ҧrC\n6 \np[3fł.q'P#'v!)N*L5D5&x[rD־E+\"4@NcTj0f	\r%q\$槴u,Ri2nfgc8b	bmG\0n\r=MP,LsQB&ՍP1}կYJyBU[ՊUNh-DڬKsg\"B'b{(\ngh\nu?Ư\n:`f;@殢 )9D\n\nML]T'&Dl7+&H7(Ydl'SncKYW.}Z[r`	,B-fg\$I5Q ";break;case"gl":$e="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9\r0  7Q!y<u9cfx(Ys~\n\$g#)	1s|dc4pMBysB02jn0 SvݣF]ɨ9b\rga8ɲ5EA5iÊvUXلA:^Z:n<oU,KVƍPQ<\r/!26	0B	p֪J~I@4#*Z\ni0B:BH`Lr(C(ƍ8\"~2~r,ԯȠɨ21/0C|7\"c*2\0x\r`C@:t52~28^=>AxDk+\r3*h@x!L2c0< P9.GhߧO+Pv\r4بxVSi!B6(J26q˒ :ҵkkJ<0ΣzdPr+6,--55`ë̳h(3<K	\nK<C{Bm,(a&!	p(Zl5(7/Þ?&Ҋ.S[sd7\$b4+@\rb\$/,zǭ\\vf]cC\0;\\V[f7l!bd|(;Z'1b(8;sXH\"@Sr\rĿ?c9!0k9BCWV@F(1|-CHv\"Lۃtyh!i2\n\"M)9QRB5p*,fÜY(ɩ47%RDyLynm6EPK-%PZA!Bʱ	\\a~ (iF60N\n. d^ހ,(R͉9i4hxb8^ JH9'D	O@BQ8;ԚRS`c \"љ6!g|JW5CaZdq2STayN%@CN+SRHAr~P\n\n+ujR1%0SʁǑ5t-!3FyL؟I@A-يm2HT9H8i/F^k0bGʲL:rq2WP1 2*	@#6A7yV~[BH\n7	\n\nX)&߇2Kȉ!&̳jJ\r'`xãK2pfPAxFkPGtH;3NQf@T\$f0t48'T{NB2\"1pJo\rs\0!0E=4\0GYi@YSuz\$*o`fMU&Z\"\0P`=0e)pиCemWx8>C'aI#.NAf6øG^,O\naPX\r42D)Gy˲odz@<2 *#Tς\r:s\0A\\NF\n\rC---I#XheP<-cI#L& JC\nT R<'\0 A\n\np@xR\nXPB`ExTΘWbǵȑf}fRpJCd}C\$K	G`DVV];Њik[<XQY2Lmo=CGm6Vߠ~}HhT0sHlu_y}\n{AOBOקje-\"Q]3U:x\0*cPX(әla\nCB%؆:pXbFS9擂p7<s\rPMi<r-\re\n\"`?dtUBn\$⇆]\n/jjOq6FYrɲpDJ3ecCy08[̭.Xzv6[Yw`FT׍1y^X*L2u8<D^S3Kʸ:[\\auǰ/{lSzjU#S1;᛻UMi.ۈ(\\`vjzpJv`o(zup_oaw2\n3J;T`b6\\(Zyr95;-(ZҪhuR\n18	2JOXy4pq*<1(u)i@ɘ~ڿ%NieGsEDHC`㬏Ig6\$x\n6`'B<0B2Z0ȰNfEFbÜ'z-`Dl0r7#mF]\n.̘(Lĕգt\"\$~P^p0o0-\$m	Ybu\r\rM\04bZr\rG6AB(p)O\0p\0n\$\"\rC0q4=(6	r5*\"ɀ8&\$\"!'	;NDW\nlqa#q*D+DkNC27	|@ڼ\"\0000Y4Э7\0pΑ*BqfZ\0HP\r\r0 cqg .%f@@g݀hg<K\r!ԗ0f\$\0_2^\$c%rl\"bhI&U\".6%\$#a(e]l+bZc^.<l8ȿ\rrI6)1,2Ɨ_9+?,2JF'RO/%/Ri 2r犡\nr#*-\$T!\"TJ0:4}R3΅4\0	\$`֐m&#)m\$#Bp(ch.h*r	&\\ɀHB46HA\$\$(K:\r3p\rVcNjJ#Ң`P.<Fb8J2g'Z%\"5n*ޞ!آ\"(sh\0(^VI3\0cN.f)3%E!г3HFaBD4A˸9#&hK>R>i6\"yQlHp蠣244'\nԁIH(.eIl4fmIQaf8cjJP(fftf/4Bn ޢ#c|K4D&^MMÂ\$wQ\"CxBlINql6rdeCgC(J*";break;case"he":$e="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r4-\$L#@'b0T#LIRQ\$c9L'3,.N(	\\aMGXk1UPtfOn1[	SVqClql{Q/CQD#) g+n^U¤VnBi'̱k\"1hDAb;9QӉuvGJ]/)\$Q)\n*fy7Lą2>2YļO>(6\"Ή-z0֡DBiåIz# 4@2\r(?:	#q1:#H4\r㬈; XhмD49Ax^;΁pF]x7/!xDlƃ46H7x@{3<ƎTn2lUë%\"H+#% (ȷ\$2kLCS!	\"N-i*%K\\AZ4,\"U\\!h54:{]	{)S=u#RzĦON!Sƴ\$P[Ȓ%!Hw)TĜ!\0(KX,P7OC~_QUSVJXgpu)6ffȲ^,	+?[O>0;Q*y\$T>RD\"'E6'\0:qD/#_Iz9#+Kt4A/\04rؾ0\$\0007s\\wn#(:OM&KC~\$UMq.Uۨs>%Z\$j;r.7.9bᩕ\"MNbNE{JNµ8\$ƣxP[Q5>qDH!:KzS\$}K)oP_ic2K2SJkM84O@#@@H'\\-\$T}d:N)%(PTb,C`M8'\$Ӳx9';*D\"Vj-n@G!```'\$8DOU*20KI\nXPU\r\"\nA20Da#\$dl\r%T}s2p:@a\rEQ_0@@P\0^\r1ܒàoK4`<K\rx\$?u4nY04ZQ&4ܙ48%\0rXa4MT0[e@Ϡ\"\\sD\r >{%>B 6h#EVfsuMHn֕`م'=5F'j1؉=KEDz9NܣqDDj\rZ\rԨxS\nBj7q䄛,\$*X1V\$TmmDSؚ\na1(#IIHpEGS<\\'\"srkb0B#^ke`y/cg@ĬrJmiket<s(wrk+51l%YBJЬUͶB˭COauWcEd\"[@D!;3{lZgՙ^KA/?̇Ѝgka}1#TǙ%DD Ǭ		]͵<s?WV|(䂗{=ϥA07y`u9lRtM'zIEH -f8HdMy~[/Hc%#phDZZQv`C5P^Ry}>ZC@ΘpCٖP\nVA<bz>W\$b ᤐkA,f]\0Aa!jY	R\n:\rDHmV\"~`)?=0ԋC\"_c!xJ&='~,pJjG	Se\"D*l)0	aԖ&4)?C\0KAR䳘(5FiÄK}FVLSOGw\\er0\$~\$+QLl_%T6?,vJy;jylC7cER}ZRt7Y^>!EPI.[ۋ\"+s-\"2)d>kt*=E%\nkY!3D3!\"0Bw	OA+Bn'z{ʣˑ/3yīϙ2PT[[v-ՕQ9ܧKf}D?9N>#qYB	yE_]/`ԳRUoU4o'e%̯b2%Tm.͏mC@T0h:&E^\$\rz{o\$.>fYLi2HB6BƺZj/fRmh\"ήʾ>l\$klhcmZnn0j%\nMlT>lf%\0xuH0.\$܊HK[k0pP*,=PLЀւFē\00ϑGi-t)`\"?l1O)kvM8!(Nn1b_Nc]\rNnj!/,d\$0b`\"?уluHk&\"n<b,jݭ\$*L<%.:<ӱXZ;	CQ\rBjo䒀VEN0b<Ȁ;\$H;;\n%(ʹ%p\0@K@q|l#mp<8UcA bЧd_QEe|7e|\$c1.\"5ON%6f˽KjL56\$N_)\$]Tp*PcBDq_+,w+<p鮆+,\rxj9LVYFŒ?^jEZ_ˌa. hK8#()JP_DPfY,kL!XZ\"R]-b\r@ `qzi+7";break;case"hi":$e="%pRX*\n\nAUpUYAX*\n\"baTBtA4!RO_IQ@q*`j:\n	Nd(O)!\"5)RW	|`Rő*?RTDyKR!\nDJ\"cU|\nԳu%g\$I-=a<fHQHAԴ%[M._Dqe0̵GYHsz.K`RC3ue\"#IrU쒮IB#RE#ɿ҆>+Iڧ5)\\/bHhjڥOMh\n+;Ⱥ)HP4J*\rj-O4@#M-H!&1|H\",LD'H?Dz1Ӹ20c+2s50!H(Rj-~dOtŪB4<38ЊQJMK\"O{\"	;nTTtrPêRؖ2POYHX#.jrF!(^@>Zre`QJ=ʪiqYQBkO`@!\0D49Ax^;p2\rH2Ap9x7ヒ9J}2+*@KR^0΋רyLFmF4ma;JM>̉O|6Q-MKPI(Ζv/XkJ=:տD	;lrX4/'o¿%&:I=-+SlC?ixp-?VCv^[]Ίo%r1I-\$.p;D[o,S:6`R\\.wdi}Ľu?\\Rx	:*+on7Kd\nbzܭuݺǀkH}WKg[tFƾzMȭt@cڈ b䂪p{TO'𙛒bxfb\">f	(mqVL)0A`<5͐fmD(oa(.bg_A*+HɰF]M!\n\r\"ngLxѷOǎ/6^\$4\"Dd,#X>96#MPw޿Z\r+#jIE\rLfeZ-DG8B&d̢Tћr!o-(6KJGWm\n\r9D\":FsUxt]E'.FIVmٛ>5,9	ٓvWަ{nE\\m4gg'󛍱DZNt(<JSkUˉ\"*UJ\$̺e\\r#P=OKAX`!0Y18Ǚ\"d7MMe)-4.[BSnҍ5IEM_J`KAh-6XMqyXm=T!*;8ڗ/.QwZzoqBJ	|	et+	al5&XcluFȃtdaΨF[I316AW4\rx5Ne8aJjqw(1]Gr	9J.Q嘵b%:Dg]4rSU{X39\$7&ܫ_dOtK.h\0)uINAZ\$j~gcnxGoʗ/jwΊhur=r|W0<;#&wa]z*Ysb.\\1y%[>Ef/}.E⎏rJ1*&5@RϵޒSaB_>=jcHI.k5C|~SlW2~9UL|DVIZXNADVRk\$QARѮEXԍ]ti	2ݟnAxpu(&L 0\n.7ASs,XsIc\n<)E̋Q\\-[2.mqoG(f&ьRjFv~FoTF\nFT&/=&UnfAk7Z1۩Զ8[G3X6y\n wBː^9AfZ޹74VM}Fݴhnn=OYWgRME PzO1S<6Te}i~CM}x:vb؃H>,9?Naxav\\_'h_1d+@0,/oIt28;\\;5\nas9egO(U7bc,S^=ZM[6CmӪk^*g+y,\\\rOgl!iJ5ZZ K.D`\rz+G\0?{H Fįbй&E.GzmL& ȮH(nFI_b'6\$8cҶF@IdY&LulN@`# :zUԨ\$?tNt]Ʒ\0'lInEtĎN(C}v_*,(n^XtDpo&ARb➃pHj&\"B#n;,ʆ(ic^oE)aH0KfpA0,T&m*tQ07KlR3RIv@2?Տn(-Z.F*\0K[Q_%p3VRO1	ѽQ|̶Qѐ??*\rJZy;o&@(FuFz?.!_4o9\"Ŵ,i#\"9>NI:3Hpd2M%/%K\"5&\nmcOD8hsψK1l|Dh03&40\n;S*NhgF*(7+BJ)*,6©J2?hM,N+.'\"\"/,ȍ.GD޲0\$hvĪwJJ6M{Zi/*p8FDJcjpl5N3b(l\0&M.L77e#FN6vzĤcRt.M?G7 jz텶@r^l20TZ'2N1N>s@,?<3?%?r\r<H'm4\"EƮȉ1	 V\r5sSQPm\"KC3CQ&	T@F08.Y%?Fi\noGT-Hj~HD|*H>-?5q/,kRM\n>%Fj\$(p*tQLMNdLjr_!9\nI-W.D[MG=KZΉ.R	:sϢkԓ0J	I2.030t|eW0WmuqVH6RϳWtyI}Zc2IAyY[|4IҴSuP5JUZ\\o#ho2\r=íQlPWSE\\`d[Ug,Ȉ_V\"51-/UtL]p4СN&\nupKdY\\o%eecEK\r9N^yX=0l\r>0tiO\rh5{i5eH?qV.6kdlv?_\\clph[V ?frxl\"](0U\nT:бGha1\n\nYAVad0j)1g3nAm%sc1cgtǨpն3`6SopqU[	VEoFI_MW~7w\\K8K\"sZ\\i\$\0^!ω2tiDRKi8zSx͍ˊwKls_^di\rWz&dU5F# \npJjnvr.yPG<wtr	ʕқZqACa5u|憡\n]p\"7|_Jh-e|7pmth7>wԑ)o}6EЦW 2QA\\^?qWSt,zN!,pҀj-qa_rX??HwnZp\nhsqמޘ/6t݉8T|S:4C#iې/OhylG7@Cn9Mm'H(șTyh[U]\nz1L4wXr+@{,鹮AYN%\r6=אf<k\",|r󉙑(MuLTPaF^onϧv_f3(gywJbxk_i܋dgօcM|7}N'v";break;case"hu":$e="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n#FQis'jbRI;g:ڊlƣjl&虦7CIiMc*)-q֞kC2Q\rZt4Oh97eEyAc;`i;e:؟Pp2i3D&aҙeD67{ɭWăc>O]\rO@,j).3B:9)lr<C\$,2\np9\r㒄.\rJ趫ر:da`PAFEhC#l2C@9 jV`@;z9Z#֎m\0Α9CcZ2\0x\r	C@:t\$2E8^?C ^'M9\r7^0P0O؋B9Z8@PH ,9Rzv]\0@F45\"jb6BpkJ2Ai8JuݲH׉-v8B-<PЂ:h設::+2ꍄ:P-\r04ZV3δ@5fCRH4?uZ1\$`+f[X78`Pe^m˞,X@61c'^\"d92y6.Lﳽ\$ƖMZ<)nk7{~2捖F1͘UP04>L)`\0ߓ\nqh=<\\ܠ9*c\r5s 53K&XZz{Aԩ(92F9leZ%^ u4w@0iP=wxG2\np6%{KB\"\"P0+LE\nh \\pE@DlڜÜoTjO\n*Ӓ\ndMI312ܛP*<0_]0@\n)5E\0ebN1رbjBmB`#.CyARQAIu(`.S*l7,:T`7&[!\razdTݙx@ᩲS{i?W^Id	BEjR*MJh~O6G]I=ОAu%0=G@O*'  &^Kltb11*pIc&Q;5`m0i +pm0Hfhi!@2w!\$m5#E1#h<7.,\0(L4] m%OT7ěrji`MO2b\$m`7s6JAxQiRHk{P*[򟒡0A1'IP*D'%o\0@RČ=+E	c^Ⱥ\r\$+540S0tdAS&Nt9p|'Nj_72A.O)5'aŌ2zavHS(ۤ<OM5llA\ri(	054#bVR(eLaPNǼ^AKo\0-YLWjU8'a\$i @ 2k;	zIm\\Fɦe[lD4Y4sjb)zQ)q>-R1PHjFXMPA~GDe,P#d;\\*\rC6>VIGfCp<;ˉf=ڸG?yb]Md@k@SGA ZB~hP!YpttY`oUI\" Ɣ9^N#7bJpk6hki!vC(wZi/:'ے߄p<7FEaք9Ve'V\"(Ct3Ypf\0˼e3|\$wV@ݎd2;bVJWX!Gŧ8lT!\$i2zp23^v]\0.b\"܍2yO@ɴHe+S)py%ϟE49E:9DN[ӫI['+һ'Leu\"CWGJ}=My28,e~gY*§vLW#sac(ڡeGQ`еEO15fjׂήd-h\nbZIj9#_FFY@,\\ba6iˬ4V[%04gf)Lڐ!l뭍b\$<#LEr#K c5LX/`Wde`uj)T\\RW piPL1D%d4\rf#g>?¤g[-\0E\rz.\rl(j9V\0NF\0Cn'	\r<'pޱ\0=\r|C0`)κ1| p>:(/cs.%θ;l P^̼ZbqXܱ^)#\$@>&ƚ@.L\rDj:o	Q)J\"P\"I!R1^6p#2@Ϙ2LvsZM`}Q\r#5%Qj`CLL&LH^ќoYe0\"%'P0%#\"r>vJφ9\n%#P8R(%2a#B%@%ֆo''K'p	b2	\$`##vg<B\0eR2/J3qC+g&фPu'p\r-&Ҍ-HJ.H(G@11D|\r޹dxJ!i5122G#2s96/\nܟu20M+g\0SZĽ.3\\K\nr27prLYh%PȄxDD~6OO96Hb0FY/-\"TD\rlBJ&C{0B0Zu?ChcNF\rS71?L>&K	b:lh#c(\\?^]1nB8)C/~\rVje`N,c\nbTjNTlg\nZҋ0BbU'u\$-IIbeI9IWJ0\"\$\",\"Lc\\2bD\$d! F\nJ&0lOhBC&KM@@,5C)1C\0̞ \n%@ՅTvN(P*M?c\\?eH/A^2TZfŞ\nȂNm@vFg8)OUObb!U/ӦV&0SH2`xPp#UqaMM)ӁB\rfp 	5چk@gsXΤ,	X.dG.)\r*.\"#=`B%\n	\\7*U\rVfq`v=M uG\0f2a8)=qR{\0.pAfР\0t\r";break;case"id":$e="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n%D2ÄL7ADt&[\nDqegQBe\$i63yiR!s\r6Hqj<PSN|L'f1Ir\"ɼ 4N#q@p9NƓa%kIt4V-K7eLxn5b#q)53򍼈e_Kb)\0AuR`Q-\nmipCxmˣX享З@7Xp^#r&jj{p֢8@H1i+1B9C4ѓ^c2\0xƍxC@:t㼴'Q4EC8^p\"xDl&4x|\n\rҍBP? 9C#\n4:1(Qs?\"(C(N:BN7;(J2#q%`5\"V:\rk}k	xWH(26\"6*?\r\0P;ηK\"{*8Qh%H ^5%:2h*L|S 6>8A6bPopbh5\nF:и:c\r<غضmx\nNjXkx[\$pqzX\"%@PhI\"\"\\ٛQiC<OI93\r(߮˘@iiۦ2\rˢ35\rp;TS/N2 3Vkn-^2ӀU:N\r0IIdX7\"i>\0007\$meNaJ.Y:D*5)Y9%1,N9I#E[Q'J+K.|R]0cp^2N욁,&T3\$ITEm\$%'!|J2hJ4rJI(4[K\$ę~p5x\rm\r\$Pmd@\$BDãnC%@Pc\r!놂ӫ6\$!rp\\WnˉU- a\"@PJ.z%bQb@@P,HLA?%@D؃r\"pܚXm\rv5Ė\$XNCbؑn\n9!*H!F|DH\r\0pCD)\\G\\7pRRYihXi6!<2AԄk\0u\r(`WR-yfML  =d8`ɻm-d<bb%:<,P( r>%8jQB+nb'0Ñ<Y 9׊BHxG)1-ᬣ0-8PN\rڮ'DT&(ԠƄ`\"kgȈ#5G\"	#5:̵G'T'@BD!P\" E	\0mrU\$6Hu]ƿ%S#Gz{`29'&T)3xZsjO6T;R}B[PX\$x7\nRaMH(GjZVmQ܊!(0Bx蹠0QJv^yH ɸ{qPAJ(pcaqBм&fCR=naxT=&|0x̹ \$IGa%*yKmoFd!`ǈo!C!쉃܀fG1V	^	0{4eM\rB.}T\n!AEi7`xʋь>-B.iiYľ[ ؒ^94/^p-I1x4e^<g-U&:lЕ	Ph AOy#G\n\$d1(bN-xABDx!OiR,6Piq3So}@ޠzSHҜлCN!jLYAӶagotKyTs׹\\7CdI\$oa4.0DAIj]Ր̑&Y+(W.O@N8zGX+DbB:G%[Jf[0_en~-Z]wuK=w׉=c|p`*19|hQѪHیpcs@ +/{/NVˉA͎4ԽK&0N'q00zbM	Ǯ>5;盛j ПJ_|pZŹTZ<`K%Ś!BhO3uwt{ir\"olB#@gKx\"\nD`X1\0RBK(`,ԣ&CL1m\"E.FfPJm\0F2E1^6\0`\"ˈ@\$xV#Ѧ:4#?,jnX#\0N+@{	S\0	0z0Lt7Ц%E		L|c/\$\rP4*%Bq@A\r.̾,/.\0ChTfTcbphB^\$@B~R&-3\rB.PjG\rbNʨYE7b\rfGDʴ2\nZ-;D#E	L&#@QHxep7f\$B`C2,*61؀:*RH'TD	U-bt=c'BH.!CApY#M®dpG#bie>\$PN\$ON&0-#d%TR'	D윑	_N^G\$e:촵\"HGd\$ K+&3<,3%8;,F#*K|_R\$Ò='P@A@Eq&]q4.olV@";break;case"it":$e="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AECI7!li((\n:Q\$c9fq	\"1s0Co&5:bb14߆,&DiG3R>i3dx_!'iH@p҈&|C)yNȃ2bclD8&uLrs<Ix(l̙\nC9.NBD:7z2KsJ;4֦Bf9kB\nԇ;Xh7H9&Qjk&ࣈX80cV++p:9`@%#B3:x3sAs 3 _(I|e@Ɍ̂eHx!L+0=IQb4	J9-C3P-\nR):\"B@tX @1*h^\n\rb:+jn!k[&V}n+,̂4ViBY3[t57B!bֹKh*?@S!ȜnGP֌@LeyDHjhR3K;hF\"\")\"`0MCTSQN|ITUH ǅB\"MfpÜTF-z\nCzW'Т	#l93/깲c#c\"@SΌ~\r+3OHù@C)4=Zr./;|s<;Ź<?o\n7¹r]Bc</{\$<0!?]\02#/L=Ô\$=6\\:H\n/I0NL\\Tc+ywc!-b<=}\rX\\#qyy'772i4Hhe)DwuH쭛`*G\nkE+@\\DX	j%ԾSeL4Jp!CGS>N8\$j2ME0`yO,`1(7I]T slin&ę2hMOrxe͆𞚈p#&	8'v݋hvF|2>M+^7I&UdG\nI44iŹ#a^@\n A(de?09B\"{s:H<Q|;e\".y-I5\$͑30( \n (@\0T+[\"&LHK}%6[̆C֥iRR)r'0Q5E\"^FΌS&;8cBNk9G2#&hyD, Y) ?%icф)S&o	L04<+ф(UȈ8?\r\rO<SL骭9]3 pVXAF?DGƒ0A<)JYJe}\$9P*q*mxqBA\\73F\0Ld0&OH4BSJWq-q1\0\0U\n @x &[ljd\rYj@쏃)Lۀ)a|ʐj-` +<iM+t7gdE%\$H֯>dR䑤\n[&NfH4˃Z~SQ\"XLi;7q[Y-yF[q0g?XH7^zĂ\"@o	dŧDX(u\nDFaeLu1P4,X*\\!\$8 AM;y5`Юj\r7N+OAMWa&c05rmBAa 䜲RsAZlY\"ޡkR\\x KȆw1YFDA𖕵%,VMc2'el͝6aN>lQltYS*&XwwYY&oymRV[oU08	`Tװa\n!4*譣\n9W;'X\"8r\\D3X>dLk]{GCd~olD|Lt5>_'u	rڣ>Dl\nc@+sڷQ	ˆ2[Q̺!/C\$ ].Cbwb5BXf\r4l:c%+ܶ;#o?1ח9?3z^GY!f8!d\"Z:-s#Wvl#kw3ppǵ>^Z\\w?]Sf<S+gKAz0\\ T1hi.Vi49\r	rCYô=B&B0c#̺!I\"h\\\n*,&/&Ge\rLY1CM	R%Tt<ĆåkeXji{.i%Ojl!b	fVFnƐ	]*bkF{hϠ.:OGorn#\"RWlDS&HȾbvB##΍\rhF&e~D\\+Kq:pK`>OkJ=Âg,È8.n2-\0pq~'\n:EI*ӇMgl_kPB=1q@&fC-zFed4Ez.Nr߅}܃KNeY\" 3\"24f,ʢ.*4,4#GXhZg(c^Ғ\"{/\"P\r\"Lnc\rVcY)%81##PJ Z\r'%f~jI`ah\00R\"@4&ĉ(쑔@O*?\r&mT9)\"e/ J\0O ZnF#!V\"2Ҭ\"eZ@`	@#Nė10#0112x+/2N &Q3\nE3s(CGE3)gΙH\"^52N\$\"IEnNa&H+:@.D	a5Ƙo`bE0i¸1<3,pںZA&rlEbb|̣P\n	,ETD)9V8";break;case"ja":$e="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp9 b:W&K<^\n2&(z>\n\$g#)eu@xn胐 Qt\"ʊ\\q4\nqCi\"VηT:Shiz1~BAXMWe[WPqI9kG2YaA\"ʅK2zė:\0T9S3P41y_yA	A\$#L+DOHU1z_QiL	T+DR\$MA_*cƆ'9PW%b'y<k'KrjHI^ӑ+0IEOzriy`\\B95(<OI h7@d:SbB1B9\$	qMqK\$-^r_CB?@420z\r8a^h\\0Ѵ}\"\rp^82ØjxDARY`|Q~S9-J<\\tjM\"iVAQ%a	{tzV!4siLr\$PD\r!pc(JADZtJIy.Q`g)51EF'I,Qĩ`9D5BiچQ@vs}^2F%r/D\\T0)J87M+WQπP(OOHd0լ!Ps9^3%6-/8)Iwc{4!=\$T7\$bC<qzQcηu'g9jMt^ļs\"Zd&W׷!B4z1+w+1\n?G@J#Sezs\\@|\">X,FZ|Y!\"\0@ak¤1zfT^\n 2`\"M{4qB(H a2\",m4!J9.=Vw\\Q|=3 	oAqBES3A:%ZB{cEa!aE)f'FKQmM1b[R7͂H1Nԃ%a/FaLu!NB(rgH(ȆXbRM(J5+F@0ȁBݩ3-h(Vr<X+\rbuhwYF]Ed\r0@:'|<`4	2jƍ	0H7 1-%̈.9\\\$1>(0S6\"\rJCR#(2P-ISe`U2YK1g-	t֪[+`<Ez\\pji\n((,ki	2\nZx\"s\nVIwDdb~HB9W	rd7xAKxIµPBťt\0UYDiQ_C;\0øz/Lh(6ϓI,뭯+@\"pv	\"y#zU\nV)F\0,G(MqBmg8GUX\r'DגB)I	Je-V9Heh	=Ar)G\r	ݾB0r>9DO\"WmcowNF))JW6LBG)@\$:D'[q/%ܫ/{EQ0&DЧ 3P\0[J\r*,Q?	+'K/Y5&4h)JxBQ@-%g*0DDN53_V엊lO\naQP/)'	%`a?EŋE	\". :VzY\"*XɞGM<o,!*-MXzi3K+*)heH,m5J0)n5Fr('@BD!P\"͜(LQ`(\"f[y/-ъ!&of1-t\rզ[j!0TP\nN~'.\nzHincxgߩ۾K3:\\)9vmG 	KScDE@υ'i,3)W1~'-r'\nOރ02+M1ND+Etx9o|tTl<jm\\΋|WV!	al5.KK\"Nyze\$Ogϻ'hHch8Aekka;alF\na \"0{ȟxruܣP(cxФCM>e!<6.~U\"ف^6mJ.Ǣ>ݴ Ap_+UbVej⩜^B<<H,8dRA\0@:HL0c\n+ FRj\"crg+ZCe`LCi#\n:aBtgJ:qf⠅\"GsD4focʃ:*NƢDL{IB!ZllÉz!~tGHt(ldpl9#.&0Fr!p>/c=ɠ\0b-F8cã2)_a1D\$_b_6coOl\\<N&\"-Ɔh~TSϨd1d7!rq<Nyꑲ!mhV\$ެK/EJ4cbۨ(J0\$ :)2In6wQH\"L\$h\$,,2'k2E.4u9fX!\"¶ycNyar\$*E&qk&nb	*-ae*U)mRQ+R੎D#DF^!(U oIff%<R}##-0f(_J:Dߋ*°b.2e*|%`&o/(R\0x/r&s]Q\"d,3nfN<7#**sm%QK9G8go}q{7߳)F\"*Sa\0t9b/\n@}>\$uxKRn;Hy?s&&}?G<2R8s,w;xi\nh!1BA%CBd/CI/~n/8@%wEOJ9+fYF\0GOEoDCfT]SIO5FpI\$ScJKPt,}4f;Ә\$r'E@KMҷIROLr	,@r'N^>qa7cK0(;=ԙ4e+	.(R\\^V=u*Q;cGH\rW1OED\\0<8&\"`\np)3A0LށC+~t_\"kPq@\"]I\n;hOWՀU2}DhFx	.dcB9a~h%c=jtajL}+(*[3M\ng;\"g,PdIc6[Qt},di\"em+%V247_kqhg3iZ\"I\n@kl*>ggt\0 \rfg-ƺ?;b@1/c@F%\"SMd6FOdGeO#\nCTgza \"#nn\0";break;case"ka":$e="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fT+U	]MJH^x894\${]&?M3s2Ԏuiz3`̞*Z%\"xܢoJitҵTA=D+I? y12EQ~\rux.ue}2T?rNSzhĬ	ZԸH:\0'i.o.ķIă[2Hָ3Ђ\0[W-o:\rp\$H<C'or.+(dɒ.׽\\3)VD+댙9;jȬ:Vץ3Zj=9>Zؕ	<SFDh,;&:O*Obs4Z*\n~\"fA546#p90'M[k.5r#,*@U6!\0x0C:3:xq\rgZp9x7>9XJ|(NPx?{W+JN᧨԰/m[HԓX<-%tH+cl9%>-[@(NnN%>#5e6;խNdL*Rث%-į6ENOͭK	^Ʃ04'ARޚE^kcg{M%ˌ:u99ԆUlIZdMznKJQMAL/'95鋵F*b\\=	iG@wP)4{9GIB]{[x}bΜJEg]#<Gӡ2,ԹYN?P=x\"IFa,h}) \r9EWѝ9@aaA0Ɋ_A7C<4 @Mo߫Tre*/`uЮ´Zo&׵')UR9X\0\\heA%.#\0@\$jhlɕƺ(^/FӃQ)ʡ;c'Rk{2d՝VZoCW1+ޱVܣcTJ!#V8VH̕	ոȩM\$D%*\$TFLL\$\nsep\\f2n8nNjru8E+Mju\\+;YʺWZ]2DPLE_|˹(tHDÎjj~{?UMz2	ČeQ<0+E9wW9jDI'	.|	2+.)DHk&yH;kU\\r.ei9R]2Ý^9H1OKVS4T4H!BZ0%ic|) P(N=4y5H*bz3bheXK}vek\\㎯\n.\n*h|\ndS3ۅibX\nM\"YjcGAR!4kT%xᶷ-HvK_Y'͞0Da/D&=ޜZtcT1'Ɛ3g\nX aL)gDib_7[zk,\r;ҴbSN@4&<pAA%v9*maGRM`kGҾD|(0t(T!+H[Qj9;<6CFt+*F;=Ubj+\0ʛP	L*Y%\"	4h:QA\nɼ\"֊R:,n ZSK8m0ecE)Oʾkz],SIa87[@bN8x8؍k/[:YǉU8dLɷ9S|ʺJ&URp{{z]컗E+718b-FF)&3aHMA8&@0LJVY^:w1_\\8p<>&LJ&jE0uH9kMF1D(˨EiK«=Ss;F^>ɛ`*p\"8L\r2gV9Z@o˒9&Q4:\r\0=D#d7nC)7duWpmW>:KJJmn&!mC5Pghy5h9:;	]fk/p@@vCBnJ_+ʘjXM'&MnXOgdOǒV1JHT \n`ye.;,Uk͚BzhBWCg@	Pb1\"SzvV#.	䣒hp(f`0l	܄0Jδ,Ԣ~LB)	\0HhtKʺ>mTPPqH-M60,h	FHfL24+BvPfQ\rԓ+hyG,1l.bll(xمuIDm]m12ědC¨5+bٰ&nh:juNJUc^lN:cpiFҕ'\"3:BԌ\"lꍿ#R84nlN.r԰t/MD4On \0Ȉ\0\r\n^QKH\r\n.nA^8'HhO+HFXBBI+p1+1.ӱW.'b,-Nl1RZnd*I5öIjB-\r2q238#12ʿe,L\rp>4\$\$#nr+M52\nL@l\$b\"#k7R`49͹9#5,݂؛EJ@&p&G14S%sR)gwd%6LQP0Rh*34rf۳,B4oJ-1tKB\"\"4-R'LsK-q4ZR(F0,-,lN4^%\$pTnpsHmK438C5k/J'O7cPgǡK.J|OJQ/%E3('{/VD4@iTN(5MeQFt{C1BnHU\$MRP3ooC0z4Q2RcH?D%Ub)1Z?\0/>*&5SU`UUnEoVX5v]@c'U+MFZt\rZ4I[Q%U8<RJP-\"eI4+	iRJXTWQ+y3_\$_v O4`tS4UԱBa3&/tHsIIM.!\rJSa2P\"\$,tT`qrHICHs;\r;K&RsLb9@\np4VRNj0ZP8D:p879c\\Qf5NpPDUfuo#meI\rhjhy0pHiC<oo&cQV*%v@1 rwpXhG\"c~'yˣ+¼SP`WlRNr?6Uw{cHh7R!=j>b輳776NƦ7DV1HGDH/<vt~ȱ9V]ǠjF5qvy~XZ&VhsCĮ~g5ol~%<Iif1zTD+pv>eVlP0*|3A.Rvn@>_`UNlبc苅S`pr N#P";break;case"ko":$e="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4(s2Cs;jGjYJӑiRAU\"K`I7FS\rzsaV/|XTSɇZvHS^+v&kCi=#qA/iHXElKȤ;Fv(=v!ȉVWj)qss])Kq{fv!松i<Ro@Y.H (u3 P0H3kN.\$zKXvEJ7\rcp;9\rVuNXk򊑔0JDB\"ő	DJH:e4u\$!\$AL5ѣ睱r/zNa0@EFP'a8^L:*uLc\\ l, ޷Pc8F481kx\0@#11(@;#7p@81`@RC3:x_?Qp_TuUXI|64,3F#m24px!g˒J^ !@vdꚹCKRSlFPi\"/m{b@\0fZ'IYX*6VLSI޸kPA(h\$C+FuS\0(0e;#`2w]ڄA؏%9\"A3TT\"JeXCj\nu=&db@L\n.P]66SØ0А&@R&P;sɑEG^iRe9,ys2mrJO(^ezo,Qi/gi\0sdY.̽eLbA6X?@bx'ݒ|\rC:[RÐ06#|!ۣ0he~ǂ,cXD\r!ͽƌQpn>0Rkt*Yq/hA'r\"0tJj>e,9;DR(tM0xo|\0<\0JRA\0:j:(C8a>D,C((`tH!XAj]M!4Ī#\0Ø [)@@n-*1\nɝ+UnUڽW`9CY AA P\"ҕmxj!8网(ة9T˙r#1<\"׉y&2ZbL~\0b .UYepX\nD\\Bʂf(JHm\r6\0,TAHZP9-DĨu Dh*x0>@Ч|[|4sՏ3@uK6*7QjTE=ABGhHzJ@PP	@T\n	)8Rrg%  xTIE9N\\J4VQPޣ2+f͙>\$&nLҵ\njHdZn\nSW4h\r!4F`έ(y`a4d!0І]b'/l=ׄ^fP\$`@T\"hMR#x.rA_PCHìELEʙfHd}~P7OE LXqhoA#\0!1sꨯ(;K qJa\"\\4ɹ9'wtH~x(A;*[w_	rEM\$KɰF\nC[^N@2ˮ/E?/,(\r~J\\Dȸb9`;)mĨiM<מ\\Q9'&1NŁ`M,=\n\n*C51:#;6.\"q)R]o=ҕll<0:o;\\L;rǩ|K]pїvP+8uj<mC:y҅B!0\\D]q(>UJT)L~]9'B*-׵<;(n\nZ:f ⧺}S.h86Hp&^gu4à\n>݃=G´1~I6)'@x+	sFj̈́itr\03mgZ\rd hBs&jLvZU\ryA&zӊsNwq-= V*KopC	\0wL]*-F2/ӥm/b:x @V;=fl?])=&	.\"n';{pBVǽa7ٓl]^v%XvGyb1BLH7&\rtY#sKFaH'\\\"f@s0_ElD2Cfk\"A?i D4Co9b(Bb.E'p8#8pB7Np6Ci7hCB:Nr:!F,o_\$H6\\^V5 FpF\01(Gt;if6M rMdbT \r\r\r\nFxMHBmrmŭsU	-dr\riG	vd!z4q(q̛Ƿ	\r|9*GZGJqS\0vrwhJzB48{A,ͱ vԱt_d߈QJbgT5p\$&\0\"\")!:&`\"\\<2GGd@*J1a*kpS\"jVF:vB)j+LDdfXѦ&a-o-wR;\$OѬFanaRX?\$B21%g_da{Rh^A<7B&\rrd ?\"4cqޖsR/g%pwR(1&+R.30#f̒0C=i2f.L\n\$d i&1RP0-ɲ1)h)\r123\"&|PI0dmo,D56NG\r-a6725Sg&R/C1	'\n&IF5s`7SI&_6o:9W(x1>q,Gh<@3\r#HrLp7l H\rv )0xz5kB\nt@@r>Z7!Q@l`\nFRhE<ȟȚT\"VJST\np)./xly\"#kz]-9\n<)(Ah`c7c{#m\n#)sR:0&&\$I)Fs!s͕h)\"PNj:k&<!dÁfoG K!\n5\"I7ԢMA\\/T-J49UQ%;C\n(=2Z\r\"tnsN:\r&5{'Vvdjo^Ig[SO̢NF8adCS.\"f\nPrۡfq,@@j3Ta4Ç.kElf1	aUbG'`\rLHkok8ƫ";break;case"lt":$e="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 t7\rLU+	4Y2?M3te>\"K\$s5Ms:o9LtuY),#)gALEuy&C\\MQp7Cj|eVS{/^4L+R:I'S=fPkʼLnx\nO4DXi:zE?FĲC\n錎*[r;\09LB:)#*Hc&*10)_\rz\n\"(ck*\nJDm+N7i1i\"\n k	{7#D0c0aX9x@;Cg-ȉ; X`жD49Ax^;Ёp&\\{*#8h\rBBHpx!: \0񌑋+\nQkU#Vbc<\n,2țW|2?Bs¿⺬71:\n\n'@Mo#/8q[?j83*HBX2ʳ ԶCL*0:BJ:UQU4B35r8%kϊHʿz9\r5Ekԑå9\rp0ʐH*9@V\$6\r[c7?bc\\N\n*O;/tb[{jkazċiD4\nuJ;mth0ĺQq޲XՋ2W\n)|cH6*\"<ʽXD!Z \0ړӭ.C#P<u*;aPVJ2!):\"&c)b2ܑT+&!4B&>,3YJ5l<5+8em\n#b(ɍ*7`^By\$<7R_ ɆӚ|LN\r2\nHJWAC^<3!Ĉ!.GBANNALHM97C\"PN<'PC(xb\rA>il.p(<P9x\$@8h|};`J<䀔Kugd\$[N/'TPN4%|K8ety=DԷN\$\"E+/\0wGeԄrRQ^dX1+DC\r18ޙIE_DdCf2yB%Ib[Q `e\0Wj ̄5*CT~kܺ\0\$UlPPM!\nxḞMhp+7uSH\rLgۖH\$ξ(MMBRН@8/ڤL\$1db.ظ4NH2F+O%!E%lW=Dt+Nݑ \$D)[\r0^gdB#^Ki.H0ldXJdYprIAm,0t*bfJQ26ꝨM#g	L*W6lueVˌ,igdAޠTem 9RkS chr8mC%bKR\"d>@E%ykHyEBb<\0a<~aƇV^cLa5cmY6c	#-P\"P5!8eDϱ?AA	\"(EEvchD+CA#\rM/綕^toGGYSXm5r-MkuH7c&<%\n+/A\nTp\"; C\rP8Ԍ(}FiUQp	C(\r!醼w9\rᔚw1XB`oPvCAZim2502?8azՋvtC܌LkEB\"1yQ(	-DrPV6&+Z?A\r2CFkZ5[t+سK<31<(FSϽJr~)fhAa Z>]J̐8:*Z1j0Qj!q%ADg^,[UjH9Zal m\\HU]j\n4EvWAwimcοQ(&ga@L^t:fR_Q}.ߍDG^8L+!PIQ\"Z_c\"C\0+z,FtAcҷEYp^:		<\\ı<IZD3K1sKvtزL62I6e#XA.(\0/\0LTĆfb/Mh@/kj\$e2od*-\0><EgbJ|esPO7Beh8,0MgcNm\rf ^͸xL\rk^D~mJ 6%`M>ˎ'H;ˡ\rG<0!/\r·n;L\0G W/,+\$cޤ\09BUb!/HOqUG1\\pnRM'\"ehC[ɜ\"@+ޅ&i>\"``A\"-~,d\$'WBGL^Q1XFm,fi_/S e\$͌aM?G.!\"c˱a#!\\sOL\"Q!JsPG%\$G\0@ 4rHf;C,1-,\$\0\";(%\$Pm\"&c)UjdqW/%RA=rtĉ+.WC̱0s	߀j/2Ye;-6'v\"y/\n4/`0Pi*r0C29 S(u!p|Ҩ*BrQ,3A3RP	14D*(D\0Zʱ(*E53#\r CB1@reVD\\cvί'e,Ӡ0Σ:lHfU#*:R;;L#T&T\\idj\0	ӯ<\$}#|[!1`Χ?;/%R\rV.BŒ\$ʦD[8:?nf@\np{H\0#8e\",(Ϋ@\$}7tZ5KEB)\0\"6^XutB`⠤\"}<A@13Ĝ<;I-x021A+I72D*Y\0\rt%4%\0[\$p\$N\nR,FzRa\ntp@O*(+PG\rL\"b5H5(,@zĦ6<R\rRg\rBCFmQL;œ cBd,\0KpD#j@o/ P&%\n\rQZ*ۀU\$O⎂1eD~kQ5'zJtpeb@UPHT&aМ\"1LP6ͥb	#";break;case"lv":$e="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(:T|i8AEh2q1M~\n\$g#)e\$:bq[8zLL4r4wa:LP\\@n0=))L\\逆X,Pm@n2e6Sm'2	i ǛfS0ƁM3{q[ܾH=q#\n2\rc7;0\0P֒c~\rx02M!Y^\\&jr.;\"L ʰcR\n(#6SP5ȒEP:i#|\"	ܵ# ڽ\${\n:C%΂PXpD49Ax^;΁p'J\\όx79J|;#5#pϦ\n\"z:x%\"Hh1\$SƨU0p:cCYBj8ۺ:`WԁBP'):dBCNb86Ŵ4*Pe@P X6{!\r\"5h	x֏mTUʶ\rIS,T\rt\r! ·bUʙS@H2C[ہz	kÎܯ72ip ,<j:l^=G\"&.h90{+~9\\uz3UG3`ub4D%ÞI\r;R̮ZWʱm\"#X\$H5H-R{\0006\"\\I02:m`r>24SԎO\\ZNLEc}\$4hM\"ĥ\"\"pGs>Oz<g1NpCV\"Bot\"z!CMrbC-ދA:%Hq#)t=5ƸC)I\$\\-VxG2\"\n9B\$m\0M\"᜽EB[)<7\"bL|!\n|4gB_R%30	8X|/poCHlt9,^\$D#4k	ʅ0//Q]\$dU\"d?!4*4\r1!\\NAa\rA\$hI-T:%jg5ޜSuN]='!,D&\"+D4G	u0̓\\\rjB\$R] Ha\"a56t7'vO*V\$|AZ(KG觉9&a/EJJ4M|Ē\"Iq^˲fBUe\ng\rxsTm=jbRHfgP-ȺD\$4g( KL|E @P5ji\r~xe`OH@R&\"hw4NT́5}eRA!CDrBMDJQ6zqbgpiLh*0G3(HC\naH#}@4_B&ial>aHiD(LI&@Hy\$\rtb񴌔8KWa\$ڭیs6K'gɗEpX؈P	\r&(2}0sLp\rK3DOV|C]e_֭C3<FӺŭE	##䄑RN~&0JF 0s\rE\nؚf\n!b3\"Je.okؔ\0002[r#zÃPVv˫%F,d3G_#AxhߐzcIsdo\r27tzD\"KБv4Q-N:FƎYj\nJ*XV	%%<R*U>Ƭpg]~yLc\"QB/Ti#~zw7ȄD\nK᫨\nR	7cPvqB4FhFm0!鵄Uz!d\$ XNܜ6oe:ԋ;r{1a\rA|5@k?h`h84qa\rm/QjPcQ,\0Aa\"la[µU<RNyR[	#7v\n/-/H,HAkKEP\\tu]5t<m-Pi-2,[6I)[Jgϯvy&׹^{TɗE+\0Q.=hda9Bv40٪,WH1#\nC\n\"rrv-b.#Zc~7#vlV?~ iT/0P\"N\r'`joP\n%\0*&%.%QXӢDBE}Z:bM\0_d`L4kG\0B/Bb(Wn~`^K`l\0fp.blT.&B]b\n Nv\rx<\rFtVfzpng9xtK␍#X}m1<z]O{	TpaA=NڱmHpVjC8q0\"\r11HJ+sQ?1EEG:&F-q/o\rȎ?^tpb%%θT2Jȋ2#*\"\$\r06c`k*:#j#.fȱrAoFBTmNd8\$:X\rќmG!hd'!)QV%X&m\"P'\0@!,RJ'25#%\nr>aQ'&2K!E\0,5q'g>lVpK\"pX`pn#NlR(%lq b)zXlJ)u)i#r+ӒjrpHf*\"@NFJ#KU\$l\07BS.\rC,I0R\"=m 1sW/Z\n^#33lSC3X^g5&l%ΥrHd*dc(|\\%KY5r(<	V-HBHB3#6@2H\";MH&hFB\"#P\rچM\0N,L %Ec5?qy7*%`Pp\0;@\0V.b&2Bkt%BX\0\nplT9Jrx#\rf[.%\04V33bs47EE42\$@M7,\"\n07@FHi(< OJ(U\r,U\$vt&\$r\\HDNq>Q΀2Y\0Hh?;Nʖ\rsGbSu\r>IFHndQQBZ}ք\"cEǧLLC3FP#\"fz00*v^eU\0^BF&0pS\nJ6Q:.e_\0\$΀@/#SLlyOtUONl@å_'Gd┩6";break;case"ms":$e="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7AD 8Ls0A7Nl~\n\$g#->9`\\64Ԭ\r pa(bAS\\݌Z*fjSi*4\rfZe;fSsW,[\rfv\$d8NJpƹiɺa6Ӯ`&s=2#*L=<Cm(5x=c99X\n*v3s,)bȳ	hK C&۬7#8Eqk6q*2\r#֗\r*O(8AhP1qH&t<k4@:X9X 4.0z\r8a^\\G#sAc8^.C ^' *(7x#\"4C:	l[z92\"ɧU*xӮ%\r\n⥈(J25{_P7/¸⠶;nωi2	\nDl!K3B,\"K>!Z^%cZڲVx3Bqc%ԑ\$/,\nb;I<,/UC<JE5Rz9iH9k)KZY\0ڤtϊRÈ_rãhܮ\rl9ˈbuH!C'څLT*Qɵm4&죘|!0Ҳ.p|9N~1\r	+F2PܒQͰ70[vt#CH#V,ňZHՍδ0NbBHEH*=q\0^iRCۑeZHs1n\"͊r#!aN}6q\rm^lT\"B-ǁ!ƀ8AG9&m77aސ eLɡ5&ܜt9'y	\r*=AbdY!oG5N!5-a(RqhdraLi3֛SzqdSnOnD9H!y=l7<3TJgxa95*u\$,DQC1~uul\"d=%!\"RBJԉXqSJ*pvsi:d7-)\n (A?\$GH)\n1\"%()SvԹx\"\rg Lys*SzI_vA\$I!3KIq/JC=G!4	*C	: @RӌXsᄁ1 ~Q)'a5dMYՔIUw\n0LI @y[!@CeE2Y'TRMZN4'TvXUhDC()rxS@C<hMY1	<\"iY}3CLjkcYM[6!*KDs&'Aؖ&Je\$%pA;('@BD!P\"KL(Ll!sd	=~̸P`L;D\r'(S]cFPzQy\$Eg\nD:O\$0E2L\rK\\vm\\oj2*<[{_.!'c:oIO.)=\$]CC)\"	aHe`\0\"+j68K1\\|g|8e&T]JUNFsKVy6&8tFqU%B@W2\n?0FON&e 잼mYNg*5٣b] C2BeN{\r`*\$oH(TCZTjP8\0H\nLĆQ<IHU!9bXFB!G@V`Wl'@V՚^N3Ɂa2XCPe2R-Djkkh;1&!fM)0nwċx6/d(XjK\ni?С&az>?'BJ#NZUNp8֡Ko0Ig=YHׇbprQo{2e,f&&?->KxӘ*_pD9=32YƤˏUF)ʜ2}TgZ6䱥{Ma[^ˁiuWJde6tA#;as<;~E4=l5Czo鷼Q/g=<z9Z\r5|{}o|~;hY/o%%RgTۂPyslR80ji[{ef_,\n`=G:'{%)b6<Btlhjxm'Y.8ϔ\r.ɧ:UNni\"N>&O6yf\\eIԤ1R?'`_Pc1J\$|jvBD|!)Ao0c.b2I6W#L\rl_pH\"u,pYm\nMV\\J+bADb2@ϐ~\n'I+\"0\0M\0v\$v1\$\\υX42ѭpG\rQX/3\rt@N4@T5dp-Lu<ƥ\ri*(	i<3J ƌJ\$B=	d(Nni*-D\rVcO8v6-ҎNCniD|8@\np#-0.rlJَSq>(EMnNE猂WNKEbpQ|\$ITMgãN&Xv.Nw9r*p\r6Nh8,9*D`Gn:%ةj|cTjhk¸@e6%rF/\0@,H ,R,->)r'B+!12&\nRҠ<봿[c#gx@0RҢ|J#jT";break;case"nl":$e="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7ADs)u4̧)іDf4Xj\\2y8DEs->8 4_F[Q~\n\$g#))UYv?!hv,c4mF\$r47e5čʰ*wEI}Na#fuVlnSoгi@t\r2a1hl -湓6FG5!uYq|P+-c1\"̴7H:\$0:(r&<\nk[95zҵcsp:2PcB\n,6!!R9z2\rX*DB:\n^Η*\$81C(eF X\0E t\$2hܵ8a{9qnJ(} =,99|FƍA-z=F:DT;ûVN\0ҍFW\06B#eBXޏb2B 9{\r\0ܖH\r@3ĉļ05ؑBZҥGyȫhI{\r8֊m=H#2>ʼM΍Gzn )\"d8πa\0>̿Vur\nm\00=5.rmC~C P2\0kuZD((629`Sf3\"@P|(WMs:UveC1M\$[Cr38|(k(mἳϴ-@2	y4⟁y\0.\n	tC!#J܂[`8Ȕ7SV2Hw/nC\ns۸;+UssX\"O~^W?tVC O,Sc>@{I^+`.(`څ0s?'h3\$HIB\r288 )1'&U:M4'xOA>BrPj2BfJ(UV=D4;*F`e~'mI:!ISNF\"/i7T9O)>rt~\$Hgd\$yH4t~b5܏%Mhq{4\0x e:Ҧ+GR%E\$%\rsv\rMdD03b)mxHq&24@@Ptr\r㺂\$J`]PRIP r^T]:[\r!4CT_QFҜ.\"'y\"Xy7ygEe2J\\*	\\9,PI*n1PI k%<4FjHjA\0C\naH#\"''i\\^aCLJ	Q,f,LrlcJ%J.CaR͍Pb?t+OǼ\"BXnMdwMxg\rP	L*ԼEb@'dOmv|F,:nzT9UԷ\$J/qƥVpA\0k;^œ@`-먎A/@ RqJ[mL\0PF4ԓRԈ\0T/6q`P*[ E	t#\n02z]#b`',AB?e:pxm6e<Yn z넑JT-A&F>L7ԊE츆ɡW\0A['t:8-nQiaƥpR3>c\$/Ɇ\0G!s-n:r\ngb쓪KCLpV2|l@n0&:BRxI\"@C2ODB^kQ6'Us(yn8l	Ɍ&dmivj9-6N{We\0Z#d6(ҧ4SD.aP*Z-n^T!l#IPܔ.TA,^7)8k7uZtKQ7hjf?ZќE5㇡C3if\\@&gn-50|z}ٴw  -=ѼQ-MH_\$je)UcÒ'&ԋimg80徟\njU2y\"PA`,&#\$I(IX\rU{p¹wپy7l@FtFu>q۞a[lW/2}ljb!UwT]`_GIcLY^R!04{_f7۷~SJA{y{[5F8%fTh\$j~;I lItLۯN1\0|рZtj^ּ[J);D0`ؙC`#i\\GFI/Į.-j&^Dc)ɭLcc\0KG-6\"ȦT*JZE?8\0VX0ί\r\nlopCkg\$۰J#\n0֤pТ*\rQ]&^11LZk\rXϺį#o\r\"JQ#\n^?%gxD81QBG99i\0C`Z:j 4.JRe۠r1llC&14ۮT@ԣt\nP&X#\r3\r[A1PAQIB_%E-BnA͑-15t0\$p\nMx0F~y_圁J(e\"or,鏪2j*@K8b[2#X(r\\\$yk-&Ntc2).:7#j	T/\nq^A3d?bJ\ra^lҽ',Jj!*!<n:&nivRb1'Bׂ \r`NJ:|#bgƁ+L|M&Nr)2*,jJx/v;lcB&4!\$Jh&ɳ[\r-b=422kpbe6\r638#T`b-HgC5s}΢\n_&\"n\\i*F0ЯV<8fReXDk:!\$gy妠zED(͵	 7'7ϩ~bl&3r&b\nZ@)J`\$X4l P#\$D\$`";break;case"no":$e="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8G#<t<'\0,uCkQ\$cġsn,p&=&%GHi3&m'0te2b,e3,	hG#	*\n\"Z\rRs3\r,o&wÜg ahf\$A29:ta3\\TϾͳ3}u8h韡B>\n)%˂kW?Sq7p90<kp;\rP6#\":o#¢pաCs6< jx޿8:30cn/\0ðlH4\r~`@HBf3Еt490!|9r4I|6Z30ZP7^0謚:\$\n2+#2LO!c2P<(+#ܽ(J25s]09 P60Cz5vdT0:8ŎM6P\$#U͌6Zm&;0͸٦,srY\"!2L	\r`6V562cX\n\"`Z5Dj8#\".FtAS5C+V	agfibS2J)JQ\rphܛS(#hS:P!R0	\"'-3aMMd#F#!M|73\"q~kz(jM9rKf=\$:7κQ\rm҂:j6/fL+pΰVak	26(9A)XYUDw c5EN-7Uc0u}7JC(P9(:|3Cʖa0haB0M-7FM19K/-âeL5֤CsN	(pܟ\$Cц&YJAAV\rQZ\r\0jwC*8jaK]2&dКlF0}9'HN\"Q	?5Ζi8qG\riÕ\0pL1<9\"tcИNvwGȮ#P٤`	a)W\$.>@Ufkd:q5'y*i.af\r	JJU[FHAq!P	@˸ M	\n\0NLvvdrd\$KG5~`~<2Q#VO%8Y#4PA8%\$L\r1l9@@rӈ!00o``Èz95ftM\0G\"\$!FIBe7#e7%75i/8̫rA\n\nIX2\$)PbKf*|oșfRŇ(*bЌ.\\g9	hKɉ3\nH\"v)Ssљgg5y55Kl\$)ZF¦H*ZC`f&>TR)FZ|7/S\\[b<'\0 A\n\\PB`Ek	b\"khI\n7f±\\2t:6Q\\\"9b/zi\nCa*AHIT}4Skbx9\")\0I!3&Y4l\n߻;y+jʙ:^vC9}<}bl^\"å'T*fHzY.?)xD@&JflfPCP_~2m\"@tF4hǼ%N	&cOy:ԇl!A*t0Ĥ]`I>v8Ep'55eCB;΢?E@@ \r;\"=+s[N7\$ě|r4^XYc	H3GZZF ULy;M7F\\߼H1e\$ma&4}_Y7)1,mA÷L]2<;R~b*(bk|_ǣ-1РpqRnF؃0ʝcLCh%'8ٮr&Ȝ@zd&Ifz䆀u;n1\$5B\0c\"̖<EalB|OϮǔċ2QڿRƵ4I9&ÀrXzi=8LZ,\$']yfa3De\n8Z	FN	J\\}}1@\"U@\"3ߠ:~hijh0p)n).|oтhoTT\0\0PNʇn-))8H YKHÄGv&/lꭃf6dB\rĵ;)f7Ab( pѢ<&TMctQVRPTζPC:нU kP+\05h#EP*Pel3YV%>\$_.+Ic\$[/\02ƣ@\rp\rB|CTJ*3Y,g2]] >&`24+m \rl\01.1C1f)61fC%)-. Kp>C<+qӃv1-1,qt3u\n b\nA  ;!sk4b,3%i0,a%},L\$1bOBrK XޫI^Z_N\0ݯ܀\07@`bݨ񍠎c	\"(P\npx?V;'.\$fkm'0'2l0oBe9F4(1U\"hC+;pQV7T9*CENngPC؈\0r[<I3&d24,4czH@!sDcdTR2sty5%Vb3?.rp !2<aY+tT\$6lf8kg\"E\$2YL_X>`\"pJ'\00Ƞ\"D1)7T";break;case"pl":$e="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AEC :'Ik0geň\$y;¨\rfwS)3	1iz=M0Q\nkr!c:DCyêI#,d	CA2eӘFաњd	B7N^ qR yW~Xzqu&p7v\nBBR\rh01!	`?(.ǌ ֏Mz(0P2I\0,K \"@9{;%s1784.<9##4J*7Q:Ǫc7Q(˄D^!`@%Ch3:x?4p9zEECxD˱2183P[4x(CzЏ̌D:C:K242u u^=tV	L\\*\$>5Mkvլ15r	cx:r܃xiHp V0~R#zbÌ6Z0B07\rnS (0W5P2Hbh6&-EC\rRV69x	K5jQX-K`7g<kz.\$#iCKڱ\0(P:5x^\0/TsN #\r*)įt\0ߌ.\rͬJʳbL؞*DMD7cY\$nԁB*QeY!V3d+'\0:xJCrq#Hƻ5I8R3\r1Z5z9K׃sI./WăcھBDHzؗ\"ٵ)(Rv`*#UUaAV T3b e:;K\$ 	qK#\$l:To3H&	b<5@KIԻu!d2PC\\AܰbB9hYA\$QWCŧC2qFx)M.KHa\$\"\"9/'#\$Ԟ!0*8&SyOi?%ÒQ\n(6Ki2jHdz\$%XVv#ZCۊ/<^4FSTFeMIʝxOI?(	N\$Q*,2@RaFlC5/\$^{hH؜%RXx)^b#J餤s@P	@3,G_f_-2&C`I`%5ÚCm͵3Sun\r:X41Eڂ2T%\"\nBfYl5CQl/Mh\n	)JF&~\nh/`DŘPR8%s2C+&!%RCj1/HSy6r\\Z\"f{b%uh@iё<<Y\$lS- @Rp)Ǔ/=S^\$NI&d#\$䥗IM8cH-//hs\"4Q鰋sq+KNm\rd,GyBY\n+Fcl2n6r{K,:fd4:c5^k'\$D5܄{C\"&\r<`VzCݖGbI K\\)t洔50`pPD\r\nk\"oךZBr 0's.3/D%wjEYFxt>\$C;b=U+n@uYLK-Ecv5lqT@ДB-Ah6[av́4X\r`96കPSHuk:|rFOԃ;F\$}la]!L0hCyz[2 %Fj4AFa|Ճ^۲\$3d@5=07o^DZw-2,2N\0Wk\rЦ(;c\\śV՚<zJSĿYoYcI,cۢnY2^	Ta[DDtuو\0VCM\"~T!P*%#a`SBZ!xӡ/)mdlͪ>Λ}u|4HjfFB!q\$G\n(Դc!GZ-oJi^^LWŎ/yC=5!K5vw~~\\NBD|dʇ?aTfn ̊\"B (J\0Up]ʩ\0.n%D<1\nt@'`B2rTx'&b3c	'GDIhL5=).OJV\"Z@d:U%㣴CPx#\$ցKg\n\$RV_pЎΤ0	#oPMlj`MF\0`BjyT@&&1z'\n_jCq&=G80q(jqjnkppM i]]#&w0qBU(A F7	%	ҷpqLZPѡQDg\\\$]˶rcQV 4coІQre0M Qo7,,rpr\\0r5\"R>Q@Q>|\nKe0Gldgmk\"z cB2<dM&\"6\r)\"6g'-Í&9t]\"P@xRz0g*&Dj)P222+pF'm]-6䥆qHEp\n0FGjW%Dt#,#@|8#/\"Mu4=A2)FM1X!2#d<#fd (@K6FY@rR!\rS\$;)<S%f82bpjSC2n=7>g2V\$yF8r]\r40nU;p0A'A=1=s=Bή.r[AD#0.3752L|C-=S##8PspvlN-h3sl#dPq#Ds	@q4cEԘEZ>P;&?!B\n%)5r7ÁLBҮ\"ba7kJj~\"\"V7tu1VN 9C% WR %05)\0o-EX\rV\"aPr*1*=\"z0\"n#ZϝP2x'\nq-T!\nZHЛIʑju-XOEXRʴՔ)3#XVӒ!F(X!&{=F;UGYIt9\"cSMQ(&01\r\"0:2\05Ue]JV)Q@g&}y&aYF?5P6\$i61Yb\r!\0:)=bTHvM\r?4edvp.d2/tCd,Ҋ]r{QVcJ-vP̪en\rF恮\0\\Z\nvc\n>5K8(E%8uM6+Q52Ռ7n6`:X%lE˨lmJQo)\0";break;case"pt":$e="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTiC,i؎hQi6OFTe6\"PDqe0̴m,5=.ǋo;]2yg4&6ZiC	-MCNf;7bh<&1N^p|BRY7DV\n8if)b:[NL,hlI]bo7[2XOԸI2>\$P#8\"#kR߉-ޖB<\np7\r܌I8܍\n<\"/Cq.	xFLS.h(M4#. ܿ,c{뎈 823(1\"I3RĎcJ2\0x8C@:t\$.48^?@xDɻ5#3Jx!R)(4lMҟ(9-ì^mDV cHx#ڟ#x\nN`B::\n\0<\0Mu]!`+})L72!\0Ci1\"0d,pV#^	kyKN=y\n	8h.Ë6eS\07mX'~`Cbm;ZZR<\\X؋N	ކ&MdZvZ=\$doiYY9YH.I{D](EymWTaL*9'\"x-<s+#ӓn\rA5#gQ:\\E#W)MR^rC|U:m*0Zujj\nRCj^鴲8\$>}kSWh.΃GLXoR^>( ɉ. {0sD2PpT\nÂa3RJKŸ2\nU2@9@}M̔#ι7,{(3BQ9H) ReM^NMRF>^41Lh	&т\$[fDDU鍤a,QQj5G&b+qUsqx],t	%,E}c91ŦĝK6Ҥ9D'ĺCf/:v<̒BXbd?\$p6KBA38l4C-IJ,\0P	A39XAA\$`#xyg\"g6g`qD,0shBHv&e@rHI{	SsKCn?SHaQKMVb늉*\r03ɤB@\$\npu*(Y2&ؽbdkܴ_MiAGEgKz\$0tKhL`7J3X;-uᘓ\$f/%sҧ)\n<)DY[ėH`3\nTAԹɂ/U'x>ӭ\n>c}jP82k-n9ATA\0F\nЗ.lUBem,\"*י\"_+i30P*[ E	ē_f\0GF(5`Ã# <vF&d]KdéObC\0[滑RmJeg{0O~^h\n}%DUV̊&\n\nrAJ4T3\$SРOha7 Vl2fUm(S.LYzXձP+{]7:\nΌ<&^V\\C#a;`~tfxc@P/&صX։c]\"5,[do0wŬQQ\$a3T\rd_F@t;wGJABU%MNAL4VgnIȱ]T!\$Zi\0pY4Q*4QI\n5V1\$yS]?W&l[)Lm	./f~O\nkx.]q8SGy'6wĮjA(tS<]7i+戱0ήm*As}3,I8w bS2OhD!G	\$Bfapb\$l\"/)r\n4374o([1m}[u\$sAjFڛfYχ2Aj*c;'	8p10DKdFVY_e-vɿIy]r\rJ^8 `_mhLlm'\0v4BRL-.V#\${&8AF3m@bX7hΒN>Zΰ.f,NnT}pX:͜\\lư٫	HTp^Id;NGc.Gbn6oP)h٣AI٤^p?BYp0\$p8\$\nِXoDN\0&5\nž/pRk	B/\nZBBg*ǈzf&/hYommʟ%q\"f2il^cDoG)p!L⸮&LqJ)jHk5cyzq\nqg--pcύqtc#ѹ@bFx%l\rc#l@\"!,R\"v\$/4r0:4\$`C\"4m4l#Gz\ngmc'\\(|.Q\nHB&)D.r&қz	\r\rE/\nܣ qB]\0fbl<ee,ED6X~]/.h/P.X``.&Z)^\rT .0\0^(u^hN\nZax\\RoX\n2Pu6GRk2~,).d:/o@**!ӝ3l@5hh#R	\"O .\"bfatbBlC\\<0\0PXef\",Sg/,XƉvø,Q!#c5DJ)mzLt\$N\r-,2PoFH1e;Ty^#U@hDWn\$`\"p\0oE<2g0o6b\nFN&gDcLZ5M.źģ'JM#LpFs=94L*a\0}@,i	\0d";break;case"pt-br":$e="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rAscIEGSbr4EcyUz0Dqe0̢\n<miiQb4(&!Nod?S4L<ي-L,ݒq`S 쪧(o:\r>yxs-s8kjFI{Ct6}c3ܡ\rê:8lܛɭ@ҏ;cp͸K7`P85x7#9>M06īƩlh!2,Դ\"&\rXb2BȠ\r73/#\n8@0ȍ\n\\:̈s\"9410z\r8a^h\\K	\\z29xDɫ-3`Ox!\rk\n&΃*׃}6\n}h\rpPв\n\0<Mo\\(!`Y}Jq1ܦ3@O0#>PU[:a44\n(:ME-\rh	2-W¿8(8:R&<h؋1~h\nb4H?/a@r\$HXB!޽Ǭj\"R6R07j/j8#2\"#zXVO\r?T}9Ed#WV]r3/F2Bؤ#r2|`Vc#ܚ8擠ڟH ͣa\np҂!-#X.+죬3T0zP7`]kc6\nNi	?pߊ,vk,'@\n)~L֭v)5*NZ1.%e\"x'㴠TP%EҹmRJQK^M՚D]z\"& XS;C(-jZIiXI؈TÂ'\"Q\n)F(!<R5d<Qx::b.[փPfL&`zalXʇѧ5&hCBN[3F7.8@{yfǖGc604# d4RVD|8A.\05pRF\n8ȧ(E;K2Hۏ[R*fZc\"\n-ؘ6J%:=eLUH%\r:FD𞓁ru`&JS\nACC0 ImbދL:2dDؐ!.H VABJGw3(\$0vICKȳZ{*L8M&,lܦO!'\n<)DSّ#3U	q}Z&%0լz\0SH0YgBji!2)'O\0F\n-h\"_ֶ\"*9\"d)giP*VIu E		nF9x5GFyhH32XK pbHᰥfGd̚qqZD8-w&6K%PA4{	r\${6o-=}+((HHib|QGR礪*KDY MQMH估V1\r&!î8gy)7<A 2ʘ֕q9I5\0z:`gOFo[l2rnJ(40Q+\nb5Y\"zwOPyj*5=Bo+6ʮe':\nz+\r}qV[|}\$\0-Dh;/O;<˰/*@@ c.]Sigh;3`)qΊ\rn𓦑IuX)TZ=5d6Ap	<,foniճȚ[.[xGy/'#q®\$1k&b<s\"AB'UD8=O`Πw K3DN3H=-TnlL'}v<(bv)JN.@͑jW4xzR0HFX/^fMlYXu\"\$4o:Ε8#Tb%/ɪlJtG 5VF\rRX{~m6{ibMO9Ǭǖ2 bbkx~~/myT^ٰ\\<iHKB%O6#]k``NMR]\rC6EӨZk\"d>CE'owDelIJւT>nNR2V/@J0~6pꐆP.mgDïw\nlrp0mjPOPc]+'6\"2z#J@l\"9y`&,OԓÜi\r<2dTn%g@dRz\"TP\"|#%bq\rMq\r\$kE-X8jjMbab=E\0sqJ|PB},m`^b	to\$%q\r<@qgL`#^ia@h\\J?0FƤ&	Ag	mr\rK0< @Xbc(&\\!#\"lt8ik\nwdsC`E-x`֔\"7\0LM֍{%-%rZ;r^^']O%:\nKQOM*/y)\rѾҎ@r|\r<R7e/:\n)kGM/2R-2+N	\"\r\0 22p2*8)q/f#d7 Vnb\\B[.<66rK|9@Г2fb8C2:\nd\$\rV`c\rTb\$\05`Zd\"OƄrf\nZx?By~%\n2;c5\n!B! \"I\"\$Qhϙ`37R*CD(O^}MDMkFX8NeTFtM-&\$FE&\"<H(Hբ7]fbDm&͔JrÉC-&\n&``EUE,f48SFB;p#(BMl#~1~\"F,¢@<ΟD\\-%.Ƌf\ne23e1\n\"\nǦ4II>̌/b8VcTD@c)P>80B0iQ%Z\"|J<]bXO5";break;case"ro":$e="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9\r0ӑ@dC&It7AE3ed&3IrE#Q&(r2NrjEDj9M 4ݤ'LqL&V< 1my1&A.Ś2ȦCMeyS\"Dbg3BiMASM7,kYF\\S>t4N;g竔sgA@1B:޲IйlKp9<P6 P\"5xפ#╊i6iBBkjZڷ P\r`M4,:N@7L8\$)2@)\n7j9#9((c94410z\r8a^\\'R.#8_0BC ^(ڸ̸r\n}8#|bh#<IeYM1=Lcֲ<C+sB3(\r:7uy/#H!#x79}\r##-(0j@Վ,rOXw D_h-4*.s~`\\J5QlKΛaOK<#\$i\$ܹ\"`@8㣐go,ZM-cN\0:@ʙ{<\0)[56)\nˡ\\M2&L?Uc(Ɣa`Ph\n6ÐZ:o/ߵ 1y~(	#\rZ!_#<WEU܎/G'Cb\"v190|x*\r0(敠k\$z5H=eCI\",DÙGcz+^gXĨKK3bؗXI/}@xRy=g(:\"ܩ\$3m(\n\nY{}{)A@s%\r|FqPM)\ruƧI\n@cQEIU.CLyP\"Fxd@\0Dni풲!/4b4T-!rC	nxSkhu%a4!BlcRJQK)4*T1Qt_*U%VGePCZ)	p9%庯\$jP2&I	#l	W>Ho(rHw'Zs|LlЁ\\M9x>nHᝁD\$ւWPc,ǆ?	{@\0D6NǩmȊMx&w5DZang`*ddQe1NBIj^|n!-Sd|[2/Dj^aL)i2My6M1L?30Dzd3&-(#uJ['iuV֨e{ďoI\\CE1YJ,7.|C\\3m,g`@fm=x<(5T)lʓ\$)e'E\"\"W_Oa#\$GK҂XSHBp`N2RYpl\nmdJ0T\n&ΚXH֔\"Rv,1sA0*FYf@\"evXJq:%N!PL\"&i%/clC:	9i_	0Ac*¬y&Z\rNce2l\\90Bb(6	;# sf\\,yr4{HYP\\\n\n_0Pc)/@DХBsƂ1T,@|pmcv?%CąrqJCIt\$\r&M.C\nh2	t0زHiNIhIiԵI[0)~\0o`mh1\0p\$grvagy%:2%*,Ah{ԏ\$@\nNN815b6ɅdH,з8Hl@BHkmtTfjoa	1鯴Mx/`^9ˈ̯^tAE¢xtQۡɃy':DY6\$a-໣r\\[%BptJl\"\nk22Ko,)D<۱3kͳ:5VnLPzl[)G5	,!,^]oSTW\ni1o唊N/2bRH݉)P8Ih~&OI?WiZ;q0#H#Ei&_D`lؼz4+npbd0<sV/\$.]G˨aCbʰdԛ,bbBĦN\r5G\r\$Gh,@i*>AhI6L2%lIOxЎoImТ\$O樤LKd@\nbnA,(\"XN쮈xB0PFPY:N̰&!\rR'\n`	O	L1\"ܤ?) q8\$1<C%m\$ìBA \r \r!\0hl1d*m(Q\rd #V͔8_4 [,&`-Dpƍ\$_9\rv[e?Qױ޷,8ϟmtxż#QPQ2<tu&,Äu	~1/t([-peĳ#-Z#bo/\$e\"!@3h%<f\0llr lXq\nXR!%rr204җrSRFG,/Eqvr(R+`0\\\$/(,M֌TK\rr'~CVa;U*0dN\rb,;\"%2\"93rY2Gmv2dv!ԗ\n.\r2W6B7A337lg	nH	)?`KJcFZ=C:\":39_c6KD5ψ5n,3LS9dꎐ\\cS1ð_d\rVe/><,_K\$D:%bZjxb\nZ:\"CN]ޭJ2Eb'd&]!K!W{I.v4٥ki\nG 8a\0 #i\$Kk8b\"\0`@sp\"H%mL]^\\It]d#TF2&~\r[f2-q|b8M\">>pYP/P';5jFob[2Bf0Lq\0(,e_FuZ@a\ns0.eL_\"-~g]͌G	SEdGJoDLJsZ\rv2O?`!rdmVUF&D\rce\"%ҭBbC\$	\0t	@\n`";break;case"ru":$e="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4Ըh/	4&Y9ڡLQcQ\$c9L'3-hKclqu0hʮsizxr#^3KB!A%X֡PTB/G\n>#=Ii\\\"\"\$=i9*JQI`=I3(@n:4<){)h4@F:PD0\r\",fƨIo#4cA%!1c)x%\$*J)G1ۧF딿Ɓ^\00Ŀ̂8@+hڢ-!\"S9S\0\n\02\"8Bk@1>H,\".r5%<;-:\\ .@.4\n	j# 4(SR+!'(z*E4]<V[n1	Դ\0X@46#0z\r8a^\\0E\rp^86cxDU2FPo %Hd2~\\x-\r;@ƅGFTQ>	𻷔GaF؎o##*z[lad%KL6QilR-!(n	0lLxʾ83+!+J~_ؠh(1 \n;Ԗ<n/1!73.|h2GNqVY6^Lhhpm<YmQ-8ȑGbxXUfiNN9)|~B{Me.@{hݚS1i\nbu\"zHW'ɕ*ZZ*gG58hm3vVCj/1@s<Lp0ɞH .2U#IU®^[>R\$(a\nTr3nOD<i+7n4Ano\$\n׾L!QPh,{X~-\"'xUӪUNoDu`ab,aϜ2&KMrrcBka \n6š[?|#F.П\"騬ȵ~RBOR)_i×4,T6\",\$~сwRc4I\\IEȐa&gjl)/!;-Ae%]YCxO6UJ\r&>%\0Kb/eg\0\\F{IH)ԆROj!n].fVw\$\0emIK&0F{*>#\"ARW\$PP{*+ED(H\\niυg:\0?MAe%jTԛi~\$ӌE|eJCϮ_ӷjRQ)Y*23t˙X\$9.Eɓhfv[#1[evת_+~ul#`!@t\r61YM9IZK[[:Lddjr.]n.n)>՜'N2\$[/qǟUxU_K0+a, <F[\nba͊C@DOp\nzGv+\\5[QUNE饨	dC&MJ.|-\",E<rY	 р֢ل&\njLYKV³PU@<iHih\rJs#2\n}]ZU#\n()-g,No'2HxniH#ICcwi'8ˈ|SUn&;[ڲbOcȈhTf\nxTDv`Hq I|v;12\0C\naH#oM,MՖ:M!&iHR6ZJVek\r޹BӦh-3e\$FrںR	R}'ڋd\\*މ69Թk`9dGav\$+PdZ,1:Q>eN*\0T\nZXjPPsr~RxENmRb?4z5`1m8OQebcߙý	\\/i2̑5WpJY#@q9pFF-\$)))ˇ?J(^3\\MnY|vZK:k}jߒ;h:3x=u1^/nܢxLp5H 	Ur\\ǔ	\\rO\r hU	²eZǞæNehiLGF)RΊb8Mj&FnhnK,i`)E\$(\n\0\n\r,Fbʛ#6\"\r*@t6jbhG(фi^h\n0~P+GRp\n't\0LBj(DMr\"#v\$K`'22,v\"~`6\0ʾ\r'C ~Sop	c7	&TFi\n-C\n/5Y@\0@\rt%'(p@m((ªF'θM醎M\$\n\0NIʺ.3HW\$|<'1-h'jWc v\$Z\r&Q*@w\rn\08pCbcx\0mFy\n 	gn\$E&ji0\$.(,P\$(r Fmh mT)%RN\"\r2/\"B*BOQdLje!hj''kD,R('t#&tz*2'\reTfils(#֯vj҅+.#.y/\$=/r/	'{00B0B(pz(@Vb7Fj70-%9nF|R*8o5\").-&ĎdVmlor6n8A1IlovyIDĄ3>Aj#*DBP(i	=SƓl-\$XsP<O?PFD.R	@*	1@oOe\n1Pn [T7@:r8rbD\"t&zz,X4g5\ntmOC*SMT\"/fR<3@.1\"4@\r`*\r8`\r\r G0L@*%Nf1T8aNO\$jiO(=u@)N)PSAdOUG\0T>MNHbdDg ]rjU/@j,5?-uE6TƖUS+jKUÉS/UgVSG5tkuxU15XAO)'/O@ǤJtSe1s[x\\5*s\\CB]\"US%x5M?I\$|>M֞8\$C.x\"<u\r2\${>\"˓QbM_*@M\"@(r+zԄ^˕A\neaIBh:@D&[mHVjsTiυQ'Z2|qis5@4[F]j[i]j#\\DVц6kulVn3ckua[3Pkl+ojsG	7M-lBtYj&f2\"&2r+~Jhhyr\"UV=֭1w[YuS4-khwmlQ\$-ch,uGhh+m{TԃPryuht\$zvK5swBV/g)	n~c#c'g}i#wC~#}pׇy\r{s(4QjwA5(-8\n-<qQѵq<=N@>rf*Ƨ dc\\1^4%8l_ee*VJ;uJoC.#V)n*2W՘ÁXx)+{6ՏtlosTjBoVgS4lS&̴eAWXUu\"-Qw92y 2\$sy2wRta1^q00*F0\$mL>b4֤7#63JD+1U'!@\n6Qb\rITrL=\ryfayd8lr^Q6@1S(fd2BE;xM\0kNIx8v3N+\nDŖb₾@Cq4x\$qHL\"a6C4EM/u&\"L9<n=MAhOO(|bcU@ڏPzP>pډh#HҊJtn)Vjt#QQ?zmqȮ)V&4D@Ђnv@a<tΦ*&*;ldJKCϽe%`>s2I؟&0pSN}:ݙ:(FqoPZToxW4\"=ghH[;xkPoOW9,'uTjcMƠ;+q(cQo\0\$'\\";break;case"sk":$e="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8U\rZv0&㙭'(a7&(n1!%iAD9ϡf?BKe|i3fRSzi0\"	75d%Stiы&KuqmNemB~Q%b	a6ORj5#'MnqoI{<q\"7)RPcC(p7G)B,CXԦcCh½7\"T6<m1#Ȝ2M4@1¤*6(䚎@P7\"̴-I\$0KZ/Q,4\r@Px@ڍ2P2\rlC\"\$(r*#\ra(Rb1E\0\"a`@!3:xILʈAr3h^80xD͸1\r̅.|˜NC\r\$7â!\n06	\rcf(Л+(OPȫB(KE<ݗ=0bC1˘%`:%Ȃ:A	'\"\\4s&7\rr8WmȌ:[2C;3DEkK\rc ʜB-c(\"IҤ8\"\0P\r8x|,⧼CőeB\0q`ʘ\rMc\\.&M5=X\\7#6%O%iGc*@1\\>4oH6Ts.{PΆ9\r#d빚jeB(*#J6xx<t1+ai;WEl,ܨ\0:4T0J7:*5lЕ@73@:^0|uoP9}2R(7_ =A3a!8BrE|:FPHrK]B`#VV3*\r{@1\"'D(RjEhZϊfP&五a`QJ)>UΥ@u&J(a:|P)ц]CrFah9v,G,%2pÖ1]B:A=\"622eSYE\\ CGؘԺ6	B'RQAI)E,ʛSGZCKT.5xC+#Da\\JEJo00䃎aPQ><,f1e&;?)@!RH_L&ԖP%ETwRP)s0˰ܩ@It)a,a(#ZR\"dbF%sɹ](gZy!*DU_H9?ɐ 8״/S,hBp9iI\rIip0.e2qh	hޜ\"j2eM*Jfr\nIR\r\$H\r0ZxMx\n&}:^*dR\0QjL\$x|H\$в'8Sx>W-bk& !0=ĥE^0!0\"_Ep^bHIA*H%_[p/V)rDVY&6{[.%Ԉ2t<BPYbÔm!\$ٖCt\$7 xS\n\"@Cr0>.bƩL;75@`Ag`+qZ`aԟag:DmVQ P(?LO<ToeICLˆnB.h\nMfPZ`2=@'\$XTWph_6(X#!b.*SldEтJ`شDfޞdI:._P1\\\"<{;stJAS ?4QrU`(UL0FC~(('({5˲90GTy!'F)Y!	;	7!07#BC\r96y#-Gڹj7ų~/?`C3FI伜29\0H\\m\n~CS;t+Qt}WXļh~i7CXp΍6WG#n7mh\r	jc7R֩\0cL(Ie0C	X}~Ly,\n].Ӊ)Z/NZtEltQ>M~	ŒzϷbcq!<I6Cߝ\0/IP=1KK/Xl'C~r>7	\n#]}2ػӤf>]\r;}|~+R֯&e\r2O&81\":}\")egFpZBƧj:`\\,G<ݧp2DrC<n,EOXM']0HDb	\0FAf8Dg:7#h6rⅼ!ϔ4/CF\"^l:C	v@3J	b^!RXW0BoP*YBA\r bC6Âۀ\r?\"//&d|LLjή9.	.c\"䂞B\nzJZ@\rF`(Q(^\rMGI\rlnPо\rHf\nBmci\rP1&er'&B:?к4ePKV]\0Y1qojހrQQ/Q%	1\\K&,~IR\$笱\"J#r\"(>.vBNZ\r[b!F&drJ0JbCBxJn嶸%e&}(jrjrv븣m*PHBNCj.vB&?Hr&΀\"[h4~Ѕy)_vE%)//0RR2VZ&Zg4;\r?00&sy	372\r3C#s(NmRss*{+F-##_#}j@DvNy\"BjIG3u1 3F%\nבp1SKR\0dSF;N;;1:.#6Ε\0`g!ӥ\r?U;t;?J@S\$nA\$31*\"%?.BZA4FC5vH!}0q3BZG^-r//5FHuT)#C+>Gf&=<-ф7/\0Ӈ6oKt:JLoKz\0#er@'\$h\n=	#zfoH##(\0q%\rVB@\rc9ckDrPC!d@'\$9or7w\"M'*-f@\np>O}\0V+W1WrW!T!ubM&\"8vF_.t}J#bNPt檮`Cf0.Gđl'+[Tm?-B,%~.d.\nthd\$.\"Db*`!p4g`q`qm\r@u<5V?Fqb94CP\"pd5bS 5.2W@ƴZ@QL\r'E_V')om\0H)gmMb̎eAp-r\"V\rl6[~ck3b\nM&Ң2LK/nd҃~`F#~uvr\07Kȑ(";break;case"sl":$e="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n*!fPsSYPaDqa9Ύr\"tDgNfoBAoB&sL@Vdk1:0v9L&9du2hyr4\rS9 դh4Ε܈h9\\,xAcFQ =ptgtfYyS=bX,ģ)^+Nĳ\npǎ`9H[:І\"\0+j꾰H2B;|B= P%M\"	\nԈ6L[# h6)1m	[/@\r\r|/`@%n3:x7vAr3p^8K22v!Hc3!cj64^0h´Pޡ\"3# 7Z3#7R\nu4>+C;v2 xی:B9+p΂ @1\$bHe@ԋm[,8*\r#%{9>HP2m1:6'U7\0P:mC :Ө칬	B5#`,Z/S451l@&CȴR\"\re;(*@z|\rc(O(P2-P*W@VUB4! ^MƧjWD[\$I8,K:>.ŌH;\rnڸ5^^!CM)hHK\r&<ԂE0Pb32|pʇ\n'iM1G(\r[F)A\r#fNs6)w\\i763r	\$Z/6QCpv%@2:_Z0%é\$V+ppD\r7 9\$9Nh-/7nW\\LĆ&D̚RlM9#n(A4\"]a:	Y+E@Ɋ\rxcz5|dxG|ii.:YLFi&tҚjoBzvNC%I\rݮg@HJJਢ@uɚOH	+E(VEmC1\0)jR}c#I1mWv8|9>C4S`'cjȋ}2ռ\n (\0PNI#Ѻ n(&n⹚SPߜe0oRZJ!ldoE\r=XsO\$˲eCKm?,`rGa3rqC:pg3 =) 'pV , #%\$䤄xD'%zkNB/\$PRY\nڡy5fOr!708iPD̻bKIzhdlMVxS\n->X*:5MoZd x	[Ob`yIɂ~7db\0&pXy\"ȋc\\Qxr\$o0ub@(̋lv1XZ?݈pgE_â'e,&/yefyM)Emy/܆:˾duM,3trQ;86ȠUG}MDY+4PzyF75ZYL?ĩԃ\0װJRa簘LlNPOdNz03F쳸\$@D srn2Ԯ G@TVi(wSJ\\`ItZ	Zj'XʮTt]\rކK(c\0wIDjG΂ZhB,Y\$ V-Z! BNA	Y`J\$00Z8he#C	\0T2DcSK&\$ʈ,^Sa5Lj\".|55Ȋ&\nXCwzbF\0c	Z\n8^-D\r 1\\pxfxK&yg<bx9a1&U[Qgy&zVjv()Y>Ym6\"N?.6u%3\$Gdw&G/w:ىSІaa`8rqF;;S8EH\$6Cs0୞jbW\")]zWP]8iuj_WA hS\n,-*?_2oj)~9oDb17,-#PW+\"^Au\"#E%ɤSP',\$Ȫ\"7d@\n?b.IbntU\\#\$p\rJsE\rjLF?/Q	&0ODDЎ\"Cʪ^HȂ1а\\`%t=@fj8[.FuM!̺P#V0olP+RKM{\rqP/\0:,-BQPZ+ok/nъңlŶ[+c0B0,	9bT\"~:0b>t\r)(0@AczW=!t%p\0003dR\r0R[,XJ¡|1VopQjoFQf#Q\"`#	6\nG4+\r>#1\\c[S*bT\\c27	M\"l#(\$2\$`lj%b``A%*Ҁ챎\\-DCb/\n<lDmG#cd7T\"\r..ڮN܀_\$z-HiMjBϨhl^q\\Յ:_)52-i2so\$r2\"(BkN1c/\$hr\$5(\";66g\0C7(-)F\"`4Tc*.e	,yeAf哢-i:}C;Gsģ}3:qLH\$P1\$;&>>;?C@	W4AV\0k2~G<f*z!\0!J<\npuhc3'F.\0t1yV7F L!b~o@x\nQ+m'<4x+j<H	\$(!	&+DC!L\$LȵE\n!T4[#%I3mDٯ3nyKdd/Pg]&`R琓\"46Ci/#l.Gl.FQESjV%g\"dIS<f p\"\\&R[|'ѣK\nĆ)HHx,NpSb#-[F8\">sQaC>RCN#&1eֿaS\r,p#°XV4G,e";break;case"sr":$e="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9C\nD?!G: 'a%e|Dqe0̢\nm=c/\"mF:D\"Uj8k:]\nHƖHr9a (h_(әHY7D	Fn7#Il2̧1: :4c41?\n+ʆ4I(k+<F\$70)pE0k/쒎x)H3Σ˩ChH2xKʾ\$1*[;\09Cx/\"/;hz'RZ߻rxƥI&D3Oȉ\nFCH1E\"B\"_ЪB6@2\r@\$\08K1o\0Mp[BюLϓB9^430z\r8a^\\0̿/x7w^C ^+/4q/\r7^0Κv餡Gs2 \$79Ų@\"\$]a1\"Jȑ\n1w\"óYI{W\ra\ng<\n7U(J2\".(9~b%k_9	*:tQJYfs4,M\"!F\n(0eB;#`27Ш1I	#a6SENT#`:2XkO\n T_-6;~BX3Xd͒3R?Ls#T!S,hb)\"b#.r??}\\2b'IK~O^vh.0Rq-RC'^cB41xcԫʝv1A`aHտ\"bb>'m@nȎro\$/*BXxDD\0Aev\n \r9LtW%Ty^KЗBp3°?!Y@/%M!2ZelHBbzJI0#ȡ\"IdMP)#zUq32ihP7 `:T \r3r!3\r\nJ%2bdR%P%SÔUh)iT\0cA2)z*Y+-f֚\rl-On }8Wr?mŽnS)RF̲%BQłjIB\\6/ܗB&\nj_%I`9RYAi-IÒ[kj+-9W(I\rն\"KݘDCZT!-^VP;ZMg0\$@NDS\0y*˰h<^\0Z`R`C5TRZɊ&YVrip 3fbIE97VGSxE B\07v\0PVIuƤ\$a.!m91)>bT\n_\n0(jȣy ivY-ÚU \" eWT-p3\0hPd]\\4W\\FIaL)g~hz/`dj]'B>JV\"t^Ct1x%;x\0*aƋw58͐0 \$SP MP93űP@miM]d٢!])M(,{_,\0ѳuԼӁ\nc3,611Luͼ4;Rc\"XzJY@mj*w%e^8RKu@\r#ܗг|_U	,RG._8EHO	*\0BEk6I`\n@V\"vإ-F<,_u@',B5A{EC3Q-ο6iԆ|Q¢M)1J՝p;^-#c)&DQ^Rr'\$\\_܆@o@NXQdŪOkTtś;!5捈F|u8'^94ByyKR@%ԳTFӲgٵ;ͤB`1|AI}p`	FyfEr\na=6HsJcd\naZ6!H(&m`u\$9׺L1\n 4	me\"2h[9or@/exfR-!<q\0A1H>om3}՘WUk Ϡ3GxC/OCUAE(­-{H/'uQ|H̏,ݎ4DL`*\n 	\0@Ǆ\r%<eCƅDHDhodal@`&v</~gFl,scbh)haLXjyxc#N6\0\\.'Px2g6PI(c P+CП\n)\nbM\nk\nWI6~P0	\"DmovC,n.cb,\rP}\rc\r+S0P̉,U\n&0\$1	%!#	SBK T6^x6A/jcz,\"'11\r\0u*Qt .\"g0؇ێ\npHM\$c,^N02KG\0HFF1dОA\r70&L`b1N7H;!\rch#rJ9\$o	1#Gc܎F+#n ølX|FK&u~d1@KC5\0G('.Pm)\nNcR E-f0~Nv.^RV\r\r\r hިsbFV*\rlLMCHMO2>Q60&2\"v:r1! @^V:ZV\$E(\$Ld=pd<pcЖН\nlRm3f78Pm3ӕ6&Q9808nd:62/MZS (2)5SL:	=d;=&SRNd~#@0(.+A%G09ʌ!etCAx,NQo:/xS1R^;s##DF H%B΀btCQ=3?)/HGAFi>2CpA19f>i?2\0K\$NKK@GY&\"֊8\\È!%>b7<U?tO)N&T0lCOQWQǘv̶/4\$EK0Q_/<z]SG0>3V:YPePU_V3t&n1>Z{/~1mLT&93.)aѶuMMXdZm<\$Ns\0.wJMTdov&hϬ\0=cBŶSrD]#?]¡\\]Uگo@k4N0OUMoaKSgK)v'<y[tX\$V\$EfZ4%d1dA,GXRuR#v\$tf4faubl+gcfMP{@MPUUdCϜ,Jm;H1FlN0_*96[St*6kk_k6Sf\"ekBEQRsO+:F<+8Ϊ!8]C\0 n)h.)q,w1г@DB+K \npɔ\$~%ЏLE(0vkl,Piw0Gk7oq&2:w&	 7rHäx.wiPĀR,b0(i#4'(s9O[I\"6F6Zb\0r^kl-!mK#o\0FCS:%'wPwԇ\$\$2vx9'=:;^GՂ7'tK'lrGG*7Inx\"\$('(DsZs5L~U.CzYPh\0Tz!8cLtδ|#ifrx;Bו9XqXni)5J V)\nd&3T 7cՓ;~";break;case"sv":$e="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7ADqzn\na!CzkDqe0t\n<pō9=N7'L	n%#)HrL×3|+f-5/2p9N\\C*ĝ!7K\\ 2Qч9g6fs+ϦuCS7OenTޝ0֭	Z<(ò\0+\"&h	R7'0k83((,h7\$J 6E0j &f\"Ƅ:b(+p܌C,B84.0z\r9Ax^;r+F\rp3(^c	\0ԎQr`7^08S49à:c곭+ͳ:28	000PJC\$aj X#@PU65\$\r&LTYIFB07S#M		#8λ6)OU	5@ʣ+\0C-֯v2e1A\n:!iq3k6c\\_\nbvl\\\rA,㪴9'Q3D4#:ө\r\rHf3oEmv78\$Gk82p	\$B(,O@%uB@T+p(\0:=)45S؇B\$C=62AXj(;qc<#8!Bmu:5@cq46.ܕtX`{-7 PK k70dPI!9N`1NJ]V7K)ټZ/6Ip#zco7qj>b~ؼb|qmIBN~8\$\$DI(妾D*\\\$+o!	K@.TdLɠ;HAroN!E4D@#&NeN&Rd-}d\$PC\$WC脄ERQKteL5؂raHĔA8<C\"\r\$2p|m,_ H9ē|*\r9JIb+l2QҌ5*d\"}hZǌ0bd45k9L(ftL9-!J\0蘉!ČJbi`%'5E)'7d\\Zgl4m\$AĲE#!Am[d4aE2-GKCI0) 8yp\$wTuamԇxJbI2}*MM!'2pnNMz>hJq|@b3h3-!JaRuz|x(  &Rˁ򔍒dVT9)tA412B\\9bڴ;&KBT-&`H#̛:ldp#@OkYkv|iȄK5HRL,손aI*\0TH\$vnB	H*@u`Q°BuJr[BaXc<>]UV\"\\^z+jº?tF`^M@/7%-R\\d,J)F(>A[agxHϚ0)KR@t`;훳~pಀe#FXcrBnĜ\0Y2ĉy0ɔ˰e\$4Q%2NJN>alўS]rt9!2◤*# (&DU!T\\R{snft6z(C.3wVòf<b._F\$:,D,¨tPL#~1ghxopC	\0]WN,*%,3;Iw-v\nȋA&6c]1z?)pktᦽ͋ȑ|MOMHg<9+Q,fvs,[\"AnW\rƔaz!Yˎ2W;6G/	2KԉC2&h-2-vr*sqAJְ\"Rvm(#.;IV6[\$)|OQނ훾Tk{lC(l6qӐ[G%\rBPP0/eƔşzHLG2O~IX6s\"BpwԂ0pe(MgK{\$&R/';(o:Ąe6jwγ,ܰ`B6P\"mT{,TF-V.364zJ\rb	T6E%!d_\0X\rtګ(l,\nIXJ6&AF 2;@3*\$8HIpX-<P(UOlB8TƺjϥoNjcٰ/Tc=&I\nd^\\@_\r#89pZCvQ!\0\r\rQA\0;M\r;8\\Ll-1`\\nSf8ͺprխ^3>4bNʃ#hLo	H-Q(1|-rMv.\r/\rcQl1-yq@Qe'\r\n@p^۱ycv!.K!d!k!ph>\"'! :	6&\"fU4r7lN1I&qliH7'FRv\\xgs&LE#h4,߅V.E#2FA*ե,\rV\rgV\"&c㎬\"3HJb+\n~\rH\$\n\"\r+l0>..0J4څ)[lCq]:,#O\"A	hXʄR\"'祐-e ,V  NZ%3	\n(xm^#(*Cd\"5R!ǔ83\nSGދ31:\nf4Le,|	,,T2|	b\nNvv\"z#d	;^4b2=D>\$ԢƔ#9̷:fīt'lg\\tcVRB.(`@qi ";break;case"ta":$e="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8UUɼ_ArªZ.(qg+S\\+5~\n\$g#)eGKN@r|,F,u]FdXGiSTrP+_5ȕʙa^i6OCq)Jj^E.Q@+W@J,W(I{\$#x\r\rx@8CH4(2a\0\$ :74#1EH%!p#%9nҗ@P#x;j\"r\\K<<2Jj2t81Pd2Nx)CH3(Q*ڒŢ2(7L(\npp@2C9HJpSc\rJEL\rYPDceI=LkԪ5L\$o_).1Am\"JϔYUiS둴,G(,X+K&C(Եv]u<#8Z3# AT\07J: 8Q13p;1=;c XD49Ax^;rW\0]Qx7EC ^-QQ7^04ܨ2*лBzd)jT5OVD79mչAZ83<^{AZ(XIu\"rʺQ9\rؚ\nr{OYp=3)]umo,#vhg)lB*{\"0:@0ʤIʨlsIҗ:C7 ]2J ;h3~NC)\"8J݉ZN=Rm+HM#!e 2Lg.z]I!P\$rbL	}a6#\$~H c!?Kˀ>\$*I.)\neQyа')Ko鐣72u1^Q9SrA##,,Sy4S&b<qd8񰚜[Ef8zj]{ǳcVv¸´tam{-]z+i	dp;!/	(I\r,9Gc;Ab_\\o<9yW0\"'	Lн.huU0hbyӇ Z\\)6Hg!|r)Csq9\r:C8~@2丁\0~qY00ujfL0x₀JJ2#7<.Z[f`,\$2IB8e\r2ӀrHusp0f\r\0ݖgq`(*LCpy9VC33 &6xQ(`JT\$n1dmj6RKFR!SHũ*Ĕ _P2pd`,2\\4f;#@hM7X>YAUJڈ8+ A5]&1KRr~V CWH^i{CyH	Zf%S8h/%eoV۳fY9gw&hlJ4(P7JAutX@pTKTO[q6 A;@\ryC@@*V:	ZBX:FY \reXt4;w=J~Q)E!\\؀PP	@cZfpBMKf|\$?s=oDPb.H#x{\r;椄LvE,%1\"Mng-hUQF,X9f!B:j!8XC~C1@YOG9NRS\nA2v3m-?]sV&ȉBȯyȥ=%\nbFp,y\".ƫ8TB\\43dZo2Wd37AGa	P8KŪsS)c5p\r`y{ѼP\r.F16N̨ml<Iz\"vd<3k0@xS\n'CN=]\n>d+?Bqv*RzRbKku\0S%iPeQ:L:SLel@A\0SCVł0TАֆ(CO%{cb_81(I:*qZ*Fp \n@\"@W\"Lu.UkwQN}EcjAj4ҩB0%f9L*<\"hw\0A\$p|ot8(krp8qe\n\\%f\\HV(MlŌv@#VX6Bk[JVrMvNtz0v|5ÆrDOg-ց*G!Ę h?H򩈖/mMP>I'+K\$tH`D(FJĦ|Nt#JGEDЌg7#奆|q(-2OBt\0zh`?wOi\nԚd\r {k{Zls\0F%0l` kͪ'ZE`7q\0Լ.6,E 贎n* \rd[c6<qB{B/!IqrH)-c@l` 6n7\rQsJ\rt@Rg\0r8x).`|CA@cF@\\g&2rq%k.<\raIW	C\0jnq QFl\r\r)@\n`(\nPa\n	G\0\$ -}/ʖqk04Ofu<(e2)<wR;	x`p<QP\r+bdg2ʊM5sd`֨AsMrײǳU6	HSi3'ώI7(7ӛ7bXcډSQ,w9\$.((qԒSJX-j1c\0<5<\\ӜU.f6?1f7Y;M=H9VKЪ:Dⲣ4yä%KOm/(D=0Nb;G˪7/XTP'p0)-^\\\nU<:BI*rB%V@d\rX-nӱ\rdp&\0ENN~h\0J*-c*ԙ7t;7w.\rQ/PuLԱQUD\rQB#PiV\r#?TlETStNS2馽u\rLQTU|iE8rBwUXs:4QQU/@53*wXSUnr;Gi?t|\\mJN?\rSzǰQdp8Dr5 D+9s~Aމ)vJ<0Qn\rT'K~A:9*5;,_V\$ǉb0\0,TV@\rTf:\r\0{~#Iյe\0c	{2_VwJgYU@kAS[6`2tpVXU_WbRoL!]YOYSaWVh8}jvtPkiwmQ^lE&MLTPc|Li?jI:6IGnqHH^qBm86p0*O^-v,V!c<n!Fs?bucnէ*5X=;tRAgVPSu!uVS78Ov*?գlxR/x3->0'Szϲ&dHb)Xd6 62wAy=Ǫ#do.\$ry]^)FY=SA'H+&adyB3xl=O>,WvW}1ph.p	2W]6P \$8^r빂5x,Rj{R6sFucՏW\r\"LvWW.'or3=w(4eȱ)lص#vV֟rx位Hk	.XVov\$Kpl4`\0PFí%iݐck)k,ŲMِW?CU+Px[67zإ|Zm9G\01zXK)YI*kl)EX\ri]T@QGA-KQdǆ#3ƁH\$)KL_iCZI|7mYptC/w{yYV|syo}?rF3nbhGo0k\r'|izOבN.AG\$`\rd@6ʹhf^U0u%zF,\\OC\0˨%e%bKw7ruוT-Bmz:-you8eYө0u:˗uz	W-{:=D\\Ja\"%-\"i(WqrH矚\rH|cw6}[+n%&yW-/w	l\0otpv)}]\nw*׃+\n)Z0}3+p\$+?;*y8yyU@I2;#;Кc19eNfY͜\"uսY~{WiI4]Qwrsm%k-Еu\0n\r:,{gG*\rcB	a\npK_h%)76\\FɂZTZ3VS}46WJd&&\rPأg\r\nfk<\0؟>e	h\r<m\\6|+^\r~ɹ){\"2So437`lytծ7TR)%ij.GPq3\\^d5F륻IW7J؇S1cVݗXR,(OEs[|tQW|}@bD\$G<\r}ܓNx]zv94M(jG\r^T1V[\r`ɿ{iHWl~w\\_`c\0@h{YbWHP`g}\0P	D|q\\Coa\\md&5}\\Xm⏓J\nrZ򻄚݀02-J\nU\\3pKOY~w#@\rz5x:9^x_M}F	\0@	t\n`";break;case"th":$e="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=G\nASZg\\Zsf{2q4\rvuTq,..+h(n1s6t9K'vK֗!AvyOS.lUشt.}pTkp+nC퓴>>Bi\"X *~-h+#\0,@4#7\r\09\r#689R: :8à4ƃ1FK=\n[;I쎷+c:lִp,,C셗\$450=9s?B.jQ@o뚑B`P#pΞϓ.(cOs̅B57NK=j悶F'Ku43N̳J<*zB;:zH4.*MV-Jί<GalUiWV'kOPi8 mP @qR_c1c3\rn#;1CN ;ԃ XPD49Ax^;pxu-H3(09xDmHQ#5H6cH7x@0E\rUezZju)d歊s?{#FOJ[H&=e>Ԛ[s\\clH,_7x+#݃`PJ2 m:Z-sJ'j=>\\-\\Yo\$>\nCԟ0|B 3#}:~ϐ)\$-[\$XZklPZI\rX{zFp*\rqCllBmswHz('t,PlF\r/Ct\nv9Q	;ȸJOTʝKoL\0ŐJWMe/Xh\\Bnȵ`ZA=lDhT0c -EG<*%ִ5IBL :yX~)P3YAM\\wI0eD\$T߃jiŮ6qtP+TIh:W\$TA<֞O%Ps\r`peqDHJEHt̘>RPsig Đ'\$D6AQ3Ax%fE!M?(d!*XrC腄 @0f\r䡆AK\n	z)i<\06C`\0:ll:*JC8aUQ(`J0GU*p7ROMԞDHѣFT(@nT,l1ͰDl2FLS,치V&d6hF>%EL2yCSI0So1Z\nCW?MԪ;&ϩ|Cٶ3zM8򭳛@\\ldlVY}aT Vo5Ŋg\0\$k6b\$!/i=5ENO0ZUb	u !b8|9UfKK!/*}#k|Ca ZΛT~6ɑE0B/G@11B0F*\0\0(.2ǤSKE'`*^|:5E(cS\0F|~xw&,RrP	|ٞڇhх6r&2G7\nm{1SpH-VXVS\nAnsHB<nJ\r90b[,[xжJ)LCԖzZAYHjl\0vXIoyqCuGGf2\r~L/8?.3e/&:xbIfbn~\0].\\;0FSQ\"#AnK9-o5u^H[9y^, DPO^N	}	Qs\nSB0ns\0ۣu/B,\n~%ڼ.'v*0O	*\0BE]@/iV\\rΣ]	tI,=5\\'YhmVt(S\reÿUϏPIU(\0h?F:uQQϴbaPHmEY>T,Mw?O ltI>J)->N'I!fҲN;>'lߊn.F=u)'@姰 |Ȏ%~5O66r?[S	&\n`G`l,c	e찹g*l*f\rKTy.\\d ~#~XH.>%l(\"\"pGJI0Jp)ML'TȞ/nQ\\-OJBO,:/Th`r8Dvѐ\rgԏK\rsfOBjEFJeBb,@C-+O̝L̉s\n\rn(ΒhKPJ:'`ȚnWC>ȥ*ne\0 	\0@X_\"D_GlNNAfd(̈́kr0P\nj6k)W#&HVLD⌬V.g1d\n\0bDN\rΝLNU\"D#qj)\"ynP*tnV %΍3e	b @T`r>IV'd04\\%Z\\%bh\nCN̬8lRg(cpmR[nr~Y%B\$¢\09J=(iВR\$c!(xdYd&Kn&B~+\rbnpu!cN2*pÚ5\"& ÒiI.9!c9/rl-/ƸMKf	51!N9(ؓóL9%m*'?5*׏t&䥋,1k/n4T`8~'&Hr;5~[h):DnsxA3:0ʣ0oo}\rBI;\"7N8\n]Hb \r\r\r<=fM&\"q^363h7bo1Qd(B+t5(~37B|n>dWXSb2D4r!26qBgH5OÒ&T}NEƭoo=\r⅛\r⼴K4TkNL1M/SR39/yOPnq0/k F&D0QQ~N9,\\0l\r s73ADeE?3Du(onnk\$Km\\P:X34\"}Gfk5rttpxCmHCg\ntp/u2\\܍溒]42s#zpZi)C44uLu}F0\nUE`9]^6AFTFa_b. Un@_2#8N(\")2{_dYW5\"/f#pE0\nF&^s#M^ShʁicF\\;aVi5܎1g6D`h@86NPlEEF`Ș4O5VФivPV\rn\\3<16u.U\0DF8l^r\$DhW.yXl7's,x'^r1\nbPMvv֣[9aOCWy\\Kl3xn'CvBYN\n6Uir\n3oH-)֯mmF@TgGvb־WWk|C@8Оn&i\nNImm/6)_q%q.N[.zvY7JdV).MJK%|0m\r7\$Nդ@8J2''iL*.\np\nۅ J(2wT-A.&ȉVͯ\0dPd\r/\rk\"vꜢ\nd.'&V\\)t4N-;>C,ʙjVNbq/vmphJGDY9:DmW8v-f|q-5:GYTLrl-uBul+mM7FGYsmMWhDMr.\r\nwb355nJsf#(93tCcVs\n\\+39؎qHNO\rt``@B9\"U~(W(a=g>Ӗ2Ur^*U-<P'2&{WHCI9h=x@\rz\$vp(2_VȬHS6z-P	\0@	t\n`";break;case"tr":$e="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9Φal1N5+b(Bi=Dqe0̳U18t5hZM,4&`(a1\rɮ}d=Iⶓ^a<~xB3|2u2\"SXS8|Ii1gQ̑̚\r;Mno+\$#ӆҙAE>yFqH7ҵ\\Y;H#9:êj꾰 P0j+\$.1+ɠ#(O;4#o\r#\"։(x9V95c1p3X;#7X༎c42\0xC@:t1B|92^'aڍ/i̍\rhx#&\0,#hԖ-m\"Lf&JB,FM6[TUBT\rmCT!Ib@PJ2%@v(,h'}T6u~VDB)ҥ8#<CZ܌W-o PߔJ\"H֛=a6x4hñBHN̻3,dQ#D)\"eqm&0˖pAL4֖	O\"5ӞN}Q!:śIA94*\$CiRX{M`{#: yDsm5\rf R@6D0+b9\$WD04mKHϧ|7v@#L0tO2Hܷ<Ks^̺&4:!D3X}@,H4c-í``d:>jz^Z\\]\$J\"77ks9LgXE(iW' r1o<qD\r_6rdq8Љ^e\$=|pR	j5`:_	24ʙJkM8y%.T\$\$(\n9dD^<GN}hsJ_uK@I\$1H	`je(3sHe0@ia4Bᒓ\0b4ə4&؛pNOЍdñ\$L(\0B%!W<!	_\rb@cNŐP?6XK\0a파U\r\nwj&zY&Hr9r*	P	@NuRY\0f(E3ʾrXRsDGhJBB-\"HDa#2#\$[Ҹb,ް 0\n(TqҺDt1:Q}k;gLİ\"@(e#u*A<S\nA{x~^Fy#`QrLI}d-EՒJ'?8TJxdɼp5aSr%(z8Ԅ1%_LPW)]pJ!8b,РT:\$L%RKzPrB3:J<Dyèysdf9\$Ԏ`;+\r}^ZAyIX(eDWzN&`g Ҋ\0/gSq>{I%զd0rKTup \n@\"gH=sj\0D1חS()D\"N6?cVYh%Ē_	޼c7cy\rg?CҰMGNC,ANL{hW<ڛS6QD}HVn[-ؤ'ˀ]H:j#@[\"*^t_낝SNy2GنUQL/]m(kظ\nK8!\nʡ075hunͿ`&қE\rndTZ [h@ܫ!.a0#c69y<=hlWQ\n4f^7h`c^@(!})eFYc26کG[ s	`ᄤФDh*5kf ~9\r``BH<1\0]9=@;TbXdj00sNY1aPMFر+[~,MYĬ>k:SG>Ndu?Nh,3za3qdLB.Unox\"׆wob/0`]p\$(EZU\$ޚr(d\rSP,)Ⱥ']Qn\\!o`ETnaמJ>hvw6ud>8IqDJ\rl%wЯb]b(/,r\n4`e^y;oB\$)*T-\"-Fª0̭\" CŢ, JEr\rx )&\\F-<Cވ͌g̏ܕC|c&\"IƢFf\n%;	-⌦ZD;NhnL.k}\rnHMoMྍdmPP0F}Ъ9MwXFVYŀI-',,b6\"n\"K&*\$0k\"X+dQ.\"w\0ȴBKV<(VY\\ӑC\rTL3Mhť-_%V٭qf\nHZHlQжQ1ѵ&tqUQfL(wcô+\0ZDPO;po!q p^!%AZKxA0\r\">+\nq26\"\"y&:bM3ߍ7XG\0P@d|=8&2.'fm'\0(W(&n3U+Q\"Q+%R*{+C?1\$LpH>P#\rg	+/jR\r%V\$RĮX%h8\\/&#2RPs+b8Š!D4[-[EENSyBN녒N\r@`ph7\$C\"g\0z`e4̳`@ZV jtl6Rk.fP<#<s<6BL:#ǖD`X#c݄;!~%c\"\\'(@X}}G\$ˮX#سe,.%e~sdsT\r(esBaYDu*G\r\$KnpǉHgEt<T4x첸	>P>e:v\rP<`^Ƅ_RGLzP\"ô`tLnzC^HpT^eDɳA4E\r.OFy؜}-lD-	# ";break;case"uk":$e="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9(;Au\r*u`Cd-|EX~\n\$g#)exZ9 G\"HESXj8R9ֽ|_b#rk:-HB!PńRDiyA	ǖx]5KOcJvf[5{ftk,TIjh0'\rz~8ȋ\$\ry*.#΋4nNƃ4ê*0(r}48죎'plA\rDn<@#)یF^ƭs	X ?V	/傼PRDh\"#OJ#\"JBdrDh14ͩ1>HrNhm,hh\\ʔZ8^t&P2\rH2O1E!jJR0RK좝v[̬=\0x0C83:xq\rYWVp9x7<9XJ}-ih+%N\nA|\0|&\"X2,W\n0<Asg=E|,5IdDG,68EI(e*i8\\5eM+޶!G1!M\$[#L{_|n0>n4HLfIy'\n&Pf~lѡE\$F>bQlFk>47h3&9tl~'N,'nk0rDs;&zOC(Yf)\"g<H40),IQ'3/fľ؈ʅJzK|BQBI}?ÖN-]\"gpSK\rtSGG 󰭙s\0#PCm00,4168Ed%^Cu	>`#*{,%T@Ch0xA(䴤FMaĺ(5BtL8	(+ifeT0(TCp0&I_SH52:BW:mAIa౷%C~0h\nOMɒ,8L	3ۏm	86@%DHԒzܓHh#)Wi	G&0\\F\$}t7G\$)f5%YxZau-1əof4TljgȍMs6[#%ek8S.ك/݄7ZbN<HtSS҇L2(Ʌj~'6|ݠpQ{Q0AR)th	jpDhxq_+-GآG%VUxrZ1J9|ZX2\\KsUҺj7Mm_!hCgMu=k[67NF,4M5éT#>G?^/H嘋i+EfhHi\"=iUV[quʹ]xPxs+|*vF{C*I45Qk4%9Kf͙,OD.kAUH	l5z`\n\nlZWꩉv	gf񪋰5/=v͖Y'am,P&lУEJL^Ha6hӐ-č@ rAZ7P`*N(b:8AT۔'Oɕ>Z8ȔĬ)~ػhєLh\rɴpf5X/	؞)\n[zج?rG<Vgv'\0HĒsI\nVׅ2RR ,{w6Q@,QX#4mMM#,UeH,љ|˩Bcڜ-rt7[6a^.V[HJ!\n>jsSERJZ%4d\"g#yw{-}LB \n<)GSfijMY{gUlYyu)HS &9߲RMQr^hsV}58dR6]CY*Y;z-S#hf`l߮TvS)+b\\LHL!݌hvQcDmblhCڏ*4҂u#]%m*RxNԶ.X(XjY'Cnq3<>-e2Jiy9q2˥yH=8#R2SN3)wH\rI)X pF9lo44 9_q&-爕a7G~T=y7F{B:)Kkz/VCKmTbJ	܈\r˄|	hs-<3`ʸ \r%`f#f#Dfl@s)/\0,2B3 V\0\0@\r\"'B\$\\p'Gk͠/O(H`y2t&Z1.D0)<|HL-/(\$frr0FS03\0 `i`&FŬְ?\0pllbGo#H?L;\$U@\n`u-ȓ,|V̀(tȈ̜LzK\$pqhfڛ<gF=ߑe1h&kǪtv!W-	N/9/wjA	gєjhe+A\$|\$1D GA\\j\$#iR9nk \$ q\$r!LjP|)\"WZ2^S#wo	1\"2P6ExD	\$rob!F\$TP\r(\\*\"d@X\n\\jd8*Q~G^ؒ\"P:`ǘK#\0>;Nd~!1M0O{\$hFsHA3ڐ2b,aV*s γH\0h3x]\0P|@dx/MNsO\0h(mjFQ~@b܂pB\"0\$L+C.c0g8/8e#S*o	bw\ni:g\"y63F\"}eT\r]p\r`\r\r xrΑ0A\0e k,S4,3[Ce\$t>Ǯ?fw oiCnzPF+dTi6N)4p\"jM\$3rT	c*:K\$}1k5I-ITf3*@\$WGJreJ~G3&I'IttLL#T}Kk?II\rM/1RBS%PpP6P' 2PRpu.<|o5d+-)n)'S\nBFd QtH <Na5Ro2*dS?ð֏\$NB60xn/WX-\"nR2S\r.Įzze<}KJ%HCc#QR1K5_fn'f#PV˥JEGuG_ny&HV,aA_7cQT4nTs^e<U/b\\tcjPTa0Pb\"![prc5\0HGE;X`44;j4_caQQTe&y,e1Odv_b2m+ck6dG/SǋhCqzE)j5tEQqM51dNqq`u5n6\$h;rGjy5WT3d5HWb*VdOHWIeq£oKUn f'=gʒlWXWjlwU64s7zlutB6`0bApʄ)3س4̶VT5VFno13.ܖ#\0N4GDNqV¼kfHv2945v}(+k3Orf&xwiǾ8{XiONt*p6haN3LJK=֔˪:bNHR,u,)X	ˎ\nZ6!uT4Z<eNه(U퍬x(ٍ/FN~hGv5}nmHD@%Bg4Ƌ0J#'Zәa3p49G.~BvM\"W7Snϸ/Sp{U80_Yc7LoM{y]d̷oD!E\$`\\2876Dhl(f0)臨>sLyNQ`b|r!PcK@SDR-97ab#G wz5	{\$d0IfWDfqo(#HYEh'f'\"mfQ_[#,\$Ӱ0OּϖEn\$@Nlw9r)G'A#MUbJH#h1lVo/j4=QnVWEx\\";break;case"uz":$e="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8!\"n:far Io7X&9 5瑃Hq9L'3(}Aap-rLfqJ֘lX*MF\n%mRp(+7NY>|B:\rY.3\r4Asҙuzah@ti8[-:KZaO7;|kul7*'֊+ɜӉh@<6`5F쌣j꾰A\0ܽ-b9\r?\n?81#/[N\"\r<Z _*\$&6B|mvH|8b\"1xJʸ4\0x4c(CC8a^\\IQ\\،x7p9I|`8Q|rj\0\nA,9%O.!Hb,=&CzV=qmh!(28xЯض^Lp<M,ۋH*k0U#=Z@P;zIϛS+@8h͞22u#;0J7IڌJPkZ53T\"Ϛǈc@ʈ\r<S\r.rItL#M0݌J9[J\n\"b(:)8cz֥N[PʲgGOaR3<YsaW6c~;YjGh&j^Wa(ȳB\\Z]\r\"7iU\$cg%]Vyu!U3M\r\$C<NSώ;[TJ7.aO.vΗp˧XE;~.d77>48BKj`q\0P2IrՇC`u\nky\rtRΕJ)JXCf&Yn-)oH3 Y| { &:xRن)0yB	;BΨ 2\rOv#!@8YQ]& ץ&t4/ڛaNi;CI%A(E!p%a)\0|K_jI^`\"t@m)tLm&4	]>M߰䚓,Pr4G\0U<\$Ei9PPѾ	5`|O:%*P:(rETs̄%[txgP2\ncL4\"t2&T᝜S\$P!r`UVFI(cM?-B0Nf1Ӏ:92[DZgW @@P>/Ju~AA>'029ZF)( MrY.L['%\$\"`FgB+pFTV䗙\"hl9sƆmF#'=%dꤕV!) SIL\"5bz	&MQB3}7!pЍ@_#qYz)(rh9c}&m\rJWmCDI:ABJP	L*PZemHŹ8bw7`M4֨d\0I7z*Rc\"iq!\r\r\$uA]t.f/W/!8I	\\#pP'a \$,5Bv\\k㢤XsYAY7FtI|Ns߁>+\\R@ƴ'&x uFʱ@ZYk\$qՔnɵ2],/C`Y3;٭3tYT`	-h\"ȸYYH̤ѠRePrt>K!sIB\rT2<S4dŜDu}\0(935{qm\")H5>]!yZTjݰfF\$6V~\$*Vr8eĕLB1-9!X>F4Soܲ!\rgZ8gD+*pl:jBHٻ+Af\\4]D効pUdBT82Ӿ5bdLӴ:vU{-9o㥾r߄9-͋.Abj87fFLçW?9\0V}`u O6˰n:ڴNv͙6uo{LJ=w~z+%L9yS5ߣX2Ko	w55`5h]IՊ4%<3tvC!\n𚣰VZ\rĳ&v>b7\\U3bwfzI2_`_t.@G`'Fr1]I\r4B-`_F]M3n/L\$),-E&,@F\$*\r\nfEND\"ncΆKBD˟ƈIBj𫰨Jp\nП/	fRf(od0cA.6/k0o>N_\rΠPV@ތ Wn-ms>'>2݂48X}ڟj^BZKd\$m-#.pZvVZ\rc9蠰mf([P&I\$,&xglW\\\"5#qdo5qPWBU̒\0lQ EyLA	\\VOjTb@fm|hDǒj#pr<oA \$p!Qa\r%\0\rF)%`cO&P'\\}ߦ\$1/u2arTkkDę+g\$+̎**IǇdJX\$\r%nT&r\$dR1	ZȾ#:65epx[!;,2l3~<25\0.\rRd\"z2A2\"YOre5ϴ2C\0`ܲ8itŠ`b*>b\np^l(4iD1[rqS5\r;%2s&|#\"648\"PFt/hcN7_	rC>}D/{%zR.j1ODmz\r@& :&\rF7|^OՆȢs44F3nE\$,\0C-W	t]+64̀nsGf;͝G#K\$\0YP|'bJm)]O:%5/`@GbGG((4% A&'6Lq5L\nPD d`I@'-1D|k8b?e";break;case"vi":$e="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn810Lthb*L QCH1b	,Q^cM3s2Nr=v8]&-.c\rF 1XE)C	nz477JqmU`-M@daH9[׵\rH!y i=Yd\$IXWxmmtWjYoqwD:<6\nc4`P7e'@@#hߢ,*X7@9Cx䐉	NA\"l<1N\n򐅥(:Z@K!\nv\rA!Z8B;&rڈ2\"80P2\rDFߍ(	:M!#=pB0K;(p:Ё\0࿎cL2\0xC@:td38^2}69Ӵ^'A00@\rp7^02\$0).:Ft6o5<-uHc@,edۿP0Cu#0<(P9 P48޷\r8R]\$KLJ)4A\" 3#!:UAjñ3hkQˑY\0\roq~4,1K(aO3f]Kul</%hNA8.;J8	ˍd(S5A3CwzB6'X(P񕍏,h41])+o휊\r7cG;\\Hms*nvtλ7-K.:N(F#w2\"a;p!pZt\r!Tv*:A8|q'iZ93\r#?2AB\"\r# D^?ႆw@.ybK	0se\".Qz4a)	Ð\n*]2Q\r(Xim)FaRHt&\\³Zu[J,yPܨH@F	!SLM!I\nU2Ğ <=N=Ҋ	:ðC\r!;0@XUJW+dբ\\zZIܳ[\$!@4lM\0@8֖Et1\"J) \$\$.3G2!5@\"JVbլ}DrP9+xbb>nˈ\$6VDhH\$VkAB\$,Wp\rm0fQޛB!Ĝ]\rANPˡ	e=]\n'зHA@\$NϊrJ	фZ1\0pA\0B҃Oo>(J(Y=k'QOd9\nAY!8)4r`AR4UѐC	hrW&4G\r2-!7dbbEy3Va>HN\\=v.htc'܂@\n#Q]4Z9[A;S!2&ƨR|Q)L!Yg\$\$0\r\$70\"WOI3\"T.7\n~WgnE̒\n<)HbsVEY\$:!!X%7JB&`Έt\$QHI'FS>?Y2`]JKi5m%hd⬘\0²2w-LIO:K(\0\rKFlŌgprR/˦Fi̧ĉEWT,eh	\\eplϡ[.?>l\\2[441)%1;?pQO)oVdd5kR\n	\0v7P(	-z\$`PJxF\"!T?a֬OF(s/mCTr#MD=UC^i'hKӢa:m.M.>k!nYAȣ'ճWy_! ϑ:0Q\r`*R6|[YfYwS`A<}RtC>wnsf^MIQ[0oG˸ @BH=C[\n,9nIoCX\0\nz\0.bر%pBg\$=&{Db/FAfoKw	!EŤס1Jd!bPdꐑ(w 8ǟ\"_~tRfJxP(Q/Fdg#'\n20[[.Y(94vh;C8ϰ9UtRНPPƑ!qFXjN\"]	Bsr0l2.&khl&sP@\"=8?EB:\\)Z.D6'@~BAbA)Hibj2jW!hI!>͡t6/\0\r.`7Gdځ̽l&#}˺RaM\ndG4C&(а\0%\"2\n`vT0s\".Cv\nOA\rl;B (ȱ;)\"y⹈,4ZlHI\\ٮV1kBi\nu\nnC,&#7jlfǫJbNdbnAv(<qIn0O2 rf1\"k,^#P\r^\r51Q>VbzsNoG\\qr.>p0 !n6N\"ﮘr\"ZA_L	n~?Η@%&&eBd\\ / JS!p\r'w\"n'j!4uN#GA):tЊ0E*?cbNDx7TѲqM)LN9,.j@/d\$0BqXi/&\n=1-0^,*o2\\0MN%\"28qJGlsq56' fM_K̪m)Rבlf36:\\;Dh[9N(wӱ\$@[O\$'@\$KtF1\n[\0B	ĲCGR\\fLnMA+q%1\"\0004j:eH\nZV.I|[F7J+[);X0S1t5tO?Q)SI>49ceKCDLbKA n^=:΃\0QB;82%\0Pop>F3L1/q	& @<dsLl' MwcjGQ\\4IP26=*I혜lG,Q9\nB,]ҝzM)&r4=\"+Ba8F.je^-mJOA,Ϊk,pICǎe(b\$;KFe,+FH\\M\r獫V,+;O";break;case"zh":$e="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4)ΔT9w:vO\"%CBrixM3s2bV}\n%[L`*9>S؜%yP⣎uYоHQ)\":VdjdK:tRd(t/0Vc5_hIG*\\?M[h9ͣQpCqH\nt+ծB_cS>R\$2AYn(\$QBr%B+EHa^CMb]j2sDNr P2\rH2GIvL\$\"s|XK͓,rpZrċq!\0кD49Ax^;pF\\7C8^2x໎c2p>%1AAN8GI+|\$jE2V֣|sӦII\$rTNS)6_/]TD1H@PJ2\n.tHD겼2EQEWAUQPrDGQxW)\0^[J19{K[ZH NDeB&sr:G4ոܨ83FuqhXsSTtܒ9lZ!zN1)PIVۂ&Whqv䤙^>#55m)ęrsyynXgZ9uLA::aZHA*h5dƌCEK9tեQJ-#I5\r:70C<h|oØ|!p4A/K+KB{LD')bJUӔ>s崏G9XS!%a(AtF8:1%<Ja{䱬4]	\rETMz!btXʵN	R[C\$\$r!bDP]'@LxfQr~¼[\0 @\$ԭB1v+ZKy0&\$ș@wMIӨdr:*A7b_:X%PQ'En.qG\"&;6-oPqtN	w\nReK}04ʙJk	8'\$tN'T䟻%v.*:a,Ř\$W1,\"r,R(0TV\"YH		Z)0xN%ZQ:PĎq6.%BEуԀSk̡N\$i*@\$\0A4ݘTDbq)\n\$\\<9pXs~m8QPDDDFd!E,Iq,y *Pp!LO^/Ht!1BrԈ@RI3\"YY\"I16-(b\$}NNJIZ¸ZeNߺTP@6\\aEtMqS\0I\"\n/Af4:(TH\nE)=XG!\"<f9!Weւ-yE\0(#@`0Y&^tkBZ=B%\0a@xA<'\0 A\nPB`EmXK1jJZ-*/Ҡ\\&&\\#y&q4 AEw\nqv{=-nPE{D̰H.e)~+Eh 6ZUL-\"onD\$[27̓q8=bߑ~.nqB9rɍBɹ׀xL\r2\0gF2dh\rЫ;	:gc>W\\B8\r!ѻ`iV^3eJ.W΄t]	&Hr\"!bQ<^Teǣ^cWT!,ۅ>:t^M<6.H\"L_OMAKk͙.BnٰnPT!\$c|E=6&Ul	Gv8FN!.S@و6'37vmr=cj _qjbi\nd WB_,8\"BÔ@!ZȸbmNtcrsGJ3=ז_+iz'Vs?u5BC0^	Yb#;Gru^U1O,ޤk~C\n9g>WJ!337e@؝8t\r1Q`nBqeݰ\"r\$EpDvow<K?w~XkMs|cV;yy4U;;7>\$dJF(JƆ_L!01+RMkHp<p?z`(Ήz/dIH;-`NeP#k\\%U^́|{T`l&#/U}i0tTЀzc'\$\"*vT:Aa^h\\c(\0\"f9!o`, kf\ra\r(arm%HL mE'6 KBlp/ g\n{\$q/Pn.N@*iQFhLPDӰMBd8B0a#\rA1G~yPooao\rQ#	 jϔkf<6A>\r8\r:l<r('d'B0e-ܞohg\rg 8y#^	x+\0\np;ϢݐJ\"!\\R>.(y0<!(f*!^#42.,4\rf֩^EƔ\rz]cz~c),h^<\$\0#,Sz\$2겐h\\x(=-hLzOÌ2ΎD+,N1KiHNJ!h Ȍ\n`ڊB.l#G+CEB\$\$3+>{,\ni*ʾ`cC8a,>`a 1p-Q1`";break;case"zh-tw":$e="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/WtЀBT)*yX^%ӕ\\r|I7FS	99STB\$rNuMТUP)&9G'ܪ{;ds'.̖L9ho^^+ieD:=.RFR%F{A,\\{Xs&֚u\0rzM6U!TDǇEtl6N_'zV~NZRZRGATO\$DЭ8UJt|R)N|rEYYg9jXtШdPL)^C-e޵!V%>Repr\$)\"P2\rH2GI@H\$EjsiZ\$EQJ3wGړDRJ\rC@:t2,x3(; ^'AT\nt[Ԕex!t%I2,EyRQQ s3]05aXER;Rq6WAiLr\$P\0<(P9,XB+\$mp:D]9G1J#o\\KrVh^6Cfvs}sGQ&d1T\\w*ZP2@tHS#׺N#* 7)A~)\"`Als\$K,JX\$dl3W_Xw^nވ\rm!n,럗A#r]?lCĐ=nq-qXd=9h9ӵ:7P0C<uka703/b00G9L@	D9?AKyDh1PPD#J\n's+BOhZKK#WJ<\\*`tF6(p~\$R C%D!oX`&mn:DF0tq1E<NV	ҲBSJ\\9B\$ @\"vDvO	>'\0\"!EDEԊ0@>5_|]@pXKs,Ё.%ߔCsǁ#<FTи@RzFGhBOby>*Q1\rF( 5RR\n4)kZzJ%W	2RL,KG+\$ ,\"8eNFf!9ņc*9a\$ULr±'Ź8&\\ܜqEL	ZQH\nJ{Wp'QHHIl|R`9L9P@EDt\np BZ9J/:*s`W1:;MrAC29D%JҒLS\nA@ԑ=F2/!5cK\nB-#䄑w9pY'0&B\0^V~f0(ra98bE;DBQa'\0H[h\"\nE.'J<:(PP	L*)11'M:X_fȼzT6 P(bkL	ȋFU:Gr`% 4Z1@(I	8PT*\0B`EKt҆\$h\$dxGpg]3M6J(+⟊|UPYxB9QV[%	@e=6v7H#Ȝ5h4WBX@\"\r.iahE\n^O` 8VéLJQ4A%U:AޢC*:tPs/AU@3fq,`R7)2BX\r!`iz_!.Zoi[lt@c\rz`!_\rh4SKzrKrterzEomW6X!a*\"9Vu0iBAa s!?n^ҕ>Ap@#yq.xKNy.9E\"|_+=DQbp,KL0Dj>Xp!#O;\\T;ѹS/pۖsPL1#^8Qw7}X8}@DBQDUvC|lf\\|B\r}2t7(*cZBB\"P_IGDE8+1K<OzudQ1<q뙊̓ۛ㿎Xz\$5.\nZZ0\00af>9{5剰7aY>A\rGk0Ѯ]\rLav#όgn\riFC|L6lMȰ&/vl,HK(.Fo:Ξf#pNy@޾+E0fڋ0j\r\$>\rp!ʙD>v	ĪlN\r+	p#\rz=\"zlP	+(PhګPx:n9]I%Y\rmWc\r\rX<-Spbpml2b7o:1Hp\"?	pk6,^a)-yb^(<q/FE(!M\nF\$%\naTĶ<\"pMO[8u\0\r\"0Q`R\$QsR@@mERQH^-̭ŉ\"25\"e22ݲ@2=\$}R#+#<d,b+p2/bfc9Lb|\rni	\0+|2TD!HVFb*|!k+)8nj.v2h\r.?n*%_P28B-	i(2l\0\np>\${JL!b%hSd2W^Bi#bAji0.>h\$,(V?xj4Fг1ed/l!3#&1ҶS(mVfnb&&#S/ít%g/Vʀ, \nɨ\n`ڏsz+#<MPN40-~Rqӛ9\\>~tF\$:ALc:dD#%a,}3";break;}$ki=array();foreach(explode("\n",lzw_decompress($e))as$X)$ki[]=(strpos($X,"\t")?explode("\t",$X):$X);return$ki;}abstract
class
SqlDb{static$instance;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($P,$V,$H);abstract
function
quote($zh);abstract
function
select_db($Db);abstract
function
query($J,$ri=false);function
multi_query($J){return$this->multi=$this->query($J);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($bc,$V,$H,array$wf=array()){$wf[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$wf[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($bc,$V,$H,$wf);}catch(\Exception$wc){return$wc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($zh){return$this->pdo->quote($zh);}function
query($J,$ri=false){$K=$this->pdo->query($J);$this->error="";if(!$K){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(23);return
false;}$this->store_result($K);return$K;}function
store_result($K=null){if(!$K){$K=$this->multi;if(!$K)return
false;}if($K->columnCount()){$K->num_rows=$K->rowCount();return$K;}$this->affected_rows=$K->rowCount();return
true;}function
next_result(){$K=$this->multi;if(!is_object($K))return
false;$K->_offset=0;return@$K->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch_array(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch_array(\PDO::FETCH_NUM);}private
function
fetch_array($Te){$L=$this->fetch($Te);return($L?array_map(array($this,'unresource'),$L):$L);}private
function
unresource($X){return(is_resource($X)?stream_get_contents($X):$X);}function
fetch_field(){$M=(object)$this->getColumnMeta($this->_offset++);$U=$M->pdo_type;$M->type=($U==\PDO::PARAM_INT?0:15);$M->charsetnr=($U==\PDO::PARAM_LOB||(isset($M->flags)&&in_array("blob",(array)$M->flags))?63:0);return$M;}function
seek($jf){for($t=0;$t<$jf;$t++)$this->fetch();}}}function
add_driver($u,$E){SqlDriver::$drivers[$u]=$E;}function
get_driver($u){return
SqlDriver::$drivers[$u];}abstract
class
SqlDriver{static$instance;static$drivers=array();static$extensions=array();static$jush;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$partitionBy=array();var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($P,$V,$H){$f=new
Db;return($f->attach($P,$V,$H)?:$f);}function
__construct(Db$f){$this->conn=$f;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$m){}function
unconvertFunction(array$m){}function
select($R,array$O,array$Z,array$s,array$yf=array(),$_=1,$G=0,$og=false){$Xd=(count($s)<count($O));$J=adminer()->selectQueryBuild($O,$Z,$s,$yf,$_,$G);if(!$J)$J="SELECT".limit(($_GET["page"]!="last"&&$_&&$s&&$Xd&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$O)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($s&&$Xd?"\nGROUP BY ".implode(", ",$s):"").($yf?"\nORDER BY ".implode(", ",$yf):""),$_,($G?$_*$G:0),"\n");$vh=microtime(true);$L=$this->conn->query($J);if($og)echo
adminer()->selectQuery($J,$vh,!$L);return$L;}function
delete($R,$wg,$_=0){$J="FROM ".table($R);return
queries("DELETE".($_?limit1($R,$J,$wg):" $J$wg"));}function
update($R,array$Q,$wg,$_=0,$dh="\n"){$Ii=array();foreach($Q
as$z=>$X)$Ii[]="$z = $X";$J=table($R)." SET$dh".implode(",$dh",$Ii);return
queries("UPDATE".($_?limit1($R,$J,$wg,$dh):" $J$wg"));}function
insert($R,array$Q){return
queries("INSERT INTO ".table($R).($Q?" (".implode(", ",array_keys($Q)).")\nVALUES (".implode(", ",$Q).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$N,array$ng){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($J,$Wh){}function
convertSearch($v,array$X,array$m){return$v;}function
value($X,array$m){return(method_exists($this->conn,'value')?$this->conn->value($X,$m):$X);}function
quoteBinary($Rg){return
q($Rg);}function
warnings(){}function
tableHelp($E,$be=false){}function
inheritsFrom($R){return
array();}function
inheritedTables($R){return
array();}function
partitionsInfo($R){return
array();}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
indexAlgorithms(array$Gh){return
array();}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$L=array();if(DB!=""){foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$M){$M["null"]=($M["nullable"]=="YES");$L[$M["tab"]][]=$M;}}return$L;}}class
Adminer{static$instance;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.1")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($h=false){return
password_file($h);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($P){return
h($P);}function
database(){return
DB;}function
databases($Rc=true){return
get_databases($Rc);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
afterConnect(){}function
headers(){}function
csp(array$xb){return$xb;}function
head($Ab=null){return
true;}function
bodyClass(){echo" adminer";}function
css(){$L=array();foreach(array("","-dark")as$Te){$o="adminer$Te.css";if(file_exists($o)){$Mc=file_get_contents($o);$L["$o?v=".crc32($Mc)]=($Te?"dark":(preg_match('~prefers-color-scheme:\s*dark~',$Mc)?'':'light'));}}return$L;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(24).'<td>',input_hidden("auth[driver]","server")."MySQL / MariaDB"),adminer()->loginFormField('server','<tr><th>'.lang(25).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(26).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'),adminer()->loginFormField('password','<tr><th>'.lang(27).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(28).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(29)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(30))."\n";}function
loginFormField($E,$qd,$Y){return$qd.$Y."\n";}function
login($we,$H){if($H=="")return
lang(31,target_blank());return
true;}function
tableName(array$Gh){return
h($Gh["Name"]);}function
fieldName(array$m,$yf=0){$U=$m["full_type"];$hb=$m["comment"];return'<span title="'.h($U.($hb!=""?($U?": ":"").$hb:'')).'">'.h($m["field"]).'</span>';}function
selectLinks(array$Gh,$Q=""){$E=$Gh["Name"];echo'<p class="links">';$ve=array("select"=>lang(32));if(support("table")||support("indexes"))$ve["table"]=lang(33);$be=false;if(support("table")){$be=is_view($Gh);if(!$be)$ve["create"]=lang(34);elseif(support("view"))$ve["view"]=lang(35);}if($Q!==null)$ve["edit"]=lang(36);foreach($ve
as$z=>$X)echo" <a href='".h(ME)."$z=".urlencode($E).($z=="edit"?$Q:"")."'".bold(isset($_GET[$z])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($E,$be)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Fh){return
array();}function
backwardKeysPrint(array$Ba,array$M){}function
selectQuery($J,$vh,$Gc=false){$L="</p>\n";if(!$Gc&&($Qi=driver()->warnings())){$u="warnings";$L=", <a href='#$u'>".lang(37)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$L<div id='$u' class='hidden'>\n$Qi</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$J))."</code> <span class='time'>(".format_time($vh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($J)."'>".lang(12)."</a>":"").$L;}function
sqlCommandQuery($J){return
shorten_utf8(trim($J),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$N,array$Uc){return$N;}function
selectLink($X,array$m){}function
selectVal($X,$A,array$m,$Hf){$L=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$m["type"])&&!preg_match("~var~",$m["type"])?"<code>$X</code>":(preg_match('~json~',$m["type"])?"<code class='jush-js'>$X</code>":$X)));if(is_blob($m)&&!is_utf8($X))$L="<i>".lang(38,strlen($Hf))."</i>";return($A?"<a href='".h($A)."'".(is_url($A)?target_blank():"").">$L</a>":$L);}function
editVal($X,array$m){return$X;}function
config(){return
array();}function
tableStructurePrint(array$n,$Gh=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(39)."<td>".lang(40).(support("comment")?"<td>".lang(41):"")."</thead>\n";$_h=driver()->structuredTypes();foreach($n
as$m){echo"<tr><th>".h($m["field"]);$U=h($m["full_type"]);$db=h($m["collation"]);echo"<td><span title='$db'>".(in_array($U,(array)$_h[lang(6)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($db&&isset($Gh["Collation"])&&$db!=$Gh["Collation"]?" $db":""))."</span>",($m["null"]?" <i>NULL</i>":""),($m["auto_increment"]?" <i>".lang(42)."</i>":"");$k=h($m["default"]);echo(isset($m["default"])?" <span title='".lang(43)."'>[<b>".($m["generated"]?"<code class='jush-".JUSH."'>$k</code>":$k)."</b>]</span>":""),(support("comment")?"<td>".h($m["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x,array$Gh){$Pf=false;foreach($x
as$E=>$w)$Pf|=!!$w["partial"];echo"<table>\n";$Ib=first(driver()->indexAlgorithms($Gh));foreach($x
as$E=>$w){ksort($w["columns"]);$og=array();foreach($w["columns"]as$z=>$X)$og[]="<i>".h($X)."</i>".($w["lengths"][$z]?"(".$w["lengths"][$z].")":"").($w["descs"][$z]?" DESC":"");echo"<tr title='".h($E)."'>","<th>$w[type]".($Ib&&$w['algorithm']!=$Ib?" ($w[algorithm])":""),"<td>".implode(", ",$og);if($Pf)echo"<td>".($w['partial']?"<code class='jush-".JUSH."'>WHERE ".h($w['partial']):"");echo"\n";}echo"</table>\n";}function
selectColumnsPrint(array$O,array$d){print_fieldset("select",lang(44),$O);$t=0;$O[""]=array();foreach($O
as$z=>$X){$X=idx($_GET["columns"],$z,array());$c=select_input(" name='columns[$t][col]'",$d,$X["col"],($z!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(45)=>driver()->functions,lang(46)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($z!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($c)":$c)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$d,array$x){print_fieldset("search",lang(47),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h(idx($_GET["fulltext"],$t))."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Pa="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$d,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(48).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Pa),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Pa }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$yf,array$d,array$x){print_fieldset("sort",lang(49),$yf);$t=0;foreach((array)$_GET["order"]as$z=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$d,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$z]),lang(50))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$d,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(50))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($_){echo"<fieldset><legend>".lang(51)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($_)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Uh){if($Uh!==null)echo"<fieldset><legend>".lang(52)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Uh)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(53)."</legend><div>","<input type='submit' value='".lang(44)."'>"," <span id='noindex' title='".lang(54)."'></span>","<script".nonce().">\n","const indexColumns = ";$d=array();foreach($x
as$w){$_b=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$_b)$d[$_b]=1;}$d[""]=1;foreach($d
as$z=>$X)json_row($z);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$ic,array$d){}function
selectColumnsProcess(array$d,array$x){$O=array();$s=array();foreach((array)$_GET["columns"]as$z=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$O[$z]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$s[]=$O[$z];}}return
array($O,$s);}function
selectSearchProcess(array$n,array$x){$L=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&idx($_GET["fulltext"],$t)!="")$L[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$z=>$X){$bb=$X["col"];if("$bb$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$lb=array();foreach(($bb!=""?array($bb=>$n[$bb]):$n)as$E=>$m){$lg="";$kb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Dd=process_length($X["val"]);$kb
.=" ".($Dd!=""?$Dd:"(NULL)");}elseif($X["op"]=="SQL")$kb=" $X[val]";elseif(preg_match('~^(I?LIKE) %%$~',$X["op"],$C))$kb=" $C[1] ".adminer()->processInput($m,"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$lg="$X[op](".q($X["val"]).", ";$kb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$kb
.=" ".adminer()->processInput($m,$X["val"]);if($bb!=""||(isset($m["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$m["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$m["type"]))&&(!preg_match('~date|timestamp~',$m["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"]))))$lb[]=$lg.driver()->convertSearch(idf_escape($E),$X,$m).$kb;}$L[]=(count($lb)==1?$lb[0]:($lb?"(".implode(" OR ",$lb).")":"1 = 0"));}}return$L;}function
selectOrderProcess(array$n,array$x){$L=array();foreach((array)$_GET["order"]as$z=>$X){if($X!="")$L[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$z])?" DESC":"");}return$L;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$Uc){return
false;}function
selectQueryBuild(array$O,array$Z,array$s,array$yf,$_,$G){return"";}function
messageQuery($J,$Vh,$Gc=false){restart_session();$sd=&get_session("queries");if(!idx($sd,$_GET["db"]))$sd[$_GET["db"]]=array();if(strlen($J)>1e6)$J=preg_replace('~[\x80-\xFF]+$~','',substr($J,0,1e6))."\n…";$sd[$_GET["db"]][]=array($J,time(),$Vh);$sh="sql-".count($sd[$_GET["db"]]);$L="<a href='#$sh' class='toggle'>".lang(55)."</a> <a href='' class='jsonly copy'>🗐</a>\n";if(!$Gc&&($Qi=driver()->warnings())){$u="warnings-".count($sd[$_GET["db"]]);$L="<a href='#$u' class='toggle'>".lang(37)."</a>, $L<div id='$u' class='hidden'>\n$Qi</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $L<div id='$sh' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($J,1000)."</code></pre>".($Vh?" <span class='time'>($Vh)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($sd[$_GET["db"]])-1)).'">'.lang(12).'</a>':'').'</div>';}function
editRowPrint($R,array$n,$M,$yi){}function
editFunctions(array$m){$L=($m["null"]?"NULL/":"");$yi=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$z=>$bd){if(!$z||(!isset($_GET["call"])&&$yi)){foreach($bd
as$Zf=>$X){if(!$Zf||preg_match("~$Zf~",$m["type"]))$L
.="/$X";}}if($z&&$bd&&!preg_match('~set|bool~',$m["type"])&&!is_blob($m))$L
.="/SQL";}if($m["auto_increment"]&&!$yi)$L=lang(42);return
explode("/",$L);}function
editInput($R,array$m,$wa,$Y){if($m["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$wa value='orig' checked><i>".lang(10)."</i></label> ":"").enum_input("radio",$wa,$m,$Y,"NULL");return"";}function
editHint($R,array$m,$Y){return"";}function
processInput(array$m,$Y,$r=""){if($r=="SQL")return$Y;$E=$m["field"];$L=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$r))$L="$r()";elseif(preg_match('~^current_(date|timestamp)$~',$r))$L=$r;elseif(preg_match('~^([+-]|\|\|)$~',$r))$L=idf_escape($E)." $r $L";elseif(preg_match('~^[+-] interval$~',$r))$L=idf_escape($E)." $r ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)&&JUSH!="pgsql"?$Y:$L);elseif(preg_match('~^(addtime|subtime|concat)$~',$r))$L="$r(".idf_escape($E).", $L)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$r))$L="$r($L)";return
unconvert_field($m,$L);}function
dumpOutput(){$L=array('text'=>lang(56),'file'=>lang(57));if(function_exists('gzencode'))$L['gz']='gzip';return$L;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($j){}function
dumpTable($R,$Ah,$be=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Ah)dump_csv(array_keys(fields($R)));}else{if($be==2){$n=array();foreach(fields($R)as$E=>$m)$n[]=idf_escape($E)." $m[full_type]";$h="CREATE TABLE ".table($R)." (".implode(", ",$n).")";}else$h=create_sql($R,$_POST["auto_increment"],$Ah);set_utf8mb4($h);if($Ah&&$h){if($Ah=="DROP+CREATE"||$be==1)echo"DROP ".($be==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($be==1)$h=remove_definer($h);echo"$h;\n\n";}}}function
dumpData($R,$Ah,$J){if($Ah){$Ee=(JUSH=="sqlite"?0:1048576);$n=array();$_d=false;if($_POST["format"]=="sql"){if($Ah=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$n=fields($R);if(JUSH=="mssql"){foreach($n
as$m){if($m["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$_d=true;break;}}}}$K=connection()->query($J,1);if($K){$Qd="";$La="";$ee=array();$cd=array();$Ch="";$Jc=($R!=''?'fetch_assoc':'fetch_row');$tb=0;while($M=$K->$Jc()){if(!$ee){$Ii=array();foreach($M
as$X){$m=$K->fetch_field();if(idx($n[$m->name],'generated')){$cd[$m->name]=true;continue;}$ee[]=$m->name;$z=idf_escape($m->name);$Ii[]="$z = VALUES($z)";}$Ch=($Ah=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Ii):"").";\n";}if($_POST["format"]!="sql"){if($Ah=="table"){dump_csv($ee);$Ah="INSERT";}dump_csv($M);}else{if(!$Qd)$Qd="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$ee)).") VALUES";foreach($M
as$z=>$X){if($cd[$z]){unset($M[$z]);continue;}$m=$n[$z];$M[$z]=($X!==null?unconvert_field($m,preg_match(number_type(),$m["type"])&&!preg_match('~\[~',$m["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Rg=($Ee?"\n":" ")."(".implode(",\t",$M).")";if(!$La)$La=$Qd.$Rg;elseif(JUSH=='mssql'?$tb%1000!=0:strlen($La)+4+strlen($Rg)+strlen($Ch)<$Ee)$La
.=",$Rg";else{echo$La.$Ch;$La=$Qd.$Rg;}}$tb++;}if($La)echo$La.$Ch;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($_d)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($zd){return
friendly_url($zd!=""?$zd:(SERVER?:"localhost"));}function
dumpHeaders($zd,$Ve=false){$Jf=$_POST["output"];$Bc=(preg_match('~sql~',$_POST["format"])?"sql":($Ve?"tar":"csv"));header("Content-Type: ".($Jf=="gz"?"application/x-gzip":($Bc=="tar"?"application/x-tar":($Bc=="sql"||$Jf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Jf=="gz"){ob_start(function($zh){return
gzencode($zh);},1e6);}return$Bc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(58)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(59):lang(60))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(61)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(62)."</a>\n":"");if($_GET["ns"]!=="")echo(support("routine")?"<a href='#routines'>".lang(63)."</a>\n":""),(support("sequence")?"<a href='#sequences'>".lang(64)."</a>\n":""),(support("type")?"<a href='#user-types'>".lang(6)."</a>\n":""),(support("event")?"<a href='#events'>".lang(65)."</a>\n":"");return
true;}function
navigation($Se){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$df=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$df)<0?h($df):"")."</a>","</span></h1>\n";switch_lang();if($Se=="auth"){$Jf="";foreach((array)$_SESSION["pwds"]as$Ki=>$fh){foreach($fh
as$P=>$Gi){$E=h(get_setting("vendor-$Ki-$P")?:get_driver($Ki));foreach($Gi
as$V=>$H){if($H!==null){$Gb=$_SESSION["db"][$Ki][$P][$V];foreach(($Gb?array_keys($Gb):array(""))as$j)$Jf
.="<li><a href='".h(auth_url($Ki,$P,$V,$j))."'>($E) ".h("$V@".($P!=""?adminer()->serverName($P):"").($j!=""?" - $j":""))."</a>\n";}}}}if($Jf)echo"<ul id='logins'>\n$Jf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$Se&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($Se);$ha=array();if(DB==""||!$Se){if(support("sql")){$ha[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(55)."</a>";$ha[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(66)."</a>";}$ha[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(67)."</a>";}$Ed=$_GET["ns"]!==""&&!$Se&&DB!="";if($Ed)$ha[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(68)."</a>";echo($ha?"<p class='links'>\n".implode("\n",$ha)."\n":"");if($Ed){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(11)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.4.1",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$ve=array();foreach($T
as$R=>$U)$ve[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.":";json_row(js_escape(ME).(support("table")?"table":"select").'=$&','/\b('.implode('|',$ve).')\b/g',false);if(support('routine')){foreach(routines()as$M)json_row(js_escape(ME).'function='.urlencode($M["SPECIFIC_NAME"]).'&name=$&','/\b'.preg_quote($M["ROUTINE_NAME"],'/').'(?=["`]?\()/g',false);}json_row('');echo"};\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$Lh=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$n){foreach($n
as$m)$Lh[$R][]=$m["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Lh)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($Se){$i=adminer()->databases();if(DB&&$i&&!in_array(DB,$i))array_unshift($i,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Eb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(28)."'>".lang(69).": ".($i?html_select("db",array(""=>"")+$i,DB).$Eb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(22)."'".($i?" class='hidden'":"").">\n";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$wh){$R="$R";$E=adminer()->tableName($wh);if($E!=""&&!$wh["partition"])echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(32)."'>".lang(70)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($wh)?"view":"structure"))." title='".lang(33)."'>$E</a>":"<span>$E</span>")."\n";}echo"</ul>\n";}function
processList(){return
process_list();}function
killProcess($u){return
kill_process($u);}}class
Plugins{private
static$append=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($eg){if($eg===null){$eg=array();$Fa="adminer-plugins";if(is_dir($Fa)){foreach(glob("$Fa/*.php")as$o)$Fd=include_once"./$o";}$rd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Fa.php")){$Fd=include_once"./$Fa.php";if(is_array($Fd)){foreach($Fd
as$dg)$eg[get_class($dg)]=$dg;}else$this->error
.=lang(71,"<b>$Fa.php</b>",$rd)."<br>";}foreach(get_declared_classes()as$Ya){if(!$eg[$Ya]&&preg_match('~^Adminer\w~i',$Ya)){$Eg=new
\ReflectionClass($Ya);$nb=$Eg->getConstructor();if($nb&&$nb->getNumberOfRequiredParameters())$this->error
.=lang(72,$rd,"<b>$Ya</b>","<b>$Fa.php</b>")."<br>";else$eg[$Ya]=new$Ya;}}}$this->plugins=$eg;$ia=new
Adminer;$eg[]=$ia;$Eg=new
\ReflectionObject($ia);foreach($Eg->getMethods()as$Qe){foreach($eg
as$dg){$E=$Qe->getName();if(method_exists($dg,$E))$this->hooks[$E][]=$dg;}}}function
__call($E,array$Nf){$sa=array();foreach($Nf
as$z=>$X)$sa[]=&$Nf[$z];$L=null;foreach($this->hooks[$E]as$dg){$Y=call_user_func_array(array($dg,$E),$sa);if($Y!==null){if(!self::$append[$E])return$Y;$L=$Y+(array)$L;}}return$L;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$F=null){$sa=func_get_args();$sa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$sa);}}Adminer::$instance=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$drivers=array("server"=>"MySQL / MariaDB")+SqlDriver::$drivers;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$instance;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($P,$V,$H){mysqli_report(MYSQLI_REPORT_OFF);list($vd,$fg)=host_port($P);$uh=adminer()->connectSsl();if($uh)$this->ssl_set($uh['key'],$uh['cert'],$uh['ca'],'','');$L=@$this->real_connect(($P!=""?$vd:ini_get("mysqli.default_host")),($P.$V!=""?$V:ini_get("mysqli.default_user")),($P.$V.$H!=""?$H:ini_get("mysqli.default_pw")),null,(is_numeric($fg)?intval($fg):ini_get("mysqli.default_port")),(is_numeric($fg)?null:$fg),($uh?($uh['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,0);return($L?'':$this->error);}function
set_charset($Ra){if(parent::set_charset($Ra))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Ra");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($zh){return"'".$this->escape_string($zh)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($P,$V,$H){if(ini_bool("mysql.allow_local_infile"))return
lang(73,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($P!=""?$P:ini_get("mysql.default_host")),($P.$V!=""?$V:ini_get("mysql.default_user")),($P.$V.$H!=""?$H:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Ra){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Ra,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Ra");}function
quote($zh){return"'".mysql_real_escape_string($zh,$this->link)."'";}function
select_db($Db){return
mysql_select_db($Db,$this->link);}function
query($J,$ri=false){$K=@($ri?mysql_unbuffered_query($J,$this->link):mysql_query($J,$this->link));$this->error="";if(!$K){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($K===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($K);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($K){$this->result=$K;$this->num_rows=mysql_num_rows($K);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$L=mysql_fetch_field($this->result,$this->offset++);$L->orgtable=$L->table;$L->charsetnr=($L->blob?63:0);return$L;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($P,$V,$H){$wf=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$uh=adminer()->connectSsl();if($uh){if($uh['key'])$wf[\PDO::MYSQL_ATTR_SSL_KEY]=$uh['key'];if($uh['cert'])$wf[\PDO::MYSQL_ATTR_SSL_CERT]=$uh['cert'];if($uh['ca'])$wf[\PDO::MYSQL_ATTR_SSL_CA]=$uh['ca'];if(isset($uh['verify']))$wf[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$uh['verify'];}list($vd,$fg)=host_port($P);return$this->dsn("mysql:charset=utf8;host=$vd".($fg?(is_numeric($fg)?";port=":";unix_socket=").$fg:""),$V,$H,$wf);}function
set_charset($Ra){return$this->query("SET NAMES $Ra");}function
select_db($Db){return$this->query("USE ".idf_escape($Db));}function
query($J,$ri=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$ri);return
parent::query($J,$ri);}}}class
Driver
extends
SqlDriver{static$extensions=array("MySQLi","MySQL","PDO_MySQL");static$jush="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($P,$V,$H){$f=parent::connect($P,$V,$H);if(is_string($f)){if(function_exists('iconv')&&!is_utf8($f)&&strlen($Rg=iconv("windows-1250","utf-8",$f))>strlen($f))$f=$Rg;return$f;}$f->set_charset(charset($f));$f->query("SET sql_quote_show_create = 1, autocommit = 1");$f->flavor=(preg_match('~MariaDB~',$f->server_info)?'maria':'mysql');add_driver(DRIVER,($f->flavor=='maria'?"MariaDB":"MySQL"));return$f;}function
__construct(Db$f){parent::__construct($f);$this->types=array(lang(74)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(75)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(76)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(77)=>array("enum"=>65535,"set"=>64),lang(78)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(79)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$f))$this->types[lang(76)]["json"]=4294967295;if(min_version('',10.7,$f)){$this->types[lang(76)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$f)){$this->types[lang(74)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.1,'',$f))$this->partitionBy=array("HASH","LINEAR HASH","KEY","LINEAR KEY","RANGE","LIST");if(min_version(5.7,10.2,$f))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$m){return(preg_match("~binary~",$m["type"])?"<code class='jush-sql'>UNHEX</code>":($m["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$m["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$Q){return($Q?parent::insert($R,$Q):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$N,array$ng){$d=array_keys(reset($N));$lg="INSERT INTO ".table($R)." (".implode(", ",$d).") VALUES\n";$Ii=array();foreach($d
as$z)$Ii[$z]="$z = VALUES($z)";$Ch="\nON DUPLICATE KEY UPDATE ".implode(", ",$Ii);$Ii=array();$re=0;foreach($N
as$Q){$Y="(".implode(", ",$Q).")";if($Ii&&(strlen($lg)+$re+strlen($Y)+strlen($Ch)>1e6)){if(!queries($lg.implode(",\n",$Ii).$Ch))return
false;$Ii=array();$re=0;}$Ii[]=$Y;$re+=strlen($Y)+2;}return
queries($lg.implode(",\n",$Ii).$Ch);}function
slowQuery($J,$Wh){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Wh FOR $J";elseif(preg_match('~^(SELECT\b)(.+)~is',$J,$C))return"$C[1] /*+ MAX_EXECUTION_TIME(".($Wh*1000).") */ $C[2]";}}function
convertSearch($v,array$X,array$m){return(preg_match('~char|text|enum|set~',$m["type"])&&!preg_match("~^utf8~",$m["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$K=$this->conn->query("SHOW WARNINGS");if($K&&$K->num_rows){ob_start();print_select_result($K);return
ob_get_clean();}}function
tableHelp($E,$be=false){$ye=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($ye?"$E-table/":str_replace("_","-",$E)."-table.html"));if(DB=="mysql")return($ye?"mysql$E-table/":"system-schema.html");}function
partitionsInfo($R){$Zc="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$K=$this->conn->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $Zc ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$L=array();list($L["partition_by"],$L["partition"],$L["partitions"])=$K->fetch_row();$Vf=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $Zc AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$L["partition_names"]=array_keys($Vf);$L["partition_values"]=array_values($Vf);return$L;}function
hasCStyleEscapes(){static$Ma;if($Ma===null){$th=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Ma=(strpos($th,'NO_BACKSLASH_ESCAPES')===false);}return$Ma;}function
engines(){$L=array();foreach(get_rows("SHOW ENGINES")as$M){if(preg_match("~YES|DEFAULT~",$M["Support"]))$L[]=$M["Engine"];}return$L;}function
indexAlgorithms(array$Gh){return(preg_match('~^(MEMORY|NDB)$~',$Gh["Engine"])?array("HASH","BTREE"):array());}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($Rc){$L=get_session("dbs");if($L===null){$J="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$L=($Rc?slow_query($J):get_vals($J));restart_session();set_session("dbs",$L);stop_session();}return$L;}function
limit($J,$Z,$_,$jf=0,$dh=" "){return" $J$Z".($_?$dh."LIMIT $_".($jf?" OFFSET $jf":""):"");}function
limit1($R,$J,$Z,$dh="\n"){return
limit($J,$Z,1,0,$dh);}function
db_collation($j,array$b){$L=null;$h=get_val("SHOW CREATE DATABASE ".idf_escape($j),1);if(preg_match('~ COLLATE ([^ ]+)~',$h,$C))$L=$C[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$h,$C))$L=$b[$C[1]][-1];return$L;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$i){$L=array();foreach($i
as$j)$L[$j]=count(get_vals("SHOW TABLES IN ".idf_escape($j)));return$L;}function
table_status($E="",$Hc=false){$L=array();foreach(get_rows($Hc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($E!=""?"AND TABLE_NAME = ".q($E):"ORDER BY Name"):"SHOW TABLE STATUS".($E!=""?" LIKE ".q(addcslashes($E,"%_\\")):""))as$M){if($M["Engine"]=="InnoDB")$M["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$M["Comment"]);if(!isset($M["Engine"]))$M["Comment"]="";if($E!="")$M["Name"]=$E;$L[$M["Name"]]=$M;}return$L;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$ye=(connection()->flavor=='maria');$L=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$M){$m=$M["COLUMN_NAME"];$U=$M["COLUMN_TYPE"];$dd=$M["GENERATION_EXPRESSION"];$Ec=$M["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Ec,$cd);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$_e);$k=$M["COLUMN_DEFAULT"];if($k!=""){$ae=preg_match('~text|json~',$_e[1]);if(!$ye&&$ae)$k=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($k));if($ye||$ae){$k=($k=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($C){return
stripslashes(str_replace("''","'",$C[1]));},$k));}if(!$ye&&preg_match('~binary~',$_e[1])&&preg_match('~^0x(\w*)$~',$k,$C))$k=pack("H*",$C[1]);}$L[$m]=array("field"=>$m,"full_type"=>$U,"type"=>$_e[1],"length"=>$_e[2],"unsigned"=>ltrim($_e[3].$_e[4]),"default"=>($cd?($ye?$dd:stripslashes($dd)):$k),"null"=>($M["IS_NULLABLE"]=="YES"),"auto_increment"=>($Ec=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Ec,$C)?$C[1]:""),"collation"=>$M["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$M[PRIVILEGES],where,order")),"comment"=>$M["COLUMN_COMMENT"],"primary"=>($M["COLUMN_KEY"]=="PRI"),"generated"=>($cd[1]=="PERSISTENT"?"STORED":$cd[1]),);}return$L;}function
indexes($R,$g=null){$L=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$g)as$M){$E=$M["Key_name"];$L[$E]["type"]=($E=="PRIMARY"?"PRIMARY":($M["Index_type"]=="FULLTEXT"?"FULLTEXT":($M["Non_unique"]?($M["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$L[$E]["columns"][]=$M["Column_name"];$L[$E]["lengths"][]=($M["Index_type"]=="SPATIAL"?null:$M["Sub_part"]);$L[$E]["descs"][]=null;$L[$E]["algorithm"]=$M["Index_type"];}return$L;}function
foreign_keys($R){static$Zf='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$L=array();$ub=get_val("SHOW CREATE TABLE ".table($R),1);if($ub){preg_match_all("~CONSTRAINT ($Zf) FOREIGN KEY ?\\(((?:$Zf,? ?)+)\\) REFERENCES ($Zf)(?:\\.($Zf))? \\(((?:$Zf,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$ub,$Ae,PREG_SET_ORDER);foreach($Ae
as$C){preg_match_all("~$Zf~",$C[2],$oh);preg_match_all("~$Zf~",$C[5],$Ph);$L[idf_unescape($C[1])]=array("db"=>idf_unescape($C[4]!=""?$C[3]:$C[4]),"table"=>idf_unescape($C[4]!=""?$C[4]:$C[3]),"source"=>array_map('Adminer\idf_unescape',$oh[0]),"target"=>array_map('Adminer\idf_unescape',$Ph[0]),"on_delete"=>($C[6]?:"RESTRICT"),"on_update"=>($C[7]?:"RESTRICT"),);}}return$L;}function
view($E){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($E),1)));}function
collations(){$L=array();foreach(get_rows("SHOW COLLATION")as$M){if($M["Default"])$L[$M["Charset"]][-1]=$M["Collation"];else$L[$M["Charset"]][]=$M["Collation"];}ksort($L);foreach($L
as$z=>$X)sort($L[$z]);return$L;}function
information_schema($j){return($j=="information_schema")||(min_version(5.5)&&$j=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($j,$db){return
queries("CREATE DATABASE ".idf_escape($j).($db?" COLLATE ".q($db):""));}function
drop_databases(array$i){$L=apply_queries("DROP DATABASE",$i,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$L;}function
rename_database($E,$db){$L=false;if(create_database($E,$db)){$T=array();$Ni=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$Ni[]=$R;else$T[]=$R;}$L=(!$T&&!$Ni)||move_tables($T,$Ni,$E);drop_databases($L?array(DB):array());}return$L;}function
auto_increment(){$za=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$za="";break;}if($w["type"]=="PRIMARY")$za=" UNIQUE";}}return" AUTO_INCREMENT$za";}function
alter_table($R,$E,array$n,array$Tc,$hb,$lc,$db,$ya,$Uf){$qa=array();foreach($n
as$m){if($m[1]){$k=$m[1][3];if(preg_match('~ GENERATED~',$k)){$m[1][3]=(connection()->flavor=='maria'?"":$m[1][2]);$m[1][2]=$k;}$qa[]=($R!=""?($m[0]!=""?"CHANGE ".idf_escape($m[0]):"ADD"):" ")." ".implode($m[1]).($R!=""?$m[2]:"");}else$qa[]="DROP ".idf_escape($m[0]);}$qa=array_merge($qa,$Tc);$wh=($hb!==null?" COMMENT=".q($hb):"").($lc?" ENGINE=".q($lc):"").($db?" COLLATE ".q($db):"").($ya!=""?" AUTO_INCREMENT=$ya":"");if($Uf){$Vf=array();if($Uf["partition_by"]=='RANGE'||$Uf["partition_by"]=='LIST'){foreach($Uf["partition_names"]as$z=>$X){$Y=$Uf["partition_values"][$z];$Vf[]="\n  PARTITION ".idf_escape($X)." VALUES ".($Uf["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$wh
.="\nPARTITION BY $Uf[partition_by]($Uf[partition])";if($Vf)$wh
.=" (".implode(",",$Vf)."\n)";elseif($Uf["partitions"])$wh
.=" PARTITIONS ".(+$Uf["partitions"]);}elseif($Uf===null)$wh
.="\nREMOVE PARTITIONING";if($R=="")return
queries("CREATE TABLE ".table($E)." (\n".implode(",\n",$qa)."\n)$wh");if($R!=$E)$qa[]="RENAME TO ".table($E);if($wh)$qa[]=ltrim($wh);return($qa?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$qa)):true);}function
alter_indexes($R,$qa){$Qa=array();foreach($qa
as$X)$Qa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Qa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$Ni){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Ni)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$Ni,$Ph){$Hg=array();foreach($T
as$R)$Hg[]=table($R)." TO ".idf_escape($Ph).".".table($R);if(!$Hg||queries("RENAME TABLE ".implode(", ",$Hg))){$Mb=array();foreach($Ni
as$R)$Mb[table($R)]=view($R);connection()->select_db($Ph);$j=idf_escape(DB);foreach($Mb
as$E=>$Mi){if(!queries("CREATE VIEW $E AS ".str_replace(" $j."," ",$Mi["select"]))||!queries("DROP VIEW $j.$E"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$Ni,$Ph){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$E=($Ph==DB?table("copy_$R"):idf_escape($Ph).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $E"))||!queries("CREATE TABLE $E LIKE ".table($R))||!queries("INSERT INTO $E SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$M){$li=$M["Trigger"];if(!queries("CREATE TRIGGER ".($Ph==DB?idf_escape("copy_$li"):idf_escape($Ph).".".idf_escape($li))." $M[Timing] $M[Event] ON $E FOR EACH ROW\n$M[Statement];"))return
false;}}foreach($Ni
as$R){$E=($Ph==DB?table("copy_$R"):idf_escape($Ph).".".table($R));$Mi=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $E"))||!queries("CREATE VIEW $E AS $Mi[select]"))return
false;}return
true;}function
trigger($E,$R){if($E=="")return
array();$N=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($E));return
reset($N);}function
triggers($R){$L=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$M)$L[$M["Trigger"]]=array($M["Timing"],$M["Event"]);return$L;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($E,$U){$oa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$ph="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$nc=driver()->enumLength;$pi="((".implode("|",array_merge(array_keys(driver()->types()),$oa)).")\\b(?:\\s*\\(((?:[^'\")]|$nc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?(?:\\s*COLLATE\\s*['\"]?[^'\"\\s,]+['\"]?)?";$Zf="$ph*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$pi";$h=get_val("SHOW CREATE $U ".idf_escape($E),2);preg_match("~\\(((?:$Zf\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$pi\\s+":"")."(.*)~is",$h,$C);$n=array();preg_match_all("~$Zf\\s*,?~is",$C[1],$Ae,PREG_SET_ORDER);foreach($Ae
as$Mf)$n[]=array("field"=>str_replace("``","`",$Mf[2]).$Mf[3],"type"=>strtolower($Mf[5]),"length"=>preg_replace_callback("~$nc~s",'Adminer\normalize_enum',$Mf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Mf[8] $Mf[7]"))),"null"=>true,"full_type"=>$Mf[4],"inout"=>strtoupper($Mf[1]),"collation"=>strtolower($Mf[9]),);return
array("fields"=>$n,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($E)),)+($U!="FUNCTION"?array("definition"=>$C[11]):array("returns"=>array("type"=>$C[12],"length"=>$C[13],"unsigned"=>$C[15],"collation"=>$C[16]),"definition"=>$C[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($E,array$M){return
idf_escape($E);}function
last_id($K){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$f,$J){return$f->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$J);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$ya,$Ah){$L=get_val("SHOW CREATE TABLE ".table($R),1);if(!$ya)$L=preg_replace('~ AUTO_INCREMENT=\d+~','',$L);return$L;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Db,$Ah=""){$E=idf_escape($Db);$L="";if(preg_match('~CREATE~',$Ah)&&($h=get_val("SHOW CREATE DATABASE $E",1))){set_utf8mb4($h);if($Ah=="DROP+CREATE")$L="DROP DATABASE IF EXISTS $E;\n";$L
.="$h;\n";}return$L."USE $E";}function
trigger_sql($R){$L="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$M)$L
.="\nCREATE TRIGGER ".idf_escape($M["Trigger"])." $M[Timing] $M[Event] ON ".table($M["Table"])." FOR EACH ROW\n$M[Statement];;\n";return$L;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$m){if(preg_match("~binary~",$m["type"]))return"HEX(".idf_escape($m["field"]).")";if($m["type"]=="bit")return"BIN(".idf_escape($m["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($m["field"]).")";}function
unconvert_field(array$m,$L){if(preg_match("~binary~",$m["type"]))$L="UNHEX($L)";if($m["type"]=="bit")$L="CONVERT(b$L, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"])){$lg=(min_version(8)?"ST_":"");$L=$lg."GeomFromText($L, $lg"."SRID($m[field]))";}return$L;}function
support($Ic){return
preg_match('~^(comment|columns|copy|database|drop_col|dump|indexes|kill|privileges|move_col|procedure|processlist|routine|sql|status|table|trigger|variables|view'.(min_version(5.1)?'|event':'').(min_version(8)?'|descidx':'').(min_version('8.0.16','10.2.1')?'|check':'').')$~',$Ic);}function
kill_process($u){return
queries("KILL ".number($u));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Tg,$g=null){return
true;}}define('Adminer\JUSH',Driver::$jush);define('Adminer\SERVER',"".$_GET[DRIVER]);define('Adminer\DB',"$_GET[db]");define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Yh,$l="",$Ka=array(),$Zh=""){page_headers();if(is_ajax()&&$l){page_messages($l);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$ai=$Yh.($Zh!=""?": $Zh":"");$bi=strip_tags($ai.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(80),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$bi,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.4.1"),'">
';$yb=adminer()->css();if(is_int(key($yb)))$yb=array_fill_keys($yb,'light');$od=in_array('light',$yb)||in_array('',$yb);$md=in_array('dark',$yb)||in_array('',$yb);$Ab=($od?($md?null:false):($md?:null));$Ke=" media='(prefers-color-scheme: dark)'";if($Ab!==false)echo"<link rel='stylesheet'".($Ab?"":$Ke)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.4.1")."'>\n";echo"<meta name='color-scheme' content='".($Ab===null?"light dark":($Ab?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.4.1");if(adminer()->head($Ab))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.1")."'>\n";foreach($yb
as$Bi=>$Te){$wa=($Te=='dark'&&!$Ab?$Ke:($Te=='light'&&$md?" media='(prefers-color-scheme: light)'":""));echo"<link rel='stylesheet'$wa href='".h($Bi)."'>\n";}echo"\n<body class='".lang(80)." nojs";adminer()->bodyClass();echo"'>\n";$o=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($o)&&filemtime($o)+86400>time()){$Li=unserialize(file_get_contents($o));$ug="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Li["version"],base64_decode($Li["signature"]),$ug)==1)$_COOKIE["adminer_version"]=$Li["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(81))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Ka!==null){$A=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($A?:".").'">'.get_driver(DRIVER).'</a> » ';$A=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$P=adminer()->serverName(SERVER);$P=($P!=""?$P:lang(25));if($Ka===false)echo"$P\n";else{echo"<a href='".h($A)."' accesskey='1' title='Alt+Shift+1'>$P</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ka)))echo'<a href="'.h($A."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Ka)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Ka
as$z=>$X){$Ob=(is_array($X)?$X[1]:h($X));if($Ob!="")echo"<a href='".h(ME."$z=").urlencode(is_array($X)?$X[0]:$X)."'>$Ob</a> » ";}}echo"$Yh\n";}}echo"<h2>$ai</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($l);$i=&get_session("dbs");if(DB!=""&&$i&&!in_array(DB,$i,true))$i=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$xb){$pd=array();foreach($xb
as$z=>$X)$pd[]="$z $X";header("Content-Security-Policy: ".implode("; ",$pd));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$ff;if(!$ff)$ff=base64_encode(rand_string());return$ff;}function
page_messages($l){$Ai=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Pe=idx($_SESSION["messages"],$Ai);if($Pe){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Pe)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Ai]);}if($l)echo"<div class='error'>$l</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($Se=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($Se);echo"</div>\n";if($Se!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(82),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($Xe){while($Xe>=2147483648)$Xe-=4294967296;while($Xe<=-2147483649)$Xe+=4294967296;return(int)$Xe;}function
long2str(array$W,$Pi){$Rg='';foreach($W
as$X)$Rg
.=pack('V',$X);if($Pi)return
substr($Rg,0,end($W));return$Rg;}function
str2long($Rg,$Pi){$W=array_values(unpack('V*',str_pad($Rg,4*ceil(strlen($Rg)/4),"\0")));if($Pi)$W[]=strlen($Rg);return$W;}function
xxtea_mx($Wi,$Vi,$Dh,$de){return
int32((($Wi>>5&0x7FFFFFF)^$Vi<<2)+(($Vi>>3&0x1FFFFFFF)^$Wi<<4))^int32(($Dh^$Vi)+($de^$Wi));}function
encrypt_string($yh,$z){if($yh=="")return"";$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($yh,true);$Xe=count($W)-1;$Wi=$W[$Xe];$Vi=$W[0];$I=floor(6+52/($Xe+1));$Dh=0;while($I-->0){$Dh=int32($Dh+0x9E3779B9);$cc=$Dh>>2&3;for($Kf=0;$Kf<$Xe;$Kf++){$Vi=$W[$Kf+1];$We=xxtea_mx($Wi,$Vi,$Dh,$z[$Kf&3^$cc]);$Wi=int32($W[$Kf]+$We);$W[$Kf]=$Wi;}$Vi=$W[0];$We=xxtea_mx($Wi,$Vi,$Dh,$z[$Kf&3^$cc]);$Wi=int32($W[$Xe]+$We);$W[$Xe]=$Wi;}return
long2str($W,false);}function
decrypt_string($yh,$z){if($yh=="")return"";if(!$z)return
false;$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($yh,false);$Xe=count($W)-1;$Wi=$W[$Xe];$Vi=$W[0];$I=floor(6+52/($Xe+1));$Dh=int32($I*0x9E3779B9);while($Dh){$cc=$Dh>>2&3;for($Kf=$Xe;$Kf>0;$Kf--){$Wi=$W[$Kf-1];$We=xxtea_mx($Wi,$Vi,$Dh,$z[$Kf&3^$cc]);$Vi=int32($W[$Kf]-$We);$W[$Kf]=$Vi;}$Wi=$W[$Xe];$We=xxtea_mx($Wi,$Vi,$Dh,$z[$Kf&3^$cc]);$Vi=int32($W[0]-$We);$W[0]=$Vi;$Dh=int32($Dh-0x9E3779B9);}return
long2str($W,true);}$bg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($z)=explode(":",$X);$bg[$z]=$X;}}function
add_invalid_login(){$Da=get_temp_dir()."/adminer.invalid";foreach(glob("$Da*")?:array($Da)as$o){$q=file_open_lock($o);if($q)break;}if(!$q)$q=file_open_lock("$Da-".rand_string());if(!$q)return;$Vd=unserialize(stream_get_contents($q));$Vh=time();if($Vd){foreach($Vd
as$Wd=>$X){if($X[0]<$Vh)unset($Vd[$Wd]);}}$Ud=&$Vd[adminer()->bruteForceKey()];if(!$Ud)$Ud=array($Vh+30*60,0);$Ud[1]++;file_write_unlock($q,serialize($Vd));}function
check_invalid_login(array&$bg){$Vd=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$o){$q=file_open_lock($o);if($q){$Vd=unserialize(stream_get_contents($q));file_unlock($q);break;}}$Ud=idx($Vd,adminer()->bruteForceKey(),array());$ef=($Ud[1]>29?$Ud[0]-time():0);if($ef>0)auth_error(lang(83,ceil($ef/60)),$bg);}$xa=$_POST["auth"];if($xa){session_regenerate_id();$Ki=$xa["driver"];$P=$xa["server"];$V=$xa["username"];$H=(string)$xa["password"];$j=$xa["db"];set_password($Ki,$P,$V,$H);$_SESSION["db"][$Ki][$P][$V][$j]=true;if($xa["permanent"]){$z=implode("-",array_map('base64_encode',array($Ki,$P,$V,$j)));$pg=adminer()->permanentLogin(true);$bg[$z]="$z:".base64_encode($pg?encrypt_string($H,$pg):"");cookie("adminer_permanent",implode(" ",$bg));}if(count($_POST)==1||DRIVER!=$Ki||SERVER!=$P||$_GET["username"]!==$V||DB!=$j)redirect(auth_url($Ki,$P,$V,$j));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$z)set_session($z,null);unset_permanent($bg);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(84).' '.lang(85));}elseif($bg&&!$_SESSION["pwds"]){session_regenerate_id();$pg=adminer()->permanentLogin();foreach($bg
as$z=>$X){list(,$Xa)=explode(":",$X);list($Ki,$P,$V,$j)=array_map('base64_decode',explode("-",$z));set_password($Ki,$P,$V,decrypt_string(base64_decode($Xa),$pg));$_SESSION["db"][$Ki][$P][$V][$j]=true;}}function
unset_permanent(array&$bg){foreach($bg
as$z=>$X){list($Ki,$P,$V,$j)=array_map('base64_decode',explode("-",$z));if($Ki==DRIVER&&$P==SERVER&&$V==$_GET["username"]&&$j==DB)unset($bg[$z]);}cookie("adminer_permanent",implode(" ",$bg));}function
auth_error($l,array&$bg){$gh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$gh]||$_GET[$gh])&&!$_SESSION["token"])$l=lang(86);else{restart_session();add_invalid_login();$H=get_password();if($H!==null){if($H===false)$l
.=($l?'<br>':'').lang(87,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($bg);}}if(!$_COOKIE[$gh]&&$_GET[$gh]&&ini_bool("session.use_only_cookies"))$l=lang(88);$Nf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$Nf["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(29),$l,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(89)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($bg);page_header(lang(90),lang(91,implode(", ",Driver::$extensions)),false);page_footer("auth");exit;}$f='';if(isset($_GET["username"])&&is_string(get_password())){list(,$fg)=host_port(SERVER);if(preg_match('~^\s*([-+]?\d+)~',$fg,$C)&&($C[1]<1024||$C[1]>65535))auth_error(lang(92),$bg);check_invalid_login($bg);$wb=adminer()->credentials();$f=Driver::connect($wb[0],$wb[1],$wb[2]);if(is_object($f)){Db::$instance=$f;Driver::$instance=new
Driver($f);if($f->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$we=null;if(!is_object($f)||($we=adminer()->login($_GET["username"],get_password()))!==true){$l=(is_string($f)?nl_br(h($f)):(is_string($we)?$we:lang(93))).(preg_match('~^ | $~',get_password())?'<br>'.lang(94):'');auth_error($l,$bg);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(82),lang(95));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($xa&&$_POST["token"])$_POST["token"]=get_token();$l='';if($_POST){if(!verify_token()){$Nd="max_input_vars";$Ie=ini_get($Nd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$z){$X=ini_get($z);if($X&&(!$Ie||$X<$Ie)){$Nd=$z;$Ie=$X;}}}$l=(!$_POST["token"]&&$Ie?lang(96,"'$Nd'"):lang(95).' '.lang(97));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$l=lang(98,"'post_max_size'");if(isset($_GET["sql"]))$l
.=' '.lang(99);}function
print_select_result($K,$g=null,array$Bf=array(),$_=0){$ve=array();$x=array();$d=array();$Ia=array();$qi=array();$L=array();for($t=0;(!$_||$t<$_)&&($M=$K->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($y=0;$y<count($M);$y++){$m=$K->fetch_field();$E=$m->name;$Af=(isset($m->orgtable)?$m->orgtable:"");$_f=(isset($m->orgname)?$m->orgname:$E);if($Bf&&JUSH=="sql")$ve[$y]=($E=="table"?"table=":($E=="possible_keys"?"indexes=":null));elseif($Af!=""){if(isset($m->table))$L[$m->table]=$Af;if(!isset($x[$Af])){$x[$Af]=array();foreach(indexes($Af,$g)as$w){if($w["type"]=="PRIMARY"){$x[$Af]=array_flip($w["columns"]);break;}}$d[$Af]=$x[$Af];}if(isset($d[$Af][$_f])){unset($d[$Af][$_f]);$x[$Af][$_f]=$y;$ve[$y]=$Af;}}if($m->charsetnr==63)$Ia[$y]=true;$qi[$y]=$m->type;echo"<th".($Af!=""||$m->name!=$_f?" title='".h(($Af!=""?"$Af.":"").$_f)."'":"").">".h($E).($Bf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($E),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($M
as$z=>$X){$A="";if(isset($ve[$z])&&!$d[$ve[$z]]){if($Bf&&JUSH=="sql"){$R=$M[array_search("table=",$ve)];$A=ME.$ve[$z].urlencode($Bf[$R]!=""?$Bf[$R]:$R);}else{$A=ME."edit=".urlencode($ve[$z]);foreach($x[$ve[$z]]as$bb=>$y){if($M[$y]===null){$A="";break;}$A
.="&where".urlencode("[".bracket_escape($bb)."]")."=".urlencode($M[$y]);}}}elseif(is_url($X))$A=$X;if($X===null)$X="<i>NULL</i>";elseif($Ia[$z]&&!is_utf8($X))$X="<i>".lang(38,strlen($X))."</i>";else{$X=h($X);if($qi[$z]==254)$X="<code>$X</code>";}if($A)$X="<a href='".h($A)."'".(is_url($A)?target_blank():'').">$X</a>";echo"<td".($qi[$z]<=9||$qi[$z]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(14))."\n";return$L;}function
referencable_primary($bh){$L=array();foreach(table_status('',true)as$Hh=>$R){if($Hh!=$bh&&fk_support($R)){foreach(fields($Hh)as$m){if($m["primary"]){if($L[$Hh]){unset($L[$Hh]);break;}$L[$Hh]=$m;}}}}return$L;}function
textarea($E,$Y,$N=10,$eb=80){echo"<textarea name='".h($E)."' rows='$N' cols='$eb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($wa,array$wf,$Y="",$rf="",$cg=""){$Oh=($wf?"select":"input");return"<$Oh$wa".($wf?"><option value=''>$cg".optionlist($wf,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$cg'>").($rf?script("qsl('$Oh').onchange = $rf;",""):"");}function
json_row($z,$X=null,$uc=true){static$Oc=true;if($Oc)echo"{";if($z!=""){echo($Oc?"":",")."\n\t\"".addcslashes($z,"\r\n\t\"\\/").'": '.($X!==null?($uc?'"'.addcslashes($X,"\r\n\"\\/").'"':$X):'null');$Oc=false;}else{echo"\n}\n";$Oc=true;}}function
edit_type($z,array$m,array$b,array$Vc=array(),array$Fc=array()){$U=$m["type"];echo"<td><select name='".h($z)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($Vc[$U])&&!in_array($U,$Fc))$Fc[]=$U;$_h=driver()->structuredTypes();if($Vc)$_h[lang(100)]=$Vc;echo
optionlist(array_merge($Fc,$_h),$U),"</select><td>","<input name='".h($z)."[length]' value='".h($m["length"])."' size='3'".(!$m["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($b?"<input list='collations' name='".h($z)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($m["collation"])."' placeholder='(".lang(101).")'>":''),(driver()->unsigned?"<select name='".h($z)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$m["unsigned"]).'</select>':''),(isset($m['on_update'])?"<select name='".h($z)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(102).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"CURRENT_TIMESTAMP":$m["on_update"])).'</select>':''),($Vc?"<select name='".h($z)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(103).")".optionlist(explode("|",driver()->onActions),$m["on_delete"])."</select> ":" ");}function
process_length($re){$pc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$pc(?:\\s*,\\s*$pc)*+\\s*\\)?\\s*\$~",$re)&&preg_match_all("~$pc~",$re,$Ae)?"(".implode(",",$Ae[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$re)));}function
process_type(array$m,$cb="COLLATE"){return" $m[type]".process_length($m["length"]).(preg_match(number_type(),$m["type"])&&in_array($m["unsigned"],driver()->unsigned)?" $m[unsigned]":"").(preg_match('~char|text|enum|set~',$m["type"])&&$m["collation"]?" $cb ".(JUSH=="mssql"?$m["collation"]:q($m["collation"])):"");}function
process_field(array$m,array$oi){if($m["on_update"])$m["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$m["on_update"]);return
array(idf_escape(trim($m["field"])),process_type($oi),($m["null"]?" NULL":" NOT NULL"),default_value($m),(preg_match('~timestamp|datetime~',$m["type"])&&$m["on_update"]?" ON UPDATE $m[on_update]":""),(support("comment")&&$m["comment"]!=""?" COMMENT ".q($m["comment"]):""),($m["auto_increment"]?auto_increment():null),);}function
default_value(array$m){$k=$m["default"];$cd=$m["generated"];return($k===null?"":(in_array($cd,driver()->generated)?(JUSH=="mssql"?" AS ($k)".($cd=="VIRTUAL"?"":" $cd")."":" GENERATED ALWAYS AS ($k) $cd"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$k)&&(preg_match('~char|binary|text|json|enum|set~',$m["type"])||preg_match('~^(?![a-z])~i',$k))?(JUSH=="sql"&&preg_match('~text|json~',$m["type"])?"(".q($k).")":q($k)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($k)":$k)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$z=>$X){if(preg_match("~$z|$X~",$U))return" class='$z'";}}function
edit_fields(array$n,array$b,$U="TABLE",array$Vc=array()){$n=array_values($n);$Jb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$ib=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(104):lang(105)),"<td id='label-type'>".lang(40)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(106),"<td>".lang(107);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(42)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",)),"<td id='label-default'$Jb>".lang(43),(support("comment")?"<td id='label-comment'$ib>".lang(41):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($n))."]","+",lang(108)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($n
as$t=>$m){$t++;$Cf=$m[($_POST?"orig":"field")];$Ub=(isset($_POST["add"][$t-1])||(isset($m["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$Cf=="");echo"<tr".($Ub?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$m["inout"]):"")."<th>";if($Ub)echo"<input name='fields[$t][field]' value='".h($m["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'".(isset($_POST["add"][$t-1])?" autofocus":"").">";echo
input_hidden("fields[$t][orig]",$Cf);edit_type("fields[$t]",$m,$b,$Vc);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$m["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($m["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Jb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$m["generated"])." ":checkbox("fields[$t][generated]",1,$m["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($m["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$ib><input name='fields[$t][comment]' value='".h($m["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(108))." ".icon("up","up[$t]","↑",lang(109))." ".icon("down","down[$t]","↓",lang(110))." ":""),($Cf==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(111)):"");}}function
process_fields(array&$n){$jf=0;if($_POST["up"]){$le=0;foreach($n
as$z=>$m){if(key($_POST["up"])==$z){unset($n[$z]);array_splice($n,$le,0,array($m));break;}if(isset($m["field"]))$le=$jf;$jf++;}}elseif($_POST["down"]){$Xc=false;foreach($n
as$z=>$m){if(isset($m["field"])&&$Xc){unset($n[key($_POST["down"])]);array_splice($n,$jf,0,array($Xc));break;}if(key($_POST["down"])==$z)$Xc=$m;$jf++;}}elseif($_POST["add"]){$n=array_values($n);array_splice($n,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$C){$X=$C[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($ed,array$rg,$d,$pf){if(!$rg)return
true;if($rg==array("ALL PRIVILEGES","GRANT OPTION"))return($ed=="GRANT"?queries("$ed ALL PRIVILEGES$pf WITH GRANT OPTION"):queries("$ed ALL PRIVILEGES$pf")&&queries("$ed GRANT OPTION$pf"));return
queries("$ed ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$d, ",$rg).$d).$pf);}function
drop_create($Yb,$h,$Zb,$Sh,$ac,$B,$Oe,$Me,$Ne,$mf,$bf){if($_POST["drop"])query_redirect($Yb,$B,$Oe);elseif($mf=="")query_redirect($h,$B,$Ne);elseif($mf!=$bf){$vb=queries($h);queries_redirect($B,$Me,$vb&&queries($Yb));if($vb)queries($Zb);}else
queries_redirect($B,$Me,queries($Sh)&&queries($ac)&&queries($Yb)&&queries($h));}function
create_trigger($pf,array$M){$Xh=" $M[Timing] $M[Event]".(preg_match('~ OF~',$M["Event"])?" $M[Of]":"");return"CREATE TRIGGER ".idf_escape($M["Trigger"]).(JUSH=="mssql"?$pf.$Xh:$Xh.$pf).rtrim(" $M[Type]\n$M[Statement]",";").";";}function
create_routine($Og,array$M){$Q=array();$n=(array)$M["fields"];ksort($n);foreach($n
as$m){if($m["field"]!="")$Q[]=(preg_match("~^(".driver()->inout.")\$~",$m["inout"])?"$m[inout] ":"").idf_escape($m["field"]).process_type($m,"CHARACTER SET");}$Lb=rtrim($M["definition"],";");return"CREATE $Og ".idf_escape(trim($M["name"]))." (".implode(", ",$Q).")".($Og=="FUNCTION"?" RETURNS".process_type($M["returns"],"CHARACTER SET"):"").($M["language"]?" LANGUAGE $M[language]":"").(JUSH=="pgsql"?" AS ".q($Lb):"\n$Lb;");}function
remove_definer($J){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$J);}function
format_foreign_key(array$p){$j=$p["db"];$gf=$p["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$p["source"])).") REFERENCES ".($j!=""&&$j!=$_GET["db"]?idf_escape($j).".":"").($gf!=""&&$gf!=$_GET["ns"]?idf_escape($gf).".":"").idf_escape($p["table"])." (".implode(", ",array_map('Adminer\idf_escape',$p["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$p["on_delete"])?" ON DELETE $p[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$p["on_update"])?" ON UPDATE $p[on_update]":"");}function
tar_file($o,$ci){$L=pack("a100a8a8a8a12a12",$o,644,0,0,decoct($ci->size),decoct(time()));$Wa=8*32;for($t=0;$t<strlen($L);$t++)$Wa+=ord($L[$t]);$L
.=sprintf("%06o",$Wa)."\0 ";echo$L,str_repeat("\0",512-strlen($L));$ci->send();echo
str_repeat("\0",511-($ci->size+511)%512);}function
doc_link(array$Yf,$Th="<sup>?</sup>"){$eh=connection()->server_info;$Li=preg_replace('~^(\d\.?\d).*~s','\1',$eh);$Ci=array('sql'=>"https://dev.mysql.com/doc/refman/$Li/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$Li)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$eh)."&id=",);if(connection()->flavor=='maria'){$Ci['sql']="https://mariadb.com/kb/en/";$Yf['sql']=(isset($Yf['mariadb'])?$Yf['mariadb']:str_replace(".html","/",$Yf['sql']));}return($Yf[JUSH]?"<a href='".h($Ci[JUSH].$Yf[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$Li":""))."'".target_blank().">$Th</a>":"");}function
db_size($j){if(!connection()->select_db($j))return"?";$L=0;foreach(table_status()as$S)$L+=$S["Data_length"]+$S["Index_length"];return
format_number($L);}function
set_utf8mb4($h){static$Q=false;if(!$Q&&preg_match('~\butf8mb4~i',$h)){$Q=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(28).": ".h(DB),lang(112),true);}else{if($_POST["db"]&&!$l)queries_redirect(substr(ME,0,-1),lang(113),drop_databases($_POST["db"]));page_header(lang(114),$l,false);echo"<p class='links'>\n";foreach(array('database'=>lang(115),'privileges'=>lang(62),'processlist'=>lang(116),'variables'=>lang(117),'status'=>lang(118),)as$z=>$X){if(support($z))echo"<a href='".h(ME)."$z='>$X</a>\n";}echo"<p>".lang(119,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(120,"<b>".h(logged_user())."</b>")."\n";$i=adminer()->databases();if($i){$Ug=support("scheme");$b=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(28).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(121)."</a>":"")."<td>".lang(122)."<td>".lang(123)."<td>".lang(124)." - <a href='".h(ME)."dbsize=1'>".lang(125)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$i=($_GET["dbsize"]?count_tables($i):array_flip($i));foreach($i
as$j=>$T){$Ng=h(ME)."db=".urlencode($j);$u=h("Db-".$j);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$j,in_array($j,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$Ng' id='$u'>".h($j)."</a>";$db=h(db_collation($j,$b));echo"<td>".(support("database")?"<a href='$Ng".($Ug?"&amp;ns=":"")."&amp;database=' title='".lang(58)."'>$db</a>":$db),"<td align='right'><a href='$Ng&amp;schema=' id='tables-".h($j)."' title='".lang(61)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($j)."'>".($_GET["dbsize"]?db_size($j):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(127)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(!empty(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(128)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$dg){$Pb=(method_exists($dg,'description')?$dg->description():"");if(!$Pb){$Eg=new
\ReflectionObject($dg);if(preg_match('~^/[\s*]+(.+)~',$Eg->getDocComment(),$C))$Pb=$C[1];}$Vg=(method_exists($dg,'screenshot')?$dg->screenshot():"");echo"<li><b>".get_class($dg)."</b>".h($Pb?": $Pb":"").($Vg?" (<a href='".h($Vg)."'".target_blank().">".lang(129)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}adminer()->afterConnect();class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($pb){$this->size+=strlen($pb);fwrite($this->handler,$pb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$n=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$O=array(idf_escape($_GET["field"]));$K=driver()->select($a,$O,array(where($_GET,$n)),$O);$M=($K?$K->fetch_row():array());echo
driver()->value($M[0],$n[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$n=fields($a);if(!$n)$l=error()?:lang(11);$S=table_status1($a);$E=adminer()->tableName($S);page_header(($n&&is_view($S)?$S['Engine']=='materialized view'?lang(130):lang(131):lang(132)).": ".($E!=""?$E:h($a)),$l);$Mg=array();foreach($n
as$z=>$m)$Mg+=$m["privileges"];adminer()->selectLinks($S,(isset($Mg["insert"])||!support("table")?"":null));$hb=$S["Comment"];if($hb!="")echo"<p class='nowrap'>".lang(41).": ".h($hb)."\n";if($n)adminer()->tableStructurePrint($n,$S);function
tables_links(array$T){echo"<ul>\n";foreach($T
as$R)echo"<li><a href='".h(ME."table=".urlencode($R))."'>".h($R)."</a>";echo"</ul>\n";}$Md=driver()->inheritsFrom($a);if($Md){echo"<h3>".lang(133)."</h3>\n";tables_links($Md);}if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(134)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x,$S);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(135)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(100)."</h3>\n";$Vc=foreign_keys($a);if($Vc){echo"<table>\n","<thead><tr><th>".lang(136)."<td>".lang(137)."<td>".lang(103)."<td>".lang(102)."<td></thead>\n";foreach($Vc
as$E=>$p){echo"<tr title='".h($E)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$p["source"]))."</i>";$A=($p["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($p["db"]),ME):($p["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($p["ns"]),ME):ME));echo"<td><a href='".h($A."table=".urlencode($p["table"]))."'>".($p["db"]!=""&&$p["db"]!=DB?"<b>".h($p["db"])."</b>.":"").($p["ns"]!=""&&$p["ns"]!=$_GET["ns"]?"<b>".h($p["ns"])."</b>.":"").h($p["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$p["target"]))."</i>)","<td>".h($p["on_delete"]),"<td>".h($p["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($E)).'">'.lang(138).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(139)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(140)."</h3>\n";$Ta=driver()->checkConstraints($a);if($Ta){echo"<table>\n";foreach($Ta
as$z=>$X)echo"<tr title='".h($z)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($z))."'>".lang(138)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(141)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(142)."</h3>\n";$ni=triggers($a);if($ni){echo"<table>\n";foreach($ni
as$z=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($z)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($z))."'>".lang(138)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(143)."</a>\n";}$Ld=driver()->inheritedTables($a);if($Ld){echo"<h3 id='partitions'>".lang(144)."</h3>\n";$Qf=driver()->partitionsInfo($a);if($Qf)echo"<p><code class='jush-".JUSH."'>BY ".h("$Qf[partition_by]($Qf[partition])")."</code>\n";tables_links($Ld);}}elseif(isset($_GET["schema"])){page_header(lang(61),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Ih=array();$Jh=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$Ae,PREG_SET_ORDER);foreach($Ae
as$t=>$C){$Ih[$C[1]]=array($C[2],$C[3]);$Jh[]="\n\t'".js_escape($C[1])."': [ $C[2], $C[3] ]";}$fi=0;$Ea=-1;$Tg=array();$Dg=array();$pe=array();$pa=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$gg=0;$Tg[$R]["fields"]=array();foreach($pa[$R]as$m){$gg+=1.25;$m["pos"]=$gg;$Tg[$R]["fields"][$m["field"]]=$m;}$Tg[$R]["pos"]=($Ih[$R]?:array($fi,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$ne=$Ea;if(idx($Ih[$R],1)||idx($Ih[$X["table"]],1))$ne=min(idx($Ih[$R],1,0),idx($Ih[$X["table"]],1,0))-1;else$Ea-=.1;while($pe[(string)$ne])$ne-=.0001;$Tg[$R]["references"][$X["table"]][(string)$ne]=array($X["source"],$X["target"]);$Dg[$X["table"]][$R][(string)$ne]=$X["target"];$pe[(string)$ne]=true;}}$fi=max($fi,$Tg[$R]["pos"][0]+2.5+$gg);}echo'<div id="schema" style="height: ',$fi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$Jh)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$fi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Tg
as$E=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($E).'"><b>'.h($E)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$m){$X='<span'.type_class($m["type"]).' title="'.h($m["type"].($m["length"]?"($m[length])":"").($m["null"]?" NULL":'')).'">'.h($m["field"]).'</span>';echo"<br>".($m["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Qh=>$Fg){foreach($Fg
as$ne=>$Ag){$oe=$ne-idx($Ih[$E],1);$t=0;foreach($Ag[0]as$oh)echo"\n<div class='references' title='".h($Qh)."' id='refs$ne-".($t++)."' style='left: $oe"."em; top: ".$R["fields"][$oh]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$oe)."em;'></div></div>";}}foreach((array)$Dg[$E]as$Qh=>$Fg){foreach($Fg
as$ne=>$d){$oe=$ne-idx($Ih[$E],1);$t=0;foreach($d
as$Ph)echo"\n<div class='references arrow' title='".h($Qh)."' id='refd$ne-".($t++)."' style='left: $oe"."em; top: ".$R["fields"][$Ph]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$oe)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Tg
as$E=>$R){foreach((array)$R["references"]as$Qh=>$Fg){foreach($Fg
as$ne=>$Ag){$Re=$fi;$Ge=-10;foreach($Ag[0]as$z=>$oh){$hg=$R["pos"][0]+$R["fields"][$oh]["pos"];$ig=$Tg[$Qh]["pos"][0]+$Tg[$Qh]["fields"][$Ag[1][$z]]["pos"];$Re=min($Re,$hg,$ig);$Ge=max($Ge,$hg,$ig);}echo"<div class='references' id='refl$ne' style='left: $ne"."em; top: $Re"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($Ge-$Re)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(145),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$l){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Bc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$Zd=preg_match('~sql~',$_POST["format"]);if($Zd){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$Ah=$_POST["db_style"];$i=array(DB);if(DB==""){$i=$_POST["databases"];if(is_string($i))$i=explode("\n",rtrim(str_replace("\r","",$i),"\n"));}foreach((array)$i
as$j){adminer()->dumpDatabase($j);if(connection()->select_db($j)){if($Zd){if($Ah)echo
use_sql($j,$Ah).";\n\n";$If="";if($_POST["types"]){foreach(types()as$u=>$U){$qc=type_values($u);if($qc)$If
.=($Ah!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($qc);\n\n";else$If
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$M){$E=$M["ROUTINE_NAME"];$Og=$M["ROUTINE_TYPE"];$h=create_routine($Og,array("name"=>$E)+routine($M["SPECIFIC_NAME"],$Og));set_utf8mb4($h);$If
.=($Ah!='DROP+CREATE'?"DROP $Og IF EXISTS ".idf_escape($E).";;\n":"")."$h;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$M){$h=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($M["Name"]),3));set_utf8mb4($h);$If
.=($Ah!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($M["Name"]).";;\n":"")."$h;;\n\n";}}echo($If&&JUSH=='sql'?"DELIMITER ;;\n\n$If"."DELIMITER ;\n\n":$If);}if($_POST["table_style"]||$_POST["data_style"]){$Ni=array();foreach(table_status('',true)as$E=>$S){$R=(DB==""||in_array($E,(array)$_POST["tables"]));$Bb=(DB==""||in_array($E,(array)$_POST["data"]));if($R||$Bb){$ci=null;if($Bc=="tar"){$ci=new
TmpFile;ob_start(array($ci,'write'),1e5);}adminer()->dumpTable($E,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Ni[]=$E;elseif($Bb){$n=fields($E);adminer()->dumpData($E,$_POST["data_style"],"SELECT *".convert_fields($n,$n)." FROM ".table($E));}if($Zd&&$_POST["triggers"]&&$R&&($ni=trigger_sql($E)))echo"\nDELIMITER ;;\n$ni\nDELIMITER ;\n";if($Bc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$j/")."$E.csv",$ci);}elseif($Zd)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$E=>$S){$R=(DB==""||in_array($E,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($E);}}foreach($Ni
as$Mi)adminer()->dumpTable($Mi,$_POST["table_style"],1);if($Bc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(67),$l,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Fb=array('','USE','DROP+CREATE','CREATE');$Kh=array('','DROP+CREATE','CREATE');$Cb=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Cb[]='INSERT+UPDATE';$M=get_settings("adminer_export");if(!$M)$M=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($M["events"])){$M["routines"]=$M["events"]=($_GET["dump"]=="");$M["triggers"]=$M["table_style"];}echo"<tr><th>".lang(146)."<td>".html_radios("output",adminer()->dumpOutput(),$M["output"])."\n","<tr><th>".lang(147)."<td>".html_radios("format",adminer()->dumpFormat(),$M["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(28)."<td>".html_select('db_style',$Fb,$M["db_style"]).(support("type")?checkbox("types",1,$M["types"],lang(6)):"").(support("routine")?checkbox("routines",1,$M["routines"],lang(63)):"").(support("event")?checkbox("events",1,$M["events"],lang(65)):"")),"<tr><th>".lang(123)."<td>".html_select('table_style',$Kh,$M["table_style"]).checkbox("auto_increment",1,$M["auto_increment"],lang(42)).(support("trigger")?checkbox("triggers",1,$M["triggers"],lang(142)):""),"<tr><th>".lang(148)."<td>".html_select('data_style',$Cb,$M["data_style"]),'</table>
<p><input type="submit" value="',lang(67),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$mg=array();if(DB!=""){$Ua=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Ua>".lang(123)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(148)."<input type='checkbox' id='check-data'$Ua></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Ni="";$Mh=tables_list();foreach($Mh
as$E=>$U){$lg=preg_replace('~_.*~','',$E);$Ua=($a==""||$a==(substr($a,-1)=="%"?"$lg%":$E));$og="<tr><td>".checkbox("tables[]",$E,$Ua,$E,"","block");if($U!==null&&!preg_match('~table~i',$U))$Ni
.="$og\n";else
echo"$og<td align='right'><label class='block'><span id='Rows-".h($E)."'></span>".checkbox("data[]",$E,$Ua)."</label>\n";$mg[$lg]++;}echo$Ni;if($Mh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(28)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$i=adminer()->databases();if($i){foreach($i
as$j){if(!information_schema($j)){$lg=preg_replace('~_.*~','',$j);echo"<tr><td>".checkbox("databases[]",$j,$a==""||$a=="$lg%",$j,"","block")."\n";$mg[$lg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Oc=true;foreach($mg
as$z=>$X){if($z!=""&&$X>1){echo($Oc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$z%")."'>".h($z)."</a>";$Oc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(62));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(149)."</a>";$K=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$ed=$K;if(!$K)$K=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($ed?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(26)."<th>".lang(25)."<th></thead>\n";while($M=$K->fetch_assoc())echo'<tr><td>'.h($M["User"])."<td>".h($M["Host"]).'<td><a href="'.h(ME.'user='.urlencode($M["User"]).'&host='.urlencode($M["Host"])).'">'.lang(12)."</a>\n";if(!$ed||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(12)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$l&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");if($_POST["format"]=="sql")echo"$_POST[query]\n";else{adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();}exit;}restart_session();$td=&get_session("queries");$sd=&$td[DB];if(!$l&&$_POST["clear"]){$sd=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(66):lang(55)),$l);$ue='--'.(JUSH=='sql'?' ':'');if(!$l&&$_POST){$q=false;if(!isset($_GET["import"]))$J=$_POST["query"];elseif($_POST["webfile"]){$rh=adminer()->importServerPath();$q=@fopen((file_exists($rh)?$rh:"compress.zlib://$rh.gz"),"rb");$J=($q?fread($q,1e6):false);}else$J=get_file("sql_file",true,";");if(is_string($J)){if(function_exists('memory_get_usage')&&($Le=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Le,strval(2*strlen($J)+memory_get_usage()+8e6)));if($J!=""&&strlen($J)<1e6){$I=$J.(preg_match("~;[ \t\r\n]*\$~",$J)?"":";");if(!$sd||first(end($sd))!=$I){restart_session();$sd[]=array($I,time());set_session("queries",$td);stop_session();}}$ph="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|$ue)[^\n]*\n?|--\r?\n)";$Nb=";";$jf=0;$kc=true;$g=connect();if($g&&DB!=""){$g->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$g);}$gb=0;$sc=array();$Of='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|'.$ue.'|$'.(JUSH=="pgsql"?'|\$([a-zA-Z]\w*)?\$':'');$gi=microtime(true);$ja=get_settings("adminer_import");while($J!=""){if(!$jf&&preg_match("~^$ph*+DELIMITER\\s+(\\S+)~i",$J,$C)){$Nb=preg_quote($C[1]);$J=substr($J,strlen($C[0]));}elseif(!$jf&&JUSH=='pgsql'&&preg_match("~^($ph*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$J,$C)){$Nb="\n\\\\\\.\r?\n";$jf=strlen($C[0]);}else{preg_match("($Nb\\s*|$Of)",$J,$C,PREG_OFFSET_CAPTURE,$jf);list($Xc,$gg)=$C[0];if(!$Xc&&$q&&!feof($q))$J
.=fread($q,1e5);else{if(!$Xc&&rtrim($J)=="")break;$jf=$gg+strlen($Xc);if($Xc&&!preg_match("(^$Nb)",$Xc)){$Na=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($gg>0&&strtolower($J[$gg-1])=="e"));$Zf=($Xc=='/*'?'\*/':($Xc=='['?']':(preg_match("~^$ue|^#~",$Xc)?"\n":preg_quote($Xc).($Na?'|\\\\.':''))));while(preg_match("($Zf|\$)s",$J,$C,PREG_OFFSET_CAPTURE,$jf)){$Rg=$C[0][0];if(!$Rg&&$q&&!feof($q))$J
.=fread($q,1e5);else{$jf=$C[0][1]+strlen($Rg);if(!$Rg||$Rg[0]!="\\")break;}}}else{$kc=false;$I=substr($J,0,$gg+($Nb[0]=="\n"?3:0));$gb++;$og="<pre id='sql-$gb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($I)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$ph*+ATTACH\\b~i",$I,$C)){echo$og,"<p class='error'>".lang(150)."\n";$sc[]=" <a href='#sql-$gb'>$gb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$og;ob_flush();flush();}$vh=microtime(true);if(connection()->multi_query($I)&&$g&&preg_match("~^$ph*+USE\\b~i",$I))$g->query($I);do{$K=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$og:""),"<p class='error'>".lang(151).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$sc[]=" <a href='#sql-$gb'>$gb</a>";if($_POST["error_stops"])break
2;}else{$Vh=" <span class='time'>(".format_time($vh).")</span>".(strlen($I)<1000?" <a href='".h(ME)."sql=".urlencode(trim($I))."'>".lang(12)."</a>":"");$la=connection()->affected_rows;$Qi=($_POST["only_errors"]?"":driver()->warnings());$Ri="warnings-$gb";if($Qi)$Vh
.=", <a href='#$Ri'>".lang(37)."</a>".script("qsl('a').onclick = partial(toggle, '$Ri');","");$_c=null;$Bf=null;$Ac="explain-$gb";if(is_object($K)){$_=$_POST["limit"];$Bf=print_select_result($K,$g,array(),$_);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$hf=$K->num_rows;echo"<p class='sql-footer'>".($hf?($_&&$hf>$_?lang(152,$_):"").lang(153,$hf):""),$Vh;if($g&&preg_match("~^($ph|\\()*+SELECT\\b~i",$I)&&($_c=explain($g,$I)))echo", <a href='#$Ac'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Ac');","");$u="export-$gb";echo", <a href='#$u'>".lang(67)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$ja["output"])." ".html_select("format",adminer()->dumpFormat(),$ja["format"]).input_hidden("query",$I)."<input type='submit' name='export' value='".lang(67)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$ph*+(CREATE|DROP|ALTER)$ph++(DATABASE|SCHEMA)\\b~i",$I)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(154,$la)."$Vh\n";}echo($Qi?"<div id='$Ri' class='hidden'>\n$Qi</div>\n":"");if($_c){echo"<div id='$Ac' class='hidden explain'>\n";print_select_result($_c,$g,$Bf);echo"</div>\n";}}$vh=microtime(true);}while(connection()->next_result());}$J=substr($J,$jf);$jf=0;}}}}if($kc)echo"<p class='message'>".lang(155)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(156,$gb-count($sc))," <span class='time'>(".format_time($gi).")</span>\n";elseif($sc&&$gb>1)echo"<p class='error'>".lang(151).": ".implode("",$sc)."\n";}else
echo"<p class='error'>".upload_error($J)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$yc="<input type='submit' value='".lang(157)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$I=$_GET["sql"];if($_POST)$I=$_POST["query"];elseif($_GET["history"]=="all")$I=$sd;elseif($_GET["history"]!="")$I=idx($sd[$_GET["history"]],0);echo"<p>";textarea("query",$I,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$yc\n",lang(158).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{$jd=(extension_loaded("zlib")?"[.gz]":"");echo"<fieldset><legend>".lang(159)."</legend><div>",file_input("SQL$jd: <input type='file' name='sql_file[]' multiple>\n$yc"),"</div></fieldset>\n";$Cd=adminer()->importServerPath();if($Cd)echo"<fieldset><legend>".lang(160)."</legend><div>",lang(161,"<code>".h($Cd)."$jd</code>"),' <input type="submit" name="webfile" value="'.lang(162).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(163))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(164))."\n",input_token();if(!isset($_GET["import"])&&$sd){print_fieldset("history",lang(165),$_GET["history"]!="");for($X=end($sd);$X;$X=prev($sd)){$z=key($sd);list($I,$Vh,$fc)=$X;echo'<a href="'.h(ME."sql=&history=$z").'">'.lang(12)."</a>"." <span class='time' title='".@date('Y-m-d',$Vh)."'>".@date("H:i:s",$Vh)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace("~^(#|$ue).*~m",'',$I)))),80,"</code>").($fc?" <span class='time'>($fc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(166)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(167)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$n=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$n):""):where($_GET,$n));$yi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($n
as$E=>$m){if(!isset($m["privileges"][$yi?"update":"insert"])||adminer()->fieldName($m)==""||$m["generated"])unset($n[$E]);}if($_POST&&!$l&&!isset($_GET["select"])){$B=$_POST["referer"];if($_POST["insert"])$B=($yi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$B))$B=ME."select=".urlencode($a);$x=indexes($a);$ti=unique_array($_GET["where"],$x);$xg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($B,lang(168),driver()->delete($a,$xg,$ti?0:1));else{$Q=array();foreach($n
as$E=>$m){$X=process_input($m);if($X!==false&&$X!==null)$Q[idf_escape($E)]=$X;}if($yi){if(!$Q)redirect($B);queries_redirect($B,lang(169),driver()->update($a,$Q,$xg,$ti?0:1));if(is_ajax()){page_headers();page_messages($l);exit;}}else{$K=driver()->insert($a,$Q);$me=($K?last_id($K):0);queries_redirect($B,lang(170,($me?" $me":"")),$K);}}}$M=null;if($_POST["save"])$M=(array)$_POST["fields"];elseif($Z){$O=array();foreach($n
as$E=>$m){if(isset($m["privileges"]["select"])){$ua=($_POST["clone"]&&$m["auto_increment"]?"''":convert_field($m));$O[]=($ua?"$ua AS ":"").idf_escape($E);}}$M=array();if(!support("table"))$O=array("*");if($O){$K=driver()->select($a,$O,array($Z),$O,array(),(isset($_GET["select"])?2:1));if(!$K)$l=error();else{$M=$K->fetch_assoc();if(!$M)$M=false;}if(isset($_GET["select"])&&(!$M||$K->fetch_assoc()))$M=null;}}if(!support("table")&&!$n){if(!$Z){$K=driver()->select($a,array("*"),array(),array("*"));$M=($K?$K->fetch_assoc():false);if(!$M)$M=array(driver()->primary=>"");}if($M){foreach($M
as$z=>$X){if(!$Z)$M[$z]=null;$n[$z]=array("field"=>$z,"null"=>($z!=driver()->primary),"auto_increment"=>($z==driver()->primary));}}}edit_form($a,$n,$M,$yi,$l);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Sf=driver()->partitionBy;$Wf=($Sf?driver()->partitionsInfo($a):array());$Cg=referencable_primary($a);$Vc=array();foreach($Cg
as$Hh=>$m)$Vc[str_replace("`","``",$Hh)."`".str_replace("`","``",$m["field"])]=$Hh;$Ef=array();$S=array();if($a!=""){$Ef=fields($a);$S=table_status1($a);if(count($S)<2)$l=lang(11);}$M=$_POST;$M["fields"]=(array)$M["fields"];if($M["auto_increment_col"])$M["fields"][$M["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($M["fields"])&&!$l){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(171),drop_tables(array($a)));else{$n=array();$pa=array();$Di=false;$Tc=array();$Df=reset($Ef);$na=" FIRST";foreach($M["fields"]as$z=>$m){$p=$Vc[$m["type"]];$oi=($p!==null?$Cg[$p]:$m);if($m["field"]!=""){if(!$m["generated"])$m["default"]=null;$tg=process_field($m,$oi);$pa[]=array($m["orig"],$tg,$na);if(!$Df||$tg!==process_field($Df,$Df)){$n[]=array($m["orig"],$tg,$na);if($m["orig"]!=""||$na)$Di=true;}if($p!==null)$Tc[idf_escape($m["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$Vc[$m["type"]],'source'=>array($m["field"]),'target'=>array($oi["field"]),'on_delete'=>$m["on_delete"],));$na=" AFTER ".idf_escape($m["field"]);}elseif($m["orig"]!=""){$Di=true;$n[]=array($m["orig"]);}if($m["orig"]!=""){$Df=next($Ef);if(!$Df)$na="";}}$Uf=array();if(in_array($M["partition_by"],$Sf)){foreach($M
as$z=>$X){if(preg_match('~^partition~',$z))$Uf[$z]=$X;}foreach($Uf["partition_names"]as$z=>$E){if($E==""){unset($Uf["partition_names"][$z]);unset($Uf["partition_values"][$z]);}}$Uf["partition_names"]=array_values($Uf["partition_names"]);$Uf["partition_values"]=array_values($Uf["partition_values"]);if($Uf==$Wf)$Uf=array();}elseif(preg_match("~partitioned~",$S["Create_options"]))$Uf=null;$D=lang(172);if($a==""){cookie("adminer_engine",$M["Engine"]);$D=lang(173);}$E=trim($M["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($E),$D,alter_table($a,$E,(JUSH=="sqlite"&&($Di||$Tc)?$pa:$n),$Tc,($M["Comment"]!=$S["Comment"]?$M["Comment"]:null),($M["Engine"]&&$M["Engine"]!=$S["Engine"]?$M["Engine"]:""),($M["Collation"]&&$M["Collation"]!=$S["Collation"]?$M["Collation"]:""),($M["Auto_increment"]!=""?number($M["Auto_increment"]):""),$Uf));}}page_header(($a!=""?lang(34):lang(68)),$l,array("table"=>$a),h($a));if(!$_POST){$qi=driver()->types();$M=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($qi["int"])?"int":(isset($qi["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$M=$S;$M["name"]=$a;$M["fields"]=array();if(!$_GET["auto_increment"])$M["Auto_increment"]="";foreach($Ef
as$m){$m["generated"]=$m["generated"]?:(isset($m["default"])?"DEFAULT":"");$M["fields"][]=$m;}if($Sf){$M+=$Wf;$M["partition_names"][]="";$M["partition_values"][]="";}}}$b=collations();if(is_array(reset($b)))$b=call_user_func_array('array_merge',array_values($b));$mc=driver()->engines();foreach($mc
as$lc){if(!strcasecmp($lc,$M["Engine"])){$M["Engine"]=$lc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(174).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($M["name"])."' autocapitalize='off'>\n",($mc?html_select("Engine",array(""=>"(".lang(175).")")+$mc,$M["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($b)echo"<datalist id='collations'>".optionlist($b)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($M["Collation"])."' placeholder='(".lang(101).")'>\n");echo"<input type='submit' value='".lang(16)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($M["fields"],$b,"TABLE",$Vc);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(42).": <input type='number' name='Auto_increment' class='size' value='".h($M["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(176),"columnShow(this.checked, 5)","jsonly");$jb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$jb,lang(41),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$M["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($jb?"":" class='hidden'").">".h($M["Comment"])."</textarea>":'<input name="Comment" value="'.h($M["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($jb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(16),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,$a));if($Sf&&(JUSH=='sql'||$a=="")){$Tf=preg_match('~RANGE|LIST~',$M["partition_by"]);print_fieldset("partition",lang(178),$M["partition_by"]);echo"<p>".html_select("partition_by",array_merge(array(""),$Sf),$M["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($M["partition"])."'>)\n",lang(179).": <input type='number' name='partitions' class='size".($Tf||!$M["partition_by"]?" hidden":"")."' value='".h($M["partitions"])."'>\n","<table id='partition-table'".($Tf?"":" class='hidden'").">\n","<thead><tr><th>".lang(180)."<th>".lang(181)."</thead>\n";foreach($M["partition_names"]as$z=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($z==count($M["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($M["partition_values"],$z)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Jd=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);$Hd=driver()->indexAlgorithms($S);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Jd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Jd[]="SPATIAL";$x=indexes($a);$n=fields($a);$ng=array();if(JUSH=="mongo"){$ng=$x["_id_"];unset($Jd[0]);unset($x["_id_"]);}$M=$_POST;if($M)save_settings(array("index_options"=>$M["options"]));if($_POST&&!$l&&!$_POST["add"]&&!$_POST["drop_col"]){$qa=array();foreach($M["indexes"]as$w){$E=$w["name"];if(in_array($w["type"],$Jd)){$d=array();$se=array();$Qb=array();$Id=(support("partial_indexes")?$w["partial"]:"");$Gd=(in_array($w["algorithm"],$Hd)?$w["algorithm"]:"");$Q=array();ksort($w["columns"]);foreach($w["columns"]as$z=>$c){if($c!=""){$re=idx($w["lengths"],$z);$Ob=idx($w["descs"],$z);$Q[]=($n[$c]?idf_escape($c):$c).($re?"(".(+$re).")":"").($Ob?" DESC":"");$d[]=$c;$se[]=($re?:null);$Qb[]=$Ob;}}$zc=$x[$E];if($zc){ksort($zc["columns"]);ksort($zc["lengths"]);ksort($zc["descs"]);if($w["type"]==$zc["type"]&&array_values($zc["columns"])===$d&&(!$zc["lengths"]||array_values($zc["lengths"])===$se)&&array_values($zc["descs"])===$Qb&&$zc["partial"]==$Id&&(!$Hd||$zc["algorithm"]==$Gd)){unset($x[$E]);continue;}}if($d)$qa[]=array($w["type"],$E,$Q,$Gd,$Id);}}foreach($x
as$E=>$zc)$qa[]=array($zc["type"],$E,"DROP");if(!$qa)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(182),alter_indexes($a,$qa));}page_header(lang(134),$l,array("table"=>$a),h($a));$Lc=array_keys($n);if($_POST["add"]){foreach($M["indexes"]as$z=>$w){if($w["columns"][count($w["columns"])]!="")$M["indexes"][$z]["columns"][]="";}$w=end($M["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$M["indexes"][]=array("columns"=>array(1=>""));}if(!$M){foreach($x
as$z=>$w){$x[$z]["name"]=$z;$x[$z]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$M["indexes"]=$x;}$se=(JUSH=="sql"||JUSH=="mssql");$jh=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(183);$Ad=" class='idxopts".($jh?"":" hidden")."'";if($Hd)echo"<th id='label-algorithm'$Ad>".lang(184).doc_link(array('sql'=>'create-index.html#create-index-storage-engine-index-types','mariadb'=>'storage-engine-index-types/',));echo'<th><input type="submit" class="wayoff">',lang(185).($se?"<span$Ad> (".lang(186).")</span>":"");if($se||support("descidx"))echo
checkbox("options",1,$jh,lang(107),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(187);if(support("partial_indexes"))echo"<th id='label-condition'$Ad>".lang(188);echo'<th><noscript>',icon("plus","add[0]","+",lang(108)),'</noscript>
</thead>
';if($ng){echo"<tr><td>PRIMARY<td>";foreach($ng["columns"]as$z=>$c)echo
select_input(" disabled",$Lc,$c),"<label><input disabled type='checkbox'>".lang(50)."</label> ";echo"<td><td>\n";}$y=1;foreach($M["indexes"]as$w){if(!$_POST["drop_col"]||$y!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$y][type]",array(-1=>"")+$Jd,$w["type"],($y==count($M["indexes"])?"indexesAddRow.call(this);":""),"label-type");if($Hd)echo"<td$Ad>".html_select("indexes[$y][algorithm]",array_merge(array(""),$Hd),$w['algorithm'],"label-algorithm");echo"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$z=>$c){echo"<span>".select_input(" name='indexes[$y][columns][$t]' title='".lang(39)."'",($n&&($c==""||$n[$c])?array_combine($Lc,$Lc):array()),$c,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span$Ad>",($se?"<input type='number' name='indexes[$y][lengths][$t]' class='size' value='".h(idx($w["lengths"],$z))."' title='".lang(106)."'>":""),(support("descidx")?checkbox("indexes[$y][descs][$t]",1,idx($w["descs"],$z),lang(50)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$y][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n";if(support("partial_indexes"))echo"<td$Ad><input name='indexes[$y][partial]' value='".h($w["partial"])."' autocapitalize='off' aria-labelledby='label-condition'>\n";echo"<td>".icon("cross","drop_col[$y]","x",lang(111)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$y++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(16),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$M=$_POST;if($_POST&&!$l&&!$_POST["add"]){$E=trim($M["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(189),drop_databases(array(DB)));}elseif(DB!==$E){if(DB!=""){$_GET["db"]=$E;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($E),lang(190),rename_database($E,$M["collation"]));}else{$i=explode("\n",str_replace("\r","",$E));$Bh=true;$le="";foreach($i
as$j){if(count($i)==1||$j!=""){if(!create_database($j,$M["collation"]))$Bh=false;$le=$j;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($le),lang(191),$Bh);}}else{if(!$M["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($E).(preg_match('~^[a-z0-9_]+$~i',$M["collation"])?" COLLATE $M[collation]":""),substr(ME,0,-1),lang(192));}}page_header(DB!=""?lang(58):lang(115),$l,array(),h(DB));$b=collations();$E=DB;if($_POST)$E=$M["name"];elseif(DB!="")$M["collation"]=db_collation(DB,$b);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$ed){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$ed,$C)&&$C[1]){$E=stripcslashes(idf_unescape("`$C[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($E,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($E).'</textarea><br>':'<input name="name" autofocus value="'.h($E).'" data-maxlength="64" autocapitalize="off">')."\n".($b?html_select("collation",array(""=>"(".lang(101).")")+$b,$M["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",)):""),'<input type="submit" value="',lang(16),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(177,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(108))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(193).": ".h($ca),$l);$Og=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Dd=array();$If=array();foreach($Og["fields"]as$t=>$m){if(substr($m["inout"],-3)=="OUT"&&JUSH=='sql')$If[$t]="@".idf_escape($m["field"])." AS ".idf_escape($m["field"]);if(!$m["inout"]||substr($m["inout"],0,2)=="IN")$Dd[]=$t;}if(!$l&&$_POST){$Oa=array();foreach($Og["fields"]as$z=>$m){$X="";if(in_array($z,$Dd)){$X=process_input($m);if($X===false)$X="''";if(isset($If[$z]))connection()->query("SET @".idf_escape($m["field"])." = $X");}if(isset($If[$z]))$Oa[]="@".idf_escape($m["field"]);elseif(in_array($z,$Dd))$Oa[]=$X;}$J=(isset($_GET["callf"])?"SELECT ":"CALL ").($Og["returns"]["type"]=="record"?"* FROM ":"").table($ca)."(".implode(", ",$Oa).")";$vh=microtime(true);$K=connection()->multi_query($J);$la=connection()->affected_rows;echo
adminer()->selectQuery($J,$vh,!$K);if(!$K)echo"<p class='error'>".error()."\n";else{$g=connect();if($g)$g->select_db(DB);do{$K=connection()->store_result();if(is_object($K))print_select_result($K,$g);else
echo"<p class='message'>".lang(194,$la)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($If)print_select_result(connection()->query("SELECT ".implode(", ",$If)));}}echo'
<form action="" method="post">
';if($Dd){echo"<table class='layout'>\n";foreach($Dd
as$z){$m=$Og["fields"][$z];$E=$m["field"];echo"<tr><th>".adminer()->fieldName($m);$Y=idx($_POST["fields"],$E);if($Y!=""){if($m["type"]=="set")$Y=implode(",",$Y);}input($m,$Y,idx($_POST["function"],$E,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(193),'">
',input_token(),'</form>

<pre>
';function
pre_tr($Rg){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Rg))));}$R='(\+--[-+]+\+\n)';$M='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$M$R?($M*)$R?~m",function($C){$Pc=pre_tr($C[2]);return"<table>\n".($C[1]?"<thead>$Pc</thead>\n":$Pc).pre_tr($C[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($Og['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$E=$_GET["name"];$M=$_POST;if($_POST&&!$l&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$M["source"]=array_filter($M["source"],'strlen');ksort($M["source"]);$Ph=array();foreach($M["source"]as$z=>$X)$Ph[$z]=$M["target"][$z];$M["target"]=$Ph;}if(JUSH=="sqlite")$K=recreate_table($a,$a,array(),array(),array(" $E"=>($M["drop"]?"":" ".format_foreign_key($M))));else{$qa="ALTER TABLE ".table($a);$K=($E==""||queries("$qa DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($E)));if(!$M["drop"])$K=queries("$qa ADD".format_foreign_key($M));}queries_redirect(ME."table=".urlencode($a),($M["drop"]?lang(195):($E!=""?lang(196):lang(197))),$K);if(!$M["drop"])$l=lang(198);}page_header(lang(199),$l,array("table"=>$a),h($a));if($_POST){ksort($M["source"]);if($_POST["add"])$M["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$M["target"]=array();}elseif($E!=""){$Vc=foreign_keys($a);$M=$Vc[$E];$M["source"][]="";}else{$M["table"]=$a;$M["source"]=array("");}echo'
<form action="" method="post">
';$oh=array_keys(fields($a));if($M["db"]!="")connection()->select_db($M["db"]);if($M["ns"]!=""){$Ff=get_schema();set_schema($M["ns"]);}$Bg=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$Ph=array_keys(fields(in_array($M["table"],$Bg)?$M["table"]:reset($Bg)));$rf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(200).": ".html_select("table",$Bg,$M["table"],$rf)."</label>\n";if(JUSH!="sqlite"){$Gb=array();foreach(adminer()->databases()as$j){if(!information_schema($j))$Gb[]=$j;}echo"<label>".lang(69).": ".html_select("db",$Gb,$M["db"]!=""?$M["db"]:$_GET["db"],$rf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(201),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(136),'<th id="label-target">',lang(137),'</thead>
';$y=0;foreach($M["source"]as$z=>$X){echo"<tr>","<td>".html_select("source[".(+$z)."]",array(-1=>"")+$oh,$X,($y==count($M["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$z)."]",$Ph,idx($M["target"],$z),"","label-target");$y++;}echo'</table>
<p>
<label>',lang(103),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$M["on_delete"]),'</label>
<label>',lang(102),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$M["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",)),'<p>
<input type="submit" value="',lang(16),'">
<noscript><p><input type="submit" name="add" value="',lang(202),'"></noscript>
';if($E!="")echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,$E));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$M=$_POST;$Gf="VIEW";if(JUSH=="pgsql"&&$a!=""){$wh=table_status1($a);$Gf=strtoupper($wh["Engine"]);}if($_POST&&!$l){$E=trim($M["name"]);$ua=" AS\n$M[select]";$B=ME."table=".urlencode($E);$D=lang(203);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$E&&JUSH!="sqlite"&&$U=="VIEW"&&$Gf=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($E).$ua,$B,$D);else{$Rh=$E."_adminer_".uniqid();drop_create("DROP $Gf ".table($a),"CREATE $U ".table($E).$ua,"DROP $U ".table($E),"CREATE $U ".table($Rh).$ua,"DROP $U ".table($Rh),($_POST["drop"]?substr(ME,0,-1):$B),lang(204),$D,lang(205),$a,$E);}}if(!$_POST&&$a!=""){$M=view($a);$M["name"]=$a;$M["materialized"]=($Gf!="VIEW");if(!$l)$l=error();}page_header(($a!=""?lang(35):lang(206)),$l,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(187),': <input name="name" value="',h($M["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$M["materialized"],lang(130)):""),'<p>';textarea("select",$M["select"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Td=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$xh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$M=$_POST;if($_POST&&!$l){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(207));elseif(in_array($M["INTERVAL_FIELD"],$Td)&&isset($xh[$M["STATUS"]])){$Sg="\nON SCHEDULE ".($M["INTERVAL_VALUE"]?"EVERY ".q($M["INTERVAL_VALUE"])." $M[INTERVAL_FIELD]".($M["STARTS"]?" STARTS ".q($M["STARTS"]):"").($M["ENDS"]?" ENDS ".q($M["ENDS"]):""):"AT ".q($M["STARTS"]))." ON COMPLETION".($M["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(208):lang(209)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Sg.($aa!=$M["EVENT_NAME"]?"\nRENAME TO ".idf_escape($M["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($M["EVENT_NAME"]).$Sg)."\n".$xh[$M["STATUS"]]." COMMENT ".q($M["EVENT_COMMENT"]).rtrim(" DO\n$M[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(210).": ".h($aa):lang(211)),$l);if(!$M&&$aa!=""){$N=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$M=reset($N);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(187),'<td><input name="EVENT_NAME" value="',h($M["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(212),'<td><input name="STARTS" value="',h("$M[EXECUTE_AT]$M[STARTS]"),'">
<tr><th title="datetime">',lang(213),'<td><input name="ENDS" value="',h($M["ENDS"]),'">
<tr><th>',lang(214),'<td><input type="number" name="INTERVAL_VALUE" value="',h($M["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Td,$M["INTERVAL_FIELD"]),'<tr><th>',lang(118),'<td>',html_select("STATUS",$xh,$M["STATUS"]),'<tr><th>',lang(41),'<td><input name="EVENT_COMMENT" value="',h($M["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$M["ON_COMPLETION"]=="PRESERVE",lang(215)),'</table>
<p>';textarea("EVENT_DEFINITION",$M["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$Og=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$M=$_POST;$M["fields"]=(array)$M["fields"];if($_POST&&!process_fields($M["fields"])&&!$l){$Cf=routine($_GET["procedure"],$Og);$Rh="$M[name]_adminer_".uniqid();foreach($M["fields"]as$z=>$m){if($m["field"]=="")unset($M["fields"][$z]);}drop_create("DROP $Og ".routine_id($ca,$Cf),create_routine($Og,$M),"DROP $Og ".routine_id($M["name"],$M),create_routine($Og,array("name"=>$Rh)+$M),"DROP $Og ".routine_id($Rh,$M),substr(ME,0,-1),lang(216),lang(217),lang(218),$ca,$M["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(219):lang(220)).": ".h($ca):(isset($_GET["function"])?lang(221):lang(222))),$l);if(!$_POST){if($ca=="")$M["language"]="sql";else{$M=routine($_GET["procedure"],$Og);$M["name"]=$ca;}}$b=get_vals("SHOW CHARACTER SET");sort($b);$Pg=routine_languages();echo($b?"<datalist id='collations'>".optionlist($b)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(187),': <input name="name" value="',h($M["name"]),'" data-maxlength="64" autocapitalize="off">
',($Pg?"<label>".lang(21).": ".html_select("language",$Pg,$M["language"])."</label>\n":""),'<input type="submit" value="',lang(16),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($M["fields"],$b,$Og);if(isset($_GET["function"])){echo"<tr><td>".lang(223);edit_type("returns",(array)$M["returns"],$b,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$M["definition"],20);echo'<p>
<input type="submit" value="',lang(16),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$E=$_GET["name"];$M=$_POST;if($M&&!$l){if(JUSH=="sqlite")$K=recreate_table($a,$a,array(),array(),array(),"",array(),"$E",($M["drop"]?"":$M["clause"]));else{$K=($E==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($E)));if(!$M["drop"])$K=queries("ALTER TABLE ".table($a)." ADD".($M["name"]!=""?" CONSTRAINT ".idf_escape($M["name"]):"")." CHECK ($M[clause])");}queries_redirect(ME."table=".urlencode($a),($M["drop"]?lang(224):($E!=""?lang(225):lang(226))),$K);}page_header(($E!=""?lang(227).": ".h($E):lang(141)),$l,array("table"=>$a));if(!$M){$Va=driver()->checkConstraints($a);$M=array("name"=>$E,"clause"=>$Va[$E]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(187).': <input name="name" value="'.h($M["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",),"?"),'<p>';textarea("clause",$M["clause"]);echo'<p><input type="submit" value="',lang(16),'">
';if($E!="")echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,$E));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$E="$_GET[name]";$mi=trigger_options();$M=(array)trigger($E,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$l&&in_array($_POST["Timing"],$mi["Timing"])&&in_array($_POST["Event"],$mi["Event"])&&in_array($_POST["Type"],$mi["Type"])){$pf=" ON ".table($a);$Yb="DROP TRIGGER ".idf_escape($E).(JUSH=="pgsql"?$pf:"");$B=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($Yb,$B,lang(228));else{if($E!="")queries($Yb);queries_redirect($B,($E!=""?lang(229):lang(230)),queries(create_trigger($pf,$_POST)));if($E!="")queries(create_trigger($pf,$M+array("Type"=>reset($mi["Type"]))));}}$M=$_POST;}page_header(($E!=""?lang(231).": ".h($E):lang(232)),$l,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(233),'<td>',html_select("Timing",$mi["Timing"],$M["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(234),'<td>',html_select("Event",$mi["Event"],$M["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$mi["Event"])?" <input name='Of' value='".h($M["Of"])."' class='hidden'>":""),'<tr><th>',lang(40),'<td>',html_select("Type",$mi["Type"],$M["Type"]),'</table>
<p>',lang(187),': <input name="Trigger" value="',h($M["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$M["Statement"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($E!="")echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,$E));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ea=$_GET["user"];$rg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$M){foreach(explode(",",($M["Privilege"]=="Grant option"?"":$M["Context"]))as$qb)$rg[$qb][$M["Privilege"]]=$M["Comment"];}$rg["Server Admin"]+=$rg["File access on server"];$rg["Databases"]["Create routine"]=$rg["Procedures"]["Create routine"];unset($rg["Procedures"]["Create routine"]);$rg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$rg["Columns"][$X]=$rg["Tables"][$X];unset($rg["Server Admin"]["Usage"]);foreach($rg["Tables"]as$z=>$X)unset($rg["Databases"][$z]);$af=array();if($_POST){foreach($_POST["objects"]as$z=>$X)$af[$X]=(array)$af[$X]+idx($_POST["grants"],$z,array());}$fd=array();$nf="";if(isset($_GET["host"])&&($K=connection()->query("SHOW GRANTS FOR ".q($ea)."@".q($_GET["host"])))){while($M=$K->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$M[0],$C)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$C[1],$Ae,PREG_SET_ORDER)){foreach($Ae
as$X){if($X[1]!="USAGE")$fd["$C[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$M[0]))$fd["$C[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$M[0],$C))$nf=$C[1];}}if($_POST&&!$l){$of=(isset($_GET["host"])?q($ea)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $of",ME."privileges=",lang(235));else{$cf=q($_POST["user"])."@".q($_POST["host"]);$Xf=$_POST["pass"];if($Xf!=''&&!$_POST["hashed"]&&!min_version(8)){$Xf=get_val("SELECT PASSWORD(".q($Xf).")");$l=!$Xf;}$vb=false;if(!$l){if($of!=$cf){$vb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $cf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Xf));$l=!$vb;}elseif($Xf!=$nf)queries("SET PASSWORD FOR $cf = ".q($Xf));}if(!$l){$Lg=array();foreach($af
as$if=>$ed){if(isset($_GET["grant"]))$ed=array_filter($ed);$ed=array_keys($ed);if(isset($_GET["grant"]))$Lg=array_diff(array_keys(array_filter($af[$if],'strlen')),$ed);elseif($of==$cf){$lf=array_keys((array)$fd[$if]);$Lg=array_diff($lf,$ed);$ed=array_diff($ed,$lf);unset($fd[$if]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$if,$C)&&(!grant("REVOKE",$Lg,$C[2]," ON $C[1] FROM $cf")||!grant("GRANT",$ed,$C[2]," ON $C[1] TO $cf"))){$l=true;break;}}}if(!$l&&isset($_GET["host"])){if($of!=$cf)queries("DROP USER $of");elseif(!isset($_GET["grant"])){foreach($fd
as$if=>$Lg){if(preg_match('~^(.+)(\(.*\))?$~U',$if,$C))grant("REVOKE",array_keys($Lg),$C[2]," ON $C[1] FROM $cf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(236):lang(237)),!$l);if($vb)connection()->query("DROP USER $cf");}}page_header((isset($_GET["host"])?lang(26).": ".h("$ea@$_GET[host]"):lang(149)),$l,array("privileges"=>array('',lang(62))));$M=$_POST;if($M)$fd=$af;else{$M=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$M["pass"]=$nf;if($nf!="")$M["hashed"]=true;$fd[(DB==""||$fd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(25),'<td><input name="host" data-maxlength="60" value="',h($M["host"]),'" autocapitalize="off">
<tr><th>',lang(26),'<td><input name="user" data-maxlength="80" value="',h($M["user"]),'" autocapitalize="off">
<tr><th>',lang(27),'<td><input name="pass" id="pass" value="',h($M["pass"]),'" autocomplete="new-password">
',($M["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$M["hashed"],lang(238),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(62).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($fd
as$if=>$ed){echo'<th>'.($if!="*.*"?"<input name='objects[$t]' value='".h($if)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(25),"Databases"=>lang(28),"Tables"=>lang(132),"Columns"=>lang(39),"Procedures"=>lang(239),)as$qb=>$Ob){foreach((array)$rg[$qb]as$qg=>$hb){echo"<tr><td".($Ob?">$Ob<td":" colspan='2'").' lang="en" title="'.h($hb).'">'.h($qg);$t=0;foreach($fd
as$if=>$ed){$E="'grants[$t][".h(strtoupper($qg))."]'";$Y=$ed[strtoupper($qg)];if($qb=="Server Admin"&&$if!=(isset($fd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$E><option><option value='1'".($Y?" selected":"").">".lang(240)."<option value='0'".($Y=="0"?" selected":"").">".lang(241)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$E value='1'".($Y?" checked":"").($qg=="All privileges"?" id='grants-$t-all'>":">".($qg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(16),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(177,"$ea@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$l){$ge=0;foreach((array)$_POST["kill"]as$X){if(adminer()->killProcess($X))$ge++;}queries_redirect(ME."processlist=",lang(242,$ge),$ge||!$_POST["kill"]);}}page_header(lang(116),$l);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(adminer()->processList()as$t=>$M){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($M
as$z=>$X)echo"<th>$z".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($z),));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$M[JUSH=="sql"?"Id":"pid"],0):"");foreach($M
as$z=>$X)echo"<td>".((JUSH=="sql"&&$z=="Info"&&preg_match("~Query|Killed~",$M["Command"])&&$X!="")||(JUSH=="pgsql"&&$z=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$z=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($M["db"]!=""?"db=".urlencode($M["db"])."&":"")."sql=".urlencode($X)).'">'.lang(243).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(244,max_connections()),"<p><input type='submit' value='".lang(245)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$n=fields($a);$Vc=column_foreign_keys($a);$kf=$S["Oid"];$ka=get_settings("adminer_import");$Mg=array();$d=array();$Xg=array();$zf=array();$Uh="";foreach($n
as$z=>$m){$E=adminer()->fieldName($m);$Ye=html_entity_decode(strip_tags($E),ENT_QUOTES);if(isset($m["privileges"]["select"])&&$E!=""){$d[$z]=$Ye;if(is_shortable($m))$Uh=adminer()->selectLengthProcess();}if(isset($m["privileges"]["where"])&&$E!="")$Xg[$z]=$Ye;if(isset($m["privileges"]["order"])&&$E!="")$zf[$z]=$Ye;$Mg+=$m["privileges"];}list($O,$s)=adminer()->selectColumnsProcess($d,$x);$O=array_unique($O);$s=array_unique($s);$Xd=count($s)<count($O);$Z=adminer()->selectSearchProcess($n,$x);$yf=adminer()->selectOrderProcess($n,$x);$_=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$ui=>$M){$ua=convert_field($n[key($M)]);$O=array($ua?:idf_escape(key($M)));$Z[]=where_check($ui,$n);$L=driver()->select($a,$O,$Z,$O);if($L)echo
first($L->fetch_row());}exit;}$ng=$wi=array();foreach($x
as$w){if($w["type"]=="PRIMARY"){$ng=array_flip($w["columns"]);$wi=($O?$ng:array());foreach($wi
as$z=>$X){if(in_array(idf_escape($z),$O))unset($wi[$z]);}break;}}if($kf&&!$ng){$ng=$wi=array($kf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($kf));}if($_POST&&!$l){$Ti=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Va=array();foreach($_POST["check"]as$Sa)$Va[]=where_check($Sa,$n);$Ti[]="((".implode(") OR (",$Va)."))";}$Ti=($Ti?"\nWHERE ".implode(" AND ",$Ti):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$Zc=($O?implode(", ",$O):"*").convert_fields($d,$n,$O)."\nFROM ".table($a);$hd=($s&&$Xd?"\nGROUP BY ".implode(", ",$s):"").($yf?"\nORDER BY ".implode(", ",$yf):"");$J="SELECT $Zc$Ti$hd";if(is_array($_POST["check"])&&!$ng){$si=array();foreach($_POST["check"]as$X)$si[]="(SELECT".limit($Zc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n).$hd,1).")";$J=implode(" UNION ALL ",$si);}adminer()->dumpData($a,"table",$J);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$Vc)){if($_POST["save"]||$_POST["delete"]){$K=true;$la=0;$Q=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$E=>$X){$X=process_input($n[$E]);if($X!==null&&($_POST["clone"]||$X!==false))$Q[idf_escape($E)]=($X!==false?$X:idf_escape($E));}}if($_POST["delete"]||$Q){$J=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($Q)).")\nSELECT ".implode(", ",$Q)."\nFROM ".table($a):"");if($_POST["all"]||($ng&&is_array($_POST["check"]))||$Xd){$K=($_POST["delete"]?driver()->delete($a,$Ti):($_POST["clone"]?queries("INSERT $J$Ti".driver()->insertReturning($a)):driver()->update($a,$Q,$Ti)));$la=connection()->affected_rows;if(is_object($K))$la+=$K->num_rows;}else{foreach((array)$_POST["check"]as$X){$Si="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n);$K=($_POST["delete"]?driver()->delete($a,$Si,1):($_POST["clone"]?queries("INSERT".limit1($a,$J,$Si)):driver()->update($a,$Q,$Si,1)));if(!$K)break;$la+=connection()->affected_rows;}}}$D=lang(246,$la);if($_POST["clone"]&&$K&&$la==1){$me=last_id($K);if($me)$D=lang(170," $me");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$D,$K);if(!$_POST["delete"]){$jg=(array)$_POST["fields"];edit_form($a,array_intersect_key($n,$jg),$jg,!$_POST["clone"],$l);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$l=lang(247);else{$K=true;$la=0;foreach($_POST["val"]as$ui=>$M){$Q=array();foreach($M
as$z=>$X){$z=bracket_escape($z,true);$Q[idf_escape($z)]=(preg_match('~char|text~',$n[$z]["type"])||$X!=""?adminer()->processInput($n[$z],$X):"NULL");}$K=driver()->update($a,$Q," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($ui,$n),($Xd||$ng?0:1)," ");if(!$K)break;$la+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(246,$la),$K);}}elseif(!is_string($Mc=get_file("csv_file",true)))$l=upload_error($Mc);elseif(!preg_match('~~u',$Mc))$l=lang(248);else{save_settings(array("output"=>$ka["output"],"format"=>$_POST["separator"]),"adminer_import");$K=true;$eb=array_keys($n);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Mc,$Ae);$la=count($Ae[0]);driver()->begin();$dh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$N=array();foreach($Ae[0]as$z=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$dh]*)$dh~",$X.$dh,$Be);if(!$z&&!array_diff($Be[1],$eb)){$eb=$Be[1];$la--;}else{$Q=array();foreach($Be[1]as$t=>$bb)$Q[idf_escape($eb[$t])]=($bb==""&&$n[$eb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$bb)?str_replace('""','"',substr($bb,1,-1)):$bb));$N[]=$Q;}}$K=(!$N||driver()->insertUpdate($a,$N,$ng));if($K)driver()->commit();queries_redirect(remove_from_uri("page"),lang(249,$la),$K);driver()->rollback();}}}$Hh=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(44).": $Hh",$l);$Q=null;if(isset($Mg["insert"])||!support("table")){$Nf=array();foreach((array)$_GET["where"]as$X){if(isset($Vc[$X["col"]])&&count($Vc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$Nf["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$Q=$Nf?"&".http_build_query($Nf):"";}adminer()->selectLinks($S,$Q);if(!$d&&support("table"))echo"<p class='error'>".lang(250).($n?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($O,$d);adminer()->selectSearchPrint($Z,$Xg,$x);adminer()->selectOrderPrint($yf,$zf,$x);adminer()->selectLimitPrint($_);adminer()->selectLengthPrint($Uh);adminer()->selectActionPrint($x);echo"</form>\n";$G=$_GET["page"];$Yc=null;if($G=="last"){$Yc=get_val(count_rows($a,$Z,$Xd,$s));$G=floor(max(0,intval($Yc)-1)/$_);}$Yg=$O;$gd=$s;if(!$Yg){$Yg[]="*";$rb=convert_fields($d,$n,$O);if($rb)$Yg[]=substr($rb,2);}foreach($O
as$z=>$X){$m=$n[idf_unescape($X)];if($m&&($ua=convert_field($m)))$Yg[$z]="$ua AS $X";}if(!$Xd&&$wi){foreach($wi
as$z=>$X){$Yg[]=idf_escape($z);if($gd)$gd[]=idf_escape($z);}}$K=driver()->select($a,$Yg,$Z,$gd,$yf,$_,$G,true);if(!$K)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$G)$K->seek($_*$G);$jc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$N=array();while($M=$K->fetch_assoc()){if($G&&JUSH=="oracle")unset($M["RNUM"]);$N[]=$M;}if($_GET["page"]!="last"&&$_&&$s&&$Xd&&JUSH=="sql")$Yc=get_val(" SELECT FOUND_ROWS()");if(!$N)echo"<p class='message'>".lang(14)."\n";else{$Ca=adminer()->backwardKeys($a,$Hh);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$s&&$O?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(251)."</a>");$Ze=array();$bd=array();reset($O);$zg=1;foreach($N[0]as$z=>$X){if(!isset($wi[$z])){$X=idx($_GET["columns"],key($O))?:array();$m=$n[$O?($X?$X["col"]:current($O)):$z];$E=($m?adminer()->fieldName($m,$zg):($X["fun"]?"*":h($z)));if($E!=""){$zg++;$Ze[$z]=$E;$c=idf_escape($z);$wd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($z);$Ob="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($z))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$ad=apply_sql_function($X["fun"],$E);$nh=isset($m["privileges"]["order"])||$ad;echo($nh?"<a href='".h($wd.($yf[0]==$c||$yf[0]==$z?$Ob:''))."'>$ad</a>":$ad),"<span class='column hidden'>";if($nh)echo"<a href='".h($wd.$Ob)."' title='".lang(50)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($m["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(47).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($z)."');");echo"</span>";}$bd[$z]=$X["fun"];next($O);}}$se=array();if($_GET["modify"]){foreach($N
as$M){foreach($M
as$z=>$X)$se[$z]=max($se[$z],min(40,strlen(utf8_decode($X))));}}echo($Ca?"<th>".lang(252):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($N,$Vc)as$Xe=>$M){$ti=unique_array($N[$Xe],$x);if(!$ti){$ti=array();reset($O);foreach($N[$Xe]as$z=>$X){if(!preg_match('~^(COUNT|AVG|GROUP_CONCAT|MAX|MIN|SUM)\(~',current($O)))$ti[$z]=$X;next($O);}}$ui="";foreach($ti
as$z=>$X){$m=(array)$n[$z];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$m["type"])&&strlen($X)>64){$z=(strpos($z,'(')?$z:idf_escape($z));$z="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$m["collation"])?$z:"CONVERT($z USING ".charset(connection()).")").")";$X=md5($X);}$ui
.="&".($X!==null?urlencode("where[".bracket_escape($z)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($z));}echo"<tr>".(!$s&&$O?"":"<td>".checkbox("check[]",substr($ui,1),in_array(substr($ui,1),(array)$_POST["check"])).($Xd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$ui)."' class='edit'>".lang(253)."</a>"));reset($O);foreach($M
as$z=>$X){if(isset($Ze[$z])){$c=current($O);$m=(array)$n[$z];$X=driver()->value($X,$m);if($X!=""&&(!isset($jc[$z])||$jc[$z]!=""))$jc[$z]=(is_mail($X)?$Ze[$z]:"");$A="";if(is_blob($m)&&$X!="")$A=ME.'download='.urlencode($a).'&field='.urlencode($z).$ui;if(!$A&&$X!==null){foreach((array)$Vc[$z]as$p){if(count($Vc[$z])==1||end($p["source"])==$z){$A="";foreach($p["source"]as$t=>$oh)$A
.=where_link($t,$p["target"][$t],$N[$Xe][$oh]);$A=($p["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($p["db"]),ME):ME).'select='.urlencode($p["table"]).$A;if($p["ns"])$A=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($p["ns"]),$A);if(count($p["source"])==1)break;}}}if($c=="COUNT(*)"){$A=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$ti))$A
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($ti
as$de=>$W)$A
.=where_link($t++,$de,$W);}$xd=select_value($X,$A,$m,$Uh);$u=h("val[$ui][".bracket_escape($z)."]");$kg=idx(idx($_POST["val"],$ui),bracket_escape($z));$ec=!is_array($M[$z])&&is_utf8($xd)&&$N[$Xe][$z]==$M[$z]&&!$bd[$z]&&!$m["generated"];$U=(preg_match('~^(AVG|MIN|MAX)\((.+)\)~',$c,$C)?$n[idf_unescape($C[2])]["type"]:$m["type"]);$Th=preg_match('~text|json|lob~',$U);$Yd=preg_match(number_type(),$U)||preg_match('~^(CHAR_LENGTH|ROUND|FLOOR|CEIL|TIME_TO_SEC|COUNT|SUM)\(~',$c);echo"<td id='$u'".($Yd&&($X===null||is_numeric(strip_tags($xd))||$U=="money")?" class='number'":"");if(($_GET["modify"]&&$ec&&$X!==null)||$kg!==null){$kd=h($kg!==null?$kg:$M[$z]);echo">".($Th?"<textarea name='$u' cols='30' rows='".(substr_count($M[$z],"\n")+1)."'>$kd</textarea>":"<input name='$u' value='$kd' size='$se[$z]'>");}else{$xe=strpos($xd,"<i>…</i>");echo" data-text='".($xe?2:($Th?1:0))."'".($ec?"":" data-warning='".h(lang(254))."'").">$xd";}}next($O);}if($Ca)echo"<td>";adminer()->backwardKeysPrint($Ca,$N[$Xe]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($N||$G){$xc=true;if($_GET["page"]!="last"){if(!$_||(count($N)<$_&&($N||!$G)))$Yc=($G?$G*$_:0)+count($N);elseif(JUSH!="sql"||!$Xd){$Yc=($Xd?false:found_rows($S,$Z));if(intval($Yc)<max(1e4,2*($G+1)*$_))$Yc=first(slow_query(count_rows($a,$Z,$Xd,$s)));else$xc=false;}}$Lf=($_&&($Yc===false||$Yc>$_||$G));if($Lf)echo(($Yc===false?count($N)+1:$Yc-$G*$_)>$_?'<p><a href="'.h(remove_from_uri("page")."&page=".($G+1)).'" class="loadmore">'.lang(255).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $_, '".lang(256)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($Lf){$Fe=($Yc===false?$G+(count($N)>=$_?2:1):floor(($Yc-1)/$_));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(257)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(257)."', '".($G+1)."')); return false; };"),pagination(0,$G).($G>5?" …":"");for($t=max(1,$G-4);$t<min($Fe,$G+5);$t++)echo
pagination($t,$G);if($Fe>0)echo($G+5<$Fe?" …":""),($xc&&$Yc!==false?pagination($Fe,$G):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Fe'>".lang(258)."</a>");}else
echo"<legend>".lang(257)."</legend>",pagination(0,$G).($G>1?" …":""),($G?pagination($G,$G):""),($Fe>$G?pagination($G+1,$G).($Fe>$G+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(259)."</legend>";$Vb=($xc?"":"~ ").$Yc;$sf="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Vb' : checked); selectCount('selected2', this.checked || !checked ? '$Vb' : checked);";echo
checkbox("all",1,0,($Yc!==false?($xc?"":"~ ").lang(153,$Yc):""),$sf)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(251),'</legend><div>
<input type="submit" value="',lang(16),'"',($_GET["modify"]?'':' title="'.lang(247).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(126),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(12),'">
<input type="submit" name="clone" value="',lang(243),'">
<input type="submit" name="delete" value="',lang(20),'">',confirm(),'</div></fieldset>
';$Wc=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$c){if($c["fun"]){unset($Wc['sql']);break;}}if($Wc){print_fieldset("export",lang(67)." <span id='selected2'></span>");$Jf=adminer()->dumpOutput();echo($Jf?html_select("output",$Jf,$ka["output"])." ":""),html_select("format",$Wc,$ka["format"])," <input type='submit' name='export' value='".lang(67)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($jc,'strlen'),$d);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<p>","<a href='#import'>".lang(66)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ",file_input("<input type='file' name='csv_file'> ".html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$ka["format"])." <input type='submit' name='import' value='".lang(66)."'>"),"</span>";echo
input_token(),"</form>\n",(!$s&&$O?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$wh=isset($_GET["status"]);page_header($wh?lang(118):lang(117));$Ji=($wh?show_status():show_variables());if(!$Ji)echo"<p class='message'>".lang(14)."\n";else{echo"<table>\n";foreach($Ji
as$M){echo"<tr>";$z=array_shift($M);echo"<th><code class='jush-".JUSH.($wh?"status":"set")."'>".h($z)."</code>";foreach($M
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Eh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$E=>$S){json_row("Comment-$E",h($S["Comment"]));if(!is_view($S)||preg_match('~materialized~i',$S["Engine"])){foreach(array("Engine","Collation")as$z)json_row("$z-$E",h($S[$z]));foreach($Eh+array("Auto_increment"=>0,"Rows"=>0)as$z=>$X){if($S[$z]!=""){$X=format_number($S[$z]);if($X>=0)json_row("$z-$E",($z=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Eh[$z]))$Eh[$z]+=($S["Engine"]!="InnoDB"||$z!="Data_free"?$S[$z]:0);}elseif(array_key_exists($z,$S))json_row("$z-$E","?");}}}foreach($Eh
as$z=>$X)json_row("sum-$z",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$j=>$X){json_row("tables-$j",$X);json_row("size-$j",db_size($j));}json_row("");}exit;}else{$Nh=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Nh&&!$l&&!$_POST["search"]){$K=true;$D="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$K=truncate_tables($_POST["tables"]);$D=lang(260);}elseif($_POST["move"]){$K=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$D=lang(261);}elseif($_POST["copy"]){$K=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$D=lang(262);}elseif($_POST["drop"]){if($_POST["views"])$K=drop_views($_POST["views"]);if($K&&$_POST["tables"])$K=drop_tables($_POST["tables"]);$D=lang(263);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$M)$D
.="<b>".h($R)."</b>: ".h($M["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$K=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$D=lang(264);}elseif(!$_POST["tables"])$D=lang(11);elseif($K=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($M=$K->fetch_assoc())$D
.="<b>".h($M["Table"])."</b>: ".h($M["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$D,$K);}page_header(($_GET["ns"]==""?lang(28).": ".h(DB):lang(265).": ".h($_GET["ns"])),$l,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(266)."</h3>\n";$Mh=tables_list();if(!$Mh)echo"<p class='message'>".lang(11)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(267)." <span id='selected2'></span></legend><div>",html_select("op",adminer()->operators(),idx($_POST,"op",JUSH=="elastic"?"should":"LIKE %%"))," <input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(47)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$_POST["op"];search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(132),'<td>'.lang(268).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(122).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(269).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(270).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(271).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(42).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(272).doc_link(array('sql'=>'show-table-status.html',)),(support("comment")?'<td>'.lang(41).doc_link(array('sql'=>'show-table-status.html',)):''),"</thead>\n";$T=0;foreach($Mh
as$E=>$U){$Mi=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$E);echo'<tr><td>'.checkbox(($Mi?"views[]":"tables[]"),$E,in_array("$E",$Nh,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($E)."' title='".lang(33)."' id='$u'>".h($E).'</a>':h($E));if($Mi&&!preg_match('~materialized~i',$U)){$Yh=lang(131);echo'<td colspan="6">'.(support("view")?"<a href='".h(ME)."view=".urlencode($E)."' title='".lang(35)."'>$Yh</a>":$Yh),'<td align="right"><a href="'.h(ME)."select=".urlencode($E).'" title="'.lang(32).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(34)),"Index_length"=>array("indexes",lang(135)),"Data_free"=>array("edit",lang(36)),"Auto_increment"=>array("auto_increment=1&create",lang(34)),"Rows"=>array("select",lang(32)),)as$z=>$A){$u=" id='$z-".h($E)."'";echo($A?"<td align='right'>".(support("table")||$z=="Rows"||(support("indexes")&&$z!="Data_length")?"<a href='".h(ME."$A[0]=").urlencode($E)."'$u title='$A[1]'>?</a>":"<span$u>?</span>"):"<td id='$z-".h($E)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($E)."'>":""),"\n";}echo"<tr><td><th>".lang(244,count($Mh)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$z)echo"<td align='right' id='sum-$z'>";echo"\n","</table>\n",script("ajaxSetHtml('".js_escape(ME)."script=db');"),"</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Hi="<input type='submit' value='".lang(273)."'> ".on_help("'VACUUM'");$vf="<input type='submit' name='optimize' value='".lang(274)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$Hi."<input type='submit' name='check' value='".lang(275)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$Hi.$vf:(JUSH=="sql"?"<input type='submit' value='".lang(276)."'> ".on_help("'ANALYZE TABLE'").$vf."<input type='submit' name='check' value='".lang(275)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(277)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(278)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(127)."'>".on_help("'DROP TABLE'").confirm()."\n";$i=(support("scheme")?adminer()->schemas():adminer()->databases());echo"</div></fieldset>\n";$Wg="";if(count($i)!=1&&JUSH!="sqlite"){echo"<fieldset><legend>".lang(279)." <span id='selected3'></span></legend><div>";$j=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo($i?html_select("target",$i,$j):'<input name="target" value="'.h($j).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(280)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(281)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(282)):""),"</div></fieldset>\n";$Wg=" selectCount('selected3', formChecked(this, /^(tables|views)\[/));";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")."$Wg }"),input_token(),"</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(68)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(206)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(63)."</h3>\n";$Qg=routines();if($Qg){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(187).'<td>'.lang(40).'<td>'.lang(223)."<td></thead>\n";foreach($Qg
as$M){$E=($M["SPECIFIC_NAME"]==$M["ROUTINE_NAME"]?"":"&name=".urlencode($M["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($M["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($M["SPECIFIC_NAME"]).$E).'">'.h($M["ROUTINE_NAME"]).'</a>','<td>'.h($M["ROUTINE_TYPE"]),'<td>'.h($M["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($M["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($M["SPECIFIC_NAME"]).$E).'">'.lang(138)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(222).'</a>':'').'<a href="'.h(ME).'function=">'.lang(221)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(65)."</h3>\n";$N=get_rows("SHOW EVENTS");if($N){echo"<table>\n","<thead><tr><th>".lang(187)."<td>".lang(283)."<td>".lang(212)."<td>".lang(213)."<td></thead>\n";foreach($N
as$M)echo"<tr>","<th>".h($M["Name"]),"<td>".($M["Execute at"]?lang(284)."<td>".$M["Execute at"]:lang(214)." ".$M["Interval value"]." ".$M["Interval field"]."<td>$M[Starts]"),"<td>$M[Ends]",'<td><a href="'.h(ME).'event='.urlencode($M["Name"]).'">'.lang(138).'</a>';echo"</table>\n";$vc=get_val("SELECT @@event_scheduler");if($vc&&$vc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($vc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(211)."</a>\n";}}}}page_footer();